/*==========================================================================
//  x_mad.h -- by Patrick Martin                Last updated:  2-12-1999
//--------------------------------------------------------------------------
//  This is the header file for x_mad.c.  Any files that use the
//  functions in x_mad.c must include this file.
//========================================================================*/

/***************/
/*  CONSTANTS  */
/***************/

/* Gas types. */
#define GAS_POISON   0
#define GAS_BIO      1
#define GAS_MIND     2

/* Blast power for nukes and black hole bombs. */
#define HOLE_DAMAGE       300
#define NUKE_DAMAGE       250
#define NUKE_BURNRADIUS   500
#define NUKE_RADIUS      1000


/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_mad.c
*/
void check_rocketdodge (edict_t *self, vec3_t start, vec3_t dir, int speed);
void Coven_CureAll (edict_t *ent);
void Coven_FixVision (edict_t *ent);
void Coven_CureLevel (void);

void Coven_ThrowThing (edict_t *ent, vec3_t dir, int knockback);
void Coven_BlastRadius
 (edict_t *inflictor, edict_t *attacker, float damage, edict_t *ignore,
  float radius, qboolean burn, int knockback, int mod);
void Coven_BlastTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FireBlast
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage, int knockback);

qboolean Coven_CanGas (edict_t *ent);
void Coven_GasFade (edict_t *self);
void Coven_KillCloud (edict_t *self);
void Coven_AcidDamage (edict_t *self);
void Coven_GermDamage (edict_t *self);
void Coven_AlterMind (edict_t *self);
void Coven_SpawnGas
 (edict_t *self, vec3_t start, vec3_t dir, float damage, int speed,
  float duration, float damage_radius, int gastype);
void Coven_GasbombTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FireGasbomb
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage, int gastype);

void Coven_NapalmTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FireNapalm
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage);

void Coven_SmartFlameThink (edict_t *self);
void Coven_SmartFlame (vec3_t origin, int color);
void Coven_SmartExplode (edict_t *self);
void Coven_BecomeSmartExplosion (edict_t *ent);
void Coven_KillSmartLaser (edict_t *ent);
void Coven_SmartTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_ColorSmoke (vec3_t origin, vec3_t smokedir, int color);
void Coven_SmartLaserThink (edict_t *self);
void Coven_SpawnSmartLaser (edict_t *self, edict_t *targ, int damage);
void Coven_SmartThink (edict_t *self);
void Coven_FireSmart
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage);

static edict_t *findall (edict_t *from);
void Coven_MushExplodeThink (edict_t *self);
void Coven_MakeMushExplosion (vec3_t origin);
void Coven_Mushroom (vec3_t origin);
void Coven_WaveThink (edict_t *self);
void Coven_BecomeWave (edict_t *self, int type);
void Coven_NukeDamage
 (edict_t *inflictor, edict_t *attacker, float damage, float radius);
void Coven_NukeTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FireNuke
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage);

void Coven_CoreThink (edict_t *self);
void Coven_BecomeCore (edict_t *self);
void Coven_MakeWave (vec3_t origin);
void Coven_GravityDamage (edict_t *targ, edict_t *hole, float dist);
void Coven_HoleThink (edict_t *self);
void Coven_BlackHole
 (edict_t *self, vec3_t start, vec3_t dir, float damage, int speed,
  float duration, float damage_radius, int radius_damage);
void Coven_HoleBombTouch
 (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FireHole
 (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed,
  float damage_radius, int radius_damage);


/*===========================/  END OF FILE  /===========================*/
