/*==========================================================================
//  x_fire.h -- by Patrick Martin               Last updated:  2-28-1999
//--------------------------------------------------------------------------
//  This is the header file for the x_fire*.c files.
//
//  The Napalm2 code uses my custom flame model.  It is similar to
//  (but NOT the same as) the flame2.mdl in Quake 1.
//
//  Frames:
//     0 -  2  Small flame expansion (used for fireball creation)
//     3 - 14  Small fire (used for fireballs and the like)
//    15 - 20  Large flame expansion (used for burning entities)
//    21 - 32  Large fire (used for burning entities)
//    33 - 38  Huge flare (NOT used)
//         39  Tiny spark (near invisible; used for smoke)
//         40  Base frame (NOT used)
//
//  Skins:
//     0  Orange fire
//
//========================================================================*/

#include "x_firemd.h"


/***************/
/*  CONSTANTS  */
/***************/

/* Time in seconds the entity on fire will burn. */
#define BURN_TIME              30
#define BURN_DM_TIME    100000000

/* Default radius for fire splash damage. */
#define RADIUS_FIRE_SPLASH     80

/* Default dropped flame duration. */
#define FLAME_TIME              2
#define FLAME_EXTRA_TIME        3

/* Default firestorm attributes. */
#define FIRESTORM_DELAY         0.7
#define FIRESTORM_DURATION      4
#define FIRESTORM_RADIUS       64

/* Maximum number of firestorms a player can have at a time. */
#define MAX_FIRESTORMS          2

/* Fireflags.
        SHIFT_Z      =  Vertical flame shift.
        DOWN         =  Shift flame down, not up.
        DELTA_ALIVE  =  Adjust only if target is alive.
        DELTA_BASE   =  Base adjustments (+4 if alive, -18 if dead).
        DELTA_VIEW   =  Adjust w/ viewheight (clients only).
        IGNITE       =  Target can ignite.
*/
#define FIREFLAG_SHIFT_Z        0x000000ff
#define FIREFLAG_DOWN           0x00000100
#define FIREFLAG_DELTA_ALIVE    0x00000200
#define FIREFLAG_DELTA_BASE     0x00000400
#define FIREFLAG_DELTA_VIEW     0x00000800
#define FIREFLAG_IGNITE         0x00001000


/****************/
/*  PROTOTYPES  */
/****************/

/*
// g_combat.c
*/
qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);


/*
// x_fire1.c
// Core burn code
*/
void     Coven_CacheFire (void);
void     Coven_KillAllFires (void);
qboolean Coven_NeedSpeed (void);

void     Coven_MakeSmoke (vec3_t spot);
void     Coven_BecomeSmoke (edict_t *self);
void     Coven_BecomeSteam (edict_t *self);
void     Coven_FastSmallExplodeThink (edict_t *self);
void     Coven_SmallExplodeThink (edict_t *self);
void     Coven_StartSmallExplosion (edict_t *self);
void     Coven_BecomeSmallExplosion (edict_t *self);

qboolean Coven_InWater (edict_t *ent);
qboolean Coven_Inflammable (edict_t *ent);
qboolean Coven_ActivePowerArmor (edict_t *ent, vec3_t point);
qboolean Coven_FireResistant (edict_t *ent, vec3_t point);
qboolean Coven_NoFriendlyFire (edict_t *victim, edict_t *attacker);

void     Coven_BurnDamage
 (edict_t *victim, edict_t *fire, vec3_t point, vec3_t normal,
  vec3_t damage, int dflags, int mod);
void     Coven_BurnRadius
 (edict_t *fire, float radius, vec3_t damage, edict_t *ignore, int mod);

void     Coven_CheckMaster (edict_t *fire);
void     Coven_FireSpot (vec3_t spot, edict_t *ent);
qboolean Coven_FlameOut (edict_t *self);
void     Coven_Burn (edict_t *self);
void     Coven_Ignite (edict_t *victim, edict_t *attacker, vec3_t point);


/*
// x_fire2.c
// Pyrotechnics
*/
void     Coven_CheckFire (edict_t *self);
void     Coven_FireDropTouch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void     Coven_FireDrop
 (edict_t *attacker, vec3_t spot, vec3_t damage, vec3_t radius_damage,
  float duration_base, int blast_chance, int mod_strike, int mod_splash);
void     Coven_EasyFireDrop (edict_t *self);

void     Coven_CloudBurst (edict_t *self);
void     Coven_CloudBurstDamage (edict_t *self);
void     Coven_FlameCloud
 (edict_t *attacker, vec3_t start, vec3_t cloud, vec3_t timer,
  vec3_t damage, vec3_t radius_damage, int rain_chance, int blast_chance);

void     Coven_RemoveFireStorm (edict_t *self);
void     Coven_FireStormThink (edict_t *self);
void     Coven_LinkFireStorm (edict_t *self);
void     Coven_CreateFireStorm
 (edict_t *attacker, vec3_t start, vec3_t damage, vec3_t radius_damage,
  vec3_t dim);

qboolean Coven_CanDamageFromPoint (edict_t *targ, vec3_t point);
qboolean Coven_NegateMissile (edict_t *ent);
void     Coven_FlashRadius
 (edict_t *attacker, vec3_t origin, float damage, vec3_t radii,
  edict_t *ignore, int mod);
void     Coven_FlashEffects (vec3_t p1, vec3_t p2);
void     Coven_FlashExplosion
 (edict_t *attacker, vec3_t p1, vec3_t p2, float damage, vec3_t radii,
  edict_t *ignore, int mod);


/*===========================/  END OF FILE  /===========================*/
