/*==========================================================================
//  x_cache.c -- by Patrick Martin              Last updated:  3-21-1999
//--------------------------------------------------------------------------
//  This file contains code that loads more data before the client
//  enters play.
//========================================================================*/

#include "g_local.h"
#include "x_cache.h"
#include "x_ctf.h"


/*=======================================================================*/

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB pics.
//------------------------------------------------------------------------*/
void Coven_CachePics (void)
{
// Bubbles
        gi.imageindex ("bubble1");
        gi.imageindex ("bubble2");
        gi.imageindex ("bubble3");
        gi.imageindex ("bubble4");
        gi.imageindex ("bubble5");
        gi.imageindex ("bubble6");
        gi.imageindex ("bubble7");
        gi.imageindex ("bubble8");

// TAB for menu message
        gi.imageindex ("i_airstrike");

// CTF icons
        if (!ctf->value)
                return;

        gi.imageindex("ctfsb1");
        gi.imageindex("ctfsb2");
        gi.imageindex("i_ctf1");
        gi.imageindex("i_ctf1d");
        gi.imageindex("i_ctf1t");
        gi.imageindex("i_ctf2");
        gi.imageindex("i_ctf2d");
        gi.imageindex("i_ctf2t");
        gi.imageindex("i_ctfj");
        gi.imageindex("sbfctf1");
        gi.imageindex("sbfctf2");
}

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new weapons.  Invulnerability is precached
//  because it is used for the three second respawn shield.
//------------------------------------------------------------------------*/
void Coven_CacheItems (void)
{
// All Weapons
        PrecacheItem (FindItem ("Grapple"));
        PrecacheItem (FindItem ("Blast Bomb I"));
        PrecacheItem (FindItem ("Blast Bomb II"));
        PrecacheItem (FindItem ("Poison Gas Bomb"));
        PrecacheItem (FindItem ("Spore Cloud Bomb"));
        PrecacheItem (FindItem ("Mind Gas Bomb"));
        PrecacheItem (FindItem ("Napalm Bomb"));
        PrecacheItem (FindItem ("Smart Bomb"));
        PrecacheItem (FindItem ("Nuclear Bomb"));
        PrecacheItem (FindItem ("Black Hole Bomb"));

// Respawn protection
        PrecacheItem (FindItem ("Invulnerability"));

// Techs
        if ((int)dmflags->value & DF_CTF_TECH)
        {       // NOTE:  This is here hopefully to fix 'can't find pic'.
                PrecacheItem (FindItem ("Disruptor Shield"));
                PrecacheItem (FindItem ("Power Amplifier"));
                PrecacheItem (FindItem ("Time Accel"));
                PrecacheItem (FindItem ("AutoDoc"));
        }
}

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB sounds (mostly battlesuits).
//------------------------------------------------------------------------*/
void Coven_CacheSounds (void)
{
// Screams
        gi.soundindex ("player/burn1.wav");
        gi.soundindex ("player/burn2.wav");
// NOTE:  'lava*.wav' are precached in 'g_spawn.c'.

// Extra Rhino sounds
        gi.soundindex ("armour/rhino/more/gasp1.wav");
        gi.soundindex ("armour/rhino/more/gasp2.wav");
}


/*===========================/  END OF FILE  /===========================*/
