/*==========================================================================
//  x_sound.c -- by Patrick Martin              Last updated:  3-20-1999
//--------------------------------------------------------------------------
//  This file contains code that plays the various player sounds
//  in the Armorback patch.
//========================================================================*/

#include "g_local.h"
#include "x_sound.h"


/*========================/  Normal Suit Sounds  /========================*/

/*------------------------------------------------------/ New Code /--------
//  This is called when a player dies.
//------------------------------------------------------------------------*/
void Coven_SfxDeath (edict_t *ent)
{
/* If underwater, make death gurp instead. */
        if (ent->waterlevel == 3)
        {       Coven_SfxDrown (ent);
                return;
        }

        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("*death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/mercury/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/zeppelin/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/gravyburner/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/wirecutter/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/rhino/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/sugarconny/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/bulkhead/death%i.wav", (rand()%4)+1)), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player jumps.
//------------------------------------------------------------------------*/
void Coven_SfxJump (edict_t *ent)
{
/* The dead make no noise. */
        if (ent->health <= 0)
                return;

        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                gi.sound (ent, CHAN_VOICE, gi.soundindex("*jump1.wav"), 1, ATTN_NORM, 0);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/mercury/jump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/zeppelin/jump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/gravyburner/jump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/wirecutter/jump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/rhino/jump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/sugarconny/jump1.wav"), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/bulkhead/jump1.wav"), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player gets hurt and is not on fire.
//------------------------------------------------------------------------*/
void Coven_SfxPain (edict_t *ent)
{
        int     l, r;

/* If underwater, make gurp sounds instead. */
        if (ent->waterlevel == 3)
        {       Coven_SfxGurp (ent);
                return;
        }

        r = 1 + (rand()&1);
        if (ent->health < 25)
                l = 25;
        else if (ent->health < 50)
                l = 50;
        else if (ent->health < 75)
                l = 75;
        else
                l = 100;

        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("*pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/mercury/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/zeppelin/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/gravyburner/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/wirecutter/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/rhino/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/sugarconny/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/bulkhead/pain%i_%i.wav", l, r)), 1, ATTN_NORM, 0);
}

//*-----------------------------------------------------/ New Code /--------
//  This checks if the PPM's drown wav is 'drown' instead of 'drown1'.
//  (In AB, this should not be used in DM.)
//------------------------------------------------------------------------*/
qboolean Coven_SfxAltDrown (edict_t *ent)
{
        char    *info;
        char    ppm[16];

        info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
        sscanf (info, "%15[^/]", ppm);

        if (Q_stricmp(ppm, "female") == 0)
                return true;
        if (Q_stricmp(ppm, "crakhor") == 0)
                return true;

        return false;
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player drowns.
//------------------------------------------------------------------------*/
void Coven_SfxDrown (edict_t *ent)
{
        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                if (Coven_SfxAltDrown (ent))
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("*drown.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("*drown1.wav"), 1, ATTN_NORM, 0);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/mercury/drown1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/zeppelin/drown1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/gravyburner/drown1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/wirecutter/drown1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/rhino/drown1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/sugarconny/drown1.wav"), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/bulkhead/drown1.wav"), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player is drowning.
//------------------------------------------------------------------------*/
void Coven_SfxGurp (edict_t *ent)
{
        int     i = 1 + (rand()&1);

        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("*gurp%i.wav", i)), 1, ATTN_NORM, 0);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/mercury/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/zeppelin/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/gravyburner/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/wirecutter/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/rhino/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/sugarconny/gurp%i.wav", i)), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/bulkhead/gurp%i.wav", i)), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player falls and hits the ground VERY hard.
//------------------------------------------------------------------------*/
void Coven_SfxFallFar (edict_t *ent)
{
        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                ent->s.event = EV_FALLFAR;
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/mercury/fall1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/zeppelin/fall1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/gravyburner/fall1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/wirecutter/fall1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/rhino/fall1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/sugarconny/fall1.wav"), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/bulkhead/fall1.wav"), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player falls and hits the ground hard.
//------------------------------------------------------------------------*/
void Coven_SfxFall (edict_t *ent)
{
        if (!deathmatch->value)
        {       // SP -- play PPM sfx.
                ent->s.event = EV_FALL;
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/mercury/fall2.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/zeppelin/fall2.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/gravyburner/fall2.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/wirecutter/fall2.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/rhino/fall2.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/sugarconny/fall2.wav"), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/bulkhead/fall2.wav"), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player gets hurt and is on fire or in lava.
//------------------------------------------------------------------------*/
void Coven_SfxBump (edict_t *ent)
{
/* The dead make no noise. */
        if (ent->health <= 0)
                return;

/* Not all PPMs have a 'bump1.wav' sound. */
        if (!deathmatch->value)
                return;

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/mercury/bump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/zeppelin/bump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/gravyburner/bump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/wirecutter/bump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/rhino/bump1.wav"), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/sugarconny/bump1.wav"), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex("armour/bulkhead/bump1.wav"), 1, ATTN_NORM, 0);
}


/*=========================/  More Suit Sounds  /=========================*/

/*------------------------------------------------------/ New Code /--------
//  This determines if the player's PPM is some huge beast.
//  So far, only The Coven's Rhino PPM qualifies.
//  This is used only if not in deathmatch.
//------------------------------------------------------------------------*/
qboolean Coven_IsBeast (edict_t *ent)
{
        char    *info;
        char    ppm[16];

        if (!deathmatch->value)
                return false;

        info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
        sscanf (info, "%15[^/]", ppm);

        if (Q_stricmp(ppm, "rhino") == 0)
                return true;
        if (Q_stricmp(ppm, "sugarconny") == 0)
                return true;

        return false;
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player gets hurt and is on fire or in lava.
//------------------------------------------------------------------------*/
void Coven_SfxBurn (edict_t *ent)
{
/* Bulkhead can't scream, so use normal pain sounds. */
        if (ent->battlesuit == SUIT_BULKHEAD)
        {       Coven_SfxPain (ent);
                return;
        }

/* Heavy suits scream like Stroggs.  The rest scream like humans. */
        if ( (ent->battlesuit == SUIT_RHINO) ||
             (ent->battlesuit == SUIT_SUGARCONNY) || (Coven_IsBeast (ent)) )
        {       if (rand()&1)
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("player/lava1.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("player/lava2.wav"), 1, ATTN_NORM, 0);
        }
        else
        {       if (rand()&1)
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("player/burn1.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound (ent, CHAN_VOICE, gi.soundindex("player/burn2.wav"), 1, ATTN_NORM, 0);
        }
}

/*------------------------------------------------------/ New Code /--------
//  If a PPM is gasping, use this instead.
//------------------------------------------------------------------------*/
void Coven_SfxAltGasp (edict_t *ent, int i)
{
        char    *info;
        char    ppm[16];

/* If PPM is Armourback-based, such as the Rhino, use suits' gasp sounds. */
        info = Info_ValueForKey (ent->client->pers.userinfo, "skin");
        sscanf (info, "%15[^/]", ppm);

        if (Q_stricmp(ppm, "mercury") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/mercury/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (Q_stricmp(ppm, "zeppelin") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/zeppelin/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (Q_stricmp(ppm, "gravyburner") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/gravyburner/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (Q_stricmp(ppm, "wirecutter") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/wirecutter/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (Q_stricmp(ppm, "rhino") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/rhino/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (Q_stricmp(ppm, "sugarconny") == 0)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/sugarconny/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("player/gasp%i.wav", i)), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player gasps for air.
//------------------------------------------------------------------------*/
void Coven_SfxGasp (edict_t *ent, int i)
{
/* The dead make no noise. */
        if (ent->health <= 0)
                return;

/* If not in deathmatch, call alternate PPM gasping function. */
        if (!deathmatch->value)
        {       Coven_SfxAltGasp (ent, i);
                return;
        }

        if (ent->battlesuit == SUIT_MERCURY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/mercury/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_ZEPPELIN)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/zeppelin/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_GRAVYBURNER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/gravyburner/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_WIRECUTTER)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/wirecutter/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_RHINO)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/rhino/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else if (ent->battlesuit == SUIT_SUGARCONNY)
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/sugarconny/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
        else
                gi.sound (ent, CHAN_VOICE, gi.soundindex(va("armour/bulkhead/more/gasp%i.wav", i)), 1, ATTN_NORM, 0);
}

/*------------------------------------------------------/ New Code /--------
//  This is called when a player makes footsteps.
//------------------------------------------------------------------------*/
void Coven_SfxFootstep (edict_t *ent)
{
/* The dead make no noise. */
        if (ent->health <= 0)
                return;

/* Light suits are silent. */
        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                return;

/* Bulkhead has no feet. */
        if (ent->battlesuit == SUIT_BULKHEAD)
                return;

/* The rest make footsteps. */
        if (ent->battlesuit == SUIT_RHINO)
        {       if (ent->waterlevel)
                        gi.sound (ent, CHAN_BODY, gi.soundindex("armour/rhino/more/stompwat.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound (ent, CHAN_BODY, gi.soundindex("armour/rhino/more/stomp.wav"), 1, ATTN_NORM, 0);
        }
        else if (ent->battlesuit == SUIT_SUGARCONNY)
        {       if (ent->waterlevel)
                        gi.sound (ent, CHAN_BODY, gi.soundindex("armour/sugarconny/more/stompwat.wav"), 1, ATTN_NORM, 0);
                else
                        gi.sound (ent, CHAN_BODY, gi.soundindex("armour/sugarconny/more/stomp.wav"), 1, ATTN_NORM, 0);
        }
        else
                ent->s.event = EV_FOOTSTEP;
}


/*===========================/  END OF FILE  /===========================*/
