/*==========================================================================
//  x_select.h -- by various                    Last updated:  5-3-1999
//--------------------------------------------------------------------------
//  This is the header for x_select.c.
//========================================================================*/

/***************/
/*  CONSTANTS  */
/***************/

/* Menu types. */
#define MENU_MAIN               1
#define MENU_SUIT               2
#define MENU_GUN_LEFT           3
#define MENU_GUN_RIGHT          4
#define MENU_TEAM               5
#define MENU_HELP_MAIN          6
#define MENU_HELP_RULES         7
#define MENU_HELP_SUITS         8
#define MENU_HELP_WEAPONS       9
#define MENU_HELP_WEAPONS_A    10
#define MENU_HELP_WEAPONS_B    11
#define MENU_HELP_WEAPONS_C    12
#define MENU_HELP_COMMANDS     13
#define MENU_HELP_FAQ          14
#define MENU_VOTE_MAIN         15
#define MENU_VOTE_END          16
#define MENU_VOTE_MAP          17
#define MENU_VOTE_FAST         18
#define MENU_VOTE_FF           19
#define MENU_VOTE_TEAMS        20
#define MENU_VOTE_RULES        21
#define MENU_VOTE_ARMS         22
#define MENU_VOTE_TECH         23
#define MENU_SETTINGS          24
#define MENU_MOTD              25
#define MENU_COVEN             26
#define MENU_SECRET            27

/* Max. number of characters allowed in MOTD. */
#define MAX_MOTD_LINES         14
#define MAX_MOTD_LINE_SIZE     25
#define MAX_MOTD_SIZE         500

/* Max. maps allowed in maplist. */
#define MAX_MAPS        100


/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_select.c
*/
void Coven_Reselect (edict_t *ent);
void Coven_EndSelect (edict_t *ent);

void CovenUpdate_TeamMenu (void);
void CovenUpdate_SecretMenu (void);
void CovenUpdate_VoteEndMenu (void);
void CovenUpdate_VoteFastMenu (void);
void CovenUpdate_VoteMapMenu (void);
void CovenUpdate_VoteFireMenu (void);
void CovenUpdate_VoteTeamsMenu (void);
void CovenUpdate_VoteRulesMenu (void);
void CovenUpdate_VoteTechMenu (void);
void CovenUpdate_VoteArmsMenu (void);
void CovenUpdate_Settings (void);

void CovenMenu_Done (edict_t *ent, pmenu_t *p);
void CovenMenu_Main (edict_t *ent, pmenu_t *p);
void CovenMenu_Suits (edict_t *ent, pmenu_t *p);
void CovenMenu_HelpMain (edict_t *ent, pmenu_t *p);
void CovenMenu_Help1 (edict_t *ent, pmenu_t *p);
void CovenMenu_Help2 (edict_t *ent, pmenu_t *p);
void CovenMenu_Help3 (edict_t *ent, pmenu_t *p);
void CovenMenu_Help4 (edict_t *ent, pmenu_t *p);
void CovenMenu_Help5 (edict_t *ent, pmenu_t *p);
void CovenMenu_Weapon1 (edict_t *ent, pmenu_t *p);
void CovenMenu_Weapon2 (edict_t *ent, pmenu_t *p);
void CovenMenu_Weapon3 (edict_t *ent, pmenu_t *p);
void CovenMenu_VoteMain (edict_t *ent, pmenu_t *p);

void Coven_VoteMenu (edict_t *ent);
void Coven_HelpMenu (edict_t *ent);
void Coven_TeamMenu (edict_t *ent);
void Coven_SuitMenu (edict_t *ent);
void Coven_MainMenu (edict_t *ent);

void Coven_Key1 (edict_t *ent);
void Coven_Key2 (edict_t *ent);
void Coven_Key3 (edict_t *ent);
void Coven_Key4 (edict_t *ent);
void Coven_Key5 (edict_t *ent);
void Coven_Key6 (edict_t *ent);
void Coven_Key7 (edict_t *ent);
void Coven_Key8 (edict_t *ent);
void Coven_Key9 (edict_t *ent);
void Coven_Key0 (edict_t *ent);
void Coven_KeyOption (edict_t *ent, int key);

void Coven_GetVotes (void);

void Coven_CheckExitVote (void);
void Coven_GetVotedMap (char *newmap);
qboolean Coven_DuplicateMap (char *mapnow);
void Coven_GetMapVoteList (void);

void Coven_CycleMap (char *newmap);
void Coven_RandomMap (char *newmap);

qboolean Coven_LegalChar (char c);
void Coven_GetMOTD (void);

void Coven_ConfigInit (void);


/*===========================/  END OF FILE  /===========================*/
