/*==========================================================================
//  x_select.c -- by various                    Last updated:  6-1-1999
//--------------------------------------------------------------------------
//  This file contains menu/weapon selection related code.
//========================================================================*/

#include "g_local.h"
#include "x_client.h"
#include "x_rules.h"
#include "x_select.h"
#include "x_team.h"


/*=======================/  Player Preparation  /=======================*/

/*----------------------------------------------------/ New Code /--------//
//  This lets a player get out of line and reselect suit and weapons.
//  Can also be used after death.
//------------------------------------------------------------------------*/
void Coven_Reselect (edict_t *ent)
{
/* Only in DM. */
        if (!deathmatch->value)
                return;

/* Bring up menu if player is dead or observing and not in line. */
        if (ent->deadflag)
        {
                ent->client->latched_buttons = 0;

                if (!ent->client->resp.spectator && (level.time > ent->client->respawn_time))
                {
                        // Reset 'mayplay' so player can become spectator.
                        ent->client->resp.mayplay = false;

                        // Trigger spectator respawn.
                        ent->client->pers.spectator = true;
                }
                return;
        }
        if (ent->client->resp.spectator && !ent->RA_quepos)
        {
                if (!ent->client->menu)
                {       Coven_MainMenu (ent);
                        return;
                }
                PMenu_Close (ent);
                return;
        }

/* Rest is for arena DM only. */
        if (!Coven_ArenaOn ())
                return;

/* Player cannot be playing in the arena. */
        if (ent->RA_playing)
                return;

/* Player must be in line. */
        if (!ent->RA_quepos)
                return;

/* Don't let the player get out of line if viewing chasecam. */
        if (ent->client->chase_target)
                return;

/* Remove player from line and bring up the menu. */
        Coven_RemoveFromPlayerQue (ent);
        Coven_MainMenu (ent);
}

/*----------------------------------------------------/ New Code /--------//
//  The player finished selecting a team, suit, and weapons and
//  is ready to be put into play.
//------------------------------------------------------------------------*/
void Coven_EndSelect (edict_t *ent)
{
        if (Coven_ArenaOn() && !ent->RA_playing)
        {       // Put player in line.
                ent->stall_time = 0;
                Coven_AddToPlayerQue (ent);
                return;
        }

        /* Put player in the game. */
        ent->client->pers.spectator = false;

        gi.WriteByte (svc_stufftext);
        gi.WriteString ("hand 0\n");
        gi.unicast (ent, true);
}


//=====================================================================//
// MENU

/* Template
      //{ "123456789012345678901234", PMENU_ALIGN_LEFT,   NULL },
*/

//=====================================================================//

pmenu_t main1menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Main Menu",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Armoury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Color Select",          PMENU_ALIGN_LEFT,    NULL },
        { "3. Help",                  PMENU_ALIGN_LEFT,    NULL },
        { "4. Voting Options",        PMENU_ALIGN_LEFT,    NULL },
        { "5. Current Settings",      PMENU_ALIGN_LEFT,    NULL },
        { "6. Message of the Day",    PMENU_ALIGN_LEFT,    NULL },
        { "7. The Coven",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to join the game",   PMENU_ALIGN_LEFT2,   CovenMenu_Done },
        { "ESC to Exit Menu",         PMENU_ALIGN_LEFT,    NULL },
        { "(TAB to Return)",          PMENU_ALIGN_LEFT,    NULL },
};

pmenu_t main2menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Main Menu",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Armoury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Join a Team",           PMENU_ALIGN_LEFT,    NULL },
        { "3. Help",                  PMENU_ALIGN_LEFT,    NULL },
        { "4. Voting Options",        PMENU_ALIGN_LEFT,    NULL },
        { "5. Current Settings",      PMENU_ALIGN_LEFT,    NULL },
        { "6. Message of the Day",    PMENU_ALIGN_LEFT,    NULL },
        { "7. The Coven",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to join the game",   PMENU_ALIGN_LEFT2,   CovenMenu_Done },
        { "ESC to Exit Menu",         PMENU_ALIGN_LEFT,    NULL },
        { "(TAB to Return)",          PMENU_ALIGN_LEFT,    NULL },
};

pmenu_t main3menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Main Menu",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Armoury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Color Select",          PMENU_ALIGN_LEFT,    NULL },
        { "3. Help",                  PMENU_ALIGN_LEFT,    NULL },
        { "4. Voting Options",        PMENU_ALIGN_LEFT,    NULL },
        { "5. Current Settings",      PMENU_ALIGN_LEFT,    NULL },
        { "6. Message of the Day",    PMENU_ALIGN_LEFT,    NULL },
        { "7. The Coven",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ESC to Exit Menu",         PMENU_ALIGN_LEFT,    NULL },
        { "(TAB to Return)",          PMENU_ALIGN_LEFT,    NULL },
};

pmenu_t main4menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Main Menu",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Armoury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Join a Team",           PMENU_ALIGN_LEFT,    NULL },
        { "3. Help",                  PMENU_ALIGN_LEFT,    NULL },
        { "4. Voting Options",        PMENU_ALIGN_LEFT,    NULL },
        { "5. Current Settings",      PMENU_ALIGN_LEFT,    NULL },
        { "6. Message of the Day",    PMENU_ALIGN_LEFT,    NULL },
        { "7. The Coven",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ESC to Exit Menu",         PMENU_ALIGN_LEFT,    NULL },
        { "(TAB to Return)",          PMENU_ALIGN_LEFT,    NULL },
};


/*============================/  Armoury  /============================*/

pmenu_t suitmenu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Suit Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "LIGHT",                    PMENU_ALIGN_LEFT2,   NULL },
        { "1. Mercury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Zeppelin",              PMENU_ALIGN_LEFT,    NULL },
        { "MEDIUM",                   PMENU_ALIGN_LEFT2,   NULL },
        { "3. GravyBurner",           PMENU_ALIGN_LEFT,    NULL },
        { "4. WireCutter",            PMENU_ALIGN_LEFT,    NULL },
        { "HEAVY",                    PMENU_ALIGN_LEFT2,   NULL },
        { "5. Rhino",                 PMENU_ALIGN_LEFT,    NULL },
        { "6. SugarConny",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t suitbmenu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Suit Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "LIGHT",                    PMENU_ALIGN_LEFT2,   NULL },
        { "1. Mercury",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Zeppelin",              PMENU_ALIGN_LEFT,    NULL },
        { "MEDIUM",                   PMENU_ALIGN_LEFT2,   NULL },
        { "3. GravyBurner",           PMENU_ALIGN_LEFT,    NULL },
        { "4. WireCutter",            PMENU_ALIGN_LEFT,    NULL },
        { "HEAVY",                    PMENU_ALIGN_LEFT2,   NULL },
        { "5. BulkHead",              PMENU_ALIGN_LEFT,    NULL },
        { "6. SugarConny",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t left1menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Left Weapon Select",       PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Grapple",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Assault Shotgun",       PMENU_ALIGN_LEFT,    NULL },
        { "3. Particle Beam",         PMENU_ALIGN_LEFT,    NULL },
        { "4. Grenade Launcher",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};

pmenu_t left2menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Left Weapon Select",       PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Prod Rod",              PMENU_ALIGN_LEFT,    NULL },
        { "2. Photon Cannon",         PMENU_ALIGN_LEFT,    NULL },
        { "3. Minigun",               PMENU_ALIGN_LEFT,    NULL },
        { "4. Bazooka",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};

pmenu_t left3menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Left Weapon Select",       PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Carver",                PMENU_ALIGN_LEFT,    NULL },
        { "2. Flamethrower",          PMENU_ALIGN_LEFT,    NULL },
        { "3. Auto Shotgun",          PMENU_ALIGN_LEFT,    NULL },
        { "4. MIRV Launcher",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};


pmenu_t right1menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Right Weapon Select",      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Grapple",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Assault Shotgun",       PMENU_ALIGN_LEFT,    NULL },
        { "3. Particle Beam",         PMENU_ALIGN_LEFT,    NULL },
        { "4. Grenade Launcher",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};

pmenu_t right2menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Right Weapon Select",      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Prod Rod",              PMENU_ALIGN_LEFT,    NULL },
        { "2. Photon Cannon",         PMENU_ALIGN_LEFT,    NULL },
        { "3. Minigun",               PMENU_ALIGN_LEFT,    NULL },
        { "4. Bazooka",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};

pmenu_t right3menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Right Weapon Select",      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Carver",                PMENU_ALIGN_LEFT,    NULL },
        { "2. Flamethrower",          PMENU_ALIGN_LEFT,    NULL },
        { "3. Auto Shotgun",          PMENU_ALIGN_LEFT,    NULL },
        { "4. MIRV Launcher",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Suits },
};


/*============================/  Team Menu  /============================*/

pmenu_t skinmenu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Color Select",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Blue",                  PMENU_ALIGN_LEFT,    NULL },
        { "2. Red",                   PMENU_ALIGN_LEFT,    NULL },
        { "3. Green",                 PMENU_ALIGN_LEFT,    NULL },
        { "4. Gold",                  PMENU_ALIGN_LEFT,    NULL },
        { "5. Purple",                PMENU_ALIGN_LEFT,    NULL },
        { "6. Gray",                  PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t skin2menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Team Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  TEAM   SIZE",           PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "1. Blue",                  PMENU_ALIGN_LEFT,    NULL },
        { "2. Red",                   PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t skin3menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Team Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  TEAM   SIZE",           PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "1. Blue",                  PMENU_ALIGN_LEFT,    NULL },
        { "2. Red",                   PMENU_ALIGN_LEFT,    NULL },
        { "3. Green",                 PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t skin4menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Team Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  TEAM   SIZE",           PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "1. Blue",                  PMENU_ALIGN_LEFT,    NULL },
        { "2. Red",                   PMENU_ALIGN_LEFT,    NULL },
        { "3. Green",                 PMENU_ALIGN_LEFT,    NULL },
        { "4. Gold",                  PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};

pmenu_t skin5menu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Team Select",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  TEAM   SIZE",           PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "1. Blue",                  PMENU_ALIGN_LEFT,    NULL },
        { "2. Red",                   PMENU_ALIGN_LEFT,    NULL },
        { "3. Green",                 PMENU_ALIGN_LEFT,    NULL },
        { "4. Gold",                  PMENU_ALIGN_LEFT,    NULL },
        { "5. Purple",                PMENU_ALIGN_LEFT,    NULL },
        { "",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};


/*==========================/  Main Help Menu  /==========================*/

pmenu_t helpmainmenu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Help Main Menu",           PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Rules",                 PMENU_ALIGN_LEFT,    NULL },
        { "2. Suits",                 PMENU_ALIGN_LEFT,    NULL },
        { "3. Weapons",               PMENU_ALIGN_LEFT,    NULL },
        { "4. New Commands",          PMENU_ALIGN_LEFT,    NULL },
        { "5. FAQ",                   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};


/*============================/  Rules Menu  /============================*/

pmenu_t help1menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Rules",                    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Getting Started",       PMENU_ALIGN_LEFT,    NULL },
        { "2. The Aim",               PMENU_ALIGN_LEFT,    NULL },
        { "3. Arena:  Duel",          PMENU_ALIGN_LEFT,    NULL },
        { "4. Arena:  Elimination",   PMENU_ALIGN_LEFT,    NULL },
        { "5. Capture",               PMENU_ALIGN_LEFT,    NULL },
        { "6. CTF",                   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_HelpMain },
};

pmenu_t rule1menu[] = {
        { "Getting Started",          PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "To start, you must go",    PMENU_ALIGN_LEFT,    NULL },
        { "to the Armoury, select",   PMENU_ALIGN_LEFT,    NULL },
        { "a battlesuit, and then",   PMENU_ALIGN_LEFT,    NULL },
        { "choose a weapon for",      PMENU_ALIGN_LEFT,    NULL },
        { "each arm.",                PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Choose your weapons",      PMENU_ALIGN_LEFT,    NULL },
        { "wisely, for you will not", PMENU_ALIGN_LEFT,    NULL },
        { "find any new weapons to",  PMENU_ALIGN_LEFT,    NULL },
        { "pickup.  In addition,",    PMENU_ALIGN_LEFT,    NULL },
        { "you may pickup ammo",      PMENU_ALIGN_LEFT,    NULL },
        { "only if you have the",     PMENU_ALIGN_LEFT,    NULL },
        { "weapons or equipment",     PMENU_ALIGN_LEFT,    NULL },
        { "that use it.",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};

pmenu_t rule2menu[] = {
        { "The Aim",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "The aim is to earn the",   PMENU_ALIGN_LEFT,    NULL },
        { "most points by killing",   PMENU_ALIGN_LEFT,    NULL },
        { "your opponents as many",   PMENU_ALIGN_LEFT,    NULL },
        { "times as possible.",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "The server may also",      PMENU_ALIGN_LEFT,    NULL },
        { "employ arena, capture,",   PMENU_ALIGN_LEFT,    NULL },
        { "or CTF modes of play.",    PMENU_ALIGN_LEFT,    NULL },
        { "Each mode has its",        PMENU_ALIGN_LEFT,    NULL },
        { "own set of rules and",     PMENU_ALIGN_LEFT,    NULL },
        { "possible bonus scoring.",  PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};

pmenu_t rule3menu[] = {
        { "Arena:  Duel",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "In arena duel, two",       PMENU_ALIGN_LEFT,    NULL },
        { "players or teams are",     PMENU_ALIGN_LEFT,    NULL },
        { "pitted against each",      PMENU_ALIGN_LEFT,    NULL },
        { "other.  Extra clients",    PMENU_ALIGN_LEFT,    NULL },
        { "must wait in line and",    PMENU_ALIGN_LEFT,    NULL },
        { "observe until one side",   PMENU_ALIGN_LEFT,    NULL },
        { "conquers the other.",      PMENU_ALIGN_LEFT,    NULL },
        { "The winning side will",    PMENU_ALIGN_LEFT,    NULL },
        { "face the next player",     PMENU_ALIGN_LEFT,    NULL },
        { "or team in line while",    PMENU_ALIGN_LEFT,    NULL },
        { "the losing side is",       PMENU_ALIGN_LEFT,    NULL },
        { "moved to the end of",      PMENU_ALIGN_LEFT,    NULL },
        { "the line.",                PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};

pmenu_t rule4menu[] = {
        { "Arena:  Elimination",      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "In arena elimination,",    PMENU_ALIGN_LEFT,    NULL },
        { "all players are placed",   PMENU_ALIGN_LEFT,    NULL },
        { "in the game and fight",    PMENU_ALIGN_LEFT,    NULL },
        { "until one player or",      PMENU_ALIGN_LEFT,    NULL },
        { "team is left standing.",   PMENU_ALIGN_LEFT,    NULL },
        { "Defeated players cannot",  PMENU_ALIGN_LEFT,    NULL },
        { "reenter the fight until",  PMENU_ALIGN_LEFT,    NULL },
        { "the elimination is over.", PMENU_ALIGN_LEFT,    NULL },
        { "The sole player or team",  PMENU_ALIGN_LEFT,    NULL },
        { "who survives at the end",  PMENU_ALIGN_LEFT,    NULL },
        { "earns bonus points.",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};

pmenu_t rule5menu[] = {
        { "Capture",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "In capture, players are",  PMENU_ALIGN_LEFT,    NULL },
        { "given runes that boost",   PMENU_ALIGN_LEFT,    NULL },
        { "defense, offense, or",     PMENU_ALIGN_LEFT,    NULL },
        { "health.  The goal is to",  PMENU_ALIGN_LEFT,    NULL },
        { "capture all the runes.",   PMENU_ALIGN_LEFT,    NULL },
        { "To do this, you must",     PMENU_ALIGN_LEFT,    NULL },
        { "defeat other players who", PMENU_ALIGN_LEFT,    NULL },
        { "carry runes.  Death will", PMENU_ALIGN_LEFT,    NULL },
        { "cause a player to drop",   PMENU_ALIGN_LEFT,    NULL },
        { "all the runes he or she",  PMENU_ALIGN_LEFT,    NULL },
        { "held.  The first player",  PMENU_ALIGN_LEFT,    NULL },
        { "or team who collects all", PMENU_ALIGN_LEFT,    NULL },
        { "the runes wins a score",   PMENU_ALIGN_LEFT,    NULL },
        { "bonus.",                   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};

pmenu_t rule6menu[] = {
        { "CTF",                      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "In CTF, players join on",  PMENU_ALIGN_LEFT,    NULL },
        { "one of two teams, then",   PMENU_ALIGN_LEFT,    NULL },
        { "try to capture the other", PMENU_ALIGN_LEFT,    NULL },
        { "team's flag as many",      PMENU_ALIGN_LEFT,    NULL },
        { "times as possible.",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "To capture the flag, you", PMENU_ALIGN_LEFT,    NULL },
        { "must take the flag from",  PMENU_ALIGN_LEFT,    NULL },
        { "the enemy base, then",     PMENU_ALIGN_LEFT,    NULL },
        { "bring it to your team's",  PMENU_ALIGN_LEFT,    NULL },
        { "flag.",                    PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help1 },
};


/*============================/  Suits Menu  /============================*/

pmenu_t help2menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Suits",                    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Light",                 PMENU_ALIGN_LEFT,    NULL },
        { "2. Medium",                PMENU_ALIGN_LEFT,    NULL },
        { "3. Heavy",                 PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_HelpMain },
};

pmenu_t suit1menu[] = {
        { "Light Suits",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "MERCURY",                  PMENU_ALIGN_LEFT2,   NULL },
        { "  Lithe femme fatale.",    PMENU_ALIGN_LEFT,    NULL },
        { "ZEPPELIN",                 PMENU_ALIGN_LEFT2,   NULL },
        { "  Winged metalhead.",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "The suits in this",        PMENU_ALIGN_LEFT,    NULL },
        { "class possess enhanced",   PMENU_ALIGN_LEFT,    NULL },
        { "abilities that make up",   PMENU_ALIGN_LEFT,    NULL },
        { "for their relatively",     PMENU_ALIGN_LEFT,    NULL },
        { "weak firepower.  They",    PMENU_ALIGN_LEFT,    NULL },
        { "can run silently, swim",   PMENU_ALIGN_LEFT,    NULL },
        { "longer without air, and",  PMENU_ALIGN_LEFT,    NULL },
        { "use a jetpack to fly.",    PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help2 },
};

pmenu_t suit2menu[] = {
        { "Medium Suits",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "GRAVYBURNER",              PMENU_ALIGN_LEFT2,   NULL },
        { "  Tall man of steel.",     PMENU_ALIGN_LEFT,    NULL },
        { "WIRECUTTER",               PMENU_ALIGN_LEFT2,   NULL },
        { "  Bulky robo-turtle.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "These suits have the",     PMENU_ALIGN_LEFT,    NULL },
        { "same basic physical",      PMENU_ALIGN_LEFT,    NULL },
        { "abilities as marines.",    PMENU_ALIGN_LEFT,    NULL },
        { "They also have good",      PMENU_ALIGN_LEFT,    NULL },
        { "firepower -- more than",   PMENU_ALIGN_LEFT,    NULL },
        { "a light suit, but less",   PMENU_ALIGN_LEFT,    NULL },
        { "than a heavy suit.",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help2 },
};

pmenu_t suit3menu[] = {
        { "Heavy Suits",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "RHINO",                    PMENU_ALIGN_LEFT2,   NULL },
        { "  Horned cyber-beast.",    PMENU_ALIGN_LEFT,    NULL },
        { "SUGARCONNY",               PMENU_ALIGN_LEFT2,   NULL },
        { "  Fat, shambling hulk.",   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "These massive behemoths",  PMENU_ALIGN_LEFT,    NULL },
        { "are always armed with",    PMENU_ALIGN_LEFT,    NULL },
        { "very powerful weapons.",   PMENU_ALIGN_LEFT,    NULL },
        { "However, heavy suits",     PMENU_ALIGN_LEFT,    NULL },
        { "move slower than lighter", PMENU_ALIGN_LEFT,    NULL },
        { "suits, and they always",   PMENU_ALIGN_LEFT,    NULL },
        { "stomp loudly whenever",    PMENU_ALIGN_LEFT,    NULL },
        { "they walk.",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help2 },
};

pmenu_t suit3bmenu[] = {
        { "Heavy Suits",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "BULKHEAD",                 PMENU_ALIGN_LEFT2,   NULL },
        { "  The inhuman tank.",      PMENU_ALIGN_LEFT,    NULL },
        { "SUGARCONNY",               PMENU_ALIGN_LEFT2,   NULL },
        { "  Fat, shambling hulk.",   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "These slow and noisy",     PMENU_ALIGN_LEFT,    NULL },
        { "behemoths wield very",     PMENU_ALIGN_LEFT,    NULL },
        { "powerful weapons.",        PMENU_ALIGN_LEFT,    NULL },
        { "BulkHead cannot crouch,",  PMENU_ALIGN_LEFT,    NULL },
        { "but instead ducks his",    PMENU_ALIGN_LEFT,    NULL },
        { "head behind his armor,",   PMENU_ALIGN_LEFT,    NULL },
        { "halving all damage.",      PMENU_ALIGN_LEFT,    NULL },
        { "BulkHead is also fire",    PMENU_ALIGN_LEFT,    NULL },
        { "resistant.",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help2 },
};


/*===========================/  Weapons Menu  /===========================*/

pmenu_t help3menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Weapons",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Light",                 PMENU_ALIGN_LEFT,    NULL },
        { "2. Medium",                PMENU_ALIGN_LEFT,    NULL },
        { "3. Heavy",                 PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_HelpMain },
};

pmenu_t weapon1menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Light Weapons",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Grapple",               PMENU_ALIGN_LEFT,    NULL },
        { "2. Assault Shotgun",       PMENU_ALIGN_LEFT,    NULL },
        { "3. Particle Beam",         PMENU_ALIGN_LEFT,    NULL },
        { "4. Grenade Launcher",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Help3 },
};

pmenu_t weapon2menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Medium Weapons",           PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Prod Rod",              PMENU_ALIGN_LEFT,    NULL },
        { "2. Photon Cannon",         PMENU_ALIGN_LEFT,    NULL },
        { "3. Minigun",               PMENU_ALIGN_LEFT,    NULL },
        { "4. Bazooka",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Help3 },
};

pmenu_t weapon3menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "Heavy Weapons",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. Carver",                PMENU_ALIGN_LEFT,    NULL },
        { "2. Flamethrower",          PMENU_ALIGN_LEFT,    NULL },
        { "3. Auto Shotgun",          PMENU_ALIGN_LEFT,    NULL },
        { "4. MIRV Launcher",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Help3 },
};

pmenu_t weapon11menu[] = {
        { "Grapple",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  N/A",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This is useful for",       PMENU_ALIGN_LEFT,    NULL },
        { "climbing as well as",      PMENU_ALIGN_LEFT,    NULL },
        { "disemboweling opponents.", PMENU_ALIGN_LEFT,    NULL },
        { "As long as you press and", PMENU_ALIGN_LEFT,    NULL },
        { "hold the attack button,",  PMENU_ALIGN_LEFT,    NULL },
        { "you will be able to move", PMENU_ALIGN_LEFT,    NULL },
        { "along the cable or drill", PMENU_ALIGN_LEFT,    NULL },
        { "an opponent until the",    PMENU_ALIGN_LEFT,    NULL },
        { "cable is severed.",        PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon1 },
};

pmenu_t weapon12menu[] = {
        { "Assault Shotgun",          PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Shells",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This gun shoots a",        PMENU_ALIGN_LEFT,    NULL },
        { "burst of three shells",    PMENU_ALIGN_LEFT,    NULL },
        { "followed by a second of",  PMENU_ALIGN_LEFT,    NULL },
        { "reloading.  Powerful at",  PMENU_ALIGN_LEFT,    NULL },
        { "close range, the pellets", PMENU_ALIGN_LEFT,    NULL },
        { "will spread out to cover", PMENU_ALIGN_LEFT,    NULL },
        { "a wide area at further",   PMENU_ALIGN_LEFT,    NULL },
        { "distances.",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon1 },
};

pmenu_t weapon13menu[] = {
        { "Particle Beam",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Cells",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This rapid-fire energy",   PMENU_ALIGN_LEFT,    NULL },
        { "weapon shoots atomic-",    PMENU_ALIGN_LEFT,    NULL },
        { "sized particles near",     PMENU_ALIGN_LEFT,    NULL },
        { "the speed of light.",      PMENU_ALIGN_LEFT,    NULL },
        { "If the particles make",    PMENU_ALIGN_LEFT,    NULL },
        { "contact with any solid,",  PMENU_ALIGN_LEFT,    NULL },
        { "they release their",       PMENU_ALIGN_LEFT,    NULL },
        { "energy in a small",        PMENU_ALIGN_LEFT,    NULL },
        { "explosion that damages",   PMENU_ALIGN_LEFT,    NULL },
        { "any targets nearby.",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon1 },
};

pmenu_t weapon14menu[] = {
        { "Grenade Launcher",         PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Grenades",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "The name speaks for",      PMENU_ALIGN_LEFT,    NULL },
        { "itself -- it lobs",        PMENU_ALIGN_LEFT,    NULL },
        { "powerful grenades at",     PMENU_ALIGN_LEFT,    NULL },
        { "high speeds.  Although",   PMENU_ALIGN_LEFT,    NULL },
        { "the rate of fire is slow", PMENU_ALIGN_LEFT,    NULL },
        { "and it takes some skill",  PMENU_ALIGN_LEFT,    NULL },
        { "to aim grenades, the",     PMENU_ALIGN_LEFT,    NULL },
        { "damage is very good.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon1 },
};


pmenu_t weapon21menu[] = {
        { "Prod Rod",                 PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  N/A",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This acts as both a",      PMENU_ALIGN_LEFT,    NULL },
        { "short range blaster and",  PMENU_ALIGN_LEFT,    NULL },
        { "a pogo stick.  If the",    PMENU_ALIGN_LEFT,    NULL },
        { "rod strikes a target, it", PMENU_ALIGN_LEFT,    NULL },
        { "it inflicts heavy damage", PMENU_ALIGN_LEFT,    NULL },
        { "and shoves the target",    PMENU_ALIGN_LEFT,    NULL },
        { "away.  If the rod",        PMENU_ALIGN_LEFT,    NULL },
        { "strikes a wall or",        PMENU_ALIGN_LEFT,    NULL },
        { "floor, the attacker is",   PMENU_ALIGN_LEFT,    NULL },
        { "propelled away.  If the",  PMENU_ALIGN_LEFT,    NULL },
        { "rod misses, a powerful",   PMENU_ALIGN_LEFT,    NULL },
        { "blaster bolt is fired.",   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon2 },
};

pmenu_t weapon22menu[] = {
        { "Photon Cannon",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Cells",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This gun shoots a",        PMENU_ALIGN_LEFT,    NULL },
        { "powerful beam that",       PMENU_ALIGN_LEFT,    NULL },
        { "explodes on contact,",     PMENU_ALIGN_LEFT,    NULL },
        { "damaging those nearby.",   PMENU_ALIGN_LEFT,    NULL },
        { "If a target is struck",    PMENU_ALIGN_LEFT,    NULL },
        { "by the beam, the target",  PMENU_ALIGN_LEFT,    NULL },
        { "will take severe damage",  PMENU_ALIGN_LEFT,    NULL },
        { "and get thrown.  Also,",   PMENU_ALIGN_LEFT,    NULL },
        { "more beams can erupt",     PMENU_ALIGN_LEFT,    NULL },
        { "from the victim to",       PMENU_ALIGN_LEFT,    NULL },
        { "strike more targets.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon2 },
};

pmenu_t weapon23menu[] = {
        { "Minigun",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Bullets",           PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This is a chaingun",       PMENU_ALIGN_LEFT,    NULL },
        { "with almost no spin",      PMENU_ALIGN_LEFT,    NULL },
        { "time delay.  The damage",  PMENU_ALIGN_LEFT,    NULL },
        { "this weapon can do as",    PMENU_ALIGN_LEFT,    NULL },
        { "well as the amount of",    PMENU_ALIGN_LEFT,    NULL },
        { "bullets it consumes is",   PMENU_ALIGN_LEFT,    NULL },
        { "fearsome indeed.",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon2 },
};

pmenu_t weapon24menu[] = {
        { "Bazooka",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Rockets",           PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This is the basic",        PMENU_ALIGN_LEFT,    NULL },
        { "rocket launcher.  The",    PMENU_ALIGN_LEFT,    NULL },
        { "rockets fly moderately",   PMENU_ALIGN_LEFT,    NULL },
        { "fast and do excellent",    PMENU_ALIGN_LEFT,    NULL },
        { "damage to those caught",   PMENU_ALIGN_LEFT,    NULL },
        { "in the blast.  The",       PMENU_ALIGN_LEFT,    NULL },
        { "rate of fire is also",     PMENU_ALIGN_LEFT,    NULL },
        { "relatively fast.",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon2 },
};


pmenu_t weapon31menu[] = {
        { "Carver",                   PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  N/A",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This is a circular",       PMENU_ALIGN_LEFT,    NULL },
        { "saw designed for melee.",  PMENU_ALIGN_LEFT,    NULL },
        { "There is a delay as",      PMENU_ALIGN_LEFT,    NULL },
        { "it spins up, but once",    PMENU_ALIGN_LEFT,    NULL },
        { "spinning, it can do mad",  PMENU_ALIGN_LEFT,    NULL },
        { "damage.  Once at full",    PMENU_ALIGN_LEFT,    NULL },
        { "speed, any light or",      PMENU_ALIGN_LEFT,    NULL },
        { "medium suit it hits",      PMENU_ALIGN_LEFT,    NULL },
        { "will be killed instantly", PMENU_ALIGN_LEFT,    NULL },
        { "regardless of health or",  PMENU_ALIGN_LEFT,    NULL },
        { "armor unless half damage", PMENU_ALIGN_LEFT,    NULL },
        { "is set.",                  PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon3 },
};

pmenu_t weapon32menu[] = {
        { "Flamethrower",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Fuel",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This weapon spews forth",  PMENU_ALIGN_LEFT,    NULL },
        { "a burst of flame that",    PMENU_ALIGN_LEFT,    NULL },
        { "sets victims on fire.",    PMENU_ALIGN_LEFT,    NULL },
        { "While burning, each",      PMENU_ALIGN_LEFT,    NULL },
        { "victim takes damage",      PMENU_ALIGN_LEFT,    NULL },
        { "each second, and can",     PMENU_ALIGN_LEFT,    NULL },
        { "spread the fire to",       PMENU_ALIGN_LEFT,    NULL },
        { "others -- even you!",      PMENU_ALIGN_LEFT,    NULL },
        { "The flamethrower is",      PMENU_ALIGN_LEFT,    NULL },
        { "useless underwater.",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon3 },
};

pmenu_t weapon33menu[] = {
        { "Auto Shotgun",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Shells",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This is a rapid-fire",     PMENU_ALIGN_LEFT,    NULL },
        { "shotgun, and it can",      PMENU_ALIGN_LEFT,    NULL },
        { "spray an area full of",    PMENU_ALIGN_LEFT,    NULL },
        { "lethal pellets in a",      PMENU_ALIGN_LEFT,    NULL },
        { "short amount of time.",    PMENU_ALIGN_LEFT,    NULL },
        { "The damage potential",     PMENU_ALIGN_LEFT,    NULL },
        { "is very high.",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon3 },
};

pmenu_t weapon34menu[] = {
        { "MIRV Launcher",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Ammo:  Rockets",           PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "This launches a slow but", PMENU_ALIGN_LEFT,    NULL },
        { "very powerful rocket.",    PMENU_ALIGN_LEFT,    NULL },
        { "Once it explodes, four",   PMENU_ALIGN_LEFT,    NULL },
        { "more weaker missiles",     PMENU_ALIGN_LEFT,    NULL },
        { "will emerge from the",     PMENU_ALIGN_LEFT,    NULL },
        { "explosion and fly",        PMENU_ALIGN_LEFT,    NULL },
        { "erratically.  These",      PMENU_ALIGN_LEFT,    NULL },
        { "missiles will home in",    PMENU_ALIGN_LEFT,    NULL },
        { "on targets visible to",    PMENU_ALIGN_LEFT,    NULL },
        { "both the attacker and",    PMENU_ALIGN_LEFT,    NULL },
        { "the initial explosion.",   PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Weapon3 },
};


/*===========================/  Command Menu  /===========================*/

pmenu_t help4menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "New Commands",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. altscore",              PMENU_ALIGN_LEFT,    NULL },
        { "2. id",                    PMENU_ALIGN_LEFT,    NULL },
        { "3. key [value]",           PMENU_ALIGN_LEFT,    NULL },
        { "4. menu",                  PMENU_ALIGN_LEFT,    NULL },
        { "5. push",                  PMENU_ALIGN_LEFT,    NULL },
        { "6. team [value]",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_HelpMain },
};

pmenu_t cmd1menu[] = {
        { "Command:  altscore",       PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "This toggles the",         PMENU_ALIGN_LEFT,    NULL },
        { "player's alternate",       PMENU_ALIGN_LEFT,    NULL },
        { "scoreboard display.",      PMENU_ALIGN_LEFT,    NULL },
        { "Alternate scoreboards",    PMENU_ALIGN_LEFT,    NULL },
        { "are available only in",    PMENU_ALIGN_LEFT,    NULL },
        { "team games.",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "In CTF, the alternate",    PMENU_ALIGN_LEFT,    NULL },
        { "scoreboard is text only.", PMENU_ALIGN_LEFT,    NULL },
        { "In other team games, the", PMENU_ALIGN_LEFT,    NULL },
        { "alternate scoreboard",     PMENU_ALIGN_LEFT,    NULL },
        { "displays only teammates.", PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};

pmenu_t cmd2menu[] = {
        { "Command:  id",             PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "This toggles the",         PMENU_ALIGN_LEFT,    NULL },
        { "player's target",          PMENU_ALIGN_LEFT,    NULL },
        { "identification.",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Unless target id is",      PMENU_ALIGN_LEFT,    NULL },
        { "disabled by the server,",  PMENU_ALIGN_LEFT,    NULL },
        { "it is on by default.",     PMENU_ALIGN_LEFT,    NULL },
        { "While the target id is",   PMENU_ALIGN_LEFT,    NULL },
        { "active, the mug, name,",   PMENU_ALIGN_LEFT,    NULL },
        { "and distance in metres",   PMENU_ALIGN_LEFT,    NULL },
        { "of any living target",     PMENU_ALIGN_LEFT,    NULL },
        { "aimed at by the player",   PMENU_ALIGN_LEFT,    NULL },
        { "are displayed.",           PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};

pmenu_t cmd3menu[] = {
        { "Command:  key [value]",    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Usable only in menus,",    PMENU_ALIGN_LEFT,    NULL },
        { "this command selects",     PMENU_ALIGN_LEFT,    NULL },
        { "the option displayed",     PMENU_ALIGN_LEFT,    NULL },
        { "next to its number.",      PMENU_ALIGN_LEFT,    NULL },
        { "If no value was given",    PMENU_ALIGN_LEFT,    NULL },
        { "or the value given was",   PMENU_ALIGN_LEFT,    NULL },
        { "not a number, zero will",  PMENU_ALIGN_LEFT,    NULL },
        { "be assumed.",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};

pmenu_t cmd4menu[] = {
        { "Command:  menu",           PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "This allows dead players", PMENU_ALIGN_LEFT,    NULL },
        { "to become spectators,",    PMENU_ALIGN_LEFT,    NULL },
        { "and opens or closes",      PMENU_ALIGN_LEFT,    NULL },
        { "the main menu for",        PMENU_ALIGN_LEFT,    NULL },
        { "spectators.",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "In arena, if you open",    PMENU_ALIGN_LEFT,    NULL },
        { "the main menu while you",  PMENU_ALIGN_LEFT,    NULL },
        { "are waiting in line,",     PMENU_ALIGN_LEFT,    NULL },
        { "your player will be",      PMENU_ALIGN_LEFT,    NULL },
        { "taken out of line.",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};

pmenu_t cmd5menu[] = {
        { "Command:  push",           PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "This causes your player",  PMENU_ALIGN_LEFT,    NULL },
        { "to push a target that is", PMENU_ALIGN_LEFT,    NULL },
        { "up close and directly in", PMENU_ALIGN_LEFT,    NULL },
        { "front of you.",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "If the target is another", PMENU_ALIGN_LEFT,    NULL },
        { "player, he or she is",     PMENU_ALIGN_LEFT,    NULL },
        { "pushed away unharmed.",    PMENU_ALIGN_LEFT,    NULL },
        { "If the target is a",       PMENU_ALIGN_LEFT,    NULL },
        { "shootable button,",        PMENU_ALIGN_LEFT,    NULL },
        { "door, or wall; it",        PMENU_ALIGN_LEFT,    NULL },
        { "may activate.  (e.g.,",    PMENU_ALIGN_LEFT,    NULL },
        { "secret doors open.)",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};

pmenu_t cmd6menu[] = {
        { "Command:  team [value]",   PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "If no value is given,",    PMENU_ALIGN_LEFT,    NULL },
        { "this command will show",   PMENU_ALIGN_LEFT,    NULL },
        { "the name of the team",     PMENU_ALIGN_LEFT,    NULL },
        { "your player is on.",       PMENU_ALIGN_LEFT,    NULL },
        { "Otherwise, this may",      PMENU_ALIGN_LEFT,    NULL },
        { "change the color or",      PMENU_ALIGN_LEFT,    NULL },
        { "team of your player.",     PMENU_ALIGN_LEFT,    NULL },
        { "The value may be a",       PMENU_ALIGN_LEFT,    NULL },
        { "number or the actual",     PMENU_ALIGN_LEFT,    NULL },
        { "name of the team.  If",    PMENU_ALIGN_LEFT,    NULL },
        { "value is gibberish,",      PMENU_ALIGN_LEFT,    NULL },
        { "zero will be assumed.",    PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help4 },
};


/*=============================/  FAQ Menu  /=============================*/

pmenu_t help5menu[] = {
        { "",                         PMENU_ALIGN_CENTER2, NULL },
        { "FAQ",                      PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. How do I change",       PMENU_ALIGN_LEFT,    NULL },
        { "    weapons?",             PMENU_ALIGN_LEFT,    NULL },
        { "2. How do I fly?",         PMENU_ALIGN_LEFT,    NULL },
        { "3. How do I put out",      PMENU_ALIGN_LEFT,    NULL },
        { "    fires?",               PMENU_ALIGN_LEFT,    NULL },
        { "4. Why can't battlesuits", PMENU_ALIGN_LEFT,    NULL },
        { "    wave?",                PMENU_ALIGN_LEFT,    NULL },
        { "5. Why can't I see or",    PMENU_ALIGN_LEFT,    NULL },
        { "    hear...?",             PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_HelpMain },
};

pmenu_t faq1menu[] = {
        { "How do I change weapons?", PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "To switch weapons, press", PMENU_ALIGN_LEFT,    NULL },
        { "'/' or any of the number", PMENU_ALIGN_LEFT,    NULL },
        { "keys.  You can also go",   PMENU_ALIGN_LEFT,    NULL },
        { "to the console and type",  PMENU_ALIGN_LEFT,    NULL },
        { "'weapnext'.",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "If all weapons are on,",   PMENU_ALIGN_LEFT,    NULL },
        { "keys 1-4 are linked to",   PMENU_ALIGN_LEFT,    NULL },
        { "one of the four weapons.", PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "1 = Melee (no ammo)",      PMENU_ALIGN_LEFT,    NULL },
        { "2 = Power Shot",           PMENU_ALIGN_LEFT,    NULL },
        { "3 = Rapid Fire",           PMENU_ALIGN_LEFT,    NULL },
        { "4 = Artillery",            PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};

pmenu_t faq2menu[] = {
        { "How do I fly?",            PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Before you can fly, you",  PMENU_ALIGN_LEFT,    NULL },
        { "must have a jetpack and",  PMENU_ALIGN_LEFT,    NULL },
        { "fuel.  Only a light suit", PMENU_ALIGN_LEFT,    NULL },
        { "can carry a jetpack.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "To activate the jetpack,", PMENU_ALIGN_LEFT,    NULL },
        { "press 'g'.  You can also", PMENU_ALIGN_LEFT,    NULL },
        { "go to the console and",    PMENU_ALIGN_LEFT,    NULL },
        { "type 'use Jetpack'.",      PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};

pmenu_t faq3menu[] = {
        { "Help, I'm burning!",       PMENU_ALIGN_CENTER2, NULL },
        { "How do I put out fires?",  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "Once you catch on fire,",  PMENU_ALIGN_LEFT,    NULL },
        { "do one of the following",  PMENU_ALIGN_LEFT,    NULL },
        { "to snuff the flames:",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Enter a pool of liquid.",  PMENU_ALIGN_LEFT,    NULL },
        { "Pick up adrenaline.",      PMENU_ALIGN_LEFT,    NULL },
        { "Pick up 10+ health.",      PMENU_ALIGN_LEFT,    NULL },
        { "Use invulnerability.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};

pmenu_t faq4menu[] = {
        { "Why can't battlesuits",    PMENU_ALIGN_CENTER2, NULL },
        { "wave?",                    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "None of the battlesuit",   PMENU_ALIGN_LEFT,    NULL },
        { "models have any wave",     PMENU_ALIGN_LEFT,    NULL },
        { "animations.",              PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Since battlesuits cannot", PMENU_ALIGN_LEFT,    NULL },
        { "wave, the wave command",   PMENU_ALIGN_LEFT,    NULL },
        { "will cause battlesuits",   PMENU_ALIGN_LEFT,    NULL },
        { "to push instead.",         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};

pmenu_t faq5menu[] = {
        { "Why can't I see/hear...?", PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "ArmourBack is not a",      PMENU_ALIGN_LEFT,    NULL },
        { "server-side only patch.",  PMENU_ALIGN_LEFT,    NULL },
        { "To view the icons and",    PMENU_ALIGN_LEFT,    NULL },
        { "models, and to hear many", PMENU_ALIGN_LEFT,    NULL },
        { "of the extra sounds, you", PMENU_ALIGN_LEFT,    NULL },
        { "must have the ArmourBack", PMENU_ALIGN_LEFT,    NULL },
        { "pak0.pak in your current", PMENU_ALIGN_LEFT,    NULL },
        { "game directory.",          PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "If the server is set to",  PMENU_ALIGN_LEFT,    NULL },
        { "CTF, you must also have",  PMENU_ALIGN_LEFT,    NULL },
        { "the CTF pak in your game", PMENU_ALIGN_LEFT,    NULL },
        { "or baseq2 directory.",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Back",                     PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};

// NOTE:  This is not with the other vote menus because it is in the FAQ...
pmenu_t secretmenu[] = {
        { "Secret Vote",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Help5 },
};


/*============================/  Vote Menu  /============================*/

pmenu_t vote1menu[] = {
        { "End Level",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "To end the level now,",    PMENU_ALIGN_LEFT,    NULL },
        { "all must vote YES.",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote2menu[] = {
        { "Fast Switch",              PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote3menu[] = {
        { "Map Voting",               PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote4menu[] = {
        { "No Friendly Fire",        PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote5menu[] = {
        { "Number of Teams",          PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote6menu[] = {
        { "Rules",                    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote7menu[] = {
        { "Techs",                    PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};

pmenu_t vote8menu[] = {
        { "Weapons",                  PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "#  OPTION     VOTES",      PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",     PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "Press 0 to clear vote",    PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_VoteMain },
};


/*=============================/  Settings  /=============================*/

pmenu_t servermenu[] = {
        { "Current Settings",         PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_CENTER2, CovenMenu_Main },
};


/*===============================/  MotD  /===============================*/

pmenu_t motdmenu[] = {
        { "Message of the Day",       PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "",                         PMENU_ALIGN_CENTER,  NULL },
        { "ENTER to go back",         PMENU_ALIGN_CENTER2, CovenMenu_Main },
};


/*============================/  The Coven  /============================*/

pmenu_t covenmenu[] = {
        { "The Coven",                PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "You can reach The Coven",  PMENU_ALIGN_LEFT,    NULL },
        { "on the World Wide Web.",   PMENU_ALIGN_LEFT,    NULL },
        { "The web link is --",       PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "http://www.thecoven.com",  PMENU_ALIGN_LEFT2,   NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "You can also contact",     PMENU_ALIGN_LEFT,    NULL },
        { "The Coven through email.", PMENU_ALIGN_LEFT,    NULL },
        { "The email address is --",  PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "feedback@thecoven.com",    PMENU_ALIGN_LEFT2,   NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_CENTER2, CovenMenu_Main },
};


/*==========================/  Server Options  /==========================*/

pmenu_t optionsmainmenu[] = {
        { "ArmourBack",               PMENU_ALIGN_CENTER2, NULL },
        { "Voting Options",           PMENU_ALIGN_CENTER2, NULL },
        { NULL,                       PMENU_ALIGN_CENTER,  NULL },
        { "1. End Level",             PMENU_ALIGN_LEFT,    NULL },
        { "2. Fast Switch",           PMENU_ALIGN_LEFT,    NULL },
        { "3. Next Map",              PMENU_ALIGN_LEFT,    NULL },
        { "4. No Friendly Fire",      PMENU_ALIGN_LEFT,    NULL },
        { "5. Number of Teams",       PMENU_ALIGN_LEFT,    NULL },
        { "6. Rules",                 PMENU_ALIGN_LEFT,    NULL },
        { "7. Techs",                 PMENU_ALIGN_LEFT,    NULL },
        { "8. Weapons",               PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "",                         PMENU_ALIGN_LEFT,    NULL },
        { "Press number to select",   PMENU_ALIGN_LEFT,    NULL },
        { "ENTER to go back",         PMENU_ALIGN_LEFT2,   CovenMenu_Main },
};


/*==========================/  Menu Updates  /==========================*/

// TEAM SELECT
void CovenUpdate_TeamMenu (void)
{
	static char team1players[32];
	static char team2players[32];
        static char team3players[32];
        static char team4players[32];
        static char team5players[32];
        int     i;
        int     teamindex[MAX_AB_SKINS];

        // Initialize skin/team array.
        for (i = 0; i < MAX_AB_SKINS; i++)
                teamindex[i] = 0;

        // Find out how many players are in each team.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        teamindex[g_edicts[i+1].client->resp.suitcolor]++;

        // Update menu text
        sprintf (team1players, "1. Blue    %3d", teamindex[1]);
        sprintf (team2players, "2. Red     %3d", teamindex[2]);
        sprintf (team3players, "3. Green   %3d", teamindex[3]);
        sprintf (team4players, "4. Gold    %3d", teamindex[4]);
        sprintf (team5players, "5. Purple  %3d", teamindex[5]);

        skin2menu[5].text = skin3menu[5].text = skin4menu[5].text = skin5menu[5].text = team1players;
        skin2menu[6].text = skin3menu[6].text = skin4menu[6].text = skin5menu[6].text = team2players;
        skin3menu[7].text = skin4menu[7].text = skin5menu[7].text = team3players;
        skin4menu[8].text = skin5menu[8].text = team4players;
        skin5menu[9].text = team5players;
}

// BULKHEAD SECRET
void CovenUpdate_SecretMenu (void)
{
        static char secret1[32];
        static char secret2[32];
        int     i;
        int     yea = 0;
        int     nay = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                {
                        if (g_edicts[i+1].client->resp.vote_secret == 1)
                                yea++;
                        else if (g_edicts[i+1].client->resp.vote_secret == 2)
                                nay++;
                }

        // Update menu text
        sprintf (secret1, "1. BulkHead     %3d", yea);
        sprintf (secret2, "2. Rhino        %3d", nay);

        secretmenu[4].text = secret1;
        secretmenu[5].text = secret2;
}

// END LEVEL
void CovenUpdate_VoteEndMenu (void)
{
        static char end1[32];
        static char end2[32];
        int     i;
        int     yea = 0;
        int     nay = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                {
                        if (g_edicts[i+1].client->resp.vote_end)
                                yea++;
                        else
                                nay++;
                }

        // Update menu text
        sprintf (end1, "1. Yes          %3d", yea);
        sprintf (end2, "2. No           %3d", nay);

        vote1menu[4].text = end1;
        vote1menu[5].text = end2;
}

// FAST WEAPON SWITCH
void CovenUpdate_VoteFastMenu (void)
{
        static char fast1[32];
        static char fast2[32];
        int     i;
        int     yea = 0;
        int     nay = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                {
                        if (g_edicts[i+1].client->resp.vote_dm_fast == 1)
                                yea++;
                        else if (g_edicts[i+1].client->resp.vote_dm_fast == 2)
                                nay++;
                }

        // Update menu text
        sprintf (fast1, "1. Yes          %3d", yea);
        sprintf (fast2, "2. No           %3d", nay);

        vote2menu[4].text = fast1;
        vote2menu[5].text = fast2;
}

// NEXT MAP
#define MAX_VOTEMAPS    9
#define MAX_FILELENGTH  8

static char     maplist[MAX_VOTEMAPS][(MAX_FILELENGTH+1)];
static int      mapsinlist;

void CovenUpdate_VoteMapMenu (void)
{
        static char vlist[MAX_VOTEMAPS][32];
        int     i;
        int     voteindex[MAX_VOTEMAPS];

        // Initialize the vote array.
        for (i = 0; i < MAX_VOTEMAPS; i++)
                voteindex[i] = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (g_edicts[i+1].client->resp.vote_map > 0)
                                voteindex[(g_edicts[i+1].client->resp.vote_map)-1]++;

        // Update menu text
        vote3menu[2].text = "#  OPTION     VOTES";
        vote3menu[3].text = "";
        for (i = 0; i < mapsinlist; i++)
        {
                // FIXME:  Should have two less space chars?
                sprintf (vlist[i], "%d. %-9s    %3d", (i+1), maplist[i], voteindex[i]);
                vote3menu[i+4].text = vlist[i];
        }
        vote3menu[i+4].text = "";
        for (i += 5; i < 14; i++)
                vote3menu[i].text = "";
}

// NO FRIENDLY FIRE
void CovenUpdate_VoteFireMenu (void)
{
        static char fire1[32];
        static char fire2[32];
        int     i;
        int     yea = 0;
        int     nay = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                {
                        if (g_edicts[i+1].client->resp.vote_dm_ff == 1)
                                yea++;
                        else if (g_edicts[i+1].client->resp.vote_dm_ff == 2)
                                nay++;
                }

        // Update menu text
        sprintf (fire1, "1. Yes          %3d", yea);
        sprintf (fire2, "2. No           %3d", nay);

        vote4menu[4].text = fire1;
        vote4menu[5].text = fire2;
}

// NUMBER OF TEAMS
void CovenUpdate_VoteTeamsMenu (void)
{
        static char not1[32];
        static char not2[32];
        static char not3[32];
        static char not4[32];
        static char not5[32];
        int     i;
        int     voteindex[5];

        // Initialize the vote array.
        for (i = 0; i < 5; i++)
                voteindex[i] = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (g_edicts[i+1].client->resp.vote_teams > 0)
                                voteindex[(g_edicts[i+1].client->resp.vote_teams)-1]++;

        // Update menu text
        sprintf (not1, "1. None         %3d", voteindex[0]);
        sprintf (not2, "2. Two          %3d", voteindex[1]);
        sprintf (not3, "3. Three        %3d", voteindex[2]);
        sprintf (not4, "4. Four         %3d", voteindex[3]);
        sprintf (not5, "5. Five         %3d", voteindex[4]);

        vote5menu[4].text = not1;
        vote5menu[5].text = not2;
        vote5menu[6].text = not3;
        vote5menu[7].text = not4;
        vote5menu[8].text = not5;
}

// RULES
void CovenUpdate_VoteRulesMenu (void)
{
        static char rule1[32];
        static char rule2[32];
        static char rule3[32];
        static char rule4[32];
        static char rule5[32];
        int     i;
        int     voteindex[5];

        // Initialize the vote array.
        for (i = 0; i < 5; i++)
                voteindex[i] = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (g_edicts[i+1].client->resp.vote_rules > 0)
                                voteindex[(g_edicts[i+1].client->resp.vote_rules)-1]++;

        // Update menu text
        sprintf (rule1, "1. Normal       %3d", voteindex[0]);
        sprintf (rule2, "2. Duel         %3d", voteindex[1]);
        sprintf (rule3, "3. Elimination  %3d", voteindex[2]);
        sprintf (rule4, "4. Rune Capture %3d", voteindex[3]);
        sprintf (rule5, "5. CTF          %3d", voteindex[4]);

        vote6menu[4].text = rule1;
        vote6menu[5].text = rule2;
        vote6menu[6].text = rule3;
        vote6menu[7].text = rule4;
        vote6menu[8].text = rule5;
}

// TECHS
void CovenUpdate_VoteTechMenu (void)
{
        static char tech1[32];
        static char tech2[32];
        int     i;
        int     yea = 0;
        int     nay = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                {
                        if (g_edicts[i+1].client->resp.vote_dm_tech == 1)
                                yea++;
                        else if (g_edicts[i+1].client->resp.vote_dm_tech == 2)
                                nay++;
                }

        // Update menu text
        sprintf (tech1, "1. Yes          %3d", yea);
        sprintf (tech2, "2. No           %3d", nay);

        vote7menu[4].text = tech1;
        vote7menu[5].text = tech2;
}

// WEAPONS
void CovenUpdate_VoteArmsMenu (void)
{
        static char arm1[32];
        static char arm2[32];
        static char arm3[32];
        int     i;
        int     voteindex[3];

        // Initialize the vote array.
        for (i = 0; i < 3; i++)
                voteindex[i] = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (g_edicts[i+1].client->resp.vote_arms > 0)
                                voteindex[(g_edicts[i+1].client->resp.vote_arms)-1]++;

        // Update menu text
        sprintf (arm1, "1. Normal       %3d", voteindex[0]);
        sprintf (arm2, "2. Joust        %3d", voteindex[1]);
        sprintf (arm3, "3. All Weapons  %3d", voteindex[2]);

        vote8menu[4].text = arm1;
        vote8menu[5].text = arm2;
        vote8menu[6].text = arm3;
}

// SETTINGS
void CovenUpdate_Settings (void)
{
        static char set[10][32];
        int     i;
        int     no_of_players = 0;

        // Find out how many players are in each team.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        no_of_players++;

        // Update menu text
        if (strlen(level.mapname) > 8)
                sprintf (set[0], "Map:      ???");
        else
                sprintf (set[0], "Map:      %s", level.mapname);
        sprintf (set[1], "Players:  %d", no_of_players);
        sprintf (set[2], "Teams:    %d", ab_teams);

        sprintf (set[3], "DM Flags:  %d", ((int)dmflags->value));
        if (ab_rules == RULES_DUEL)
                sprintf (set[4], "Rules:     Duel");
        else if (ab_rules == RULES_ELIMINATION)
                sprintf (set[4], "Rules:     Elimination");
        else if (ab_rules == RULES_CAPTURE)
                sprintf (set[4], "Rules:     Rune Capture");
        else if (ab_rules == RULES_CTF)
                sprintf (set[4], "Rules:     CTF");
        else
                sprintf (set[4], "Rules:     Normal");
        if (ab_arms == ARMS_JOUST)
                sprintf (set[5], "Weapons:   Joust");
        else if (ab_arms == ARMS_ALL)
                sprintf (set[5], "Weapons:   All");
        else
                sprintf (set[5], "Weapons:   Any two");


        if ((int)(dmflags->value) & DF_FAST_SWITCH)
                sprintf (set[6], "Fast Switch:    Yes");
        else
                sprintf (set[6], "Fast Switch:    No");
        if ((int)(dmflags->value) & DF_NO_FRIENDLY_FIRE)
                sprintf (set[7], "Friendly Fire:  No");
        else
                sprintf (set[7], "Friendly Fire:  Yes");
        if ((int)(dmflags->value) & DF_CTF_TECH)
                sprintf (set[8], "Techs:          Yes");
        else
                sprintf (set[8], "Techs:          No");
        if ((int)(dmflags->value) & DF_NO_VOTING)
                sprintf (set[9], "Voting:         No");
        else
                sprintf (set[9], "Voting:         Yes");

        servermenu[2].text  = set[0];
        servermenu[3].text  = set[1];
        servermenu[4].text  = set[2];
        servermenu[6].text  = set[3];
        servermenu[7].text  = set[4];
        servermenu[8].text  = set[5];
        servermenu[10].text = set[6];
        servermenu[11].text = set[7];
        servermenu[12].text = set[8];
        servermenu[13].text = set[9];
}


/*==========================/  Menu Functions  /==========================*/

// MAIN MENUS
void CovenMenu_Done (edict_t *ent, pmenu_t *p)
{
        if (!Coven_SuitReady (ent))
        {       gi.cprintf (ent, PRINT_HIGH, "You are not ready.\n");
                return;
        }

        if (ab_teams >= 2)
        {       /* If teams are on, player must be on a team to play. */
                Coven_CheckTeamSkin (ent);
                if (!ent->client->resp.suitcolor)
                {       gi.cprintf (ent, PRINT_HIGH, "Can't play -- all teams are full.");
                        return;
                }
        }

        PMenu_Close (ent);
        Coven_EndSelect (ent);
}

void CovenMenu_Main (edict_t *ent, pmenu_t *p)
{
        PMenu_Close (ent);
        Coven_MainMenu (ent);
}

void CovenMenu_Suits (edict_t *ent, pmenu_t *p)
{
        PMenu_Close (ent);
        Coven_SuitMenu (ent);
}

void CovenMenu_HelpMain (edict_t *ent, pmenu_t *p)
{
        PMenu_Close (ent);
        Coven_HelpMenu (ent);
}

// HELP TOPICS
void CovenMenu_Help1 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_RULES;
        PMenu_Close (ent);
        PMenu_Open (ent, help1menu, -1, sizeof(help1menu) / sizeof(pmenu_t));
}

void CovenMenu_Help2 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_SUITS;
        PMenu_Close (ent);
        PMenu_Open (ent, help2menu, -1, sizeof(help2menu) / sizeof(pmenu_t));
}

void CovenMenu_Help3 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_WEAPONS;
        PMenu_Close (ent);
        PMenu_Open (ent, help3menu, -1, sizeof(help3menu) / sizeof(pmenu_t));
}

void CovenMenu_Help4 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_COMMANDS;
        PMenu_Close (ent);
        PMenu_Open (ent, help4menu, -1, sizeof(help4menu) / sizeof(pmenu_t));
}

void CovenMenu_Help5 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_FAQ;
        PMenu_Close (ent);
        PMenu_Open (ent, help5menu, -1, sizeof(help5menu) / sizeof(pmenu_t));
}

// GUNS
void CovenMenu_Weapon1 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_WEAPONS_A;
        PMenu_Close (ent);
        PMenu_Open (ent, weapon1menu, -1, sizeof(weapon1menu) / sizeof(pmenu_t));
}

void CovenMenu_Weapon2 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_WEAPONS_B;
        PMenu_Close (ent);
        PMenu_Open (ent, weapon2menu, -1, sizeof(weapon2menu) / sizeof(pmenu_t));
}

void CovenMenu_Weapon3 (edict_t *ent, pmenu_t *p)
{
        ent->style = MENU_HELP_WEAPONS_C;
        PMenu_Close (ent);
        PMenu_Open (ent, weapon3menu, -1, sizeof(weapon3menu) / sizeof(pmenu_t));
}

// VOTING
void CovenMenu_VoteMain (edict_t *ent, pmenu_t *p)
{
        PMenu_Close (ent);
        Coven_VoteMenu (ent);
}


//=====================================================================//

// VOTE SELECT
void Coven_VoteMenu (edict_t *ent)
{
        ent->style = MENU_VOTE_MAIN;
        PMenu_Close (ent);
        PMenu_Open (ent, optionsmainmenu, -1, sizeof(optionsmainmenu) / sizeof(pmenu_t));
}

// HELP SELECT
void Coven_HelpMenu (edict_t *ent)
{
        ent->style = MENU_HELP_MAIN;
        PMenu_Close (ent);
        PMenu_Open (ent, helpmainmenu, -1, sizeof(helpmainmenu) / sizeof(pmenu_t));
}

// TEAM SELECT
void Coven_TeamMenu (edict_t *ent)
{
        ent->style = MENU_TEAM;
        PMenu_Close (ent);

        if (ab_teams < 2)
        {       // Free-for-all color menu is always static.
                PMenu_Open (ent, skinmenu, -1, sizeof(skinmenu) / sizeof(pmenu_t));
                return;
        }

        CovenUpdate_TeamMenu ();
        if (ab_teams == 2)
                PMenu_Open (ent, skin2menu, -1, sizeof(skin2menu) / sizeof(pmenu_t));
        else if (ab_teams == 3)
                PMenu_Open (ent, skin3menu, -1, sizeof(skin3menu) / sizeof(pmenu_t));
        else if (ab_teams == 4)
                PMenu_Open (ent, skin4menu, -1, sizeof(skin4menu) / sizeof(pmenu_t));
        else //if (ab_teams == 5)
                PMenu_Open (ent, skin5menu, -1, sizeof(skin5menu) / sizeof(pmenu_t));
}

// SUIT SELECT
void Coven_SuitMenu (edict_t *ent)
{
        ent->style = MENU_SUIT;
        PMenu_Close (ent);
        if (secret_on)
                PMenu_Open (ent, suitbmenu, -1, sizeof(suitbmenu) / sizeof(pmenu_t));
        else
                PMenu_Open (ent, suitmenu, -1, sizeof(suitmenu) / sizeof(pmenu_t));
}

// MAIN MENU
void Coven_MainMenu (edict_t *ent)
{
        // If player joins in during intermission, do nothing.
        if (level.intermissiontime)
                return;

        ent->style = MENU_MAIN;
        PMenu_Close (ent);

        if (Coven_SuitReady (ent))
        {       // Suit is ready.
                if (ab_teams < 2)
                        PMenu_Open (ent, main1menu, -1, sizeof(main1menu) / sizeof(pmenu_t));
                else
                        PMenu_Open (ent, main2menu, -1, sizeof(main2menu) / sizeof(pmenu_t));
                return;
        }

        // Clear suit and item icon if not ready.
        ent->client->pers.selected_item = 0;
        ent->battlesuit = ent->client->resp.battlesuit = 0;
        if (ab_teams < 2)
                PMenu_Open (ent, main3menu, -1, sizeof(main3menu) / sizeof(pmenu_t));
        else
                PMenu_Open (ent, main4menu, -1, sizeof(main4menu) / sizeof(pmenu_t));
}


/*=========================/  Menu Commands  /=========================*/

/*----------------------------------------------------/ New Code /--------//
//  This automatically sets the suit's left weapon to the melee class.
//------------------------------------------------------------------------*/
static void Coven_Joust (edict_t *ent)
{
        gitem_t *item;

        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
        {       // Light suits get grapple.
                item = FindItem ("Grapple");
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;
                ent->style = MENU_GUN_RIGHT;
                PMenu_Close (ent);
                PMenu_Open (ent, right1menu, -1, sizeof(right1menu) / sizeof(pmenu_t));
        }
        else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
        {       // Medium suits get prod rod.
                item = FindItem ("Prod Rod");
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;
                ent->style = MENU_GUN_RIGHT;
                PMenu_Close (ent);
                PMenu_Open (ent, right2menu, -1, sizeof(right2menu) / sizeof(pmenu_t));
        }
        else
        {       // Heavy suit?  Give carver.
                item = FindItem ("Carver");
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;
                ent->style = MENU_GUN_RIGHT;
                PMenu_Close (ent);
                PMenu_Open (ent, right3menu, -1, sizeof(right3menu) / sizeof(pmenu_t));
        }
}

extern void Cmd_WeapNext_f (edict_t *ent);

void Coven_Key1 (edict_t *ent)
{
        gitem_t *item;

/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {
                if (ab_arms == ARMS_ALL)
                {
                        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                                item = FindItem ("Grapple");
                        else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                                item = FindItem ("Prod Rod");
                        else
                                item = FindItem ("Carver");

                        if (ent->client->pers.inventory[ITEM_INDEX(item)])
                                item->use (ent, item);
                        else
                                gi.cprintf (ent, PRINT_HIGH, "Weapon 1 not available.\n");
                }
                else
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                Coven_SuitMenu(ent);
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                ent->battlesuit = ent->client->resp.battlesuit = SUIT_MERCURY;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left1menu, -1, sizeof(left1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_GUN_LEFT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                {       item = FindItem ("Grapple");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right1menu, -1, sizeof(right1menu) / sizeof(pmenu_t));
                }
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                {       item = FindItem ("Prod Rod");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right2menu, -1, sizeof(right2menu) / sizeof(pmenu_t));
                }
                else
                {       item = FindItem ("Carver");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right3menu, -1, sizeof(right3menu) / sizeof(pmenu_t));
                }
        }
        else if (ent->style == MENU_GUN_RIGHT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                        item = FindItem ("Grapple");
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                        item = FindItem ("Prod Rod");
                else
                        item = FindItem ("Carver");

                /* Ignore selection if player already has item. */
                if (item == ent->client->resp.lastgun)
                        return;

                /* Show last selection. */
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;

                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_TEAM)
        {       if (ent->client->resp.suitcolor != SKIN_BLUE)
                {       if (Coven_TeamFull(SKIN_BLUE))
                        {       gi.cprintf (ent, PRINT_HIGH, "Team %s is full.\n", Coven_TeamName(SKIN_BLUE));
                                if (!Coven_OpenTeams (ent))
                                        Coven_MainMenu(ent);
                                return;
                        }
                        Coven_MenuTeamChange (ent, SKIN_BLUE);
                        if (ab_teams >= 2)
                                CovenUpdate_TeamMenu ();
                }
                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_HELP_MAIN)
        {
                ent->style = MENU_HELP_RULES;
                PMenu_Close (ent);
                PMenu_Open (ent, help1menu, -1, sizeof(help1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule1menu, -1, sizeof(rule1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_SUITS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, suit1menu, -1, sizeof(suit1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS)
        {
                ent->style = MENU_HELP_WEAPONS_A;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon1menu, -1, sizeof(weapon1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_A)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon11menu, -1, sizeof(weapon11menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_B)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon21menu, -1, sizeof(weapon21menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_C)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon31menu, -1, sizeof(weapon31menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd1menu, -1, sizeof(cmd1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq1menu, -1, sizeof(faq1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq1menu, -1, sizeof(faq1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteEndMenu ();
                ent->style = MENU_VOTE_END;
                PMenu_Close (ent);
                PMenu_Open (ent, vote1menu, -1, sizeof(vote1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteEndMenu ();
                ent->style = MENU_VOTE_END;
                PMenu_Close (ent);
                PMenu_Open (ent, vote1menu, -1, sizeof(vote1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 1)
                {       ent->client->resp.vote_map = 1;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 1;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_ARMS)
        {
                ent->client->resp.vote_arms = 1;
                CovenUpdate_VoteArmsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 1;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_END)
        {
                ent->client->resp.vote_end = 1;
                CovenUpdate_VoteEndMenu ();
                Coven_VoteMenu (ent);
                Coven_CheckExitVote ();
        }
        else if (ent->style == MENU_VOTE_FAST)
        {
                ent->client->resp.vote_dm_fast = 1;
                CovenUpdate_VoteFastMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_FF)
        {
                ent->client->resp.vote_dm_ff = 1;
                CovenUpdate_VoteFireMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TECH)
        {
                ent->client->resp.vote_dm_tech = 1;
                CovenUpdate_VoteTechMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_SECRET)
        {
                ent->client->resp.vote_secret = 1;
                CovenUpdate_SecretMenu ();
                ent->style = MENU_HELP_FAQ;
                PMenu_Close (ent);
                PMenu_Open (ent, help5menu, -1, sizeof(help5menu) / sizeof(pmenu_t));
        }
}

void Coven_Key2 (edict_t *ent)
{
        gitem_t *item;

/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {
                if (ab_arms == ARMS_ALL)
                {
                        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                                item = FindItem ("Assault Shotgun");
                        else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                                item = FindItem ("Photon Cannon");
                        else
                                item = FindItem ("Flamethrower");

                        if (ent->client->pers.inventory[ITEM_INDEX(item)])
                                item->use (ent, item);
                        else
                                gi.cprintf (ent, PRINT_HIGH, "Weapon 2 not available.\n");
                }
                else
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                if (Coven_AllFull ())
                {       // Do nothing if all teams are full.
                        gi.cprintf (ent, PRINT_HIGH, "All teams are full.\n");
                        return;
                }
                if ((int)(dmflags->value) & DF_TEAM_LOCK)
                {       if (ent->client->resp.suitcolor && (ab_teams >= 2))
                        {       // Team is locked and cannot be changed.
                                gi.cprintf (ent, PRINT_HIGH, "Can't -- not allowed to change teams.\n");
                                return;
                        }
                }
                Coven_TeamMenu(ent);
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                ent->battlesuit = ent->client->resp.battlesuit = SUIT_ZEPPELIN;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left1menu, -1, sizeof(left1menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_GUN_LEFT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                {       item = FindItem ("Assault Shotgun");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right1menu, -1, sizeof(right1menu) / sizeof(pmenu_t));
                }
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                {       item = FindItem ("Photon Cannon");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right2menu, -1, sizeof(right2menu) / sizeof(pmenu_t));
                }
                else
                {       item = FindItem ("Flamethrower");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right3menu, -1, sizeof(right3menu) / sizeof(pmenu_t));
                }
        }
        else if (ent->style == MENU_GUN_RIGHT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                        item = FindItem ("Assault Shotgun");
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                        item = FindItem ("Photon Cannon");
                else
                        item = FindItem ("Flamethrower");

                /* Ignore selection if player already has item. */
                if (item == ent->client->resp.lastgun)
                        return;

                /* Show last selection. */
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;

                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_TEAM)
        {       if (ent->client->resp.suitcolor != SKIN_RED)
                {       if (Coven_TeamFull(SKIN_RED))
                        {       gi.cprintf (ent, PRINT_HIGH, "Team %s is full.\n", Coven_TeamName(SKIN_RED));
                                if (!Coven_OpenTeams (ent))
                                        Coven_MainMenu(ent);
                                return;
                        }
                        Coven_MenuTeamChange (ent, SKIN_RED);
                        if (ab_teams >= 2)
                                CovenUpdate_TeamMenu ();
                }
                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_HELP_MAIN)
        {
                ent->style = MENU_HELP_SUITS;
                PMenu_Close (ent);
                PMenu_Open (ent, help2menu, -1, sizeof(help2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule2menu, -1, sizeof(rule2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_SUITS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, suit2menu, -1, sizeof(suit2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS)
        {
                ent->style = MENU_HELP_WEAPONS_B;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon2menu, -1, sizeof(weapon2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_A)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon12menu, -1, sizeof(weapon12menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_B)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon22menu, -1, sizeof(weapon22menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_C)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon32menu, -1, sizeof(weapon32menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd2menu, -1, sizeof(cmd2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq2menu, -1, sizeof(faq2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteFastMenu ();
                ent->style = MENU_VOTE_FAST;
                PMenu_Close (ent);
                PMenu_Open (ent, vote2menu, -1, sizeof(vote2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 2)
                {       ent->client->resp.vote_map = 2;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 2;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_ARMS)
        {
                ent->client->resp.vote_arms = 2;
                CovenUpdate_VoteArmsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 2;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_END)
        {
                ent->client->resp.vote_end = 0;
                CovenUpdate_VoteEndMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_FAST)
        {
                ent->client->resp.vote_dm_fast = 2;
                CovenUpdate_VoteFastMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_FF)
        {
                ent->client->resp.vote_dm_ff = 2;
                CovenUpdate_VoteFireMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TECH)
        {
                ent->client->resp.vote_dm_tech = 2;
                CovenUpdate_VoteTechMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_SECRET)
        {
                ent->client->resp.vote_secret = 2;
                CovenUpdate_SecretMenu ();
                ent->style = MENU_HELP_FAQ;
                PMenu_Close (ent);
                PMenu_Open (ent, help5menu, -1, sizeof(help5menu) / sizeof(pmenu_t));
        }
}

void Coven_Key3 (edict_t *ent)
{
        gitem_t *item;

/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {
                if (ab_arms == ARMS_ALL)
                {
                        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                                item = FindItem ("Particle Beam");
                        else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                                item = FindItem ("Minigun");
                        else
                                item = FindItem ("Auto Shotgun");

                        if (ent->client->pers.inventory[ITEM_INDEX(item)])
                                item->use (ent, item);
                        else
                                gi.cprintf (ent, PRINT_HIGH, "Weapon 3 not available.\n");
                }
                else
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                Coven_HelpMenu (ent);
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                ent->battlesuit = ent->client->resp.battlesuit = SUIT_GRAVYBURNER;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left2menu, -1, sizeof(left2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_GUN_LEFT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                {       item = FindItem ("Particle Beam");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right1menu, -1, sizeof(right1menu) / sizeof(pmenu_t));
                }
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                {       item = FindItem ("Minigun");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right2menu, -1, sizeof(right2menu) / sizeof(pmenu_t));
                }
                else
                {       item = FindItem ("Auto Shotgun");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right3menu, -1, sizeof(right3menu) / sizeof(pmenu_t));
                }
        }
        else if (ent->style == MENU_GUN_RIGHT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                        item = FindItem ("Particle Beam");
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                        item = FindItem ("Minigun");
                else
                        item = FindItem ("Auto Shotgun");

                /* Ignore selection if player already has item. */
                if (item == ent->client->resp.lastgun)
                        return;

                /* Show last selection. */
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;

                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_TEAM)
        {       if ((ab_teams > 1) && (ab_teams < 3))
                        return;
                if (ent->client->resp.suitcolor != SKIN_GREEN)
                {       if (Coven_TeamFull(SKIN_GREEN))
                        {       gi.cprintf (ent, PRINT_HIGH, "Team %s is full.\n", Coven_TeamName(SKIN_GREEN));
                                if (!Coven_OpenTeams (ent))
                                        Coven_MainMenu(ent);
                                return;
                        }
                        Coven_MenuTeamChange (ent, SKIN_GREEN);
                        if (ab_teams >= 2)
                                CovenUpdate_TeamMenu ();
                }
                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_HELP_MAIN)
        {
                ent->style = MENU_HELP_WEAPONS;
                PMenu_Close (ent);
                PMenu_Open (ent, help3menu, -1, sizeof(help3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule3menu, -1, sizeof(rule3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_SUITS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                if (secret_on)
                        PMenu_Open (ent, suit3bmenu, -1, sizeof(suit3bmenu) / sizeof(pmenu_t));
                else
                        PMenu_Open (ent, suit3menu, -1, sizeof(suit3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS)
        {
                ent->style = MENU_HELP_WEAPONS_C;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon3menu, -1, sizeof(weapon3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_A)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon13menu, -1, sizeof(weapon13menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_B)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon23menu, -1, sizeof(weapon23menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_C)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon33menu, -1, sizeof(weapon33menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd3menu, -1, sizeof(cmd3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq3menu, -1, sizeof(faq3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                if (mapsinlist < 1)
                {       gi.cprintf (ent, PRINT_HIGH, "No maps available to vote on.\n");
                        return;
                }

                CovenUpdate_VoteMapMenu ();
                ent->style = MENU_VOTE_MAP;
                PMenu_Close (ent);
                PMenu_Open (ent, vote3menu, -1, sizeof(vote3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 3)
                {       ent->client->resp.vote_map = 3;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 3;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_ARMS)
        {
                ent->client->resp.vote_arms = 3;
                CovenUpdate_VoteArmsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 3;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
}

void Coven_Key4 (edict_t *ent)
{
        gitem_t *item;

/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {
                if (ab_arms == ARMS_ALL)
                {
                        if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                                item = FindItem ("Grenade Launcher");
                        else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                                item = FindItem ("Bazooka");
                        else
                                item = FindItem ("MIRV Launcher");

                        if (ent->client->pers.inventory[ITEM_INDEX(item)])
                                item->use (ent, item);
                        else
                                gi.cprintf (ent, PRINT_HIGH, "Weapon 4 not available.\n");
                }
                else
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                if ((int)dmflags->value & DF_NO_VOTING)
                {       gi.cprintf (ent, PRINT_HIGH, "Voting has been disabled.\n");
                        return;
                }
                Coven_VoteMenu(ent);
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                ent->battlesuit = ent->client->resp.battlesuit = SUIT_WIRECUTTER;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left2menu, -1, sizeof(left2menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_GUN_LEFT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                {       item = FindItem ("Grenade Launcher");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right1menu, -1, sizeof(right1menu) / sizeof(pmenu_t));
                }
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                {       item = FindItem ("Bazooka");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right2menu, -1, sizeof(right2menu) / sizeof(pmenu_t));
                }
                else
                {       item = FindItem ("MIRV Launcher");
                        Coven_SetGunmask (ent, item);
                        ent->client->pers.selected_item = ITEM_INDEX(item);
                        ent->client->resp.lastgun = item;
                        ent->style = MENU_GUN_RIGHT;
                        PMenu_Close (ent);
                        PMenu_Open (ent, right3menu, -1, sizeof(right3menu) / sizeof(pmenu_t));
                }
        }
        else if (ent->style == MENU_GUN_RIGHT)
        {
                if ((ent->battlesuit == SUIT_MERCURY) || (ent->battlesuit == SUIT_ZEPPELIN))
                        item = FindItem ("Grenade Launcher");
                else if ((ent->battlesuit == SUIT_GRAVYBURNER) || (ent->battlesuit == SUIT_WIRECUTTER))
                        item = FindItem ("Bazooka");
                else
                        item = FindItem ("MIRV Launcher");

                /* Ignore selection if player already has item. */
                if (item == ent->client->resp.lastgun)
                        return;

                /* Show last selection. */
                Coven_SetGunmask (ent, item);
                ent->client->pers.selected_item = ITEM_INDEX(item);
                ent->client->resp.lastgun = item;

                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_TEAM)
        {       if ((ab_teams > 1) && (ab_teams < 4))
                        return;
                if (ent->client->resp.suitcolor != SKIN_GOLD)
                {       if (Coven_TeamFull(SKIN_GOLD))
                        {       gi.cprintf (ent, PRINT_HIGH, "Team %s is full.\n", Coven_TeamName(SKIN_GOLD));
                                if (!Coven_OpenTeams (ent))
                                        Coven_MainMenu(ent);
                                return;
                        }
                        Coven_MenuTeamChange (ent, SKIN_GOLD);
                        if (ab_teams >= 2)
                                CovenUpdate_TeamMenu ();
                }
                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_HELP_MAIN)
        {
                ent->style = MENU_HELP_COMMANDS;
                PMenu_Close (ent);
                PMenu_Open (ent, help4menu, -1, sizeof(help4menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule4menu, -1, sizeof(rule4menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_A)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon14menu, -1, sizeof(weapon14menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_B)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon24menu, -1, sizeof(weapon24menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_WEAPONS_C)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, weapon34menu, -1, sizeof(weapon34menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd4menu, -1, sizeof(cmd4menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq4menu, -1, sizeof(faq4menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteFireMenu ();
                ent->style = MENU_VOTE_FF;
                PMenu_Close (ent);
                PMenu_Open (ent, vote4menu, -1, sizeof(vote4menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 4)
                {       ent->client->resp.vote_map = 4;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 4;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 4;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
}

void Coven_Key5 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                CovenUpdate_Settings ();
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, servermenu, -1, sizeof(servermenu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                if (secret_on)
                        ent->battlesuit = ent->client->resp.battlesuit = SUIT_BULKHEAD;
                else
                        ent->battlesuit = ent->client->resp.battlesuit = SUIT_RHINO;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left3menu, -1, sizeof(left3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_TEAM)
        {       if ((ab_teams > 1) && (ab_teams < 5))
                        return;
                if (ent->client->resp.suitcolor != SKIN_PURPLE)
                {       if (Coven_TeamFull(SKIN_PURPLE))
                        {       gi.cprintf (ent, PRINT_HIGH, "Team %s is full.\n", Coven_TeamName(SKIN_PURPLE));
                                if (!Coven_OpenTeams (ent))
                                        Coven_MainMenu(ent);
                                return;
                        }
                        Coven_MenuTeamChange (ent, SKIN_PURPLE);
                        if (ab_teams >= 2)
                                CovenUpdate_TeamMenu ();
                }
                Coven_MainMenu(ent);
        }
        else if (ent->style == MENU_HELP_MAIN)
        {
                ent->style = MENU_HELP_FAQ;
                PMenu_Close (ent);
                PMenu_Open (ent, help5menu, -1, sizeof(help5menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule5menu, -1, sizeof(rule5menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd5menu, -1, sizeof(cmd5menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_FAQ)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, faq5menu, -1, sizeof(faq5menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteTeamsMenu ();
                ent->style = MENU_VOTE_TEAMS;
                PMenu_Close (ent);
                PMenu_Open (ent, vote5menu, -1, sizeof(vote5menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 5)
                {       ent->client->resp.vote_map = 5;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 5;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 5;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
}

void Coven_Key6 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, motdmenu, -1, sizeof(motdmenu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_SUIT)
        {       Coven_RemoveGuns (ent);
                ent->client->pers.selected_item = 0;
                ent->battlesuit = ent->client->resp.battlesuit = SUIT_SUGARCONNY;

                if (ab_arms == ARMS_ALL)
                {       Coven_FourWeapons (ent);
                        Coven_MainMenu (ent);
                        return;
                }

                if (ab_arms == ARMS_JOUST)
                {       Coven_Joust (ent);
                        return;
                }

                ent->style = MENU_GUN_LEFT;
                PMenu_Close (ent);
                PMenu_Open (ent, left3menu, -1, sizeof(left3menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_TEAM)
        {       if (ab_teams < 2)
                {       ent->client->resp.suitcolor = 0;
                        Coven_MainMenu(ent);
                }
        }
        else if (ent->style == MENU_HELP_RULES)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, rule6menu, -1, sizeof(rule6menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_HELP_COMMANDS)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, cmd6menu, -1, sizeof(cmd6menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteRulesMenu ();
                ent->style = MENU_VOTE_RULES;
                PMenu_Close (ent);
                PMenu_Open (ent, vote6menu, -1, sizeof(vote6menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 6)
                {       ent->client->resp.vote_map = 6;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
}

void Coven_Key7 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_MAIN)
        {
                ent->style = 0;
                PMenu_Close (ent);
                PMenu_Open (ent, covenmenu, -1, sizeof(covenmenu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteTechMenu ();
                ent->style = MENU_VOTE_TECH;
                PMenu_Close (ent);
                PMenu_Open (ent, vote7menu, -1, sizeof(vote7menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 7)
                {       ent->client->resp.vote_map = 7;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
}

void Coven_Key8 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_VOTE_MAIN)
        {
                CovenUpdate_VoteArmsMenu ();
                ent->style = MENU_VOTE_ARMS;
                PMenu_Close (ent);
                PMenu_Open (ent, vote8menu, -1, sizeof(vote8menu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 8)
                {       ent->client->resp.vote_map = 8;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
}

void Coven_Key9 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_VOTE_MAP)
        {
                if (mapsinlist >= 9)
                {       ent->client->resp.vote_map = 9;
                        CovenUpdate_VoteMapMenu ();
                        Coven_VoteMenu (ent);
                }
        }
}

void Coven_Key0 (edict_t *ent)
{
/* Ignore if not a ghost. */
        if (!ent->client->resp.spectator)
        {       if (ab_arms != ARMS_ALL)
                        Cmd_WeapNext_f (ent);
                return;
        }

/* Ignore if no menu is up. */
        if (!ent->client->menu)
                return;

        if (ent->style == MENU_HELP_FAQ)
        {
                CovenUpdate_SecretMenu ();
                ent->style = MENU_SECRET;
                PMenu_Close (ent);
                PMenu_Open (ent, secretmenu, -1, sizeof(secretmenu) / sizeof(pmenu_t));
        }
        else if (ent->style == MENU_VOTE_MAP)
        {
                ent->client->resp.vote_map = 0;
                CovenUpdate_VoteMapMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_RULES)
        {
                ent->client->resp.vote_rules = 0;
                CovenUpdate_VoteRulesMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_ARMS)
        {
                ent->client->resp.vote_arms = 0;
                CovenUpdate_VoteArmsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TEAMS)
        {
                ent->client->resp.vote_teams = 0;
                CovenUpdate_VoteTeamsMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_END)
        {
                ent->client->resp.vote_end = 0;
                CovenUpdate_VoteEndMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_FAST)
        {
                ent->client->resp.vote_dm_fast = 0;
                CovenUpdate_VoteFastMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_FF)
        {
                ent->client->resp.vote_dm_ff = 0;
                CovenUpdate_VoteFireMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_VOTE_TECH)
        {
                ent->client->resp.vote_dm_tech = 0;
                CovenUpdate_VoteTechMenu ();
                Coven_VoteMenu (ent);
        }
        else if (ent->style == MENU_SECRET)
        {
                ent->client->resp.vote_secret = 0;
                CovenUpdate_SecretMenu ();
                ent->style = MENU_HELP_FAQ;
                PMenu_Close (ent);
                PMenu_Open (ent, help5menu, -1, sizeof(help5menu) / sizeof(pmenu_t));
        }
}

void Coven_KeyOption (edict_t *ent, int key)
{
        switch (key)
	{
	case 1:
                Coven_Key1 (ent);
		break;
	case 2:
                Coven_Key2 (ent);
		break;
	case 3:
                Coven_Key3 (ent);
		break;
	case 4:
                Coven_Key4 (ent);
		break;
        case 5:
                Coven_Key5 (ent);
		break;
        case 6:
                Coven_Key6 (ent);
		break;
        case 7:
                Coven_Key7 (ent);
		break;
        case 8:
                Coven_Key8 (ent);
		break;
        case 9:
                Coven_Key9 (ent);
		break;
	case 0:
                Coven_Key0 (ent);
		break;
	}
}


/*=======================================================================*/

/*=========================/  Voting Results  /=========================*/

#define MAX_VOTE_ITEMS          7
#define MAX_VOTE_OPTIONS        5

/*------------------------------------------------------/ New Code /--------
//  This checks the votes of all players and adjusts options accordingly.
//  Should be called only before a map change.
//
//  NOTE:  Map voting is done separately in another function, not here.
//------------------------------------------------------------------------*/
void Coven_GetVotes (void)
{
        edict_t *ent;
        int     i, j;
        int     voteindex[MAX_VOTE_ITEMS][MAX_VOTE_OPTIONS];
        int     vote_hi[MAX_VOTE_ITEMS];
        int     hi_op[MAX_VOTE_ITEMS];
        int     win[MAX_VOTE_ITEMS];
        int     newdmflags;

        if ((int)dmflags->value & DF_NO_VOTING)
                return;

        newdmflags = (int)dmflags->value;

        // Initialize arrays;
        for (i=0; i<MAX_VOTE_ITEMS; i++)
        {
                vote_hi[i] = 0;
                hi_op[i]   = 0;
                win[i]     = -1;

                for (j=0; j<MAX_VOTE_OPTIONS; j++)
                        voteindex[i][j] = 0;
        }

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
        {
                ent = &g_edicts[i+1];
                if (ent->inuse && ent->client)
                {
                        if (ent->client->resp.vote_rules > 0)
                                voteindex[0][(ent->client->resp.vote_rules-1)]++;
                        if (ent->client->resp.vote_arms > 0)
                                voteindex[1][(ent->client->resp.vote_arms-1)]++;
                        if (ent->client->resp.vote_teams > 0)
                                voteindex[2][(ent->client->resp.vote_teams-1)]++;
                        if (ent->client->resp.vote_dm_fast > 0)
                                voteindex[3][(ent->client->resp.vote_dm_fast-1)]++;
                        if (ent->client->resp.vote_dm_ff > 0)
                                voteindex[4][(ent->client->resp.vote_dm_ff-1)]++;
                        if (ent->client->resp.vote_dm_tech > 0)
                                voteindex[5][(ent->client->resp.vote_dm_tech-1)]++;
                        if (ent->client->resp.vote_secret > 0)
                                voteindex[6][(ent->client->resp.vote_secret-1)]++;
                }
        }

        // Find the winning vote.
        for (i=0; i<MAX_VOTE_ITEMS; i++)
        {
                for (j=0; j<MAX_VOTE_OPTIONS; j++)
                {
                        if (voteindex[i][j] > vote_hi[i])
                        {       // Clear winner so far.
                                win[i]     = j;
                                vote_hi[i] = voteindex[i][j];
                                hi_op[i]   = 1;
                        }
                        else if (vote_hi[i] && (voteindex[i][j] == vote_hi[i]))
                                (hi_op[i])++;   // Tie.
                }

                if (win[i] != -1)
                {       // A vote?.
                        if (hi_op[i] > 1)
                        {       // Tie -- break it.
                                hi_op[i] = rand() % hi_op[i];
                                for (j=0; j<MAX_VOTE_OPTIONS; j++)
                                {
                                        if (voteindex[i][j] == vote_hi[i])
                                        {       win[i] = j;
                                                if (hi_op[i] < 1)
                                                        break;
                                                (hi_op[i])--;
                                        }
                                }
                        }

                        if (i == 0)
                        {
                                gi.cvar_set ("rules", va("%d", win[i]));
                        }
                        else if (i == 1)
                        {
                                gi.cvar_set ("arms", va("%d", win[i]));
                        }
                        else if (i == 2)
                        {
                                if (win[i])
                                        gi.cvar_set ("numteams", va("%d", (win[i]+1)));
                                else
                                        gi.cvar_set ("numteams", "0");
                        }
                        else if (i == 3)
                        {
                                if (win[i] == 1)
                                        newdmflags &= ~DF_FAST_SWITCH;
                                else
                                        newdmflags |= DF_FAST_SWITCH;
                        }
                        else if (i == 4)
                        {
                                if (win[i] == 1)
                                        newdmflags &= ~DF_NO_FRIENDLY_FIRE;
                                else
                                        newdmflags |= DF_NO_FRIENDLY_FIRE;
                        }
                        else if (i == 5)
                        {
                                if (win[i] == 1)
                                        newdmflags &= ~DF_CTF_TECH;
                                else
                                        newdmflags |= DF_CTF_TECH;
                        }
                        else if (i == 6)
                        {
                                if (win[i] == 1)
                                        newdmflags &= ~DF_SECRET;
                                else
                                        newdmflags |= DF_SECRET;
                        }
                }
        }

        if ( ((int)dmflags->value) != newdmflags )
                gi.cvar_set ("dmflags", va("%d", newdmflags));
}


/*=======================================================================*/

cvar_t  *gamedir;
cvar_t  *file_motd;
cvar_t  *file_maps;
cvar_t  *file_mapvote;


/*===========================/  Map Voting  /===========================*/

/*------------------------------------------------------/ New Code /--------
//  This checks if everyone wants to leave the current level.
//------------------------------------------------------------------------*/
void Coven_CheckExitVote (void)
{
        int     i;

        if ((int)dmflags->value & DF_NO_VOTING)
                return;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (!(g_edicts[i+1].client->resp.vote_end))
                                return;

        // Exit vote is unanimous.
        exitnow = true;
}

/*------------------------------------------------------/ New Code /--------
//  This selects the next map based on map votes.
//------------------------------------------------------------------------*/
void Coven_GetVotedMap (char *newmap)
{
        int     i;
        int     voteindex[MAX_VOTEMAPS];
        int     vote_hi = 0;
        int     hi_maps = 0;
        int     vmap    = -1;

        if ((int)dmflags->value & DF_NO_VOTING)
                return;

        // Initialize array;
        for (i=0; i<MAX_VOTEMAPS; i++)
                voteindex[i] = 0;

        // Tally up the current votes.
        for (i=0; i<maxclients->value; i++)
                if (g_edicts[i+1].inuse && g_edicts[i+1].client)
                        if (g_edicts[i+1].client->resp.vote_map > 0)
                                voteindex[(g_edicts[i+1].client->resp.vote_map)-1]++;

        for (i=0; i<mapsinlist; i++)
        {
                if (voteindex[i] > vote_hi)
                {       // Clear winner so far.
                        vmap = i;
                        vote_hi = voteindex[i];
                        hi_maps = 1;
                }
                else if (vote_hi && (voteindex[i] == vote_hi))
                        hi_maps++;      // Tie.
        }

        if (vmap != -1)
        {       // A map was voted on.
                if (hi_maps > 1)
                {       // More than one map?  Do a tie breaker.
                        hi_maps = rand() % hi_maps;

                        for (i=0; i<mapsinlist; i++)
                        {
                                if (voteindex[i] == vote_hi)
                                {
                                        vmap = i;
                                        if (hi_maps < 1)
                                                break;
                                        hi_maps--;
                                }
                        }
                }

                strcpy (newmap, maplist[vmap]);
        }
}

/*------------------------------------------------------/ New Code /--------
//  This checks if a duplicate map is in the mapvote list file.
//------------------------------------------------------------------------*/
qboolean Coven_DuplicateMap (char *mapnow)
{
        int     i;

        for (i=0; i<mapsinlist; i++)
                if (!stricmp (mapnow, maplist[i]))
                        return true;

        return false;
}

/*------------------------------------------------------/ New Code /--------
//  This initializes the list of maps players can vote on.
//------------------------------------------------------------------------*/
void Coven_GetMapVoteList (void)
{
        FILE    *infile;
        char    filename[MAX_OSPATH];
        char    buffer[MAX_QPATH];
        char    mapname[MAX_QPATH];
        int     maplength;
        int     no_of_maps = 0;         // Used as a line counter.

/* Reset number of maps available to vote on. */
        mapsinlist = 0;

/* Get path of game directory, and the name of the maps file. */
        sprintf (filename, "%s/%s.txt", gamedir->string, file_mapvote->string);

/* If map list file does not exist, exit function. */
        if ( (infile = fopen(filename, "r")) == NULL )
        {       // Add current level for voting.
                strcpy (mapname, level.mapname);
                mapname[MAX_FILELENGTH] = 0;
                sprintf (maplist[0], "%s", mapname);
                mapsinlist = 1;
                return;
        }

/* Read up to max number of maps, then place them in the map array. */
        while ((fgets(buffer, MAX_QPATH, infile)) && (mapsinlist < MAX_VOTEMAPS) && (no_of_maps < MAX_MAPS))
        {
                no_of_maps++;
                sscanf (buffer, "%s", mapname);
                maplength = strlen(mapname);
                if (mapname[0] && (maplength <= MAX_FILELENGTH))
                {
                        mapname[MAX_FILELENGTH] = 0;
                        sprintf (maplist[mapsinlist], "%s", mapname);
                        if (Coven_DuplicateMap (maplist[mapsinlist]))
                                maplist[mapsinlist][0] = 0;
                        else
                                mapsinlist++;
                }
        }

/* Close the file. */
        fclose (infile);

/* If current map is not the list, put it at the bottom of the list. */
        strcpy (mapname, level.mapname);
        mapname[MAX_FILELENGTH] = 0;
        if (!Coven_DuplicateMap (mapname))
        {
                if (mapsinlist < MAX_VOTEMAPS)
                {
                        sprintf (maplist[mapsinlist], "%s", mapname);
                        mapsinlist++;
                }
                else if (mapsinlist == MAX_VOTEMAPS)
                        sprintf (maplist[mapsinlist-1], "%s", mapname);
        }
}


/*===========================/  Map Cycling  /===========================*/

/*------------------------------------------------------/ New Code /--------
//  This selects the next map below the current map.
//------------------------------------------------------------------------*/
void Coven_CycleMap (char *newmap)
{
        FILE    *infile;
        char    filename[MAX_OSPATH];
        char    buffer[MAX_QPATH];
        int     no_of_maps = 0;
        int     maplength;

/* Get path of game directory, and the name of the maps file. */
        sprintf (filename, "%s/%s.txt", gamedir->string, file_maps->string);

/* If map list file does not exist, exit function. */
        if ( (infile = fopen(filename, "r")) == NULL )
                return;

/* Find current map, then select the next map after the current map. */
        while ((fgets(buffer, MAX_QPATH, infile)) && (no_of_maps < MAX_MAPS))
        {
                no_of_maps++;
                sscanf (buffer, "%s", newmap);
                if (!stricmp (level.mapname, newmap))
                {       /* Match found!  Get the next map. */
                        if ((!fgets(buffer, MAX_QPATH, infile)) || (no_of_maps == MAX_MAPS))
                        {       /* Current map is the last, go to first. */
                                rewind (infile);
                                fgets (buffer, MAX_QPATH, infile);
                        }
                        fclose (infile);
                        sscanf (buffer, "%s", newmap);

                        /* If map name is too long, assume the entry is
                           bogus and ignore the map cycler's results.
                        */
                        maplength = strlen(newmap);
                        if (maplength > 8)
                                newmap[0] = 0;

                        return;
                }
        }

/* No match was found. */
        fclose (infile);
}

/*------------------------------------------------------/ New Code /--------
//  This randomly selects the next map.
//------------------------------------------------------------------------*/
void Coven_RandomMap (char *newmap)
{
        FILE    *infile;
        char    filename[MAX_OSPATH];
        char    buffer[MAX_QPATH];
        int     no_of_maps = 0;
        int     new_map_no;
        int     maplength;

/* Get path of game directory, and the name of the maps file. */
        sprintf (filename, "%s/%s.txt", gamedir->string, file_maps->string);

/* If map list file does not exist, exit function. */
        if ( (infile = fopen(filename, "r")) == NULL )
                return;

/* Assign each map name a number. */
        while ((fgets(buffer, MAX_QPATH, infile)) && (no_of_maps < MAX_MAPS))
                no_of_maps++;

/* Do NOT use random selection if less than two map names are found. */
        if (no_of_maps < 2)
                return;

/* Random select a map. */
        new_map_no = ((rand() % no_of_maps) + 1);

/* Check if we can reach the selected map. */
        rewind (infile);

        while (new_map_no--)
        {
                if (!fgets(buffer, MAX_QPATH, infile))
                {       fclose (infile);
                        return;
                }
        }

/* Map found and selected. */
        fclose (infile);
        sscanf (buffer, "%s", newmap);

/* If map name is too long, assume the entry is bogus and ignore
   the map cycler's results.
*/
        maplength = strlen(newmap);
        if (maplength > 8)
                newmap[0] = 0;
}


/*===============================/  MOTD  /===============================*/

/*------------------------------------------------------/ New Code /--------
//  This checks if the character value is useful and desired.
//------------------------------------------------------------------------*/
qboolean Coven_LegalChar (char c)
{
        int     i = (int)c;

/* Newline character (ascii: 10) is legal, but handled elsewhere. */

/* If value is negative (signed), convert it to positive (unsigned). */
        if (i < 0)
                i += 256;

/* Any character whose value is or between 32 and 254 is legal. */
        if ((i > 31) && (i < 255))
                return true;

/* All others are forbidden.  (Value 255 will CRASH Quake!) */
        return false;
}

/*------------------------------------------------------/ New Code /--------
//  This opens the "motd.txt" file if available, then puts the file's
//  contents into a buffer for later use.
//------------------------------------------------------------------------*/
void Coven_GetMOTD (void)
{
        FILE    *infile;
        char    filename[MAX_OSPATH];
        char    c;
        int     i = 0;
        int     v_offset = 0;
        int     linepos = 0;
        int     no_of_lines = 0;
        static char msgline[16][32];

/* Get path of game directory, and the name of the motd file. */
        sprintf (filename, "%s/%s.txt", gamedir->string, file_motd->string);

/* If MOTD file does not exist, exit function.
   NOTE:  File is opened in binary mode because the file may contain
   displayable characters whose value is above the ASCII value 127.
*/
        if ((infile = fopen(filename, "rb")) == NULL)
                return;

/* Read file until EOF or end of MOTD buffer or many lines are read,
   whichever comes first.
*/
        while ( (i < MAX_MOTD_SIZE) && (no_of_lines < MAX_MOTD_LINES) &&
                ((c = fgetc(infile)) != EOF) )
        {
                if (c == '\n')
                {       // Newline -- start another line.
                        msgline[no_of_lines][linepos] = 0;
                        i++;
                        linepos = 0;
                        no_of_lines++;
                }
                else if ( (Coven_LegalChar (c)) && (linepos < MAX_MOTD_LINE_SIZE) )
                {       // Add character.
                        msgline[no_of_lines][linepos] = c;
                        i++;
                        linepos++;
                }
                else
                        i++;
        }

/* We don't need the file anymore, so close it! */
        fclose (infile);

/* If no message was read, the MotD will be blank. */
        if (i < 1)
        {
                for (i=0; i<MAX_MOTD_LINES; i++)
                {
                        msgline[i][0] = 0;
                        motdmenu[i+2].text = msgline[i];
                }
                return;
        }

/* End the current line and advance to next line. */
        if (linepos)
        {
                msgline[no_of_lines][linepos] = 0;
                no_of_lines++;
        }

/* Find the shift needed to center MotD. */
        v_offset = (MAX_MOTD_LINES/2) - ((no_of_lines+1)/2);

/* Blank out remaining lines. */
        while (no_of_lines < MAX_MOTD_LINES)
        {
                msgline[no_of_lines][0] = 0;
                no_of_lines++;
        }

/* Center the MotD.  MotD is shifted down by 'v_offset' lines. */
        if (v_offset)
        {
                for (i=((MAX_MOTD_LINES-1)-v_offset); i>=0; i--)
                {
                        strcpy (msgline[i+v_offset], msgline[i]);
                        msgline[i][0] = 0;
                }
        }

/* Update MotD. */
        for (i=0; i<MAX_MOTD_LINES; i++)
                motdmenu[i+2].text = msgline[i];
}


/*==========================/  Initialization  /==========================*/

/*------------------------------------------------------/ New Code /--------
//  This initializes some variables and the MOTD.
//------------------------------------------------------------------------*/
void Coven_ConfigInit (void)
{
        gamedir = gi.cvar ("game", "", CVAR_SERVERINFO | CVAR_LATCH);
        file_motd = gi.cvar ("file_motd", "motd", CVAR_SERVERINFO);
        file_maps = gi.cvar ("file_maps", "maps", CVAR_SERVERINFO);
        file_mapvote = gi.cvar ("file_mapvote", "mapvote", CVAR_SERVERINFO);

        Coven_GetMOTD ();
        Coven_GetMapVoteList ();
}


/*===========================/  END OF FILE  /===========================*/
