/*==========================================================================
//  x_newent.h -- by Patrick Martin             Last updated:  2-5-1999
//--------------------------------------------------------------------------
//  This file contains definitions for the various .md2 files used
//  in the flame/teleporter patch and any patch that uses flames.
//========================================================================*/

#include "x_firemd.h"


/***************/
/*  CONSTANTS  */
/***************/

// Frames for torches.
//
#define FRAME_FIRST_TORCH       0
#define FRAME_LAST_BOWLTORCH    5
#define FRAME_LAST_WALLTORCH   11

// .md2 Filenames.
//
#define MD2_WALLTORCH   gi.modelindex("models/flames/w_torch/tris.md2")
#define MD2_BOWLTORCH   gi.modelindex("models/flames/b_torch/tris.md2")
#define MD2_LAVABALL    gi.modelindex("models/flames/lavaball/tris.md2")

// .wav Filenames.
//
#define WAV_FIRE        gi.soundindex ("flames/fire.wav")


/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_newent.c
*/
void small_walltorch_animate (edict_t *self);
void SP_light_torch_small_walltorch (edict_t *ent);
void small_bowltorch_animate (edict_t *self);
void SP_light_torch_small_bowltorch (edict_t *ent);
void large_flame_animate (edict_t *self);
void SP_light_flame_large_yellow (edict_t *ent);
void small_flame_animate (edict_t *self);
void SP_light_flame_small_yellow (edict_t *ent);
void SP_light_flame_small_white (edict_t *ent);

void lavaball_touch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void lavaball_toss (edict_t *self);
void SP_misc_fireball (edict_t *ent);

qboolean Coven_TeleKillBox (edict_t *ent);
void Coven_CTT_Touch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void SP_coven_trigger_teleport(edict_t *ent);
void SP_coven_teleport_dest (edict_t *self);


/*===========================/  END OF FILE  /===========================*/
