/*==========================================================================
//  x_hud.c -- by various                       Last updated:  4-20-1999
//--------------------------------------------------------------------------
//  This file contains code that displays extra information on the
//  players' HUD.  This also contains code for displaying the team
//  scoreboard.
//========================================================================*/

#include "g_local.h"
#include "x_ctf.h"
#include "x_hud.h"


/*======================/  ArmourBack HUD Layout  /======================*/

// NOTE:  CTF uses *ctf_statusbar.  *ctf_statusbar is in x_ctf.c.

//
// --- KBM/PM : ARMOUR-BACK RULES
//
char *ab_statusbar =

// health
"xv   50 yb  -32 pic 0 "        // Use larger AB mugs for health.
"xv    0 yb  -24 hnum "

// ammo
"if 2 "
   "xv  100 anum "
   "xv  150 pic 2 "
"endif "

// armor
"if 4 "
   "xv  200 rnum "
   "xv  250 pic 4 "
"endif "

// selected item
"if 6 "
   "xv  296 pic 6 "
"endif "

"yb  -50 "

// picked up item
"if 7 "
   "xv    0 pic 7 "
   "xv   26 yb  -42 stat_string 8 "
   "yb  -50 "
"endif "

// timer
"if 9 "
   "xv  246 num 3 10 "
   "xv  296 pic 9 "
"endif "

//  help / weapon icon 
"if 11 "
   "xv  148 pic 11 "
"endif "

//  frags
// PM:  player icon is big.  (old pos: +8 for xr)
"xr  -50 yt    2 num 3 14 "

// spectator
"if 17 "
   "xv    0 "
   "yb  -58 "
   "string2 \"SPECTATOR MODE\" "
"endif "

// chase camera
"if 16 "
   "xv    0 "
   "yb  -68 "
   "string \"Chasing\" "
   "xv   64 "
   "stat_string 16 "
"endif "

// Crosshairs
"if 18 "
   "xv  128 yv   88 pic 18 "
"endif "

// Target ID
"if 19 "
   "xv   32 yv  104 stat_string 19 "
   "xv    0         pic 20 "
   "xv   32 yv  112 num 2 21 "
"endif "

// Tech
"if 22 "
   "xr  -24 yt   26 pic 22 "
"endif "

// Game Countdown Timer
"if 23 "
   "xv   64 yv   60 num 3 23 "
   "xv  124 yv   62 string \"Time To\" "
   "xv  124 yv   74 string2 \"Game Start\" "
"endif "

// Capture Armour Runes
"if 24 "
   "xr  -75 yt   80 num 3 24 "
   "xr  -25 yt   80 picn r_armour "
"endif "

// Capture Damage Runes
"if 25 "
   "xr  -75 yt  105 num 3 25 "
   "xr  -25 yt  105 picn r_damage "
"endif "

// Capture Health Runes
"if 26 "
   "xr  -75 yt  130 num 3 26 "
   "xr  -25 yt  130 picn r_health "
"endif "
;
//------------------------


/*===========================/  Target Icons  /===========================*/

/*----------------------------------------------------/ New Code /--------//
//  This puts a filename into the 'mugname'.
//------------------------------------------------------------------------*/
void Coven_MugName (char *mugname, edict_t *ent, qboolean scoreboard)
{
        int     mugindex;
        char    mug[60][16] =
{ "ab_no0",  "ab_no1",  "ab_no2",  "ab_no3",  "ab_no4",  "ab_no5",
  "ab_m0",   "ab_m1",   "ab_m2",   "ab_m3",   "ab_m4",   "ab_m5",
  "ab_z0",   "ab_z1",   "ab_z2",   "ab_z3",   "ab_z4",   "ab_z5",
  "ab_gb0",  "ab_gb1",  "ab_gb2",  "ab_gb3",  "ab_gb4",  "ab_gb5",
  "ab_wc0",  "ab_wc1",  "ab_wc2",  "ab_wc3",  "ab_wc4",  "ab_wc5",
  "ab_r0",   "ab_r1",   "ab_r2",   "ab_r3",   "ab_r4",   "ab_r5",
  "ab_sc0",  "ab_sc1",  "ab_sc2",  "ab_sc3",  "ab_sc4",  "ab_sc5",
  "ab_bh0",  "ab_bh1",  "ab_bh2",  "ab_bh3",  "ab_bh4",  "ab_bh5",
  "ab_rip0", "ab_rip1", "ab_rip2", "ab_rip3", "ab_rip4", "ab_rip5",
  "ab_wil0", "ab_wil1", "ab_wil2", "ab_wil3", "ab_wil4", "ab_wil5"  };

        if (!ent->client)
        {
                strcpy (mugname, "ab_no0");
                return;
        }

        if (scoreboard)
        {
                if (level.intermissiontime)
                {       // Intermission -- show true face!
                        if (ent->client->resp.suitcolor || (ab_teams < 2))
                                mugindex = ent->client->resp.suitcolor + (ent->battlesuit * 6);
                        else
                                mugindex = 0;
                }
                else if (ent->client->resp.spectator)
                {       // Spectating
                        if (ent->RA_quepos)
                                mugindex = ent->client->resp.suitcolor + 54;
                        else
                                mugindex = ent->client->resp.suitcolor;
                }
                else
                {       // Playing
                        if (ent->deadflag)
                                mugindex = ent->client->resp.suitcolor + 48;
                        else
                                mugindex = ent->client->resp.suitcolor + (ent->battlesuit * 6);
                }
        }
        else
                mugindex = ent->client->resp.suitcolor + (ent->battlesuit * 6);

        strcpy (mugname, mug[mugindex]);
}

/*----------------------------------------------------/ New Code /--------//
//  This returns the number index of the icon.
//------------------------------------------------------------------------*/
int Coven_MugIndex (edict_t *ent, qboolean rip)
{
        int     mugindex;
        char    mug[54][16] =
{ "ab_no0",  "ab_no1",  "ab_no2",  "ab_no3",  "ab_no4",  "ab_no5",
  "ab_m0",   "ab_m1",   "ab_m2",   "ab_m3",   "ab_m4",   "ab_m5",
  "ab_z0",   "ab_z1",   "ab_z2",   "ab_z3",   "ab_z4",   "ab_z5",
  "ab_gb0",  "ab_gb1",  "ab_gb2",  "ab_gb3",  "ab_gb4",  "ab_gb5",
  "ab_wc0",  "ab_wc1",  "ab_wc2",  "ab_wc3",  "ab_wc4",  "ab_wc5",
  "ab_r0",   "ab_r1",   "ab_r2",   "ab_r3",   "ab_r4",   "ab_r5",
  "ab_sc0",  "ab_sc1",  "ab_sc2",  "ab_sc3",  "ab_sc4",  "ab_sc5",
  "ab_bh0",  "ab_bh1",  "ab_bh2",  "ab_bh3",  "ab_bh4",  "ab_bh5",
  "ab_rip0", "ab_rip1", "ab_rip2", "ab_rip3", "ab_rip4", "ab_rip5"  };

        if (!ent->client)
                return gi.imageindex("ab_no0");

        if (rip && ent->deadflag)
                mugindex = ent->client->resp.suitcolor + 48;
        else
                mugindex = ent->client->resp.suitcolor + (ent->battlesuit * 6);

        return gi.imageindex(mug[mugindex]);
}


/*======================/  Target Identification  /======================*/

/*----------------------------------------------------/ New Code /--------//
//  This wipes any target information off the HUD.
//------------------------------------------------------------------------*/
void Coven_ClearID (edict_t *ent)
{
        ent->client->id_time = 0;
        ent->client->ps.stats[STAT_ID_NAME] = 0;
        ent->client->ps.stats[STAT_ID_MUG] = 0;
        ent->client->ps.stats[STAT_ID_METER] = 0;
}

/*----------------------------------------------------/ New Code /--------//
//  This lights up the targeting ID on the player's HUD.
//  The target's name, mug, and distance from player is shown.
//  Crosshairs also change.
//------------------------------------------------------------------------*/
void Coven_ShowID (edict_t *targ, edict_t *ent, int metres)
{
        char    mugindex;

/* Light up crosshairs if enemy is in sights. */
        if (!Coven_OnSameSide (targ, ent))
                ent->client->ps.stats[STAT_CROSSHAIRS] = gi.imageindex("x_ok");

/* Display target ID. */
        ent->client->id_time = level.time;
        if (targ->client)
        {       // Target is a player -- show mug and name.
                int     playernum = CS_PLAYERSKINS + (targ-g_edicts-1);

                mugindex = Coven_MugIndex(targ, false);
                ent->client->ps.stats[STAT_ID_NAME] = playernum;
        }
        else
        {       // We don't know what the target is.
                mugindex = gi.imageindex("ab_no0");
                ent->client->ps.stats[STAT_ID_NAME] = CS_UNKNOWN;
        }
        ent->client->ps.stats[STAT_ID_MUG] = mugindex;
        ent->client->ps.stats[STAT_ID_METER] = metres;
}

/*----------------------------------------------------/ New Code /--------//
//  This checks for targets directly in front of the player.
//------------------------------------------------------------------------*/
void Coven_TargetID (edict_t *ent)
{
	trace_t	tr;
        vec3_t  start, forward, end;
        int     delta;
        int     range = 4096;

/* Crosshairs are idle by default. */
        ent->client->ps.stats[STAT_CROSSHAIRS] = gi.imageindex("x_no");

/* Check for players directly if front of player. */
        VectorCopy(ent->s.origin, start);
        start[2] += ent->viewheight;
        AngleVectors (ent->client->v_angle, forward, NULL, NULL);
        VectorMA (start, range, forward, end);
        tr = gi.trace (start, NULL, NULL, end, ent, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER|CONTENTS_SLIME|CONTENTS_LAVA);
        if ((tr.fraction < 1) && (tr.ent))
        {
                if ((tr.ent->client) && (!tr.ent->deadflag))
                {       /* We got someone! */
                        delta = (int)(range * tr.fraction * 0.03);
                        if (delta <= 99)
                        {       /* Targets must be within 100 metres. */
                                Coven_ShowID (tr.ent, ent, delta);
                                return;
                        }
                }
        }

/* Make ID linger for two seconds so player has a chance to read it. */
        if ((!ent->client->id_time) || ((ent->client->id_time + 1) < level.time))
                Coven_ClearID (ent);
}

/*----------------------------------------------------/ New Code /--------//
//  This toggles the player's target identification system.
//------------------------------------------------------------------------*/
void Coven_ToggleID (edict_t *ent)
{
        if (!deathmatch->value)
                return;

        if (ent->client->resp.id_active)
        {       ent->client->resp.id_active = false;
                gi.cprintf (ent, PRINT_HIGH, "Target identification OFF\n");
                return;
        }

        ent->client->resp.id_active = true;
        gi.cprintf (ent, PRINT_HIGH, "Target identification ON\n");
}

/*----------------------------------------------------/ New Code /--------//
//  This checks if targeting ID is off.
//------------------------------------------------------------------------*/
qboolean Coven_NoID (edict_t *ent)
{
/* Check if ID is disabled. */
        if ((int)(dmflags->value) & DF_NO_ID)
                return true;

/* Ignore if ghost or dead. */
        if (ent->client->pers.spectator || ent->deadflag)
                return true;

/* Check if ID is off. */
        if (!ent->client->resp.id_active)
                return true;

/* Don't show ID if other stuff is on the screen. */
        if (ent->client->ps.stats[STAT_LAYOUTS])
                return true;

/* ID is on. */
        return false;
}


/*==========================/  ArmourBack HUD  /==========================*/

/*----------------------------------------------------/ New Code /--------//
//  Show extra hud stuff that appears in arena or capture.
//------------------------------------------------------------------------*/
static void Coven_ACStats (edict_t *ent)
{
        int     tsecs = ceil(game_nofire - level.time);

        // PM:  Times are floats, but we want seconds as an int.
        if (tsecs > 0)
                ent->client->ps.stats[STAT_TIMETOSTART_SEC] = tsecs;

        if (ent->stall_time)
        {       // Show anti-stall timer.
                tsecs = floor(ent->stall_time - level.time);
                if (tsecs >= 0)
                {       ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("s_watch");
                        ent->client->ps.stats[STAT_TIMER] = tsecs;
                }
        }

        if (Coven_ArenaOn ())
        {       // If waiting in line, show position in line.
                if (ent->RA_quepos && !ent->RA_playing)
                {       ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex ("in_line");
                        ent->client->ps.stats[STAT_ARMOR] = ent->RA_quepos;
                }
	}

        if (ab_rules == RULES_CAPTURE)
        {       // Show all the player's runes.
                ent->client->ps.stats[STAT_CA_ARUNE] = ent->client->pers.inventory[ITEM_INDEX(FindItem("Armour Rune"))];
                ent->client->ps.stats[STAT_CA_DRUNE] = ent->client->pers.inventory[ITEM_INDEX(FindItem("Damage Rune"))];
                ent->client->ps.stats[STAT_CA_HRUNE] = ent->client->pers.inventory[ITEM_INDEX(FindItem("Health Rune"))];
	}
}

/*----------------------------------------------------/ New Code /--------//
//  Display short miscellaneous message for spectators.
//------------------------------------------------------------------------*/
static void Coven_ShowTabMessage (edict_t *ent)
{
        if (ent->client->resp.spectator)
	{
                // Show only if not in menu.
                if (ent->client->menu)
                        return;

                // Don't show if waiting in line.
                if (ent->RA_quepos)
                        return;

                ent->client->pickup_msg_time = 0;
                ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex("i_airstrike");
                ent->client->ps.stats[STAT_PICKUP_STRING] = CS_TAB_MENU;
	}
        else if (ent->deadflag)
        {
                // Show spectator only if player can respawn.
                if (level.time <= ent->client->respawn_time)
                        return;

                ent->client->pickup_msg_time = 0;
                ent->client->ps.stats[STAT_PICKUP_ICON] = gi.imageindex("k_comhead");
                ent->client->ps.stats[STAT_PICKUP_STRING] = CS_TAB_SPECTATOR;
        }
}

/*----------------------------------------------------/ New Code /--------//
//  Show CTF hud and target id.
//------------------------------------------------------------------------*/
static void Coven_CTFHUD (edict_t *ent)
{
        SetCTFStats (ent);

        if (level.intermissiontime)
                return;

        // PM:  Check targeting display.
        if (Coven_NoID (ent))
                Coven_ClearID (ent);
        else
                Coven_TargetID (ent);

        Coven_ShowTabMessage (ent);
}

/*----------------------------------------------------/ New Code /--------//
//  Display extra ArmourBack stats on the player's hud.
//------------------------------------------------------------------------*/
void Coven_ArmourBackHUD (edict_t *ent)
{
        ent->client->ps.stats[STAT_CROSSHAIRS] = 0;
        ent->client->ps.stats[STAT_CTF_TECH] = 0;

        if (ab_rules == RULES_CTF)
        {
                Coven_CTFHUD (ent);
                return;
        }

	ent->client->ps.stats[STAT_TIMETOSTART_SEC] = 0;
        ent->client->ps.stats[STAT_CA_ARUNE] = 0;
        ent->client->ps.stats[STAT_CA_DRUNE] = 0;
        ent->client->ps.stats[STAT_CA_HRUNE] = 0;

        Coven_ShowTech (ent);

        // No need to show extra stuff during intermission.
        if (level.intermissiontime)
                return;

        // Check targeting display.
        if (Coven_NoID (ent))
                Coven_ClearID (ent);
        else
                Coven_TargetID (ent);

        Coven_ShowTabMessage (ent);

        if (Coven_ArenaOn() || (ab_rules == RULES_CAPTURE))
                Coven_ACStats (ent);
}


/*===========================/  END OF FILE  /===========================*/
