/*==========================================================================
//  x_client.h -- by various                    Last updated:  4-19-1999
//--------------------------------------------------------------------------
//  This is the header for x_client.c.
//========================================================================*/

#include "AB_BulkHead.h"
#include "AB_GravyBurner.h"
#include "AB_Mercury.h"
#include "AB_Rhino.h"
#include "AB_SugarConny.h"
#include "AB_WireCutter.h"
#include "AB_Zeppelin.h"


/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_client.c
*/
qboolean Coven_IsPlayer (edict_t *ent);
void Coven_SuitGib (edict_t *ent, int damage, int delta);

void Coven_SetAnimAliases (edict_t *ent);
void Coven_SuitBox (edict_t *ent);
qboolean Coven_CheckGuns (edict_t *ent);
qboolean Coven_SuitReady (edict_t *ent);
qboolean Coven_BypassLine (edict_t *ent);
qboolean Coven_CanFight (edict_t *ent);

qboolean Coven_HasPowerArmor (edict_t *ent);
qboolean Coven_OnePowerArmor (edict_t *ent);
void Coven_EnableCells (edict_t *ent);
void Coven_DisableCells (edict_t *ent);

void Coven_GiveAltArmor (edict_t *ent);
void Coven_GiveJetpack (edict_t *ent);
void Coven_RestoreRunes (edict_t *ent, int h, int a, int d);

void Coven_RestoreGuns (edict_t *ent);
void Coven_GiveAmmo (edict_t *ent, gitem_t *gun);
void Coven_SetGunmask (edict_t *ent, gitem_t *gun);
void Coven_RemoveGuns (edict_t *ent);
void Coven_FourWeapons (edict_t *ent);

void Coven_StartWeapon (edict_t *ent);

gitem_t *Coven_FindOtherAmmo (edict_t *ent);
static void Coven_DropThirdAmmo
 (edict_t *ent, qboolean fuel, qboolean cells);
void Coven_DeadDropAmmo (edict_t *ent);


/*===========================/  END OF FILE  /===========================*/
