#include "g_local.h"
#include "m_player.h"
// COVEN:  Include new header files.
#include "x_client.h"
#include "x_ctf.h"
#include "x_fire.h"
#include "x_guns.h"
#include "x_hook.h"
#include "x_jet.h"
#include "x_rules.h"
#include "x_select.h"
#include "x_sound.h"
#include "x_team.h"
// COVEN

void ClientUserinfoChanged (edict_t *ent, char *userinfo);

void SP_misc_teleporter_dest (edict_t *ent);

//
// Gross, ugly, disgustuing hack section
//

// this function is an ugly as hell hack to fix some map flaws
//
// the coop spawn spots on some maps are SNAFU.  There are coop spots
// with the wrong targetname as well as spots with no name at all
//
// we use carnal knowledge of the maps to fix the coop spot targetnames to match
// that of the nearest named single player spot

static void SP_FixCoopSpots (edict_t *self)
{
	edict_t	*spot;
	vec3_t	d;

	spot = NULL;

	while(1)
	{
		spot = G_Find(spot, FOFS(classname), "info_player_start");
		if (!spot)
			return;
		if (!spot->targetname)
			continue;
		VectorSubtract(self->s.origin, spot->s.origin, d);
		if (VectorLength(d) < 384)
		{
			if ((!self->targetname) || Q_stricmp(self->targetname, spot->targetname) != 0)
			{
//				gi.dprintf("FixCoopSpots changed %s at %s targetname from %s to %s\n", self->classname, vtos(self->s.origin), self->targetname, spot->targetname);
				self->targetname = spot->targetname;
			}
			return;
		}
	}
}

// now if that one wasn't ugly enough for you then try this one on for size
// some maps don't have any coop spots at all, so we need to create them
// where they should have been

static void SP_CreateCoopSpots (edict_t *self)
{
	edict_t	*spot;

	if(Q_stricmp(level.mapname, "security") == 0)
	{
		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 - 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 64;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		spot = G_Spawn();
		spot->classname = "info_player_coop";
		spot->s.origin[0] = 188 + 128;
		spot->s.origin[1] = -164;
		spot->s.origin[2] = 80;
		spot->targetname = "jail3";
		spot->s.angles[1] = 90;

		return;
	}
}


/*QUAKED info_player_start (1 0 0) (-16 -16 -24) (16 16 32)
The normal starting point for a level.
*/
void SP_info_player_start(edict_t *self)
{
	if (!coop->value)
		return;
	if(Q_stricmp(level.mapname, "security") == 0)
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_CreateCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}

/*QUAKED info_player_deathmatch (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for deathmatch games
*/
void SP_info_player_deathmatch(edict_t *self)
{
	if (!deathmatch->value)
	{
		G_FreeEdict (self);
		return;
	}
	SP_misc_teleporter_dest (self);
}

/*QUAKED info_player_coop (1 0 1) (-16 -16 -24) (16 16 32)
potential spawning position for coop games
*/

void SP_info_player_coop(edict_t *self)
{
	if (!coop->value)
	{
		G_FreeEdict (self);
		return;
	}

	if((Q_stricmp(level.mapname, "jail2") == 0)   ||
	   (Q_stricmp(level.mapname, "jail4") == 0)   ||
	   (Q_stricmp(level.mapname, "mine1") == 0)   ||
	   (Q_stricmp(level.mapname, "mine2") == 0)   ||
	   (Q_stricmp(level.mapname, "mine3") == 0)   ||
	   (Q_stricmp(level.mapname, "mine4") == 0)   ||
	   (Q_stricmp(level.mapname, "lab") == 0)     ||
	   (Q_stricmp(level.mapname, "boss1") == 0)   ||
	   (Q_stricmp(level.mapname, "fact3") == 0)   ||
	   (Q_stricmp(level.mapname, "biggun") == 0)  ||
	   (Q_stricmp(level.mapname, "space") == 0)   ||
	   (Q_stricmp(level.mapname, "command") == 0) ||
	   (Q_stricmp(level.mapname, "power2") == 0) ||
	   (Q_stricmp(level.mapname, "strike") == 0))
	{
		// invoke one of our gross, ugly, disgusting hacks
		self->think = SP_FixCoopSpots;
		self->nextthink = level.time + FRAMETIME;
	}
}


/*QUAKED info_player_intermission (1 0 1) (-16 -16 -24) (16 16 32)
The deathmatch intermission point will be at one of these
Use 'angles' instead of 'angle', so you can set pitch or roll as well as yaw.  'pitch yaw roll'
*/
void SP_info_player_intermission(void)
{
}


//=======================================================================


void player_pain (edict_t *self, edict_t *other, float kick, int damage)
{
	// player pain is handled at the end of the frame in P_DamageFeedback
}


qboolean IsFemale (edict_t *ent)
{
	char		*info;

	if (!ent->client)
		return false;

// COVEN:  Check battlesuits.  Mercury is the only female suit.
        if (ent->battlesuit)
        {       if (ent->battlesuit == SUIT_MERCURY)
                        return true;
                return false;
        }
// COVEN

	info = Info_ValueForKey (ent->client->pers.userinfo, "gender");
	if (info[0] == 'f' || info[0] == 'F')
		return true;
	return false;
}

qboolean IsNeutral (edict_t *ent)
{
	char		*info;

	if (!ent->client)
		return false;

// COVEN:  Check battlesuits.  When in doubt, assume male.
        if (ent->battlesuit)
                return false;
// COVEN

	info = Info_ValueForKey (ent->client->pers.userinfo, "gender");
	if (info[0] != 'f' && info[0] != 'F' && info[0] != 'm' && info[0] != 'M')
		return true;
	return false;
}

void ClientObituary (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	int			mod;
	char		*message;
	char		*message2;
	qboolean	ff;

// COVEN:  Players should not die in intermission.  If so, overlook it :)
        if (level.intermissiontime)
                return;
// COVEN

	if (coop->value && attacker->client)
		meansOfDeath |= MOD_FRIENDLY_FIRE;

	if (deathmatch->value || coop->value)
	{
		ff = meansOfDeath & MOD_FRIENDLY_FIRE;
		mod = meansOfDeath & ~MOD_FRIENDLY_FIRE;
		message = NULL;
		message2 = "";

		switch (mod)
		{
		case MOD_SUICIDE:
			message = "suicides";
			break;
		case MOD_FALLING:
			message = "cratered";
			break;
		case MOD_CRUSH:
			message = "was squished";
			break;
		case MOD_WATER:
			message = "sank like a rock";
			break;
		case MOD_SLIME:
			message = "melted";
			break;
		case MOD_LAVA:
			message = "does a back flip into the lava";
			break;
		case MOD_EXPLOSIVE:
		case MOD_BARREL:
			message = "blew up";
			break;
		case MOD_EXIT:
			message = "found a way out";
			break;
		case MOD_TARGET_LASER:
			message = "saw the light";
			break;
		case MOD_TARGET_BLASTER:
			message = "got blasted";
			break;
		case MOD_BOMB:
		case MOD_SPLASH:
		case MOD_TRIGGER_HURT:
			message = "was in the wrong place";
			break;
// COVEN:  Lavaball.
                case MOD_LAVABALL:
                        message = "ate a lavaball";
			break;
// COVEN
		}
		if (attacker == self)
		{
			switch (mod)
			{
// COVEN:  ArmourBack obituaries for self-termination.
                        case MOD_BEAM_SPLASH:
                                message = "stood too close to the fireworks";
                                break;
			case MOD_HG_SPLASH:
			case MOD_G_SPLASH:
				if (IsNeutral(self))
					message = "tripped on its own grenade";
				else if (IsFemale(self))
					message = "tripped on her own grenade";
				else
					message = "tripped on his own grenade";
				break;

                        case MOD_P_SPLASH:
				if (IsNeutral(self))
                                        message = "zapped itself";
				else if (IsFemale(self))
                                        message = "zapped herself";
				else
                                        message = "zapped himself";
                                break;
			case MOD_R_SPLASH:
				if (IsNeutral(self))
					message = "blew itself up";
				else if (IsFemale(self))
					message = "blew herself up";
				else
					message = "blew himself up";
				break;

                        case MOD_FLAMETHROWER:
                                message = "had a meltdown";
                                break;
                        case MOD_FIRE_SPLASH:
                        case MOD_FIRE:
				if (IsNeutral(self))
                                        message = "burned itself";
				else if (IsFemale(self))
                                        message = "burned herself";
				else
                                        message = "burned himself";
				break;
                        case MOD_ON_FIRE:
                                message = "became toast";
				break;
                        case MOD_MIRV_ROCKET:
                        case MOD_MIRV_SPLASH:
                        case MOD_DRUNK_ROCKET:
                        case MOD_DRUNK_SPLASH:
				if (IsNeutral(self))
					message = "blew itself up";
				else if (IsFemale(self))
					message = "blew herself up";
				else
					message = "blew himself up";
				break;
// COVEN
			default:
				if (IsNeutral(self))
					message = "killed itself";
				else if (IsFemale(self))
					message = "killed herself";
				else
					message = "killed himself";
				break;
			}
		}
		if (message)
		{
// COVEN:  Check to show obituaries to all, or only to the select clients.
                        if ((int)(dmflags->value) & DF_LESS_MESSAGES)
                                gi.cprintf (self, PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
                        else
                                gi.bprintf (PRINT_MEDIUM, "%s %s.\n", self->client->pers.netname, message);
// COVEN
// COVEN:  Players may score only during normal play.
                        if (deathmatch->value && !Coven_NoFire ())
				self->client->resp.score--;
// COVEN
			self->enemy = NULL;
			return;
		}

		self->enemy = attacker;
		if (attacker && attacker->client)
		{
			switch (mod)
			{
			case MOD_TELEFRAG:
				message = "tried to invade";
				message2 = "'s personal space";
				break;
// COVEN:  ArmourBack obituaries for frags.
                        case MOD_GRAPPLE:
                                message = "was hooked by";
                                message2 = "'s grapple";
                                break;
                        case MOD_GRAPPLE_HOLD:
                                message = "was eviscerated by";
                                message2 = "'s grapple";
                                break;
			case MOD_SHOTGUN:
				message = "was gunned down by";
				break;
                        case MOD_BEAM:
                        case MOD_BEAM_SPLASH:
                                message = "was fried by";
                                message2 = "'s particle beam";
                                break;
			case MOD_GRENADE:
				message = "was popped by";
				message2 = "'s grenade";
				break;
			case MOD_G_SPLASH:
				message = "was shredded by";
				message2 = "'s shrapnel";
				break;

                        case MOD_POKER:
                                message = "was branded by";
                                break;
			case MOD_BLASTER:
				message = "was blasted by";
				break;
                        case MOD_PHOTON:
                                message = "was zapped by";
                                message2 = "'s photon cannon";
                                break;
                        case MOD_P_CHAIN:
                                message = "got beamed by";
                                message2 = "'s photon chain";
                                break;
                        case MOD_P_SPLASH:
                                message = "feels the juice from";
                                message2 = "'s photon blast";
                                break;
                        case MOD_MINIGUN:
                                message = "was perforated by";
                                message2 = "'s minigun";
                                break;
			case MOD_ROCKET:
				message = "ate";
				message2 = "'s rocket";
				break;
			case MOD_R_SPLASH:
				message = "almost dodged";
				message2 = "'s rocket";
				break;

                        case MOD_CARVER:
                                message = "was sliced in half by";
                                break;
                        case MOD_FLAMETHROWER:
                                message = "was melted by";
                                message2 = "'s flamethrower";
                                break;
                        case MOD_FIRE_SPLASH:
                                message = "was scorched by";
				break;
                        case MOD_ON_FIRE:
                                message = "was cremated by";
				break;
                        case MOD_FIRE:
                                message = "got flamed by";
				break;
                        case MOD_AUTOSHOTGUN:
				message = "was blown away by";
                                message2 = "'s auto shotgun";
                                break;
                        case MOD_MIRV_ROCKET:
                        case MOD_MIRV_SPLASH:
                                message = "rides";
                                message2 = "'s MIRV";
                                break;
                        case MOD_DRUNK_ROCKET:
                        case MOD_DRUNK_SPLASH:
                                message = "kissed one of";
                                message2 = "'s warheads";
                                break;
// COVEN
			}
			if (message)
			{
// COVEN:  Check to show obituaries to all, or only to the select clients.
                                if ((int)(dmflags->value) & DF_LESS_MESSAGES)
                                {
                                        if (ff)
                                        {
                                                gi.cprintf (self, PRINT_MEDIUM,"Friendly fire:  %s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                                gi.cprintf (attacker, PRINT_MEDIUM,"Friendly fire:  %s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                        }
                                        else
                                        {
                                                gi.cprintf (self, PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                                gi.cprintf (attacker, PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                        }
                                }
                                else
                                {
                                        if (ff)
                                                gi.bprintf (PRINT_MEDIUM,"Friendly fire:  %s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                        else
                                                gi.bprintf (PRINT_MEDIUM,"%s %s %s%s\n", self->client->pers.netname, message, attacker->client->pers.netname, message2);
                                }
// COVEN
// COVEN:  Players may score only during normal play.
                                if (deathmatch->value && !Coven_NoFire ())
// COVEN
				{
					if (ff)
						attacker->client->resp.score--;
					else
						attacker->client->resp.score++;
				}
				return;
			}
		}
	}

// COVEN:  Check to show obituaries to all, or only to the select clients.
        if ((int)(dmflags->value) & DF_LESS_MESSAGES)
                gi.cprintf (self, PRINT_MEDIUM, "%s died.\n", self->client->pers.netname);
        else
                gi.bprintf (PRINT_MEDIUM, "%s died.\n", self->client->pers.netname);
// COVEN
// COVEN:  Players may score only during normal play.
        if (deathmatch->value && !Coven_NoFire ())
		self->client->resp.score--;
// COVEN
}


void Touch_Item (edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf);

void TossClientWeapon (edict_t *self)
{
// COVEN:  General rewrite.
//        gitem_t         *item;
	edict_t		*drop;
	qboolean	quad;
//        float           spread;

	if (!deathmatch->value)
		return;

        // Drop the quad first.
	if (!((int)(dmflags->value) & DF_QUAD_DROP))
		quad = false;
	else
		quad = (self->client->quad_framenum > (level.framenum + 10));

        if (quad)
        {       // Drop quad in the middle.
                drop = Drop_Item (self, FindItemByClassname ("item_quad"));
                drop->spawnflags |= DROPPED_PLAYER_ITEM;
                drop->touch = Touch_Item;
                drop->nextthink = level.time + (self->client->quad_framenum - level.framenum) * FRAMETIME;
                drop->think = G_FreeEdict;
        }

        Coven_DeadDropAmmo (self);
// COVEN
}


/*
==================
LookAtKiller
==================
*/
void LookAtKiller (edict_t *self, edict_t *inflictor, edict_t *attacker)
{
	vec3_t		dir;

	if (attacker && attacker != world && attacker != self)
	{
		VectorSubtract (attacker->s.origin, self->s.origin, dir);
	}
	else if (inflictor && inflictor != world && inflictor != self)
	{
		VectorSubtract (inflictor->s.origin, self->s.origin, dir);
	}
	else
	{
		self->client->killer_yaw = self->s.angles[YAW];
		return;
	}

	if (dir[0])
		self->client->killer_yaw = 180/M_PI*atan2(dir[1], dir[0]);
	else {
		self->client->killer_yaw = 0;
		if (dir[1] > 0)
			self->client->killer_yaw = 90;
		else if (dir[1] < 0)
			self->client->killer_yaw = -90;
	}
	if (self->client->killer_yaw < 0)
		self->client->killer_yaw += 360;
	

}

/*
==================
player_die
==================
*/
void player_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
	int		n;

	VectorClear (self->avelocity);

	self->takedamage = DAMAGE_YES;
	self->movetype = MOVETYPE_TOSS;

	self->s.modelindex2 = 0;	// remove linked weapon model
// COVEN:  Borrowed from Zoid's CTF.
	self->s.modelindex3 = 0;	// remove linked ctf flag
// COVEN

	self->s.angles[0] = 0;
	self->s.angles[2] = 0;

	self->s.sound = 0;
	self->client->weapon_sound = 0;

	self->maxs[2] = -8;

//	self->solid = SOLID_NOT;
	self->svflags |= SVF_DEADMONSTER;

	if (!self->deadflag)
	{
// COVEN
                // Explode if jetpack is on.
                if (Jet_Active (self))
                        Jet_BecomeExplosion (self);
                // Battlesuit death anims may be as long as 2.5 seconds.
                self->client->respawn_time = level.time + 2.5;
// COVEN
		LookAtKiller (self, inflictor, attacker);
		self->client->ps.pmove.pm_type = PM_DEAD;
		ClientObituary (self, inflictor, attacker);
// COVEN:  Borrowed from Zoid's CTF.
		CTFFragBonuses(self, inflictor, attacker);
// COVEN
		TossClientWeapon (self);
// COVEN:  Remember last weapon then purge runes.
                self->client->resp.lastgun = self->client->pers.weapon;

                // Drop flag and tech.
		CTFDeadDropFlag(self);
		CTFDeadDropTech(self);

                // Purge runes.
                Coven_DropAllRunes (self);

                // Must do this after dropping runes.
                self->RA_playing = false;
                if ( ((ab_rules == RULES_DUEL) && (ab_teams >= 2)) ||
                     (ab_rules == RULES_ELIMINATION) || (ab_rules == RULES_CAPTURE) )
                        self->stall_time = level.time + AB_maxdelay->value;
/*
		if (deathmatch->value)
			Cmd_Help_f (self);		// show scores
*/
// COVEN

		// clear inventory
		// this is kind of ugly, but it's how we want to handle keys in coop
		for (n = 0; n < game.num_items; n++)
		{
			if (coop->value && itemlist[n].flags & IT_KEY)
				self->client->resp.coop_respawn.inventory[n] = self->client->pers.inventory[n];
			self->client->pers.inventory[n] = 0;
		}
	}

	// remove powerups
	self->client->quad_framenum = 0;
	self->client->invincible_framenum = 0;
	self->client->breather_framenum = 0;
	self->client->enviro_framenum = 0;
	self->flags &= ~FL_POWER_ARMOR;
// COVEN:  Clear jetpack values.
        Coven_JetClear (self);
// COVEN

// COVEN:  Player death
        //if (self->health < -40)
        if (self->health <= self->gib_health)
	{	// gib
                // Throw gibs according to suit.
                Coven_SuitGib (self, damage, 0);
                self->client->anim_priority = ANIM_DEATH;
                self->client->anim_end = 0;
	}
	else
	{	// normal death
		if (!self->deadflag)
		{
			static int i;

			i = (i+1)%3;
			// start a death animation
			self->client->anim_priority = ANIM_DEATH;

			/* AWE - BATTLESUIT */
                        if (self->battlesuit)
			{
				if (self->client->ps.pmove.pm_flags & PMF_DUCKED)
                                {       // Crouching.
                                        self->s.frame = self->crouch_death_anim_start-1;
					self->client->anim_end = self->crouch_death_anim_end;
				}
                                else if ((self->waterlevel) && (!self->groundentity))
                                {       // Swimming.
					self->s.frame = self->swim_death_anim_start-1;
					self->client->anim_end = self->swim_death_anim_end;
				}
				else
                                {       // Standing.
                                        self->s.frame = self->death_anim_start-1;
                                        self->client->anim_end = self->death_anim_end;
				}
			}
			/* AWE - MARINE */
			else
			{
				if (self->client->ps.pmove.pm_flags & PMF_DUCKED)
				{
					self->s.frame = FRAME_crdeath1-1;
					self->client->anim_end = FRAME_crdeath5;
				}
				else switch (i)
				{
				case 0:
					self->s.frame = FRAME_death101-1;
					self->client->anim_end = FRAME_death106;
					break;
				case 1:
					self->s.frame = FRAME_death201-1;
					self->client->anim_end = FRAME_death206;
					break;
				case 2:
					self->s.frame = FRAME_death301-1;
					self->client->anim_end = FRAME_death308;
					break;
				}
			}
                        Coven_SfxDeath (self);          // Play death sfx.
                        self->client->v_angle[0] = 0;   // Untilt body.
		}
	}

        // Show scores in DM.
        if (!self->deadflag)
		if (deathmatch->value)
                        if (!self->client->showscores)
                        {       // Set flag so tombstone icon appears.
                                self->deadflag = DEAD_DEAD;
                                Cmd_Help_f (self);      // show scores
                        }
// COVEN

	self->deadflag = DEAD_DEAD;

	gi.linkentity (self);
}

//=======================================================================

/*
==============
InitClientPersistant

This is only called when the game first initializes in single player,
but is called after each death and level change in deathmatch
==============
*/
void InitClientPersistant (gclient_t *client)
{
	gitem_t		*item;

	memset (&client->pers, 0, sizeof(client->pers));

// COVEN:  Set only health.
	client->pers.weapon = NULL;

        client->pers.health             = 100;
        client->pers.max_health         = 100;

        // If not DM, give the player all weapons.
        if (!deathmatch->value)
        {
                client->pers.inventory[ITEM_INDEX(FindItem ("Jetpack"))] = 1;

                client->pers.inventory[ITEM_INDEX(FindItem ("Grapple"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Assault Shotgun"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Particle Beam"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Grenade Launcher"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Prod Rod"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Photon Cannon"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Minigun"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Bazooka"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Carver"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Flamethrower"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("Auto Shotgun"))] = 1;
                client->pers.inventory[ITEM_INDEX(FindItem ("MIRV Launcher"))] = 1;

                item = FindItem("Grapple");
                client->pers.selected_item = ITEM_INDEX(item);
                client->pers.weapon = item;

                client->pers.max_bullets        = NORMAL_MAX_BULLETS;
                client->pers.max_shells         = NORMAL_MAX_SHELLS;
                client->pers.max_rockets        = NORMAL_MAX_ROCKETS;
                client->pers.max_grenades       = NORMAL_MAX_GRENADES;
                client->pers.max_cells          = NORMAL_MAX_CELLS;
                client->pers.max_slugs          = NORMAL_MAX_FUEL;
        }
// COVEN

	client->pers.connected = true;
}


void InitClientResp (gclient_t *client)
{
// COVEN:  Remember info.
        qboolean        id_active = client->resp.id_active;
        qboolean        alt_score = client->resp.alt_score;
        int             skin = client->resp.suitcolor;
        int             suit = client->resp.battlesuit;
        int             guns = client->resp.gunmask;
        gitem_t         *last;

        last = client->resp.lastgun;

        // NOTE:  Convert BulkHead <==> Rhino if secret has changed.
        if (secret_on)
        {       if (suit == SUIT_RHINO)
                        suit = SUIT_BULKHEAD;
        }
        else
        {       if (suit == SUIT_BULKHEAD)
                        suit = SUIT_RHINO;
        }
// COVEN

	memset (&client->resp, 0, sizeof(client->resp));
// COVEN:  Restore info.
        client->resp.alt_score  = alt_score;
        client->resp.id_active  = id_active;
        client->resp.suitcolor  = skin;
        client->resp.battlesuit = suit;
        client->resp.gunmask    = guns;
        client->resp.lastgun    = last;
// COVEN
	client->resp.enterframe = level.framenum;
	client->resp.coop_respawn = client->pers;
}

/*
==================
SaveClientData

Some information that should be persistant, like health, 
is still stored in the edict structure, so it needs to
be mirrored out to the client structure before all the
edicts are wiped.
==================
*/
void SaveClientData (void)
{
	int		i;
	edict_t	*ent;

	for (i=0 ; i<game.maxclients ; i++)
	{
		ent = &g_edicts[1+i];
		if (!ent->inuse)
			continue;
		game.clients[i].pers.health = ent->health;
		game.clients[i].pers.max_health = ent->max_health;
		game.clients[i].pers.savedFlags = (ent->flags & (FL_GODMODE|FL_NOTARGET|FL_POWER_ARMOR));
		if (coop->value)
			game.clients[i].pers.score = ent->client->resp.score;
	}
}

void FetchClientEntData (edict_t *ent)
{
	ent->health = ent->client->pers.health;
	ent->max_health = ent->client->pers.max_health;
	ent->flags |= ent->client->pers.savedFlags;
	if (coop->value)
		ent->client->resp.score = ent->client->pers.score;
}



/*
=======================================================================

  SelectSpawnPoint

=======================================================================
*/

/*
================
PlayersRangeFromSpot

Returns the distance to the nearest player from the given spot
================
*/
float	PlayersRangeFromSpot (edict_t *spot)
{
	edict_t	*player;
	float	bestplayerdistance;
	vec3_t	v;
	int		n;
	float	playerdistance;


	bestplayerdistance = 9999999;

	for (n = 1; n <= maxclients->value; n++)
	{
		player = &g_edicts[n];

		if (!player->inuse)
			continue;

		if (player->health <= 0)
			continue;

		VectorSubtract (spot->s.origin, player->s.origin, v);
		playerdistance = VectorLength (v);

		if (playerdistance < bestplayerdistance)
			bestplayerdistance = playerdistance;
	}

	return bestplayerdistance;
}

/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/
edict_t *SelectRandomDeathmatchSpawnPoint (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}

/*
================
SelectFarthestDeathmatchSpawnPoint

================
*/
edict_t *SelectFarthestDeathmatchSpawnPoint (void)
{
	edict_t	*bestspot;
	float	bestdistance, bestplayerdistance;
	edict_t	*spot;


	spot = NULL;
	bestspot = NULL;
	bestdistance = 0;
	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		bestplayerdistance = PlayersRangeFromSpot (spot);

		if (bestplayerdistance > bestdistance)
		{
			bestspot = spot;
			bestdistance = bestplayerdistance;
		}
	}

	if (bestspot)
	{
		return bestspot;
	}

	// if there is a player just spawned on each and every start spot
	// we have no choice to turn one into a telefrag meltdown
	spot = G_Find (NULL, FOFS(classname), "info_player_deathmatch");

	return spot;
}

edict_t *SelectDeathmatchSpawnPoint (void)
{
	if ( (int)(dmflags->value) & DF_SPAWN_FARTHEST)
		return SelectFarthestDeathmatchSpawnPoint ();
	else
		return SelectRandomDeathmatchSpawnPoint ();
}


edict_t *SelectCoopSpawnPoint (edict_t *ent)
{
	int		index;
	edict_t	*spot = NULL;
	char	*target;

	index = ent->client - game.clients;

	// player 0 starts in normal player spawn point
	if (!index)
		return NULL;

	spot = NULL;

	// assume there are four coop spots at each spawnpoint
	while (1)
	{
		spot = G_Find (spot, FOFS(classname), "info_player_coop");
		if (!spot)
			return NULL;	// we didn't have enough...

		target = spot->targetname;
		if (!target)
			target = "";
		if ( Q_stricmp(game.spawnpoint, target) == 0 )
		{	// this is a coop spawn point for one of the clients here
			index--;
			if (!index)
				return spot;		// this is it
		}
	}


	return spot;
}


/*
===========
SelectSpawnPoint

Chooses a player start, deathmatch start, coop start, etc
============
*/
void	SelectSpawnPoint (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	if (deathmatch->value)
// COVEN:  Borrowed from Zoid's CTF...
        {
                if (ab_rules == RULES_CTF)
			spot = SelectCTFSpawnPoint(ent);
		else
                        spot = SelectDeathmatchSpawnPoint ();
        }
// COVEN
	else if (coop->value)
		spot = SelectCoopSpawnPoint (ent);

	// find a single player start spot
	if (!spot)
	{
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);
}

//======================================================================


void InitBodyQue (void)
{
	int		i;
	edict_t	*ent;

	level.body_que = 0;
	for (i=0; i<BODY_QUEUE_SIZE ; i++)
	{
		ent = G_Spawn();
		ent->classname = "bodyque";
	}
}

void body_die (edict_t *self, edict_t *inflictor, edict_t *attacker, int damage, vec3_t point)
{
// COVEN:  Throw gibs according to suit.
        if (self->health <= self->gib_health)
                Coven_SuitGib (self, damage, -48);
// COVEN
}

void CopyToBodyQue (edict_t *ent)
{
	edict_t		*body;

	// grab a body que and cycle to the next one
	body = &g_edicts[(int)maxclients->value + level.body_que + 1];
	level.body_que = (level.body_que + 1) % BODY_QUEUE_SIZE;

	// FIXME: send an effect on the removed body

	gi.unlinkentity (ent);

	gi.unlinkentity (body);
	body->s = ent->s;
	body->s.number = body - g_edicts;
// COVEN:  Don't make crispy frying sounds.
        body->s.sound = 0;
// COVEN

// COVEN:  Treat body as a dead monster, so that it bleeds and not spark.
        body->svflags = ent->svflags | SVF_MONSTER | SVF_DEADMONSTER;
        body->monsterinfo.aiflags |= AI_GOOD_GUY;
// COVEN
	VectorCopy (ent->mins, body->mins);
	VectorCopy (ent->maxs, body->maxs);
	VectorCopy (ent->absmin, body->absmin);
	VectorCopy (ent->absmax, body->absmax);
	VectorCopy (ent->size, body->size);
	body->solid = ent->solid;
	body->clipmask = ent->clipmask;
	body->owner = ent->owner;
	body->movetype = ent->movetype;

// COVEN:  Tranfer fire from entity to body.
        if (ent->health > 0)
                body->health = 0;
        else
                body->health = ent->health;
        body->gib_health = ent->gib_health;
        body->groundentity = ent->groundentity;
        body->mass = ent->mass;

        body->burnout = ent->burnout;
        if (ent->burner)
        {       body->burner = ent->burner;
                body->burner->enemy = body;
                ent->burner = NULL;
        }
        body->fireflags = ent->fireflags & ~FIREFLAG_DELTA_VIEW;

        body->battlesuit = ent->battlesuit;
        body->style = ent->client->resp.suitcolor;
// COVEN

	body->die = body_die;
	body->takedamage = DAMAGE_YES;

	gi.linkentity (body);
}


void respawn (edict_t *self)
{
	if (deathmatch->value || coop->value)
	{
// COVEN:  If arena, put player back in line.
                if (Coven_ArenaOn() && !self->RA_playing)
                {
                        // Make some fog to cover body's disappearance.
                        gi.WriteByte (svc_temp_entity);
                        gi.WriteByte (TE_TELEPORT_EFFECT);
                        gi.WritePosition (self->s.origin);
                        gi.multicast (self->s.origin, MULTICAST_PVS);

                        self->svflags &= ~SVF_NOCLIENT;
                        PutClientInServer (self);

                        if (!self->client->resp.spectator)
                        {       // Player must have bypassed the line.
                                // add a teleportation effect
                                self->s.event = EV_PLAYER_TELEPORT;

                                // hold in place briefly
                                self->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
                                self->client->ps.pmove.pm_time = 14;
                                self->client->respawn_time = level.time;
                        }

			return;
		}
// COVEN

		// spectator's don't leave bodies
		if (self->movetype != MOVETYPE_NOCLIP)
			CopyToBodyQue (self);
		self->svflags &= ~SVF_NOCLIENT;
		PutClientInServer (self);

		// add a teleportation effect
		self->s.event = EV_PLAYER_TELEPORT;

		// hold in place briefly
		self->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		self->client->ps.pmove.pm_time = 14;

		self->client->respawn_time = level.time;

		return;
	}

	// restart the entire server
	gi.AddCommandString ("menu_loadgame\n");
}

/* 
 * only called when pers.spectator changes
 * note that resp.spectator should be the opposite of pers.spectator here
 */
void spectator_respawn (edict_t *ent)
{
// COVEN
        if (ent->client->pers.spectator)
        {       // Do a few things first.
                if (!ent->deadflag)
                {       // FIXME:  Do we need this?
                        CTFDeadDropFlag (ent);
                        CTFDeadDropTech (ent);
                        Coven_DropAllRunes (ent);
                }

                if (!ent->client->resp.spectator)
                {       // Make some fog to cover body's disappearance.
                        gi.WriteByte (svc_temp_entity);
                        gi.WriteByte (TE_TELEPORT_EFFECT);
                        gi.WritePosition (ent->s.origin);
                        gi.multicast (ent->s.origin, MULTICAST_PVS);
                }
        }

	ent->svflags &= ~SVF_NOCLIENT;
	PutClientInServer (ent);

        if (ent->client->pers.spectator)
        {
                ent->RA_playing = false;
                if (ab_rules == RULES_CTF)
                        ent->client->resp.ctf_state = CTF_STATE_START;

// COVEN:  Don't display if fewer messages are on.
                if (!((int)(dmflags->value) & DF_LESS_MESSAGES))
                        gi.bprintf (PRINT_HIGH, "%s has moved to the sidelines\n", ent->client->pers.netname);
// COVEN
        }
        else
        {
		// send effect
		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_LOGIN);
		gi.multicast (ent->s.origin, MULTICAST_PVS);

		// hold in place briefly
		ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		ent->client->ps.pmove.pm_time = 14;

                // Arena mode will display its messages instead.
                if (!Coven_ArenaOn ())
                        if (!((int)(dmflags->value) & DF_LESS_MESSAGES))
                                gi.bprintf (PRINT_HIGH, "%s joined the game\n", ent->client->pers.netname);
	}

	ent->client->respawn_time = level.time;
// COVEN
}

//==============================================================


/*
===========
PutClientInServer

Called when a player connects to a server or respawns in
a deathmatch.
============
*/
void PutClientInServer (edict_t *ent)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index;
	vec3_t	spawn_origin, spawn_angles;
	gclient_t	*client;
	int		i;
	client_persistant_t	saved;
	client_respawn_t	resp;

	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint (ent, spawn_origin, spawn_angles);

	index = ent-g_edicts-1;
	client = ent->client;

	// deathmatch wipes most client data every spawn
	if (deathmatch->value)
	{
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		InitClientPersistant (client);
		ClientUserinfoChanged (ent, userinfo);
// COVEN:  Set battlesuit here.
                ent->battlesuit = ent->client->resp.battlesuit;
// COVEN
	}
	else if (coop->value)
	{
//		int			n;
		char		userinfo[MAX_INFO_STRING];

		resp = client->resp;
		memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
		// this is kind of ugly, but it's how we want to handle keys in coop
//		for (n = 0; n < game.num_items; n++)
//		{
//			if (itemlist[n].flags & IT_KEY)
//				resp.coop_respawn.inventory[n] = client->pers.inventory[n];
//		}
		resp.coop_respawn.game_helpchanged = client->pers.game_helpchanged;
		resp.coop_respawn.helpchanged = client->pers.helpchanged;
		client->pers = resp.coop_respawn;
		ClientUserinfoChanged (ent, userinfo);
		if (resp.score > client->pers.score)
			client->pers.score = resp.score;
	}
	else
	{
		memset (&resp, 0, sizeof(resp));
	}

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if (client->pers.health <= 0)
		InitClientPersistant(client);
	client->resp = resp;

	// copy some data from the client to the entity
	FetchClientEntData (ent);

	// clear entity values
	ent->groundentity = NULL;
	ent->client = &game.clients[index];
	ent->takedamage = DAMAGE_AIM;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->classname = "player";
	ent->mass = 200;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 12;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->model = "players/male/tris.md2";
	ent->pain = player_pain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;
// COVEN:  Cure player and set attributes.
        ent->gib_health = -41;
	ent->burnout = 0;
        ent->fireflags = 18 | FIREFLAG_DOWN | FIREFLAG_DELTA_VIEW | FIREFLAG_IGNITE;
        ent->armoured = false;
        ent->air_max = 12;

        Coven_SuitBox (ent);
// COVEN

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(client->ps));

	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;
// COVEN:  Turn on prediction.
        client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
// COVEN

	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		client->ps.fov = 90;
	}
	else
	{
		client->ps.fov = atoi(Info_ValueForKey(client->pers.userinfo, "fov"));
		if (client->ps.fov < 1)
			client->ps.fov = 90;
		else if (client->ps.fov > 160)
			client->ps.fov = 160;
	}

// COVEN:  Player may not always spawn with weapon.
        if (client->pers.weapon)
                client->ps.gunindex = gi.modelindex(client->pers.weapon->view_model);
        else
                client->ps.gunindex = 0;
// COVEN

	// clear entity state values
	ent->s.effects = 0;
	// sknum is player num and weapon number
	// weapon number will be added in changeweapon
// COVEN:  Don't use player indicies if in suit.
        if (ent->battlesuit)
        {       ent->s.modelindex  = gi.modelindex(ent->model);
                ent->s.modelindex2 = 0;         // NO gun model
                ent->s.skinnum     = client->resp.suitcolor;
                Coven_SetAnimAliases (ent);
                ent->s.frame = ent->stand_anim_start;
        }
        else
        {       ent->s.modelindex  = 255;       // will use the skin specified model
                ent->s.modelindex2 = 255;       // custom gun model
                ent->s.skinnum     = ent - g_edicts - 1;
                ent->s.frame = 0;
        }
// COVEN
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 1;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);

	// set the delta angle
	for (i=0 ; i<3 ; i++)
	{
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);
	}

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, client->ps.viewangles);
	VectorCopy (ent->s.angles, client->v_angle);

// COVEN:  Spawn player as spectator if he is not ready to fight.
        if (!Coven_CanFight (ent))
        {       // Go to sidelines.
                gi.WriteByte (svc_stufftext);
                gi.WriteString ("cl_forwardspeed 200; cl_sidespeed 200; cl_upspeed 200\n");
                gi.unicast(ent, true);

		client->chase_target = NULL;
                client->resp.spectator = client->pers.spectator = true;

                client->resp.mayplay = true;

		ent->movetype = MOVETYPE_NOCLIP;
		ent->solid = SOLID_NOT;
		ent->svflags |= SVF_NOCLIENT;
		ent->client->ps.gunindex = 0;
		gi.linkentity (ent);
		return;
        }
        else
        {       // Let's fight!
                client->resp.spectator = client->pers.spectator = false;

                ent->stall_time = 0;

                // In DM, give player respawn protection and gear.
                if (deathmatch->value)
                {
                        client->invincible_framenum = level.framenum + 29;
                        Coven_GiveAltArmor (ent);
                        Coven_GiveJetpack (ent);
                        Coven_RestoreGuns (ent);
                }
        }
// COVEN

	if (!KillBox (ent))
	{	// could't spawn in?
	}

	gi.linkentity (ent);

	// force the current weapon up
	client->newweapon = client->pers.weapon;
// COVEN:  Raise weapon without changing hands.
        Coven_StartWeapon (ent);
// COVEN
}

/*
=====================
ClientBeginDeathmatch

A client has just connected to the server in 
deathmatch mode, so clear everything out before starting them.
=====================
*/
void ClientBeginDeathmatch (edict_t *ent)
{
// COVEN:  Forcejoin and no color variable.
        qboolean        forced = false;
// COVEN

	G_InitEdict (ent);

	InitClientResp (ent->client);

	// locate ent at a spawn point
// COVEN:  Initialize some stuff as well.
        if (ab_teams >= 2)
        {       // Already on a team, make sure it is legit.
                if (ent->client->resp.suitcolor)
                        if (ab_teams < ent->client->resp.suitcolor)
                                ent->client->resp.suitcolor = 0;

                if ((int)(dmflags->value) & DF_TEAM_FORCEJOIN)
                {       // Forcejoin on?  Set team automatically.
                        Coven_StartingTeam (ent);
                        if (ent->client->resp.suitcolor)
                                forced = true;
                }
        }

        // Init HUD related stuff.
        ent->RA_quepos = 0;
        if ( ((ab_rules == RULES_DUEL) && (ab_teams >= 2)) ||
             (ab_rules == RULES_ELIMINATION) || (ab_rules == RULES_CAPTURE) )
                ent->stall_time = level.time + AB_maxdelay->value;
        else
                ent->stall_time = 0;

        // Make sure player does not start with any runes.  Do we need this?
        ent->client->pers.inventory[ITEM_INDEX(FindItem("Armour Rune"))] = 0;
        ent->client->pers.inventory[ITEM_INDEX(FindItem("Damage Rune"))] = 0;
        ent->client->pers.inventory[ITEM_INDEX(FindItem("Health Rune"))] = 0;

        // If all weapons are on, set the weapon mask.
        ent->battlesuit = ent->client->resp.battlesuit;
        if (ab_arms == ARMS_ALL)
                Coven_FourWeapons (ent);

        PutClientInServer (ent);
// COVEN

	if (level.intermissiontime)
	{
		MoveClientToIntermission (ent);
	}
	else
	{
// COVEN:  Bring up the menu if necessary.
                if (ent->client->resp.spectator)
                {
                        // In CTF, player should spawn near home flag.
                        if (ab_rules == RULES_CTF)
                                ent->client->resp.ctf_state = CTF_STATE_START;
                }
                else
                {
                        // send effect
                        gi.WriteByte (svc_muzzleflash);
                        gi.WriteShort (ent-g_edicts);
                        gi.WriteByte (MZ_LOGIN);
                        gi.multicast (ent->s.origin, MULTICAST_PVS);
                }
// COVEN
	}

	gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);
// COVEN:  If team was forced, let everyone know what team player is on.
        if (!((int)(dmflags->value) & DF_LESS_MESSAGES))
                if (forced)
                        gi.bprintf (PRINT_HIGH, "%s has been assigned to team %s.\n", ent->client->pers.netname, Coven_TeamName (ent->client->resp.suitcolor));
// COVEN
// COVEN:  Update menus.
        if (ent->client->resp.suitcolor && (ab_teams >= 2))
                CovenUpdate_TeamMenu ();
        if ( !((int)(dmflags->value) & DF_NO_VOTING) )
                CovenUpdate_VoteEndMenu ();
// COVEN

	// make sure all view stuff is valid
	ClientEndServerFrame (ent);
}


/*
===========
ClientBegin

called when a client has finished connecting, and is ready
to be placed into the game.  This will happen every level load.
============
*/
void ClientBegin (edict_t *ent)
{
	int		i;

	ent->client = game.clients + (ent - g_edicts - 1);

	if (deathmatch->value)
	{
		ClientBeginDeathmatch (ent);
		return;
	}

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == true)
	{
		// the client has cleared the client side viewangles upon
		// connecting to the server, which is different than the
		// state when the game is saved, so we need to compensate
		// with deltaangles
		for (i=0 ; i<3 ; i++)
			ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(ent->client->ps.viewangles[i]);
	}
	else
	{
		// a spawn point will completely reinitialize the entity
		// except for the persistant data that was initialized at
		// ClientConnect() time
		G_InitEdict (ent);
		ent->classname = "player";
		InitClientResp (ent->client);
		PutClientInServer (ent);
	}

	if (level.intermissiontime)
	{
		MoveClientToIntermission (ent);
	}
	else
	{
		// send effect if in a multiplayer game
		if (game.maxclients > 1)
		{
			gi.WriteByte (svc_muzzleflash);
			gi.WriteShort (ent-g_edicts);
			gi.WriteByte (MZ_LOGIN);
			gi.multicast (ent->s.origin, MULTICAST_PVS);

			gi.bprintf (PRINT_HIGH, "%s entered the game\n", ent->client->pers.netname);
		}
	}

	// make sure all view stuff is valid
	ClientEndServerFrame (ent);
}

/*
===========
ClientUserInfoChanged

called whenever the player updates a userinfo variable.

The game can override any of the settings in place
(forcing skins or names, etc) before copying it off.
============
*/
void ClientUserinfoChanged (edict_t *ent, char *userinfo)
{
	char	*s;
	int		playernum;

	// check for malformed or illegal info strings
	if (!Info_Validate(userinfo))
	{
		strcpy (userinfo, "\\name\\badinfo\\skin\\male/grunt");
	}

	// set name
	s = Info_ValueForKey (userinfo, "name");
	strncpy (ent->client->pers.netname, s, sizeof(ent->client->pers.netname)-1);

// COVEN:  Don't let player set spectator status in ArmourBack!
/*
	// set spectator
	s = Info_ValueForKey (userinfo, "spectator");
	// spectators are only supported in deathmatch
	if (deathmatch->value && *s && strcmp(s, "0"))
		ent->client->pers.spectator = true;
	else
		ent->client->pers.spectator = false;
*/
// COVEN

	// set skin
	s = Info_ValueForKey (userinfo, "skin");

	playernum = ent-g_edicts-1;

	// combine name and skin into a configstring
// COVEN:  NO!  We don't want the PPM skin info.  Keep only the name.
        gi.configstring (CS_PLAYERSKINS+playernum, ent->client->pers.netname);
// COVEN

	// fov
	if (deathmatch->value && ((int)dmflags->value & DF_FIXED_FOV))
	{
		ent->client->ps.fov = 90;
	}
	else
	{
		ent->client->ps.fov = atoi(Info_ValueForKey(userinfo, "fov"));
		if (ent->client->ps.fov < 1)
			ent->client->ps.fov = 90;
		else if (ent->client->ps.fov > 160)
			ent->client->ps.fov = 160;
	}

	// handedness
	s = Info_ValueForKey (userinfo, "hand");
	if (strlen(s))
	{
// COVEN:  Make sure cable stays in grapple arm.
                int     oldhand = ent->client->pers.hand;

		ent->client->pers.hand = atoi(s);
                if (deathmatch->value)
                        if (ent->hook && (oldhand != ent->client->pers.hand))
                                if (ent->client->pers.hand != CENTER_HANDED)
                                {
                                        if (!strcmp (ent->client->pers.weapon->pickup_name, "Grapple"))
                                                ent->hook->style = CABLE_NORMAL;
                                        else
                                                ent->hook->style = CABLE_REVERSE;
                                }
// COVEN
	}

	// save off the userinfo in case we want to check something later
	strncpy (ent->client->pers.userinfo, userinfo, sizeof(ent->client->pers.userinfo)-1);
}


/*
===========
ClientConnect

Called when a player begins connecting to the server.
The game can refuse entrance to a client by returning false.
If the client is allowed, the connection process will continue
and eventually get to ClientBegin()
Changing levels will NOT cause this to be called again, but
loadgames will.
============
*/
qboolean ClientConnect (edict_t *ent, char *userinfo)
{
	char	*value;

	// check to see if they are on the banned IP list
	value = Info_ValueForKey (userinfo, "ip");
	if (SV_FilterPacket(value)) {
		Info_SetValueForKey(userinfo, "rejmsg", "Banned.");
		return false;
	}

// COVEN:  Spectators are unavoidable in AB, so check only the password.
        // check for a password
        value = Info_ValueForKey (userinfo, "password");
        if (*password->string && strcmp(password->string, "none") && 
            strcmp(password->string, value))
        {
                Info_SetValueForKey(userinfo, "rejmsg", "Password required or incorrect.");
                return false;
        }
// COVEN


	// they can connect
	ent->client = game.clients + (ent - g_edicts - 1);

	// if there is already a body waiting for us (a loadgame), just
	// take it, otherwise spawn one from scratch
	if (ent->inuse == false)
	{
		// clear the respawning variables
// COVEN:  Initialize ID and suit info.
                ent->client->resp.alt_score = false;
                ent->client->resp.id_active = true;
                ent->client->resp.suitcolor = 0;
                ent->client->resp.battlesuit = 0;
                ent->client->resp.gunmask = 0;
                ent->client->resp.lastgun = NULL;
// COVEN
		InitClientResp (ent->client);
		if (!game.autosaved || !ent->client->pers.weapon)
			InitClientPersistant (ent->client);
	}

	ClientUserinfoChanged (ent, userinfo);

	if (game.maxclients > 1)
		gi.dprintf ("%s connected\n", ent->client->pers.netname);

	ent->svflags = 0; // make sure we start with known default
	ent->client->pers.connected = true;
	return true;
}

/*
===========
ClientDisconnect

Called when a player drops from the server.
Will not be called between levels.
============
*/
void ClientDisconnect (edict_t *ent)
{
	int		playernum;

	if (!ent->client)
		return;

// COVEN:  Drop runes and remove player from arena.
        if (!ent->client->resp.spectator && !ent->deadflag)
                Coven_DropAllRunes (ent);

        ent->RA_playing = false;
        Coven_RemoveFromPlayerQue (ent);

        // CTF stuff.
	CTFDeadDropFlag(ent);
	CTFDeadDropTech(ent);
// COVEN

	gi.bprintf (PRINT_HIGH, "%s disconnected\n", ent->client->pers.netname);

// COVEN:  Make effect only if not a spectator.
	// send effect
        if (!ent->client->resp.spectator)
        {
                gi.WriteByte (svc_muzzleflash);
                gi.WriteShort (ent-g_edicts);
                gi.WriteByte (MZ_LOGOUT);
                gi.multicast (ent->s.origin, MULTICAST_PVS);
        }
// COVEN

	gi.unlinkentity (ent);
	ent->s.modelindex = 0;
	ent->solid = SOLID_NOT;
	ent->inuse = false;
	ent->classname = "disconnected";
	ent->client->pers.connected = false;

	playernum = ent-g_edicts-1;
	gi.configstring (CS_PLAYERSKINS+playernum, "");

// COVEN:  Update menus.
        if (ab_teams >= 2)
                CovenUpdate_TeamMenu ();

        // FIXME:  Do all this in one loop instead of many...
        if ( !((int)(dmflags->value) & DF_NO_VOTING) )
        {
                CovenUpdate_SecretMenu ();
                CovenUpdate_VoteEndMenu ();
                CovenUpdate_VoteFastMenu ();
                CovenUpdate_VoteMapMenu ();
                CovenUpdate_VoteFireMenu ();
                CovenUpdate_VoteTeamsMenu ();
                CovenUpdate_VoteRulesMenu ();
                CovenUpdate_VoteTechMenu ();
                CovenUpdate_VoteArmsMenu ();
        }
// COVEN
// COVEN:  Check end level vote (since last nay sayer may leave...).
        Coven_CheckExitVote ();
// COVEN
}


//==============================================================


edict_t	*pm_passent;

// pmove doesn't need to know about passent and contentmask
trace_t	PM_trace (vec3_t start, vec3_t mins, vec3_t maxs, vec3_t end)
{
	if (pm_passent->health > 0)
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_PLAYERSOLID);
	else
		return gi.trace (start, mins, maxs, end, pm_passent, MASK_DEADSOLID);
}

unsigned CheckBlock (void *b, int c)
{
	int	v,i;
	v = 0;
	for (i=0 ; i<c ; i++)
		v+= ((byte *)b)[i];
	return v;
}
void PrintPmove (pmove_t *pm)
{
	unsigned	c1, c2;

	c1 = CheckBlock (&pm->s, sizeof(pm->s));
	c2 = CheckBlock (&pm->cmd, sizeof(pm->cmd));
	Com_Printf ("sv %3i:%i %i\n", pm->cmd.impulse, c1, c2);
}

/*
==============
ClientThink

This will be called once for each client frame, which will
usually be a couple times for each server frame.
==============
*/
void ClientThink (edict_t *ent, usercmd_t *ucmd)
{
	gclient_t	*client;
	edict_t	*other;
	int		i, j;
	pmove_t	pm;
// COVEN:  Jetpack variable.
        qboolean        jeton = Jet_Active (ent);
// COVEN

	level.current_entity = ent;
	client = ent->client;

	if (level.intermissiontime)
	{
		client->ps.pmove.pm_type = PM_FREEZE;
		// can exit intermission after five seconds
		if (level.time > level.intermissiontime + 5.0 
			&& (ucmd->buttons & BUTTON_ANY) )
			level.exitintermission = true;
		return;
	}

	pm_passent = ent;

	if (ent->client->chase_target) {

		client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
		client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
		client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);

	} else {

		// set up for pmove
		memset (&pm, 0, sizeof(pm));

		if (ent->movetype == MOVETYPE_NOCLIP)
			client->ps.pmove.pm_type = PM_SPECTATOR;
// COVEN:  AB suits use values other than 255.
                //else if (ent->s.modelindex != 255)
                else if (!Coven_IsPlayer(ent))
// COVEN
			client->ps.pmove.pm_type = PM_GIB;
		else if (ent->deadflag)
			client->ps.pmove.pm_type = PM_DEAD;
		else
			client->ps.pmove.pm_type = PM_NORMAL;

		client->ps.pmove.gravity = sv_gravity->value;
// COVEN:  Check for jetpack.
                if (jeton)
                        Jet_ApplyJet (ent, ucmd);
// COVEN
		pm.s = client->ps.pmove;

		for (i=0 ; i<3 ; i++)
		{
			pm.s.origin[i] = ent->s.origin[i]*8;
			pm.s.velocity[i] = ent->velocity[i]*8;
		}

		if (memcmp(&client->old_pmove, &pm.s, sizeof(pm.s)))
		{
			pm.snapinitial = true;
	//		gi.dprintf ("pmove changed!\n");
		}

// COVEN:  Don't let heavy suits run.  Also check armor.
        if ( (!ent->client->resp.spectator) &&
             ((ent->battlesuit == SUIT_RHINO) ||
              (ent->battlesuit == SUIT_SUGARCONNY) ||
              (ent->battlesuit == SUIT_BULKHEAD)) )
        {
                // Cap forward movement.
                if (ucmd->forwardmove > 200)
                        ucmd->forwardmove = 200;
                else if (ucmd->forwardmove < -200)
                        ucmd->forwardmove = -200;

                // Cap side movement.
                if (ucmd->sidemove > 200)
                        ucmd->sidemove = 200;
                else if (ucmd->sidemove < -200)
                        ucmd->sidemove = -200;

                // Cap vertical movement.
                if (ucmd->upmove > 200)
                {       ucmd->upmove = 200;
                        ent->armoured = false;
                }
                else
                {       if ((ent->battlesuit == SUIT_BULKHEAD) && ent->groundentity)
                        {       if (ucmd->upmove < 0)
                                {       // Bulkhead can't crouch...
                                        ucmd->forwardmove = (short)((ucmd->forwardmove) * 0.5);
                                        ucmd->sidemove = (short)((ucmd->sidemove) * 0.5);
                                        ucmd->upmove = 0;

                                        // ...but gets special armor.
                                        if (ent->health > 0)
                                                ent->armoured = true;
                                        else
                                                ent->armoured = false;
                                }
                                else
                                        ent->armoured = false;
                        }
                        else
                        {       if (ucmd->upmove < -200)
                                        ucmd->upmove = -200;
                                ent->armoured = false;
                        }
                }

                // If strafe-moving, negate extra speed.
                if (ucmd->forwardmove && ucmd->sidemove)
                {       // 0.7071 is approximately (1/sqrt(2)).
                        ucmd->forwardmove = (short)((ucmd->forwardmove) * 0.7071);
                        ucmd->sidemove = (short)((ucmd->sidemove) * 0.7071);
                }
        }
        else
        {
                ent->armoured = false;
        }
// COVEN

		pm.cmd = *ucmd;

		pm.trace = PM_trace;	// adds default parms
		pm.pointcontents = gi.pointcontents;

		// perform a pmove
		gi.Pmove (&pm);

		// save results of pmove
		client->ps.pmove = pm.s;
		client->old_pmove = pm.s;

		for (i=0 ; i<3 ; i++)
		{
			ent->s.origin[i] = pm.s.origin[i]*0.125;
// COVEN:  Adjust velocity if not flying.
                        if ( !jeton || ( jeton && (fabs((float)pm.s.velocity[i]*0.125) < fabs(ent->velocity[i])) ) )
                                ent->velocity[i] = pm.s.velocity[i]*0.125;
// COVEN
		}

		VectorCopy (pm.mins, ent->mins);
		VectorCopy (pm.maxs, ent->maxs);

		client->resp.cmd_angles[0] = SHORT2ANGLE(ucmd->angles[0]);
		client->resp.cmd_angles[1] = SHORT2ANGLE(ucmd->angles[1]);
		client->resp.cmd_angles[2] = SHORT2ANGLE(ucmd->angles[2]);

// COVEN:  Turn off jetpack if necessary.
                if (jeton)
                {       // Kill jetpack if crouching or in water.
                        if ((ent->waterlevel > 1) || (ent->client->ps.pmove.pm_flags & PMF_DUCKED))
                                ent->client->jet_framenum = 0;
                        else
                        {       // Stay off the ground.
                                if (pm.groundentity)
                                        if (Jet_AvoidGround (ent))
                                                pm.groundentity = NULL;
                        }
                }
// COVEN
		if (ent->groundentity && !pm.groundentity && (pm.cmd.upmove >= 10) && (pm.waterlevel == 0))
		{
// COVEN:  Play AB suit sfx.
                        if (ent->battlesuit)
                                Coven_SfxJump (ent);
                        else
                                gi.sound(ent, CHAN_VOICE, gi.soundindex("*jump1.wav"), 1, ATTN_NORM, 0);
// COVEN
			PlayerNoise(ent, ent->s.origin, PNOISE_SELF);
		}

		ent->viewheight = pm.viewheight;
		ent->waterlevel = pm.waterlevel;
		ent->watertype = pm.watertype;
		ent->groundentity = pm.groundentity;
		if (pm.groundentity)
			ent->groundentity_linkcount = pm.groundentity->linkcount;

		if (ent->deadflag)
		{
			client->ps.viewangles[ROLL] = 40;
			client->ps.viewangles[PITCH] = -15;
			client->ps.viewangles[YAW] = client->killer_yaw;
		}
		else
		{
			VectorCopy (pm.viewangles, client->v_angle);
			VectorCopy (pm.viewangles, client->ps.viewangles);
		}

		gi.linkentity (ent);

		if (ent->movetype != MOVETYPE_NOCLIP)
			G_TouchTriggers (ent);

		// touch other objects
		for (i=0 ; i<pm.numtouch ; i++)
		{
			other = pm.touchents[i];
			for (j=0 ; j<i ; j++)
				if (pm.touchents[j] == other)
					break;
			if (j != i)
				continue;	// duplicated
			if (!other->touch)
				continue;
			other->touch (other, ent, NULL, NULL);
		}

	}

	client->oldbuttons = client->buttons;
	client->buttons = ucmd->buttons;
	client->latched_buttons |= client->buttons & ~client->oldbuttons;

	// save light level the player is standing on for
	// monster sighting AI
	ent->light_level = ucmd->lightlevel;

	// fire weapon from final position if needed
	if (client->latched_buttons & BUTTON_ATTACK)
	{
		if (client->resp.spectator) {

			client->latched_buttons = 0;

// COVEN:  Ignore chasecam stuff if in menu.
                        if (!client->menu)
                        {
                                if (client->chase_target) {
                                        client->chase_target = NULL;
                                        client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
                                } else
                                        GetChaseTarget(ent);
                        }
// COVEN

		} else if (!client->weapon_thunk) {
			client->weapon_thunk = true;
			Think_Weapon (ent);
		}
	}

	if (client->resp.spectator) {
		if (ucmd->upmove >= 10) {
			if (!(client->ps.pmove.pm_flags & PMF_JUMP_HELD)) {
				client->ps.pmove.pm_flags |= PMF_JUMP_HELD;
// COVEN:  Ignore chasecam stuff if in menu.
                                if (!client->menu)
                                {       // Do nothing if not chasing.
                                        if (client->chase_target)
                                                ChaseNext(ent);
                                }
// COVEN
			}
		} else
			client->ps.pmove.pm_flags &= ~PMF_JUMP_HELD;
	}

// COVEN:  Zoid's CTF regeneration tech.
	CTFApplyRegeneration(ent);
// COVEN

	// update chase cam if being followed
	for (i = 1; i <= maxclients->value; i++) {
		other = g_edicts + i;
		if (other->inuse && other->client->chase_target == ent)
			UpdateChaseCam(other);
	}
}


/*
==============
ClientBeginServerFrame

This will be called once for each server frame, before running
any other entities in the world.
==============
*/
void ClientBeginServerFrame (edict_t *ent)
{
	gclient_t	*client;
	int			buttonMask;

	if (level.intermissiontime)
		return;

	client = ent->client;

// COVEN:  Check anti-stall and spectator status.
        if (deathmatch->value)
        {
                // Check anti-stall timer.
                if (ent->stall_time && (ent->stall_time <= level.time))
                        ent->stall_time = 0;

                // Go into spectator mode if necessary.
                if (client->pers.spectator != client->resp.spectator)
                {
                        spectator_respawn(ent);
                        return;
                }
	}
// COVEN

	// run weapon animations if it hasn't been done by a ucmd_t
	if (!client->weapon_thunk && !client->resp.spectator)
		Think_Weapon (ent);
	else
		client->weapon_thunk = false;

	if (ent->deadflag)
	{
		// wait for any button just going down
		if ( level.time > client->respawn_time)
		{
			// in deathmatch, only wait for attack button
			if (deathmatch->value)
				buttonMask = BUTTON_ATTACK;
			else
				buttonMask = -1;

			if ( ( client->latched_buttons & buttonMask ) ||
				(deathmatch->value && ((int)dmflags->value & DF_FORCE_RESPAWN) ) )
			{
				respawn(ent);
				client->latched_buttons = 0;
			}
		}
		return;
	}

	// add player trail so monsters can follow
	if (!deathmatch->value)
		if (!visible (ent, PlayerTrail_LastSpot() ) )
			PlayerTrail_Add (ent->s.old_origin);

	client->latched_buttons = 0;
}
