//===========================================================================
//
// Name:			items.c
// Function:		item configuration
// Programmer:		Mr Elusive
// Last update:		1999-12-28
// Tab Size:		4 (real tabs)
//===========================================================================

#include "inv.h"

#define ITEM_NONE					0
#define ITEM_AMMO					1
#define ITEM_WEAPON					2
#define ITEM_HEALTH					3
#define ITEM_ARMOR					4
#define ITEM_POWERUP				5
#define ITEM_KEY					6
#define ITEM_FLAG					7
#define ITEM_ROAM					8
#define ITEM_RUNE					9		// Tech Item Type

//===================================
// ARMOR
//===================================

iteminfo "item_armor_shard"
{
	name					"Armor Shard"
	model					"models/powerups/armor/shard.md3"
	modelindex				MODELINDEX_ARMORSHARD
	type					ITEM_ARMOR
	index					INVENTORY_ARMOR
	respawntime			20
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_armor_combat"
{
	name					"Armor"
	model					"models/powerups/armor/armor_yel.md3"
	modelindex				MODELINDEX_ARMORCOMBAT
	type					ITEM_ARMOR
	index					INVENTORY_ARMOR
	respawntime			20
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_armor_body"
{
	name					"Heavy Armor"
	model					"models/powerups/armor/armor_red.md3"
	modelindex				MODELINDEX_ARMORBODY
	type					ITEM_ARMOR
	index					INVENTORY_ARMOR
	respawntime			20
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

//===================================
// HEALTH
//===================================

iteminfo "item_health_small"
{
	name					"5 Health"
	model					"models/powerups/health/small_cross.md3"
	modelindex				MODELINDEX_HEALTHSMALL
	type					ITEM_HEALTH
	index					INVENTORY_HEALTH
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_health"
{
	name					"25 Health"
	model					"models/powerups/health/medium_cross.md3"
	modelindex				MODELINDEX_HEALTH
	type					ITEM_HEALTH
	index					INVENTORY_HEALTH
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_health_large"
{
	name					"50 Health"
	model					"models/powerups/health/large_cross.md3"
	modelindex				MODELINDEX_HEALTHLARGE
	type					ITEM_HEALTH
	index					INVENTORY_HEALTH
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_health_mega"
{
	name					"Mega Health"
	model					"models/powerups/health/mega_cross.md3"
	modelindex				MODELINDEX_HEALTHMEGA
	type					ITEM_HEALTH
	index					INVENTORY_HEALTH
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

//===================================
// WEAPONS
//===================================
//*
iteminfo "weapon_gauntlet"
{
	name					"Gauntlet"
	model					"models/weapons2/gauntlet/gauntlet.md3"
	modelindex				MODELINDEX_GAUNTLET
	type					ITEM_WEAPON
	index					INVENTORY_GAUNTLET
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo*/

iteminfo "weapon_shotgun"
{
	name					"Shotgun"
	model					"models/weapons2/shotgun/shotgun.md3"
	modelindex				MODELINDEX_SHOTGUN
	type					ITEM_WEAPON
	index					INVENTORY_SHOTGUN
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_machinegun"
{
	name					"Machinegun"
	model					"models/weapons2/machinegun/machinegun.md3"
	modelindex				MODELINDEX_MACHINEGUN
	type					ITEM_WEAPON
	index					INVENTORY_MACHINEGUN
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_grenadelauncher"
{
	name					"Grenade Launcher"
	model					"models/weapons2/grenadel/grenadel.md2"
	modelindex				MODELINDEX_GRENADELAUNCHER
	type					ITEM_WEAPON
	index					INVENTORY_GRENADELAUNCHER
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_rocketlauncher"
{
	name					"Rocket Launcher"
	model					"models/weapons2/rocketl/rocketl.md3"
	modelindex				MODELINDEX_ROCKETLAUNCHER
	type					ITEM_WEAPON
	index					INVENTORY_ROCKETLAUNCHER
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_lightning"
{
	name					"Lightning Gun"
	model					"models/weapons2/lightning/lightning.md3"
	modelindex				MODELINDEX_LIGHTNING
	type					ITEM_WEAPON
	index					INVENTORY_LIGHTNING
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_railgun"
{
	name					"Railgun"
	model					"models/weapons2/railgun/railgun.md3"
	modelindex				MODELINDEX_RAILGUN
	type					ITEM_WEAPON
	index					INVENTORY_RAILGUN
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_plasmagun"
{
	name					"Plasma Gun"
	model					"models/weapons2/plasma/plasma.md3"
	modelindex				MODELINDEX_PLASMAGUN
	type					ITEM_WEAPON
	index					INVENTORY_PLASMAGUN
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_bfg"
{
	name					"BFG10K"
	model					"models/weapons2/bfg/bfg.md3"
	modelindex				MODELINDEX_BFG10K
	type					ITEM_WEAPON
	index					INVENTORY_BFG10K
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "weapon_grapplinghook"
{
	name					"Grappling Hook"
	model					"models/weapons2/grapple/grapple.md3"
	modelindex				MODELINDEX_GRAPPLINGHOOK
	type					ITEM_WEAPON
	index					INVENTORY_GRAPPLINGHOOK
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

//===================================
// AMMO
//===================================

iteminfo "ammo_shells"
{
	name					"Shells"
	model					"models/powerups/ammo/shotgunam.md3"
	modelindex				MODELINDEX_SHELLS
	type					ITEM_AMMO
	index					INVENTORY_SHELLS
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_bullets"
{
	name					"Bullets"
	model					"models/powerups/ammo/machinegunam.md3"
	modelindex				MODELINDEX_BULLETS
	type					ITEM_AMMO
	index					INVENTORY_BULLETS
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_grenades"
{
	name					"Grenades"
	model					"models/powerups/ammo/grenadeam.md3"
	modelindex				MODELINDEX_GRENADES
	type					ITEM_AMMO
	index					INVENTORY_GRENADES
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_cells"
{
	name					"Cells"
	model					"models/powerups/ammo/plasmaam.md3"
	modelindex				MODELINDEX_CELLS
	type					ITEM_AMMO
	index					INVENTORY_CELLS
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_lightning"
{
	name					"Lightning"
	model					"models/powerups/ammo/lightningam.md3"
	modelindex				MODELINDEX_LIGHTNINGAMMO
	type					ITEM_AMMO
	index					INVENTORY_LIGHTNINGAMMO
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_rockets"
{
	name					"Rockets"
	model					"models/powerups/ammo/rocketam.dm3"
	modelindex				MODELINDEX_ROCKETS
	type					ITEM_AMMO
	index					INVENTORY_ROCKETS
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_slugs"
{
	name					"Slugs"
	model					"models/powerups/ammo/railgunam.md3"
	modelindex				MODELINDEX_SLUGS
	type					ITEM_AMMO
	index					INVENTORY_SLUGS
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "ammo_bfg"
{
	name					"Bfg ammo"
	model					"models/powerups/ammo/bfgam.md3"
	modelindex				MODELINDEX_BFGAMMO
	type					ITEM_AMMO
	index					INVENTORY_BFGAMMO
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

//===================================
// POWERUPS
//===================================

iteminfo "holdable_teleporter"
{
	name					"Personal Teleporter"
	model					"models/powerups/holdable/teleporter.md3"
	modelindex				MODELINDEX_TELEPORTER
	type					ITEM_POWERUP
	index					INVENTORY_TELEPORTER
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "holdable_medkit"
{
	name					"Medkit"
	model					"models/powerups/holdable/medkit.md3"
	modelindex				MODELINDEX_MEDKIT
	type					ITEM_HEALTH
	index					INVENTORY_MEDKIT
	respawntime			30
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_quad"
{
	name					"Quad Damage"
	model					"models/powerups/instant/quad.md3"
	modelindex				MODELINDEX_QUAD
	type					ITEM_POWERUP
	index					INVENTORY_QUAD
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_enviro"
{
	name					"Battle Suit"
	model					"models/powerups/instant/enviro.md3"
	modelindex				MODELINDEX_ENVIRONMENTSUIT
	type					ITEM_POWERUP
	index					INVENTORY_ENVIRONMENTSUIT
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_haste"
{
	name					"Speed"
	model					"models/powerups/instant/haste_ring.md3"
	modelindex				MODELINDEX_HASTE
	type					ITEM_POWERUP
	index					INVENTORY_HASTE
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_invisibility"
{
	name					"Invisibility"
	model					"models/powerups/instant/invis.md3"
	modelindex				MODELINDEX_INVISIBILITY
	type					ITEM_POWERUP
	index					INVENTORY_INVISIBILITY
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_regen"
{
	name					"Regeneration"
	model					"models/powerups/instant/regen_ring.md3"
	modelindex				MODELINDEX_REGEN
	type					ITEM_POWERUP
	index					INVENTORY_REGEN
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "item_flight"
{
	name					"Flight"
	model					"models/powerups/instant/flight_ring.md3"
	modelindex				MODELINDEX_FLIGHT
	type					ITEM_POWERUP
	index					INVENTORY_FLIGHT
	respawntime			60
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo


//===================================
// CTF flags
//===================================

iteminfo "team_CTF_redflag"
{
	name					"Red Flag"
	model					"models/flags/r_flag.md3"
	modelindex				MODELINDEX_REDFLAG
	type					ITEM_FLAG
	index					INVENTORY_REDFLAG
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "team_CTF_blueflag"
{
	name					"Blue Flag"
	model					"models/flags/b_flag.md3"
	modelindex				MODELINDEX_BLUEFLAG
	type					ITEM_FLAG
	index					INVENTORY_BLUEFLAG
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

//===================================
// TECHS - DK_911
//===================================

iteminfo "rune_autodoc"
{
	name					"AutoDoc"
	model					"models/runes/autodoc.md3"
	modelindex				MODELINDEX_AUTODOC
	type					ITEM_RUNE
	index					INVENTORY_AUTODOC
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_timeaccel"
{
	name					"TimeAccel"
	model					"models/runes/timeaccel.md3"
	modelindex				MODELINDEX_TIMEACCEL
	type					ITEM_RUNE
	index					INVENTORY_TIMEACCEL
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_disruptor"
{
	name					"Disruptor Shield"
	model					"models/runes/disruptor.md3"
	modelindex				MODELINDEX_DISRUPTORSHIELD
	type					ITEM_RUNE
	index					INVENTORY_DISRUPTORSHIELD
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_poweramp"
{
	name					"PowerAmp"
	model					"models/runes/poweramp.md3"
	modelindex				MODELINDEX_POWERAMP
	type					ITEM_RUNE
	index					INVENTORY_POWERAMP
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_vampire"
{
	name					"Vampire"
	model					"models/runes/vampire.md3"
	modelindex				MODELINDEX_VAMPIRE
	type					ITEM_RUNE
	index					INVENTORY_VAMPIRE
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_suicide"
{
	name					"Suicide"
	model					"models/runes/suicide.md3"
	modelindex				MODELINDEX_SUICIDE
	type					ITEM_RUNE
	index					INVENTORY_SUICIDE
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_resurrect"
{
	name					"Resurrect"
	model					"models/runes/resurrect.md3"
	modelindex				MODELINDEX_RESURRECT
	type					ITEM_RUNE
	index					INVENTORY_RESURRECT
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_weaponamp"
{
	name					"WeaponAmp"
	model					"models/runes/weaponamp.md3"
	modelindex				MODELINDEX_WEAPONAMP
	type					ITEM_RUNE
	index					INVENTORY_WEAPONAMP
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_antigrav"
{
	name					"AntiGrav"
	model					"models/runes/antigrav.md3"
	modelindex				MODELINDEX_ANTIGRAV
	type					ITEM_RUNE
	index					INVENTORY_ANTIGRAV
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_radiation"
{
	name					"Radiation"
	model					"models/runes/radiation.md3"
	modelindex				MODELINDEX_RADIATION
	type					ITEM_RUNE
	index					INVENTORY_RADIATION
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_stealth"
{
	name					"Stealth"
	model					"models/runes/stealth.md3"
	modelindex				MODELINDEX_STEALTH
	type					ITEM_RUNE
	index					INVENTORY_STEALTH
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_kineticamp"
{
	name					"Kinetic Amp"
	model					"models/runes/kineticamp.md3"
	modelindex				MODELINDEX_KINETICAMP
	type					ITEM_RUNE
	index					INVENTORY_KINETICAMP
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo

iteminfo "rune_electrocute"
{
	name					"Electrocute"
	model					"models/runes/electrocute.md3"
	modelindex				MODELINDEX_ELECTROCUTE
	type					ITEM_RUNE
	index					INVENTORY_ELECTROCUTE
	mins					{-15,-15,-15}
	maxs					{15,15,15}
} //end iteminfo


//===================================
// bot roam item
//===================================

iteminfo "item_botroam"
{
	name					"Bot Roam Goal"
	model					""
	modelindex				0
	type					ITEM_ROAM
	index					0
	mins					{-15,-15,-15}
	maxs					{15,15,15}
}


