// ****************************************************************** //
// * Tangential Tutorial                                            * //
// *                                                                * //
// * By Anthony Yuen (aka Tangent-)                                 * //
// *                                                                * //
// * Last modified : [21-Feb-1998] Lesson 1                         * //
// * Last modified : [26-Feb-1998] Lesson 2                         * //
// * Last modified : [09-Mar-1998] Lesson 3                         * //
// * Last modified : [25-Mar-1998] Lesson 4                         * //
// * Web site      : http://www.planetquake.com/tangential          * //
// * Email         : ayuen@fastlanetech.com                         * //
// ****************************************************************** //

#ifndef __TUTORIAL_H__
#define __TUTORIAL_H__

#include "g_local.h"


// *********************** //
// * Forgotten functions * //
// *********************** //

void SelectSpawnPoint(edict_t *ent, vec3_t origin, vec3_t angles);
void ClientUserinfoChanged (edict_t *ent, char *userinfo);
qboolean ClientConnect(edict_t *ent, char *userinfo);
void ClientDisconnect(edict_t *ent);
void CopyToBodyQue(edict_t *ent);
void ClientThink(edict_t *ent, usercmd_t *cmd);

// ********************* //
// * Command functions * //
// ********************* //

void Svcmd_Bot_f(void);
void Bot_Create(void);
void Bot_Spawn(edict_t *ent);
void Bot_Respawn(edict_t *ent);

void Bot_Pain(edict_t *ent, edict_t *other, float kickback, int damage);

void Bot_Think(edict_t *ent);
void Bot_Aim(edict_t *ent, edict_t *target, vec3_t angles);
void Bot_Attack(edict_t *ent, usercmd_t *cmd, vec3_t angles);
void Bot_Move(edict_t *ent, edict_t *goal, usercmd_t *cmd, vec3_t angles);

edict_t *Bot_FindEnemy(edict_t *ent);

#endif
