// ****************************************************************** //
// * Tangential Tutorial                                            * //
// *                                                                * //
// * By Anthony Yuen (aka Tangent-)                                 * //
// *                                                                * //
// * Last modified : [21-Feb-1998] Lesson 1                         * //
// * Last modified : [26-Feb-1998] Lesson 2                         * //
// * Last modified : [09-Mar-1998] Lesson 3                         * //
// * Web site      : http://www.planetquake.com/tangential          * //
// * Email         : ayuen@fastlanetech.com                         * //
// ****************************************************************** //

#include "tutorial.h"


// ********************* //
// * Command functions * //
// ********************* //

void Svcmd_Bot_f(void)
    {
    char *arg = gi.argv(2);

    if (Q_stricmp(arg, "kill") == 0)
        {
        int i;
        char *name = gi.argv(3);
        edict_t *bot;

        // Search for the bot with the specified name
        for (i = maxclients->value; i > 0; i--)
            {
            bot = g_edicts + i + 1;

            if (bot->client && 
               (Q_stricmp("bot", bot->classname) == 0) &&
               (Q_stricmp(name, bot->client->pers.netname) == 0))
                {
		        ClientDisconnect(bot);
                break;
                }
            // end if
            }
        // next
        }
    else if (Q_stricmp(arg, "spawn") == 0)
        Bot_Create();
    // end if
    }
// end of Svcmd_Bot_f


void Bot_Create(void)
    {
    int      i;
    char     userinfo[MAX_INFO_STRING];
    edict_t	*bot;

    // Search for a free client slot
    for (i = maxclients->value; i > 0; i--)
        {
        bot = g_edicts + i + 1;

        if (!bot->inuse)
		    break;
        // end if
        }
    // next

    if (bot->inuse)
        bot = NULL;
    // end if

    if (bot)
        {
        // Initialize userinfo
        memset(userinfo, 0, MAX_INFO_STRING);

        // Add bot's name/skin/hand to userinfo
        Info_SetValueForKey(userinfo, "name", "VoodooBot");
        Info_SetValueForKey(userinfo, "skin", "female/voodoo");
        Info_SetValueForKey(userinfo, "hand", "2");   // Center handed

        ClientConnect(bot, userinfo);
        G_InitEdict(bot);
        InitClientResp(bot->client);

        // Put the bot into the game world
        Bot_Spawn(bot);

        // Send effects
        gi.WriteByte(svc_muzzleflash);
        gi.WriteShort(bot - g_edicts);
        gi.WriteByte(MZ_LOGIN);
        gi.multicast(bot->s.origin, MULTICAST_PVS);

        // Broadcast to let everyone know the bot is in!
        gi.bprintf(PRINT_HIGH, "%s entered the game\n", bot->client->pers.netname);

        // Make sure all view stuff is valid
        ClientEndServerFrame(bot);
        }
    else
        {
	    gi.dprintf("%s cannot connect - server is full!\n", "VoodooBot");
        }
    // end if
    }
// end of Bot_Create


void Bot_Spawn(edict_t *ent)
    {
    vec3_t               origin, angles;
    vec3_t               mins = {-16, -16, -24};
    vec3_t               maxs = {16, 16, 32};
    int                  i, index;
    client_persistant_t  pers;     // Note: wrong spelling for "persistent"!
    client_respawn_t     resp;

    if (!deathmatch->value)
        {
        gi.dprintf("Must be in Deathmatch to spawn VoodooBot!\n");
        return;
        }
    // end if

    SelectSpawnPoint(ent, origin, angles);

    index = ent - g_edicts - 1;

    if (deathmatch->value)    // Deathmatch wipes most client data every spawn
        {
        char userinfo[MAX_INFO_STRING];

        resp = ent->client->resp;
        memcpy(userinfo, ent->client->pers.userinfo, MAX_INFO_STRING);
        InitClientPersistant(ent->client);
        ClientUserinfoChanged(ent, userinfo);
        }
    else
        memset(&resp, 0, sizeof(client_respawn_t));
    // end if

    // Clear everything except the persistent data
    pers = ent->client->pers;
    memset(ent->client, 0, sizeof(gclient_t));
    ent->client->pers = pers;
    ent->client->resp = resp;

    // Copy some data from the client to the entity
    FetchClientEntData(ent);

    // Fill in entity values
    ent->groundentity     = NULL;
    ent->client           = &game.clients[index];
    ent->takedamage       = DAMAGE_AIM;
    ent->movetype         = MOVETYPE_WALK;
    ent->viewheight       = 22;
    ent->inuse            = true;
    ent->classname        = "bot";
    ent->mass             = 200;
    ent->solid            = SOLID_BBOX;
    ent->deadflag         = DEAD_NO;
    ent->air_finished     = level.time + 12;
    ent->clipmask         = MASK_PLAYERSOLID;
    ent->think            = Bot_Think;
    ent->touch            = NULL;
    ent->pain             = Bot_Pain;
    ent->die              = player_die;
    ent->waterlevel       = 0;
    ent->watertype        = 0;
    ent->flags           &= ~FL_NO_KNOCKBACK;
    ent->enemy            = NULL;
    ent->movetarget       = NULL;

    VectorCopy(mins, ent->mins);
    VectorCopy(maxs, ent->maxs);
    VectorClear(ent->velocity);

    // Clear player_state values
    memset(&ent->client->ps, 0, sizeof(player_state_t));

    // Set up orientation and delta angles
    for (i = 0; i < 3; i++)
        {
        ent->client->ps.pmove.origin[i] = origin[i] * 8;
        ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(angles[i] - ent->client->resp.cmd_angles[i]);
        }
    // next

    ent->client->ps.fov = 90;
    ent->client->ps.gunindex = gi.modelindex(ent->client->pers.weapon->view_model);

    // Clear entity state values
    ent->s.effects        = 0;
    ent->s.skinnum        = index;
    ent->s.modelindex     = 255;      // will use the skin specified model
    ent->s.modelindex2    = 255;      // custom gun model
    ent->s.frame          = 0;

    VectorCopy(origin, ent->s.origin);
    ent->s.origin[2]++;               // make sure off ground

    ent->s.angles[PITCH]  = 0;
    ent->s.angles[YAW]    = angles[YAW];
    ent->s.angles[ROLL]   = 0;

    VectorCopy(ent->s.angles, ent->client->ps.viewangles);
    VectorCopy(ent->s.angles, ent->client->v_angle);

    gi.unlinkentity(ent); // Must do this before KillBox
    KillBox(ent);         // Telefrag!
    gi.linkentity(ent);   // Tada!  In the game world!

    // Force the current weapon up
    ent->client->newweapon = ent->client->pers.weapon;
    ChangeWeapon(ent);

    ent->nextthink = level.time + FRAMETIME;
    }
// end of ent_Spawn


void Bot_Respawn(edict_t *ent)
    {
    CopyToBodyQue(ent);

    Bot_Spawn(ent);

    ent->s.event = EV_PLAYER_TELEPORT;
    }
// end of Bot_Respawn


void Bot_Think(edict_t *ent)
    {
    usercmd_t   cmd;
    vec3_t      angles = { 0, 0, 0 };
    //int         iMoveType;

    VectorCopy(ent->client->v_angle, angles);
    VectorSet(ent->client->ps.pmove.delta_angles, 0, 0, 0);
    memset(&cmd, 0, sizeof(usercmd_t));

    if (ent->deadflag == DEAD_DEAD)
        {
        ent->client->buttons = 0;
        cmd.buttons = BUTTON_ATTACK;   // This will cause a respawn
        }
    else if (ent->enemy)
        {
        Bot_Attack(ent, &cmd, angles); // Attack enemy!
        }
    // end if

    // Approximate the time it takes for a client to render the current frame
    cmd.msec = 100;

    // View angle
    cmd.angles[PITCH] = ANGLE2SHORT(angles[PITCH]);
    cmd.angles[YAW]   = ANGLE2SHORT(angles[YAW]);
    cmd.angles[ROLL]  = ANGLE2SHORT(angles[ROLL]);

    // Tell the game engine to process the bot's command
    ClientThink(ent, &cmd);

    ent->nextthink = level.time + FRAMETIME;
    }
// end of Bot_Think


void Bot_Aim(edict_t *ent, edict_t *target, vec3_t angles)
    {
    vec3_t dir, start, end;

    VectorCopy(target->s.origin, start);
    VectorCopy(ent->s.origin, end);
    VectorSubtract(start, end, dir);
    vectoangles(dir, angles);
    }
// end of Bot_Aim


void Bot_Attack(edict_t *ent, usercmd_t *cmd, vec3_t angles)
    {
    if (ent->enemy->deadflag == DEAD_DEAD)
        ent->enemy = NULL;    // No need to mess with the dead
    else
        {
        if (infront(ent, ent->enemy))  // Is enemy in line-of-sight?
            {
            Bot_Aim(ent, ent->enemy, angles);

            if (random() < 0.3)        // Don't fire too often!
                cmd->buttons = BUTTON_ATTACK;  // Make an attack!
            // end if
            }
        // end if
        }
    // end if
    }
// end of Bot_Attack


void Bot_Pain(edict_t *ent, edict_t *other, float kickback, int damage)
    {
    if (ent != other)                    // Don't hate self...
        {
        ent->oldenemy = ent->enemy;      // Save the old enemy
        ent->enemy    = other;           // The attacker becomes the new enemy
        }
    // end if

    player_pain(ent, other, kickback, damage);  // Just use the normal pain function
    }
// end of Bot_Pain


