/* o_weapon.c
 *
 * Hentai's visual weapons mod
 *
 * 10 march 1998	jet@poboxes.com
 */

#include "g_local.h"
#include "o_weapon.h"

/*
 * Global variables
 */

cvar_t *vwep;

/*
 * Global functions
 */

void blaster_touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void check_dodge (edict_t *self, vec3_t start, vec3_t dir, int speed);


/* ShowGun
 *
 * set models for weapon
 */

void ShowGun(edict_t *ent)
{
	char heldmodel[128];
	int len;

	if(!ent->client->pers.weapon)
	{
		ent->s.modelindex2 = 0;
		return;
	}

	strcpy(heldmodel, "players/");
	strcat(heldmodel, Info_ValueForKey (ent->client->pers.userinfo, "skin"));
	for(len = 8; heldmodel[len]; len++)
		if(heldmodel[len] == '/') heldmodel[++len] = '\0';
	strcat(heldmodel, ent->client->pers.weapon->icon); 
	strcat(heldmodel, ".md2");
/*	gi.dprintf ("%s\n", heldmodel);*/
	ent->s.modelindex2 = gi.modelindex(heldmodel);  // Hentai's custom gun models
}

/* fire_laserblaster
 *
 * replaces fancy blaster edicts with green lasers,
 * this significantly reduces net load.  should be fixed
 * by alternate means by zoid in 3.15
 */

void fire_laserblaster (edict_t *self, vec3_t start, vec3_t dir, int damage, int speed, int effect, qboolean hyper)
{   
	edict_t *bolt;   
	trace_t tr;
	
	VectorNormalize (dir);   

/* laser blast */
	bolt = G_Spawn();
	VectorCopy (start, bolt->s.origin);
	vectoangles (dir, bolt->s.angles);
	VectorScale (dir, speed, bolt->velocity);
	VectorAdd (start, bolt->velocity, bolt->s.old_origin);
	bolt->clipmask = MASK_SHOT;
	bolt->movetype = MOVETYPE_FLYMISSILE;
	bolt->solid = SOLID_BBOX;
	bolt->s.renderfx |= RF_BEAM;
	bolt->s.modelindex = 1;       
	bolt->owner = self;                
	bolt->s.frame = 3;
// set the color
	if (self->client) {
		switch (self->client->resp.ctf_team) {
		case CTF_TEAM1:
			bolt->s.skinnum = 0xf2f2f0f0;	/* red */
			break;
		case CTF_TEAM2:                                                                                            // on blue team
			bolt->s.skinnum = 0xf3f3f1f1;	/* blue */
			break;
		default:
			bolt->s.skinnum = 0xd0d1d2d3;	/* green */
		}
	}
#if 0
	VectorSet (bolt->mins, -8, -8, -8);
	VectorSet (bolt->maxs, 8, 8, 8);
#else
	VectorClear (bolt->mins);
	VectorClear (bolt->maxs);
#endif
	bolt->touch = blaster_touch;
	bolt->nextthink = level.time + 4;
	bolt->think = G_FreeEdict;                
	bolt->dmg = damage;
	bolt->classname = "bolt";
	if (hyper) bolt->spawnflags = 1;
	gi.linkentity (bolt);

	if (self->client) check_dodge (self, bolt->s.origin, dir, speed);
	tr = gi.trace (self->s.origin, NULL, NULL, bolt->s.origin, bolt, MASK_SHOT);
	if (tr.fraction < 1.0) {
		VectorMA (bolt->s.origin, -10, dir, bolt->s.origin);
		bolt->touch (bolt, tr.ent, NULL, NULL);                
	}
}

/* end of file */
