/* o_map.c
 *
 * from MapMod created by Jeremy Mappus - Jerm aka DarkTheties
 *
 * Similarly to Rocket Arena a section in orange.ini called Maps 
 * contains a list of nextmaps, e.g.
 *
 *		[Maps]
 *		base1 = base2
 *		base1 = base1
 *
 * 7 january 1998	jet@poboxes.com
 */


#include "g_local.h"
#include "o_map.h"
#include "o_ini.h"
#include "o_shared.h"

/* o_map_nextmap
 *
 * move onto nextmap if one exists
 */

void o_map_next(char *thismap, char **nextmap)
{
	char *result;
	int i = 0;

	ini_initialise();
	result = ini_key_value (ORANGE_INI, "Maps", thismap, *nextmap);
	while (result[i]) {
		if (result[i] == '\n') result[i] = '\0';
		i++;
	}
	result = strdup (result);   
	ini_closedown();

	gi.dprintf("nextmap: [%s]\n", result);

	*nextmap = result;
}

/* end of file */
