/* o_config.c
 *
 * 26 March 1998	Michael Imor
 */
#include "g_local.h"
#include "o_ini.h"
#include "o_config.h"
#include "o_shared.h"

/*
 * Global variables
 */

extern cvar_t *gamedir;

/*
 * Local functions
 */

void o_initctf (void);

/* o_initctf
 *
 * set ctf strings
 */
 
void o_initctf (void) {
	char *file = ORANGE_INI;
	char *score = "CTF Scores";
	char *config = "CTF Config";

	CTF_CAPTURE_BONUS				= atoi (ini_key_value (file, score, "capture bonus", "15"));
	CTF_TEAM_BONUS				= atoi (ini_key_value (file, score, "team bonus", "10"));
	CTF_RECOVERY_BONUS			= atoi (ini_key_value (file, score, "recovery bonus", "1"));
	CTF_FLAG_BONUS				= atoi (ini_key_value (file, score, "pickup bonus", "0"));
 	CTF_FRAG_CARRIER_BONUS			= atoi (ini_key_value (file, score, "carrier bonus", "2"));
	CTF_CARRIER_DANGER_PROTECT_BONUS	= atoi (ini_key_value (file, score, "danger assist", "2"));
	CTF_CARRIER_PROTECT_BONUS		= atoi (ini_key_value (file, score, "protect assist", "1"));
	CTF_FLAG_DEFENSE_BONUS			= atoi (ini_key_value (file, score, "flag defense", "1"));
	CTF_RETURN_FLAG_ASSIST_BONUS		= atoi (ini_key_value (file, score, "return assist", "1"));
	CTF_FRAG_CARRIER_ASSIST_BONUS		= atoi (ini_key_value (file, score, "capture assist", "2"));

 	CTF_FLAG_RETURN_TIME			= atoi (ini_key_value (file, config, "flag return", "40"));
	CTF_TARGET_PROTECT_RADIUS		= atoi (ini_key_value (file, config, "target radius", "400"));
	CTF_ATTACKER_PROTECT_RADIUS		= atoi (ini_key_value (file, config, "attacker radius", "400"));
	CTF_CARRIER_DANGER_PROTECT_TIMEOUT	= atoi (ini_key_value (file, config, "danger timeout", "8"));
 	CTF_FRAG_CARRIER_ASSIST_TIMEOUT	= atoi (ini_key_value (file, config, "carrier timeout", "10"));
 	CTF_RETURN_FLAG_ASSIST_TIMEOUT	= atoi (ini_key_value (file, config, "return timeout", "10"));
}

/* o_initconfig
 *
 * set the configuration from config file
 */

void o_initconfig (void) {
	ini_initialise ();

	o_initctf();

	ini_closedown ();
}

/* end of file */
