/* tab setting: 3
 *
 * o_base.c
 *
 * spawn pretty lasers at the ctf bases
 */

#include "g_local.h"

/*
 * local functions
 */

void pre_base_laser_think (edict_t *self);
void base_laser_on (edict_t *self); 
void base_laser_off (edict_t *self);
void base_laser_think (edict_t *self);

/*
 * global functions
 */

void target_laser_on (edict_t *self);
void target_laser_off (edict_t *self);

/*
 * global variables
 */

extern vec3_t MOVEDIR_DOWN;

/* create_base
 *
 * called after flag has spawned, create the lasers
 */

void create_base (edict_t *ent, qboolean red)
{
   edict_t *self;
   vec3_t   wallp;
   trace_t  tr;
   int      laser_colour[] = {
                        0xf2f2f0f0,    // red
                        0xd0d1d2d3,    // green
                        0xf3f3f1f1,    // blue
                        0xdcdddedf,    // yellow
                        0xe0e1e2e3     // bitty yellow strobe
                     };

   // Setup end point
   wallp[0]=ent->s.origin[0];
   wallp[1]=ent->s.origin[1];
   wallp[2]=ent->s.origin[2]+8192;  

   // trace
   tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

   // Line complete ? (ie. no collision)
   if (tr.fraction == 1.0)
   {
      gi.dprintf ("create_base: Too far from wall.\n");
      return;
   }

   // Ok, lets stick one on then ...
//   gi.dprintf ("create_base: Laser attached.\n");

   // -----------
   // Setup laser
   // -----------
   self = G_Spawn();

   self->movetype     = MOVETYPE_NONE;
   self->solid        = SOLID_NOT;
   self->s.renderfx   = RF_BEAM|RF_TRANSLUCENT;
   self->s.modelindex = 1;        // must be non-zero
   self->s.sound      = gi.soundindex ("world/laser.wav");
   self->classname    = "base_laser";
   self->s.frame      = 2;  // beam diameter
   self->owner        = self;
   if (red)
      self->s.skinnum = laser_colour[0];
   else
      self->s.skinnum = laser_colour[2];
   self->dmg          = 0;
   self->touch        = NULL;
   self->think        = pre_base_laser_think;
//   self->delay        = level.time + LASER_TIME;

   // Set orgin of laser to point of contact with wall
   VectorCopy(tr.endpos,self->s.origin);

   // convert normal at point of contact to laser angles
   vectoangles(tr.plane.normal,self->s.angles);

   // setup laser movedir (projection of laser)

//   G_SetMovedir (self->s.angles, self->movedir);
// derek - change angles as this calculates normal to surface hit
//         which leads to odd skew lasers
   VectorCopy (MOVEDIR_DOWN, self->movedir);

   VectorSet (self->mins, -8, -8, -8);
   VectorSet (self->maxs, 8, 8, 8);

   // link to world
   gi.linkentity (self);

   // start on ...
   target_laser_off (self);

   // but make automatically come on
   self->nextthink = level.time + 2;
}

/*
 * local functions
 */

void pre_base_laser_think (edict_t *self) 
{
//   gi.dprintf("create_base: laser on\n");
   target_laser_on (self);
   self->think = base_laser_think;
}

void base_laser_on (edict_t *self)
{
   self->spawnflags |= 0x80000001;
   self->svflags &= ~SVF_NOCLIENT;
   base_laser_think (self);
}

void base_laser_off (edict_t *self)
{
   self->spawnflags &= ~1;
   self->svflags |= SVF_NOCLIENT;
   self->nextthink = 0;
}

void base_laser_think (edict_t *self)
{
   edict_t  *ignore;
   vec3_t   start;
   vec3_t   end;
   trace_t  tr;
   vec3_t   point;
   vec3_t   last_movedir;
   int      count;
   static   vec3_t   lmins = {-4, -4, -4};
   static   vec3_t   lmaxs = {4, 4, 4};

   if (self->spawnflags & 0x80000000)
      count = 8;
   else
      count = 4;

   if (self->enemy)
   {
      VectorCopy (self->movedir, last_movedir);
      VectorMA (self->enemy->absmin, 0.5, self->enemy->size, point);
      VectorSubtract (point, self->s.origin, self->movedir);
      VectorNormalize (self->movedir);
      if (!VectorCompare(self->movedir, last_movedir))
         self->spawnflags |= 0x80000000;
   }

   ignore = self;
   VectorCopy (self->s.origin, start);
   VectorMA (start, 2048, self->movedir, end);
   while(1)
   {
      tr = gi.trace (start, NULL, NULL, end, ignore, CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);

      if (!tr.ent)
         break;

      // hurt it if we can
//      if ((tr.ent->takedamage) && !(tr.ent->flags & FL_IMMUNE_LASER) && (tr.ent != self->owner))
//         T_Damage (tr.ent, self, self->owner, self->movedir, tr.endpos, vec3_origin, self->dmg, 1, DAMAGE_ENERGY);

      // if we hit something that's not a monster or player or is immune to lasers, we're done
      if (!(tr.ent->svflags & SVF_MONSTER) && (!tr.ent->client))
      {
         if (self->spawnflags & 0x80000000)
         {
            self->spawnflags &= ~0x80000000;
            gi.WriteByte (svc_temp_entity);
            gi.WriteByte (TE_LASER_SPARKS);
            gi.WriteByte (count);
            gi.WritePosition (tr.endpos);
            gi.WriteDir (tr.plane.normal);
            gi.WriteByte (self->s.skinnum);
            gi.multicast (tr.endpos, MULTICAST_PVS);
         }
         break;
      }

      ignore = tr.ent;
      VectorCopy (tr.endpos, start);
   }

   VectorCopy (tr.endpos, self->s.old_origin);

   self->nextthink = level.time + FRAMETIME;
}

void CTFBaseInit(void)
{
	edict_t *ent;
	edict_t *from, *tfar = NULL;
	vec3_t dir;
	float farthest = 0;
	edict_t *base1 = NULL, *base2 = NULL;

	base1 = G_Find(NULL, FOFS(classname), "item_flag_team1");
	base2 = G_Find(NULL, FOFS(classname), "item_flag_team2");

	if (base1 && base2)
		return;
	else if (base1)
		tfar = base1;
	else if (base2)
		tfar = base2;
	else {

// find any point
		ent = tfar = from = G_Find(NULL, FOFS(classname), "info_player_deathmatch");
// find one end
		while (from) {
			from = G_Find(from, FOFS(classname), "info_player_deathmatch");
			if (from) {
				_VectorSubtract(from->s.origin, ent->s.origin, dir);
				if (VectorLength(dir) > farthest) {
					tfar = from;
					farthest = VectorLength(dir);
				}
			}
		}

		if (!tfar) {
			gi.dprintf ("cannot find deathmatch spawn points\n");
			return;
		}

		tfar->s.effects |= EF_COLOR_SHELL;
		tfar->s.renderfx |= RF_SHELL_RED;

		ent = G_Spawn();
		ent->classname = "item_flag_team1";

		VectorCopy(tfar->s.origin, ent->s.origin);
		ent->s.origin[2] += 16;

		SpawnItem(ent, FindItemByClassname(ent->classname));
	}

// find another
	ent = from = G_Find(NULL, FOFS(classname), "info_player_deathmatch");
	while (from) {
		from = G_Find(from, FOFS(classname), "info_player_deathmatch");
		if (from) {
			_VectorSubtract(from->s.origin, tfar->s.origin, dir);
			if (VectorLength(dir) > farthest) {
				ent = from;
				farthest = VectorLength(dir);
			}
		}
	}

	tfar = ent;
	tfar->s.effects |= EF_COLOR_SHELL;
	if (base2)
		tfar->s.renderfx |= RF_SHELL_RED;
	else
		tfar->s.renderfx |= RF_SHELL_BLUE;

	ent = G_Spawn();
	if (base2)
		ent->classname = "item_flag_team1";
	else
		ent->classname = "item_flag_team2";

	VectorCopy(tfar->s.origin, ent->s.origin);
	ent->s.origin[2] += 16;

	SpawnItem(ent, FindItemByClassname(ent->classname));
}

/* end of file */

