/* tab setting: 3
 *
 * l_gibstats.h
 *
 * http://www.planetquake.com/gibstats
 */

#ifndef __L_GIBSTATS_H
#define __L_GIBSTATS_H

/*
 * Global variables
 */

extern qboolean gs_enabled;
extern cvar_t *gibstats;
extern FILE *gs_file;

/*
 * Global functions
 */

#ifdef __cplusplus
extern "C" {
#endif

void gs_shutdown (void);
void gs_init (void);
void gs_map_start (void);
void gs_write_death (edict_t *self, edict_t *inflictor, edict_t *attacker);
void gs_player_entered (edict_t *ent);
void gs_disconnect (edict_t *ent);
void gs_name_change (char *oldname, char *newname);

#ifdef __cplusplus
}
#endif

#endif /* __L_GIBSTATS_H */

/* end of file */
