//Quake2 .md2 file viewer
//source code released on Dec 8, 1997
//by Trey Harrison    -     trey@crack.com
//learn. do not steal.

#ifndef _MDLDEMO_H_
#define _MDLDEMO_H_

#include <stdio.h>

typedef struct {
	float x,y,z;
} vec3_t;

typedef struct                     
{
  int ident;
  int version;
  int skinwidth;
  int skinheight;
  int framesize; // byte size of each frame
  int num_skins;
  int num_xyz;
  int num_st; // greater than num_xyz for seams
  int num_tris;
  int num_glcmds; // dwords in strip/fan command list
  int num_frames;
  int ofs_skins; // each skin is a MAX_SKINNAME string
  int ofs_st; // byte offset from start for stverts
  int ofs_tris; // offset for dtriangles
  int ofs_frames; // offset for first frame
  int ofs_glcmds; 
  int ofs_end; // end of file
} mdlheader_t;

typedef struct
{ u_char x;
  u_char y;                    // X,Y,Z coordinate, packed on 0-255 
  u_char z;
  u_char lightnormalindex;     // index of the vertex normal
} trivertx_t;

typedef struct
{
  vec3_t scale; // multiply byte verts by this
  vec3_t origin; // then add this
  char name[16]; // frame name from grabbing
  trivertx_t verts[1]; // variable sized
} frameinfo_t;

typedef struct {
    char            **skinnames;
    long            num_skins;
    
    long            num_glcmds;
    long            *glcmds;
    
		long            numframes;
    frameinfo_t     *frames;    
		long            framesize;

    long            skinwidth;
		long            skinheight;
		
    float           s_scale;
		float           t_scale;

    float           skin_screen_offset_x;
    float           skin_screen_offset_y;
		    
} mdl_t;

typedef struct
{ unsigned char magic[4];             // Name of the new WAD format = "PACK"
  long diroffset;              // Position of WAD directory from start of file
  long dirsize;                // Number of entries * 0x40 (64 char)
} pakheader_t;


typedef struct
{ char filename[0x38];       // Name of the file, Unix style, with extension,
                               // 56 chars, padded with '\0'.
  long offset;                 // Position of the entry in PACK file
  long size;                   // Size of the entry in PACK file
} pakentry_t;

typedef struct char_link_s
{
  char data[256];
  struct char_link_s *next;
} char_link;

//Function Prototypes

//md2view.c
void InitModelTexture(mdl_t *mdl, char *pakfile, int skin_num, char *skin_fname);
void DrawModel(mdl_t *,float,float,float,int,float,int,int,float,float);
void DrawSkin(mdl_t *);
mdl_t *LoadMDLFromMDL(char *mdlname);
mdl_t *LoadMDLFromPAK(char *pakname, char *mdlname);
void FreeModel(mdl_t *);

//misc.c
void *SafeMalloc(unsigned int size);
void SetIntelPrecision();
extern const float VTX_SNAP;
void ExtractExtName(char *ext,char *source, char *dest);
BOOL keydown(long param);
BOOL keywaspressed(long param);
char *remove_path(char *fname);
char *extract_path(char *fname);
void dos_path(char *fname);
FILE *FindInPak(char *pakname, char *filename, int *size, int *offset);
void ExitWithError(char *errorstr);
void WriteMdlList(char *pakname);
void AddSkinNamesToModel(char *lstname, mdl_t *model);
void Write3dfxTga();

//winmain.c
HWND StartWindow(HINSTANCE hInstance, int iCmdShow);

//global vars
extern HWND mainhwnd;
extern mdl_t *model;

#endif
