#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include "mdl.h"

int tim;
void tim_count () {tim ++;}
END_OF_FUNCTION (tim_count);

main()
{

    int i, j;                /* loop variables    */
    int hres=640, vres=480;  /* screen resolution */

    float cam_x = 0, cam_y = 0, cam_z = 0;
    V3D_f cam_pos, cam_vel;
    float cam_roll = 0, cam_yaw = 0, cam_pitch = -30;

    float zoom = 0.005;

    BITMAP * buf;  /* offscreen drawing buffer */

    mdl_t p_model;
    mdl_t p_image;

    p_model.verts = NULL;
    p_image.verts = NULL;

    mdl_load (&p_model, "model.txt");
    mdl_new  (&p_image, p_model.vert_count, p_model.frame_count);

    cam_pos.x = 0;
    cam_pos.y = -100;
    cam_pos.z = 0;

    /* initialize Allegro game programming library */

    allegro_init ();
    set_color_depth (8);
    set_gfx_mode (GFX_AUTODETECT, hres, vres, 0, 0);
    set_clip (screen, 0, 0, hres-1, vres-1);

    tim = 0;
    LOCK_VARIABLE (tim);
    LOCK_FUNCTION (tim_count);
    install_timer ();
    install_int_ex (tim_count, BPS_TO_TIMER(40));

    install_keyboard ();

    /* don't know if we'll even use this:          */
    /* set_projection_viewport (0, 0, hres, vres); */

    buf = create_bitmap (hres,vres);          /* create the buffer */
    rectfill (buf, 0, 0, hres-1, vres-1, 0);  /* clear the buffer  */

    i = 0;
    while (1)
    {
        rectfill  (buf, 0, 0, hres-1, vres-1, 0);
        mdl_copy  (&p_image, &p_model);

        /* transform to world coords */
        mdl_rot   (&p_image, 0, 0, 0);
        mdl_trans (&p_image, 0, 0, -100);

        /* transform to camera coords */
        mdl_trans (&p_image, -cam_pos.x, -cam_pos.y, -cam_pos.z);
        mdl_rot   (&p_image, 0, -cam_yaw, 0);
        mdl_rot   (&p_image, -cam_pitch, 0, 0);
        mdl_rot   (&p_image, 0, 0, -cam_roll);

        /* transform to screen coords */
//        mdl_proj  (&p_image, 100);
        mdl_scale (&p_image, hres * zoom, vres * zoom, 0);
        mdl_trans (&p_image, hres/2, vres/2, 0);

        mdl_draw  (&p_image, buf);
        blit      (buf, screen, 0, 0, 0, 0, hres, vres);

        if (i != tim)
        {
            if (key [KEY_ESC]   ) break;
            if (key [KEY_RIGHT] ) cam_yaw ++;
            if (key [KEY_LEFT]  ) cam_yaw --;
            if (key [KEY_UP]    )
            {
                cam_vel.x = - sin (cam_yaw * 3.1459/180);
                cam_vel.y = 0;
                cam_vel.z = - cos (cam_yaw * 3.1459/180);

                cam_pos.x += cam_vel.x;
                cam_pos.y += cam_vel.y;
                cam_pos.z += cam_vel.z;
            }
            if (key [KEY_DOWN]  )
            {
                cam_vel.x = sin (cam_yaw * 3.1459/180);
                cam_vel.y = 0;
                cam_vel.z = cos (cam_yaw * 3.1459/180);

                cam_pos.x += cam_vel.x;
                cam_pos.y += cam_vel.y;
                cam_pos.z += cam_vel.z;
            }
        }
        i = tim;
    }
    allegro_exit();
    return 0;
}

