#include <stdio.h>
#include <math.h>
#include <allegro.h>
#include "mdl.h"


/* COPY MODEL */

void mdl_copy (mdl_t * self, mdl_t * other)
{
    int i;
    if (self->vert_count == 0) return;

    if (self->vert_count != other->vert_count
       || self->frame_count != other->frame_count)
       mdl_new (self, other->vert_count, other->frame_count);

    for (i=0; i<self->vert_count; i++)
    {
        self->verts[i].x = other->verts[i].x;
        self->verts[i].y = other->verts[i].y;
        self->verts[i].z = other->verts[i].z;
    }
}


/* DRAW MODEL */

void mdl_draw (mdl_t * self, BITMAP * bmp)
{
    int i;
    if (self->vert_count == 0) return;
    for (i=0; i<self->vert_count; i+=3)
    {
        // triangle3d_f(screen,POLYTYPE_FLAT,screen,pts+i,pts+i+1,pts+i+2);
        line (bmp, self->verts[i].x,   self->verts[i].y,   self->verts[i+1].x, self->verts[i+1].y ,15);
        line (bmp, self->verts[i+1].x, self->verts[i+1].y, self->verts[i+2].x, self->verts[i+2].y ,15);
        line (bmp, self->verts[i+2].x, self->verts[i+2].y, self->verts[i].x,   self->verts[i].y   ,15);
    }
}


/* MOVE MODEL */

void mdl_trans (mdl_t * self, float x, float y, float z)
{
    int i;
    if (self->vert_count == 0) return;
    for (i=0; i<self->vert_count; i++)
    {
        self->verts[i].x += x;
        self->verts[i].y += y;
        self->verts[i].z += z;
    }
}


/* SCALE MODEL */

void mdl_scale (mdl_t * self, float x, float y, float z)
{
    int i;
    if (self->vert_count == 0) return;
    for (i=0; i<self->vert_count; i++)
    {
        self->verts[i].x *= x;
        self->verts[i].y *= y;
        self->verts[i].z *= z;
    }
}


/* ROTATE MODEL */

void mdl_rot (mdl_t * self, float x, float y, float z)
{
    int i;

    float xx, xy, xz;
    float yx, yy, yz;
    float zx, zy, zz;

    float mxx, mxy, mxz;
    float myx, myy, myz;
    float mzx, mzy, mzz;

    float c, s;

    float mx, my, mz;

    if (self->vert_count == 0) return;

    xx = 1;  xy = 0;  xz = 0;
    yx = 0;  yy = 1;  yz = 0;
    zx = 0;  zy = 0;  zz = 1;

    // x rotation = roll

    c = (float) cos(x * 3.1459/180);
    s = (float) sin(x * 3.1459/180);

    myx = yx*c + zx*s;  mzx = zx*c - yx*s;
    myy = yy*c + zy*s;  mzy = zy*c - yy*s;
    myz = yz*c + zz*s;  mzz = zz*c - yz*s;

    yx = myx;  yy = myy;  yz = myz;
    zx = mzx;  zy = mzy;  zz = mzz;

    // z rotation = pitch

    c = (float) cos(z * 3.1459/180);
    s = (float) sin(z * 3.1459/180);

    mxx = xx*c + yx*s;  myx = yx*c - xx*s;
    mxy = xy*c + yy*s;  myy = yy*c - xy*s;
    mxz = xz*c + yz*s;  myz = yz*c - xz*s;

    xx = mxx;  xy = mxy;  xz = mxz;
    yx = myx;  yy = myy;  yz = myz;

    // y rotation = yaw

    c = (float) cos(y * 3.1459/180);
    s = (float) sin(y * 3.1459/180);

    mxx = xx*c + zx*s;  mzx = zx*c - xx*s;
    mxy = xy*c + zy*s;  mzy = zy*c - xy*s;
    mxz = xz*c + zz*s;  mzz = zz*c - xz*s;

    xx = mxx;  xy = mxy;  xz = mxz;
    zx = mzx;  zy = mzy;  zz = mzz;


    // apply matrix to vertices

    for (i=0; i<self->vert_count; i++)
    {
        mx = self->verts[i].x * xx + self->verts[i].y * xy + self->verts[i].z * xz;
        my = self->verts[i].x * yx + self->verts[i].y * yy + self->verts[i].z * yz;
        mz = self->verts[i].x * zx + self->verts[i].y * zy + self->verts[i].z * zz;

        self->verts[i].x = mx;
        self->verts[i].y = my;
        self->verts[i].z = mz;
    }
}


mdl_t pmdl, imdl;
V3D_f pts [1494]; /* will be replaced by dynamically allocated coords */
V3D_f img [1494]; /* will be replaced by dynamically allocated coords */
float raw [4482] = /* YUCK!  will be loaded from a file */
{
2.00,10.00,-6.50,4.00,6.00,-6.50,-2.00,8.00,-6.50
,-2.00,8.00,-6.50,4.00,6.00,-6.50,0.00,4.00,-6.50
,-2.00,8.00,-6.50,0.00,4.00,-6.50,-4.00,7.00,-3.50
,-4.00,7.00,-3.50,0.00,4.00,-6.50,-2.00,3.00,-3.50
,4.00,11.00,-3.50,6.00,7.00,-3.50,2.00,10.00,-6.50
,4.00,6.00,-6.50,2.00,10.00,-6.50,6.00,7.00,-3.50
,-2.00,8.00,-6.50,-4.00,7.00,-3.50,-3.00,10.00,-3.50
,2.00,10.00,-6.50,1.00,12.00,-3.50,4.00,11.00,-3.50
,2.00,10.00,-6.50,-2.00,8.00,-6.50,-1.00,11.00,-5.50
,-1.00,11.00,-5.50,-2.00,8.00,-6.50,-3.00,10.00,-3.50
,1.00,12.00,-3.50,2.00,10.00,-6.50,-1.00,11.00,-5.50
,0.00,4.00,-6.50,4.00,6.00,-6.50,3.00,3.00,-5.50
,5.00,4.00,-3.50,4.00,6.00,-6.50,6.00,7.00,-3.50
,1.00,2.00,-3.50,-2.00,3.00,-3.50,0.00,4.00,-6.50
,0.00,4.00,-6.50,3.00,3.00,-5.50,1.00,2.00,-3.50
,5.00,4.00,-3.50,3.00,3.00,-5.50,4.00,6.00,-6.50
,0.75,-2.50,-6.50,-1.50,-3.00,-5.50,-0.75,0.50,-6.50
,-0.75,0.50,-6.50,-1.50,-3.00,-5.50,-2.50,-1.00,-5.50
,-0.75,0.50,-6.50,-2.50,-1.00,-5.50,-1.50,2.00,-3.50
,-1.50,2.00,-3.50,-2.50,-1.00,-5.50,-3.00,0.00,-3.50
,1.50,-4.00,-3.50,-1.00,-4.00,-3.50,0.75,-2.50,-6.50
,-1.50,-3.00,-5.50,0.75,-2.50,-6.50,-1.00,-4.00,-3.50
,-0.75,0.50,-6.50,-1.50,2.00,-3.50,1.00,2.00,-3.50
,0.75,-2.50,-6.50,3.00,-2.00,-3.50,1.50,-4.00,-3.50
,0.75,-2.50,-6.50,-0.75,0.50,-6.50,2.00,0.00,-5.50
,2.00,0.00,-5.50,-0.75,0.50,-6.50,1.00,2.00,-3.50
,3.00,-2.00,-3.50,0.75,-2.50,-6.50,2.00,0.00,-5.50
,-2.50,-1.00,-5.50,-1.50,-3.00,-5.50,-4.00,-3.00,-5.50
,-3.00,-5.00,-3.50,-1.50,-3.00,-5.50,-1.00,-4.00,-3.50
,-5.00,-1.00,-3.50,-3.00,0.00,-3.50,-2.50,-1.00,-5.50
,-2.50,-1.00,-5.50,-4.00,-3.00,-5.50,-5.00,-1.00,-3.50
,-3.00,-5.00,-3.50,-4.00,-3.00,-5.50,-1.50,-3.00,-5.50
,2.00,0.00,-5.50,1.00,2.00,-3.50,3.00,3.00,-5.50
,3.00,3.00,-5.50,3.00,-2.00,-3.50,2.00,0.00,-5.50
,3.00,3.00,-5.50,5.00,4.00,-3.50,3.00,-2.00,-3.50
,-3.00,10.00,-3.50,1.00,12.00,-3.50,-1.00,11.00,-5.50
,-4.00,-3.00,-5.50,-3.00,-5.00,-3.50,-4.50,-6.00,-5.50
,-4.50,-6.00,-5.50,-5.00,-1.00,-3.50,-4.00,-3.00,-5.50
,-5.00,-1.00,-3.50,-4.50,-6.00,-5.50,-6.00,-7.00,-3.50
,-4.50,-10.00,-3.50,-2.50,-10.00,-5.50,-3.50,-12.00,-4.50
,-2.50,-10.00,-5.50,-0.50,-10.00,-3.50,0.50,-12.00,-5.00
,2.50,-12.00,-3.50,0.50,-12.00,-5.00,-0.50,-10.00,-3.50
,-2.50,-10.00,-5.50,0.50,-12.00,-5.00,0.50,-12.00,-7.00
,0.50,-12.00,-7.00,-3.50,-12.00,-4.50,-2.50,-10.00,-5.50
,0.50,-12.00,-5.00,-3.50,-12.00,-4.50,0.50,-12.00,-7.00
,-2.50,-10.00,-5.50,-4.50,-10.00,-3.50,-4.50,-6.00,-5.50
,-4.50,-10.00,-3.50,-6.00,-7.00,-3.50,-4.50,-6.00,-5.50
,-0.50,-10.00,-3.50,-4.50,-6.00,-5.50,-3.00,-5.00,-3.50
,-0.50,-10.00,-3.50,-2.50,-10.00,-5.50,-4.50,-6.00,-5.50
,-2.00,8.00,-0.50,4.00,6.00,-0.50,2.00,10.00,-0.50
,0.00,4.00,-0.50,4.00,6.00,-0.50,-2.00,8.00,-0.50
,-4.00,7.00,-3.50,0.00,4.00,-0.50,-2.00,8.00,-0.50
,-2.00,3.00,-3.50,0.00,4.00,-0.50,-4.00,7.00,-3.50
,2.00,10.00,-0.50,6.00,7.00,-3.50,4.00,11.00,-3.50
,6.00,7.00,-3.50,2.00,10.00,-0.50,4.00,6.00,-0.50
,-3.00,10.00,-3.50,-4.00,7.00,-3.50,-2.00,8.00,-0.50
,4.00,11.00,-3.50,1.00,12.00,-3.50,2.00,10.00,-0.50
,-1.00,11.00,-1.50,-2.00,8.00,-0.50,2.00,10.00,-0.50
,-3.00,10.00,-3.50,-2.00,8.00,-0.50,-1.00,11.00,-1.50
,-1.00,11.00,-1.50,2.00,10.00,-0.50,1.00,12.00,-3.50
,3.00,3.00,-1.50,4.00,6.00,-0.50,0.00,4.00,-0.50
,6.00,7.00,-3.50,4.00,6.00,-0.50,5.00,4.00,-3.50
,0.00,4.00,-0.50,-2.00,3.00,-3.50,1.00,2.00,-3.50
,1.00,2.00,-3.50,3.00,3.00,-1.50,0.00,4.00,-0.50
,4.00,6.00,-0.50,3.00,3.00,-1.50,5.00,4.00,-3.50
,-0.75,0.50,-0.50,-1.50,-3.00,-1.50,0.75,-2.50,-0.50
,-2.50,-1.00,-1.50,-1.50,-3.00,-1.50,-0.75,0.50,-0.50
,-1.50,2.00,-3.50,-2.50,-1.00,-1.50,-0.75,0.50,-0.50
,-3.00,0.00,-3.50,-2.50,-1.00,-1.50,-1.50,2.00,-3.50
,0.75,-2.50,-0.50,-1.00,-4.00,-3.50,1.50,-4.00,-3.50
,-1.00,-4.00,-3.50,0.75,-2.50,-0.50,-1.50,-3.00,-1.50
,1.00,2.00,-3.50,-1.50,2.00,-3.50,-0.75,0.50,-0.50
,1.50,-4.00,-3.50,3.00,-2.00,-3.50,0.75,-2.50,-0.50
,2.00,0.00,-1.50,-0.75,0.50,-0.50,0.75,-2.50,-0.50
,1.00,2.00,-3.50,-0.75,0.50,-0.50,2.00,0.00,-1.50
,2.00,0.00,-1.50,0.75,-2.50,-0.50,3.00,-2.00,-3.50
,-4.00,-3.00,-1.50,-1.50,-3.00,-1.50,-2.50,-1.00,-1.50
,-1.00,-4.00,-3.50,-1.50,-3.00,-1.50,-3.00,-5.00,-3.50
,-2.50,-1.00,-1.50,-3.00,0.00,-3.50,-5.00,-1.00,-3.50
,-5.00,-1.00,-3.50,-4.00,-3.00,-1.50,-2.50,-1.00,-1.50
,-1.50,-3.00,-1.50,-4.00,-3.00,-1.50,-3.00,-5.00,-3.50
,3.00,3.00,-1.50,1.00,2.00,-3.50,2.00,0.00,-1.50
,2.00,0.00,-1.50,3.00,-2.00,-3.50,3.00,3.00,-1.50
,3.00,-2.00,-3.50,5.00,4.00,-3.50,3.00,3.00,-1.50
,-1.00,11.00,-1.50,1.00,12.00,-3.50,-3.00,10.00,-3.50
,-4.50,-6.00,-1.50,-3.00,-5.00,-3.50,-4.00,-3.00,-1.50
,-4.00,-3.00,-1.50,-5.00,-1.00,-3.50,-4.50,-6.00,-1.50
,-6.00,-7.00,-3.50,-4.50,-6.00,-1.50,-5.00,-1.00,-3.50
,-3.50,-12.00,-2.50,-2.00,-10.00,-1.50,-4.50,-10.00,-3.50
,0.50,-12.00,-2.00,-0.50,-10.00,-3.50,-2.00,-10.00,-1.50
,-0.50,-10.00,-3.50,0.50,-12.00,-2.00,2.50,-12.00,-3.50
,0.50,-12.00,0.00,0.50,-12.00,-2.00,-2.00,-10.00,-1.50
,-2.00,-10.00,-1.50,-3.50,-12.00,-2.50,0.50,-12.00,0.00
,0.50,-12.00,0.00,-3.50,-12.00,-2.50,0.50,-12.00,-2.00
,-4.50,-6.00,-1.50,-4.50,-10.00,-3.50,-2.00,-10.00,-1.50
,-4.50,-6.00,-1.50,-6.00,-7.00,-3.50,-4.50,-10.00,-3.50
,-3.00,-5.00,-3.50,-4.50,-6.00,-1.50,-0.50,-10.00,-3.50
,-4.50,-6.00,-1.50,-2.00,-10.00,-1.50,-0.50,-10.00,-3.50
,0.50,-12.00,-5.00,2.50,-12.00,-3.50,0.50,-12.00,-2.00
,0.50,-12.00,-2.00,-3.50,-12.00,-4.50,0.50,-12.00,-5.00
,-3.50,-12.00,-4.50,0.50,-12.00,-2.00,-3.50,-12.00,-2.50
,-2.00,8.00,6.50,4.00,6.00,6.50,2.00,10.00,6.50
,0.00,4.00,6.50,4.00,6.00,6.50,-2.00,8.00,6.50
,-4.00,7.00,3.50,0.00,4.00,6.50,-2.00,8.00,6.50
,-2.00,3.00,3.50,0.00,4.00,6.50,-4.00,7.00,3.50
,2.00,10.00,6.50,6.00,7.00,3.50,4.00,11.00,3.50
,6.00,7.00,3.50,2.00,10.00,6.50,4.00,6.00,6.50
,-3.00,10.00,3.50,-4.00,7.00,3.50,-2.00,8.00,6.50
,4.00,11.00,3.50,1.00,12.00,3.50,2.00,10.00,6.50
,-1.00,11.00,5.50,-2.00,8.00,6.50,2.00,10.00,6.50
,-3.00,10.00,3.50,-2.00,8.00,6.50,-1.00,11.00,5.50
,-1.00,11.00,5.50,2.00,10.00,6.50,1.00,12.00,3.50
,3.00,3.00,5.50,4.00,6.00,6.50,0.00,4.00,6.50
,6.00,7.00,3.50,4.00,6.00,6.50,5.00,4.00,3.50
,0.00,4.00,6.50,-2.00,3.00,3.50,1.00,2.00,3.50
,1.00,2.00,3.50,3.00,3.00,5.50,0.00,4.00,6.50
,4.00,6.00,6.50,3.00,3.00,5.50,5.00,4.00,3.50
,-0.75,0.50,6.50,-1.50,-3.00,5.50,0.75,-2.50,6.50
,-2.50,-1.00,5.50,-1.50,-3.00,5.50,-0.75,0.50,6.50
,-1.50,2.00,3.50,-2.50,-1.00,5.50,-0.75,0.50,6.50
,-3.00,0.00,3.50,-2.50,-1.00,5.50,-1.50,2.00,3.50
,0.75,-2.50,6.50,-1.00,-4.00,3.50,1.50,-4.00,3.50
,-1.00,-4.00,3.50,0.75,-2.50,6.50,-1.50,-3.00,5.50
,1.00,2.00,3.50,-1.50,2.00,3.50,-0.75,0.50,6.50
,1.50,-4.00,3.50,3.00,-2.00,3.50,0.75,-2.50,6.50
,2.00,0.00,5.50,-0.75,0.50,6.50,0.75,-2.50,6.50
,1.00,2.00,3.50,-0.75,0.50,6.50,2.00,0.00,5.50
,2.00,0.00,5.50,0.75,-2.50,6.50,3.00,-2.00,3.50
,-4.00,-3.00,5.50,-1.50,-3.00,5.50,-2.50,-1.00,5.50
,-1.00,-4.00,3.50,-1.50,-3.00,5.50,-3.00,-5.00,3.50
,-2.50,-1.00,5.50,-3.00,0.00,3.50,-5.00,-1.00,3.50
,-5.00,-1.00,3.50,-4.00,-3.00,5.50,-2.50,-1.00,5.50
,-1.50,-3.00,5.50,-4.00,-3.00,5.50,-3.00,-5.00,3.50
,3.00,3.00,5.50,1.00,2.00,3.50,2.00,0.00,5.50
,2.00,0.00,5.50,3.00,-2.00,3.50,3.00,3.00,5.50
,3.00,-2.00,3.50,5.00,4.00,3.50,3.00,3.00,5.50
,-1.00,11.00,5.50,1.00,12.00,3.50,-3.00,10.00,3.50
,-4.50,-6.00,5.50,-3.00,-5.00,3.50,-4.00,-3.00,5.50
,-4.00,-3.00,5.50,-5.00,-1.00,3.50,-4.50,-6.00,5.50
,-6.00,-7.00,3.50,-4.50,-6.00,5.50,-5.00,-1.00,3.50
,-3.50,-12.00,4.50,-2.00,-10.00,5.50,-4.50,-10.00,3.50
,0.50,-12.00,5.00,-0.50,-10.00,3.50,-2.00,-10.00,5.50
,-0.50,-10.00,3.50,0.50,-12.00,5.00,2.50,-12.00,3.50
,0.50,-12.00,7.00,0.50,-12.00,5.00,-2.00,-10.00,5.50
,-2.00,-10.00,5.50,-3.50,-12.00,4.50,0.50,-12.00,7.00
,0.50,-12.00,7.00,-3.50,-12.00,4.50,0.50,-12.00,5.00
,-4.50,-6.00,5.50,-4.50,-10.00,3.50,-2.00,-10.00,5.50
,-4.50,-6.00,5.50,-6.00,-7.00,3.50,-4.50,-10.00,3.50
,-3.00,-5.00,3.50,-4.50,-6.00,5.50,-0.50,-10.00,3.50
,-4.50,-6.00,5.50,-2.00,-10.00,5.50,-0.50,-10.00,3.50
,2.00,10.00,0.50,4.00,6.00,0.50,-2.00,8.00,0.50
,-2.00,8.00,0.50,4.00,6.00,0.50,0.00,4.00,0.50
,-2.00,8.00,0.50,0.00,4.00,0.50,-4.00,7.00,3.50
,-4.00,7.00,3.50,0.00,4.00,0.50,-2.00,3.00,3.50
,4.00,11.00,3.50,6.00,7.00,3.50,2.00,10.00,0.50
,4.00,6.00,0.50,2.00,10.00,0.50,6.00,7.00,3.50
,-2.00,8.00,0.50,-4.00,7.00,3.50,-3.00,10.00,3.50
,2.00,10.00,0.50,1.00,12.00,3.50,4.00,11.00,3.50
,2.00,10.00,0.50,-2.00,8.00,0.50,-1.00,11.00,1.50
,-1.00,11.00,1.50,-2.00,8.00,0.50,-3.00,10.00,3.50
,1.00,12.00,3.50,2.00,10.00,0.50,-1.00,11.00,1.50
,0.00,4.00,0.50,4.00,6.00,0.50,3.00,3.00,1.50
,5.00,4.00,3.50,4.00,6.00,0.50,6.00,7.00,3.50
,1.00,2.00,3.50,-2.00,3.00,3.50,0.00,4.00,0.50
,0.00,4.00,0.50,3.00,3.00,1.50,1.00,2.00,3.50
,5.00,4.00,3.50,3.00,3.00,1.50,4.00,6.00,0.50
,0.75,-2.50,0.50,-1.50,-3.00,1.50,-0.75,0.50,0.50
,-0.75,0.50,0.50,-1.50,-3.00,1.50,-2.50,-1.00,1.50
,-0.75,0.50,0.50,-2.50,-1.00,1.50,-1.50,2.00,3.50
,-1.50,2.00,3.50,-2.50,-1.00,1.50,-3.00,0.00,3.50
,1.50,-4.00,3.50,-1.00,-4.00,3.50,0.75,-2.50,0.50
,-1.50,-3.00,1.50,0.75,-2.50,0.50,-1.00,-4.00,3.50
,-0.75,0.50,0.50,-1.50,2.00,3.50,1.00,2.00,3.50
,0.75,-2.50,0.50,3.00,-2.00,3.50,1.50,-4.00,3.50
,0.75,-2.50,0.50,-0.75,0.50,0.50,2.00,0.00,1.50
,2.00,0.00,1.50,-0.75,0.50,0.50,1.00,2.00,3.50
,3.00,-2.00,3.50,0.75,-2.50,0.50,2.00,0.00,1.50
,-2.50,-1.00,1.50,-1.50,-3.00,1.50,-4.00,-3.00,1.50
,-3.00,-5.00,3.50,-1.50,-3.00,1.50,-1.00,-4.00,3.50
,-5.00,-1.00,3.50,-3.00,0.00,3.50,-2.50,-1.00,1.50
,-2.50,-1.00,1.50,-4.00,-3.00,1.50,-5.00,-1.00,3.50
,-3.00,-5.00,3.50,-4.00,-3.00,1.50,-1.50,-3.00,1.50
,2.00,0.00,1.50,1.00,2.00,3.50,3.00,3.00,1.50
,3.00,3.00,1.50,3.00,-2.00,3.50,2.00,0.00,1.50
,3.00,3.00,1.50,5.00,4.00,3.50,3.00,-2.00,3.50
,-3.00,10.00,3.50,1.00,12.00,3.50,-1.00,11.00,1.50
,-4.00,-3.00,1.50,-3.00,-5.00,3.50,-4.50,-6.00,1.50
,-4.50,-6.00,1.50,-5.00,-1.00,3.50,-4.00,-3.00,1.50
,-5.00,-1.00,3.50,-4.50,-6.00,1.50,-6.00,-7.00,3.50
,-4.50,-10.00,3.50,-2.50,-10.00,1.50,-3.50,-12.00,2.50
,-2.50,-10.00,1.50,-0.50,-10.00,3.50,0.50,-12.00,2.00
,2.50,-12.00,3.50,0.50,-12.00,2.00,-0.50,-10.00,3.50
,-2.50,-10.00,1.50,0.50,-12.00,2.00,0.50,-12.00,0.00
,0.50,-12.00,0.00,-3.50,-12.00,2.50,-2.50,-10.00,1.50
,0.50,-12.00,2.00,-3.50,-12.00,2.50,0.50,-12.00,0.00
,-2.50,-10.00,1.50,-4.50,-10.00,3.50,-4.50,-6.00,1.50
,-4.50,-10.00,3.50,-6.00,-7.00,3.50,-4.50,-6.00,1.50
,-0.50,-10.00,3.50,-4.50,-6.00,1.50,-3.00,-5.00,3.50
,-0.50,-10.00,3.50,-2.50,-10.00,1.50,-4.50,-6.00,1.50
,0.50,-12.00,2.00,2.50,-12.00,3.50,0.50,-12.00,5.00
,0.50,-12.00,5.00,-3.50,-12.00,4.50,0.50,-12.00,2.00
,-3.50,-12.00,2.50,0.50,-12.00,2.00,-3.50,-12.00,4.50
,14.50,11.00,-5.00,14.50,5.50,-5.00,7.50,11.50,-5.00
,14.50,5.50,-5.00,7.50,5.50,-5.00,7.50,11.50,-5.00
,14.50,11.00,-5.00,7.50,14.50,0.00,14.50,14.00,0.00
,7.50,14.50,0.00,14.50,11.00,-5.00,7.50,11.50,-5.00
,7.50,5.50,-5.00,14.50,5.50,-5.00,14.50,2.50,0.00
,7.50,5.50,-5.00,14.50,2.50,0.00,7.50,2.50,0.00
,14.50,5.50,-5.00,14.50,11.00,-5.00,18.50,7.00,-2.00
,14.50,11.00,-5.00,18.50,9.00,-2.00,18.50,7.00,-2.00
,14.50,11.00,-5.00,14.50,14.00,0.00,18.50,10.00,0.00
,18.50,6.00,0.00,14.50,2.50,0.00,14.50,5.50,-5.00
,14.50,5.50,-5.00,18.50,7.00,-2.00,18.50,6.00,0.00
,14.50,11.00,-5.00,18.50,10.00,0.00,18.50,9.00,-2.00
,20.50,7.00,-2.00,18.50,7.00,-2.00,18.50,9.00,-2.00
,18.50,9.00,-2.00,20.50,9.00,-2.00,20.50,7.00,-2.00
,20.50,9.00,-2.00,18.50,9.00,-2.00,18.50,10.00,0.00
,20.50,10.00,0.00,20.50,9.00,-2.00,18.50,10.00,0.00
,20.50,6.00,0.00,18.50,6.00,0.00,18.50,7.00,-2.00
,18.50,7.00,-2.00,20.50,7.00,-2.00,20.50,6.00,0.00
,22.50,8.00,-2.00,20.50,7.00,-2.00,20.50,9.00,-2.00
,22.50,10.00,-2.00,22.50,8.00,-2.00,20.50,9.00,-2.00
,20.50,9.00,-2.00,20.50,10.00,0.00,22.50,10.00,-2.00
,22.50,7.00,0.00,20.50,6.00,0.00,20.50,7.00,-2.00
,20.50,10.00,0.00,22.50,11.00,0.00,22.50,10.00,-2.00
,22.50,8.00,-2.00,22.50,7.00,0.00,20.50,7.00,-2.00
,22.50,8.00,-2.00,22.50,10.00,-2.00,24.50,8.50,-2.00
,24.50,10.50,-2.00,24.50,8.50,-2.00,22.50,10.00,-2.00
,22.50,11.00,0.00,24.50,11.50,0.00,24.50,10.50,-2.00
,24.50,10.50,-2.00,22.50,10.00,-2.00,22.50,11.00,0.00
,24.50,8.50,-2.00,24.50,7.50,0.00,22.50,8.00,-2.00
,22.50,7.00,0.00,22.50,8.00,-2.00,24.50,7.50,0.00
,24.50,8.50,-2.00,24.50,10.50,-2.00,25.50,7.50,-2.50
,25.50,12.00,0.00,25.50,11.50,-2.50,24.50,11.50,0.00
,24.50,7.50,0.00,25.50,7.50,-2.50,25.50,7.00,0.00
,25.50,11.50,-2.50,24.50,10.50,-2.00,24.50,11.50,0.00
,24.50,7.50,0.00,24.50,8.50,-2.00,25.50,7.50,-2.50
,24.50,10.50,-2.00,25.50,11.50,-2.50,25.50,7.50,-2.50
,27.50,7.50,-2.50,25.50,7.50,-2.50,25.50,11.50,-2.50
,27.50,11.50,-2.50,27.50,7.50,-2.50,25.50,11.50,-2.50
,25.50,11.50,-2.50,25.50,12.00,0.00,27.50,11.50,-2.50
,27.50,7.50,-2.50,25.50,7.00,0.00,25.50,7.50,-2.50
,27.50,12.00,0.00,27.50,11.50,-2.50,25.50,12.00,0.00
,25.50,7.00,0.00,27.50,7.50,-2.50,27.50,7.00,0.00
,27.50,7.50,-2.50,27.50,11.50,-2.50,29.50,9.50,-1.50
,29.50,9.50,-1.50,29.50,8.00,-1.50,27.50,7.50,-2.50
,29.50,8.00,-1.50,29.50,9.50,-1.50,32.00,8.00,-1.50
,29.50,9.50,-1.50,32.00,9.50,-1.50,32.00,8.00,-1.50
,27.50,11.50,-2.50,27.50,12.00,0.00,29.50,10.00,0.00
,29.50,10.00,0.00,29.50,9.50,-1.50,27.50,11.50,-2.50
,29.50,10.00,0.00,32.00,9.50,-1.50,29.50,9.50,-1.50
,32.00,9.50,-1.50,29.50,10.00,0.00,32.00,10.00,0.00
,32.00,7.50,0.00,29.50,7.50,0.00,29.50,8.00,-1.50
,29.50,8.00,-1.50,32.00,8.00,-1.50,32.00,7.50,0.00
,29.50,7.50,0.00,27.50,7.00,0.00,27.50,7.50,-2.50
,27.50,7.50,-2.50,29.50,8.00,-1.50,29.50,7.50,0.00
,32.00,9.50,-1.50,32.00,10.00,0.00,32.50,8.50,0.00
,32.50,8.50,0.00,32.00,8.00,-1.50,32.00,9.50,-1.50
,32.50,8.50,0.00,32.00,7.50,0.00,32.00,8.00,-1.50
,1.50,14.00,0.00,7.50,14.50,0.00,7.50,11.50,-5.00
,1.50,11.50,-4.00,1.50,14.00,0.00,7.50,11.50,-5.00
,7.50,11.50,-5.00,7.50,5.50,-5.00,1.50,11.50,-4.00
,7.50,11.50,-5.00,7.50,5.50,-5.00,1.50,11.50,-4.00
,1.50,6.50,-4.00,1.50,11.50,-4.00,7.50,5.50,-5.00
,1.50,4.50,0.00,1.50,6.50,-4.00,7.50,2.50,0.00
,7.50,5.50,-5.00,7.50,2.50,0.00,1.50,6.50,-4.00
,1.50,14.00,0.00,1.50,11.50,-4.00,-4.50,13.00,0.00
,-4.50,7.50,-3.00,-4.50,11.00,-3.00,1.50,6.50,-4.00
,-4.50,6.00,0.00,-4.50,7.50,-3.00,1.50,4.50,0.00
,1.50,6.50,-4.00,1.50,4.50,0.00,-4.50,7.50,-3.00
,-4.50,11.00,-3.00,-4.50,13.00,0.00,1.50,11.50,-4.00
,1.50,11.50,-4.00,1.50,6.50,-4.00,-4.50,11.00,-3.00
,-4.50,13.00,0.00,-4.50,11.00,-3.00,-10.50,11.50,0.00
,-4.50,11.00,-3.00,-10.50,10.00,-2.50,-10.50,11.50,0.00
,-4.50,7.50,-3.00,-10.50,6.00,0.00,-10.50,7.50,-2.50
,-4.50,7.50,-3.00,-4.50,6.00,0.00,-10.50,6.00,0.00
,-4.50,7.50,-3.00,-10.50,7.50,-2.50,-10.50,10.00,-2.50
,-4.50,11.00,-3.00,-4.50,7.50,-3.00,-10.50,10.00,-2.50
,-16.50,7.00,-2.00,-16.50,8.00,-2.00,-10.50,7.50,-2.50
,-16.50,8.00,-2.00,-16.50,9.50,0.00,-10.50,10.00,-2.50
,-16.50,5.50,0.00,-16.50,7.00,-2.00,-10.50,6.00,0.00
,-16.50,7.00,-2.00,-10.50,7.50,-2.50,-10.50,6.00,0.00
,-16.50,8.00,-2.00,-10.50,10.00,-2.50,-10.50,7.50,-2.50
,-16.50,9.50,0.00,-10.50,11.50,0.00,-10.50,10.00,-2.50
,-16.50,9.50,0.00,-16.50,8.00,-2.00,-22.50,7.00,0.00
,-16.50,5.50,0.00,-22.50,4.00,0.00,-22.50,5.50,-1.50
,-22.50,5.50,-1.50,-22.50,7.00,0.00,-16.50,8.00,-2.00
,-16.50,7.00,-2.00,-16.50,5.50,0.00,-22.50,5.50,-1.50
,-16.50,8.00,-2.00,-16.50,7.00,-2.00,-22.50,5.50,-1.50
,-22.50,7.00,0.00,-22.50,5.50,-1.50,-32.00,1.00,0.00
,-32.00,1.00,0.00,-22.50,5.50,-1.50,-22.50,4.00,0.00
,7.50,11.50,5.00,14.50,5.50,5.00,14.50,11.00,5.00
,7.50,11.50,5.00,7.50,5.50,5.00,14.50,5.50,5.00
,14.50,14.00,0.00,7.50,14.50,0.00,14.50,11.00,5.00
,7.50,11.50,5.00,14.50,11.00,5.00,7.50,14.50,0.00
,14.50,2.50,0.00,14.50,5.50,5.00,7.50,5.50,5.00
,7.50,2.50,0.00,14.50,2.50,0.00,7.50,5.50,5.00
,18.50,7.00,2.00,14.50,11.00,5.00,14.50,5.50,5.00
,18.50,7.00,2.00,18.50,9.00,2.00,14.50,11.00,5.00
,18.50,10.00,0.00,14.50,14.00,0.00,14.50,11.00,5.00
,14.50,5.50,5.00,14.50,2.50,0.00,18.50,6.00,0.00
,18.50,6.00,0.00,18.50,7.00,2.00,14.50,5.50,5.00
,18.50,9.00,2.00,18.50,10.00,0.00,14.50,11.00,5.00
,18.50,9.00,2.00,18.50,7.00,2.00,20.50,7.00,2.00
,20.50,7.00,2.00,20.50,9.00,2.00,18.50,9.00,2.00
,18.50,10.00,0.00,18.50,9.00,2.00,20.50,9.00,2.00
,18.50,10.00,0.00,20.50,9.00,2.00,20.50,10.00,0.00
,18.50,7.00,2.00,18.50,6.00,0.00,20.50,6.00,0.00
,20.50,6.00,0.00,20.50,7.00,2.00,18.50,7.00,2.00
,20.50,9.00,2.00,20.50,7.00,2.00,22.50,8.00,2.00
,20.50,9.00,2.00,22.50,8.00,2.00,22.50,10.00,2.00
,22.50,10.00,2.00,20.50,10.00,0.00,20.50,9.00,2.00
,20.50,7.00,2.00,20.50,6.00,0.00,22.50,7.00,0.00
,22.50,10.00,2.00,22.50,11.00,0.00,20.50,10.00,0.00
,20.50,7.00,2.00,22.50,7.00,0.00,22.50,8.00,2.00
,24.50,8.50,2.00,22.50,10.00,2.00,22.50,8.00,2.00
,22.50,10.00,2.00,24.50,8.50,2.00,24.50,10.50,2.00
,24.50,10.50,2.00,24.50,11.50,0.00,22.50,11.00,0.00
,22.50,11.00,0.00,22.50,10.00,2.00,24.50,10.50,2.00
,22.50,8.00,2.00,24.50,7.50,0.00,24.50,8.50,2.00
,24.50,7.50,0.00,22.50,8.00,2.00,22.50,7.00,0.00
,25.50,7.50,2.50,24.50,10.50,2.00,24.50,8.50,2.00
,24.50,11.50,0.00,25.50,11.50,2.50,25.50,12.00,0.00
,25.50,7.00,0.00,25.50,7.50,2.50,24.50,7.50,0.00
,24.50,11.50,0.00,24.50,10.50,2.00,25.50,11.50,2.50
,25.50,7.50,2.50,24.50,8.50,2.00,24.50,7.50,0.00
,25.50,7.50,2.50,25.50,11.50,2.50,24.50,10.50,2.00
,25.50,11.50,2.50,25.50,7.50,2.50,27.50,7.50,2.50
,25.50,11.50,2.50,27.50,7.50,2.50,27.50,11.50,2.50
,27.50,11.50,2.50,25.50,12.00,0.00,25.50,11.50,2.50
,25.50,7.50,2.50,25.50,7.00,0.00,27.50,7.50,2.50
,25.50,12.00,0.00,27.50,11.50,2.50,27.50,12.00,0.00
,27.50,7.00,0.00,27.50,7.50,2.50,25.50,7.00,0.00
,29.50,9.50,1.50,27.50,11.50,2.50,27.50,7.50,2.50
,27.50,7.50,2.50,29.50,8.00,1.50,29.50,9.50,1.50
,32.00,8.00,1.50,29.50,9.50,1.50,29.50,8.00,1.50
,32.00,8.00,1.50,32.00,9.50,1.50,29.50,9.50,1.50
,29.50,10.00,0.00,27.50,12.00,0.00,27.50,11.50,2.50
,27.50,11.50,2.50,29.50,9.50,1.50,29.50,10.00,0.00
,29.50,9.50,1.50,32.00,9.50,1.50,29.50,10.00,0.00
,32.00,10.00,0.00,29.50,10.00,0.00,32.00,9.50,1.50
,29.50,8.00,1.50,29.50,7.50,0.00,32.00,7.50,0.00
,32.00,7.50,0.00,32.00,8.00,1.50,29.50,8.00,1.50
,27.50,7.50,2.50,27.50,7.00,0.00,29.50,7.50,0.00
,29.50,7.50,0.00,29.50,8.00,1.50,27.50,7.50,2.50
,32.50,8.50,0.00,32.00,10.00,0.00,32.00,9.50,1.50
,32.00,9.50,1.50,32.00,8.00,1.50,32.50,8.50,0.00
,32.00,8.00,1.50,32.00,7.50,0.00,32.50,8.50,0.00
,7.50,11.50,5.00,7.50,14.50,0.00,1.50,14.00,0.00
,7.50,11.50,5.00,1.50,14.00,0.00,1.50,11.50,4.00
,1.50,11.50,4.00,7.50,5.50,5.00,7.50,11.50,5.00
,1.50,11.50,4.00,7.50,5.50,5.00,7.50,11.50,5.00
,7.50,5.50,5.00,1.50,11.50,4.00,1.50,6.50,4.00
,7.50,2.50,0.00,1.50,6.50,4.00,1.50,4.50,0.00
,1.50,6.50,4.00,7.50,2.50,0.00,7.50,5.50,5.00
,-4.50,13.00,0.00,1.50,11.50,4.00,1.50,14.00,0.00
,1.50,6.50,4.00,-4.50,11.00,3.00,-4.50,7.50,3.00
,1.50,4.50,0.00,-4.50,7.50,3.00,-4.50,6.00,0.00
,-4.50,7.50,3.00,1.50,4.50,0.00,1.50,6.50,4.00
,1.50,11.50,4.00,-4.50,13.00,0.00,-4.50,11.00,3.00
,-4.50,11.00,3.00,1.50,6.50,4.00,1.50,11.50,4.00
,-10.50,11.50,0.00,-4.50,11.00,3.00,-4.50,13.00,0.00
,-10.50,11.50,0.00,-10.50,10.00,2.50,-4.50,11.00,3.00
,-10.50,7.50,2.50,-10.50,6.00,0.00,-4.50,7.50,3.00
,-10.50,6.00,0.00,-4.50,6.00,0.00,-4.50,7.50,3.00
,-10.50,10.00,2.50,-10.50,7.50,2.50,-4.50,7.50,3.00
,-10.50,10.00,2.50,-4.50,7.50,3.00,-4.50,11.00,3.00
,-10.50,7.50,2.50,-16.50,8.00,2.00,-16.50,7.00,2.00
,-10.50,10.00,2.50,-16.50,9.50,0.00,-16.50,8.00,2.00
,-10.50,6.00,0.00,-16.50,7.00,2.00,-16.50,5.50,0.00
,-10.50,6.00,0.00,-10.50,7.50,2.50,-16.50,7.00,2.00
,-10.50,7.50,2.50,-10.50,10.00,2.50,-16.50,8.00,2.00
,-10.50,10.00,2.50,-10.50,11.50,0.00,-16.50,9.50,0.00
,-22.50,7.00,0.00,-16.50,8.00,2.00,-16.50,9.50,0.00
,-22.50,5.50,1.50,-22.50,4.00,0.00,-16.50,5.50,0.00
,-16.50,8.00,2.00,-22.50,7.00,0.00,-22.50,5.50,1.50
,-22.50,5.50,1.50,-16.50,5.50,0.00,-16.50,7.00,2.00
,-22.50,5.50,1.50,-16.50,7.00,2.00,-16.50,8.00,2.00
,-32.00,1.00,0.00,-22.50,5.50,1.50,-22.50,7.00,0.00
,-22.50,4.00,0.00,-22.50,5.50,1.50,-32.00,1.00,0.00
,15.00,1.00,-3.50,15.00,1.00,-4.50,15.00,5.00,-4.50
,15.00,5.00,-4.50,15.00,5.00,-3.50,15.00,1.00,-3.50
,14.00,1.00,-3.00,15.00,1.00,-3.50,15.00,5.00,-3.50
,15.00,5.00,-3.50,14.00,5.00,-3.00,14.00,1.00,-3.00
,15.00,5.00,-4.50,15.00,1.00,-4.50,14.00,5.00,-5.00
,14.00,1.00,-5.00,14.00,5.00,-5.00,15.00,1.00,-4.50
,13.00,1.00,-4.50,13.00,1.00,-3.50,13.00,5.00,-3.50
,13.00,5.00,-3.50,13.00,5.00,-4.50,13.00,1.00,-4.50
,14.00,1.00,-5.00,13.00,1.00,-4.50,13.00,5.00,-4.50
,13.00,5.00,-4.50,14.00,5.00,-5.00,14.00,1.00,-5.00
,13.00,5.00,-3.50,13.00,1.00,-3.50,14.00,5.00,-3.00
,14.00,1.00,-3.00,14.00,5.00,-3.00,13.00,1.00,-3.50
,18.50,1.00,-3.50,18.50,1.00,-4.50,15.00,1.00,-4.50
,15.00,1.00,-4.50,15.00,1.00,-3.50,18.50,1.00,-3.50
,18.50,0.00,-3.00,18.50,1.00,-3.50,15.00,1.00,-3.50
,15.00,1.00,-3.50,15.00,0.00,-3.00,18.50,0.00,-3.00
,15.00,1.00,-4.50,18.50,1.00,-4.50,15.00,0.00,-5.00
,18.50,0.00,-5.00,15.00,0.00,-5.00,18.50,1.00,-4.50
,15.00,-1.00,-4.50,15.00,0.00,-5.00,18.50,0.00,-5.00
,15.00,0.00,-5.00,14.00,1.00,-5.00,15.00,1.00,-4.50
,15.00,1.00,-3.50,14.00,1.00,-3.00,15.00,0.00,-3.00
,15.00,0.00,-5.00,13.00,1.00,-4.50,14.00,1.00,-5.00
,13.00,1.00,-4.50,15.00,0.00,-5.00,15.00,-1.00,-4.50
,15.00,-1.00,-3.50,15.00,0.00,-3.00,14.00,1.00,-3.00
,14.00,1.00,-3.00,13.00,1.00,-3.50,15.00,-1.00,-3.50
,13.00,1.00,-3.50,13.00,1.00,-4.50,15.00,-1.00,-4.50
,15.00,-1.00,-4.50,15.00,-1.00,-3.50,13.00,1.00,-3.50
,15.00,-1.00,-4.50,18.50,0.00,-5.00,18.50,0.00,-3.00
,18.50,0.00,-3.00,15.00,-1.00,-3.50,15.00,-1.00,-4.50
,18.50,1.00,-4.50,21.00,1.00,-5.00,20.50,0.00,-5.50
,20.50,0.00,-5.50,18.50,0.00,-5.00,18.50,1.00,-4.50
,15.00,-1.00,-3.50,18.50,0.00,-3.00,15.00,0.00,-3.00
,18.50,0.00,-3.00,20.50,0.00,-2.50,21.00,1.00,-3.00
,18.50,1.00,-3.50,18.50,0.00,-3.00,21.00,1.00,-3.00
,21.50,1.00,-4.00,21.00,1.00,-5.00,18.50,1.00,-4.50
,18.50,1.00,-4.50,18.50,1.00,-3.50,21.50,1.00,-4.00
,18.50,1.00,-3.50,21.00,1.00,-3.00,21.50,1.00,-4.00
,21.00,1.00,-5.00,21.50,1.00,-4.00,21.50,0.00,-4.50
,21.50,0.00,-3.50,21.50,1.00,-4.00,21.00,1.00,-3.00
,18.50,0.00,-3.00,18.50,0.00,-5.00,21.50,0.00,-4.50
,18.50,0.00,-3.00,21.50,0.00,-4.50,21.50,0.00,-3.50
,18.50,0.00,-5.00,20.50,0.00,-5.50,21.50,0.00,-4.50
,21.50,0.00,-3.50,20.50,0.00,-2.50,18.50,0.00,-3.00
,23.50,0.00,-4.00,21.50,0.00,-4.50,21.50,1.00,-4.00
,21.50,1.00,-4.00,21.50,0.00,-3.50,23.50,0.00,-4.00
,22.50,0.00,-2.50,21.50,0.00,-3.50,21.00,1.00,-3.00
,22.50,0.00,-2.50,21.00,1.00,-3.00,20.50,0.00,-2.50
,22.50,0.00,-5.50,20.50,0.00,-5.50,21.00,1.00,-5.00
,21.00,1.00,-5.00,21.50,0.00,-4.50,22.50,0.00,-5.50
,23.50,0.00,-4.00,21.50,0.00,-3.50,21.50,0.00,-4.50
,22.50,0.00,-5.50,21.50,0.00,-4.50,20.50,0.00,-5.50
,20.50,0.00,-2.50,21.50,0.00,-3.50,22.50,0.00,-2.50
,14.00,5.00,-5.00,13.00,5.00,-4.50,14.00,6.00,-4.00
,15.00,5.00,-4.50,14.00,5.00,-5.00,14.00,6.00,-4.00
,14.00,6.00,-4.00,15.00,5.00,-3.50,15.00,5.00,-4.50
,14.00,6.00,-4.00,14.00,5.00,-3.00,15.00,5.00,-3.50
,14.00,6.00,-4.00,13.00,5.00,-4.50,13.00,5.00,-3.50
,14.00,6.00,-4.00,13.00,5.00,-3.50,14.00,5.00,-3.00
,15.00,1.00,4.50,15.00,1.00,3.50,15.00,5.00,3.50
,15.00,5.00,3.50,15.00,5.00,4.50,15.00,1.00,4.50
,14.00,1.00,5.00,15.00,1.00,4.50,15.00,5.00,4.50
,15.00,5.00,4.50,14.00,5.00,5.00,14.00,1.00,5.00
,15.00,5.00,3.50,15.00,1.00,3.50,14.00,5.00,3.00
,14.00,1.00,3.00,14.00,5.00,3.00,15.00,1.00,3.50
,13.00,1.00,3.50,13.00,1.00,4.50,13.00,5.00,4.50
,13.00,5.00,4.50,13.00,5.00,3.50,13.00,1.00,3.50
,14.00,1.00,3.00,13.00,1.00,3.50,13.00,5.00,3.50
,13.00,5.00,3.50,14.00,5.00,3.00,14.00,1.00,3.00
,13.00,5.00,4.50,13.00,1.00,4.50,14.00,5.00,5.00
,14.00,1.00,5.00,14.00,5.00,5.00,13.00,1.00,4.50
,18.50,1.00,4.50,18.50,1.00,3.50,15.00,1.00,3.50
,15.00,1.00,3.50,15.00,1.00,4.50,18.50,1.00,4.50
,18.50,0.00,5.00,18.50,1.00,4.50,15.00,1.00,4.50
,15.00,1.00,4.50,15.00,0.00,5.00,18.50,0.00,5.00
,15.00,1.00,3.50,18.50,1.00,3.50,15.00,0.00,3.00
,18.50,0.00,3.00,15.00,0.00,3.00,18.50,1.00,3.50
,15.00,-1.00,3.50,15.00,0.00,3.00,18.50,0.00,3.00
,15.00,0.00,3.00,14.00,1.00,3.00,15.00,1.00,3.50
,15.00,1.00,4.50,14.00,1.00,5.00,15.00,0.00,5.00
,15.00,0.00,3.00,13.00,1.00,3.50,14.00,1.00,3.00
,13.00,1.00,3.50,15.00,0.00,3.00,15.00,-1.00,3.50
,15.00,-1.00,4.50,15.00,0.00,5.00,14.00,1.00,5.00
,14.00,1.00,5.00,13.00,1.00,4.50,15.00,-1.00,4.50
,13.00,1.00,4.50,13.00,1.00,3.50,15.00,-1.00,3.50
,15.00,-1.00,3.50,15.00,-1.00,4.50,13.00,1.00,4.50
,15.00,-1.00,3.50,18.50,0.00,3.00,18.50,0.00,5.00
,18.50,0.00,5.00,15.00,-1.00,4.50,15.00,-1.00,3.50
,18.50,1.00,3.50,21.00,1.00,3.00,20.50,0.00,2.50
,20.50,0.00,2.50,18.50,0.00,3.00,18.50,1.00,3.50
,15.00,-1.00,4.50,18.50,0.00,5.00,15.00,0.00,5.00
,18.50,0.00,5.00,20.50,0.00,5.50,21.00,1.00,5.00
,18.50,1.00,4.50,18.50,0.00,5.00,21.00,1.00,5.00
,21.50,1.00,4.00,21.00,1.00,3.00,18.50,1.00,3.50
,18.50,1.00,3.50,18.50,1.00,4.50,21.50,1.00,4.00
,18.50,1.00,4.50,21.00,1.00,5.00,21.50,1.00,4.00
,21.00,1.00,3.00,21.50,1.00,4.00,21.50,0.00,3.50
,21.50,0.00,4.50,21.50,1.00,4.00,21.00,1.00,5.00
,18.50,0.00,5.00,18.50,0.00,3.00,21.50,0.00,3.50
,18.50,0.00,5.00,21.50,0.00,3.50,21.50,0.00,4.50
,18.50,0.00,3.00,20.50,0.00,2.50,21.50,0.00,3.50
,21.50,0.00,4.50,20.50,0.00,5.50,18.50,0.00,5.00
,23.50,0.00,4.00,21.50,0.00,3.50,21.50,1.00,4.00
,21.50,1.00,4.00,21.50,0.00,4.50,23.50,0.00,4.00
,22.50,0.00,5.50,21.50,0.00,4.50,21.00,1.00,5.00
,22.50,0.00,5.50,21.00,1.00,5.00,20.50,0.00,5.50
,22.50,0.00,2.50,20.50,0.00,2.50,21.00,1.00,3.00
,21.00,1.00,3.00,21.50,0.00,3.50,22.50,0.00,2.50
,23.50,0.00,4.00,21.50,0.00,4.50,21.50,0.00,3.50
,22.50,0.00,2.50,21.50,0.00,3.50,20.50,0.00,2.50
,20.50,0.00,5.50,21.50,0.00,4.50,22.50,0.00,5.50
,14.00,5.00,3.00,13.00,5.00,3.50,14.00,6.00,4.00
,15.00,5.00,3.50,14.00,5.00,3.00,14.00,6.00,4.00
,14.00,6.00,4.00,15.00,5.00,4.50,15.00,5.00,3.50
,14.00,6.00,4.00,14.00,5.00,5.00,15.00,5.00,4.50
,14.00,6.00,4.00,13.00,5.00,3.50,13.00,5.00,4.50
,14.00,6.00,4.00,13.00,5.00,4.50,14.00,5.00,5.00
,-4.50,-10.00,-3.50,-3.50,-12.00,-4.50,-3.50,-12.00,-2.50
,-3.50,-12.00,2.50,-3.50,-12.00,4.50,-4.50,-10.00,3.50
};


/* LOAD MODEL - nastily hacked with hardcoded models */

void mdl_load (mdl_t * self, char * fn)
{
    int i, j;
    FILE * fptr;

/*
    fptr = fopen (fn, "rt");

    if (fptr == NULL)
    {
        self->frame_count = 0;
        self->vert_count  = 0;
        return;
    }

    self->frame_count = get_int_value (fptr, "frame_count");
    self->vert_count  = get_int_value (fptr, "vert_count");
*/

self->frame_count = 1;
self->vert_count  = 1494;

    mdl_new (self, self->vert_count, self->frame_count);

    if (self->vert_count == 0)  {/* fclose (fptr); */  return;}

    for (i=0,j=0; i<self->vert_count*3; i+=3,j+=1)
    {
        self->verts[j].x = raw [i];
        self->verts[j].y = raw [i+1] * -1;
        self->verts[j].z = raw [i+2];
    }

    /* fclose (fptr); */
}


/* CREATE NEW MODEL - nastily hacked with hardcoded models */

void mdl_new (mdl_t * self, int v, int f)
{
    if (self->verts != NULL) free (self->verts);

    self->frame_count = f;
    self->vert_count  = v;
    self->verts       = malloc (v * f * sizeof(V3D_f));

    if (self->verts == NULL)
    {
        self->frame_count = 0;
        self->vert_count  = 0;
    }
}


/* PERSPECTIVE PROJECTION */

void mdl_proj (mdl_t * self, float z)
{
    int i;
    float temp;

    if (self->vert_count == 0) return;

    for (i=0; i<self->vert_count; i++)
    {
        temp = self->verts[i].z;

        if (z + temp > 1)
        {
            self->verts[i].x *= z / (z + temp);
            self->verts[i].y *= z / (z + temp);
        }
        else
        {
            self->verts[i].x *= z;
            self->verts[i].y *= z;
        }
    }
}

int get_int_value (FILE * fptr, char * key)
{
    char string [81];
    int value;

    rewind (fptr);

    while (!feof(fptr))
    {
        fscanf (fptr, "%s\n", string);

        if (strcmp (string, key) == 0)
        {
            fscanf (fptr, "=%i\n", &value);
            return value;
        }
    }

    return 0;
}


