/*
    Copyright (C) 1999 by Seth Galbraith

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SQUAWK_H
#define SQUAWK_H

#include "cssys/common/sysdriv.h"
#include "csengine/cssprite.h"
#include "csgeom/math3d.h"
#include "csutil/csvector.h"
#include "sqkview.h"

class csWorld;

class csSprite3DVector : public csVector
{
  bool FreeItem (csSome item)
  {
    if (item) delete (csSprite3D *) item;
    return true;
  }
};

class sqkViewVector : public csVector
{
  bool FreeItem (csSome item)
  {
    if (item) delete (sqkView *) item;
    return true;
  }
};

class sqkSystem : public SysSystemDriver
{
  public:

    csWorld* world;
    sqkViewVector views;
    csSprite3DVector sprites;
    long frameTime;

    /// @@@ create a squawk or crystal space sky box class
    csSector * skybox;

  public:

    sqkSystem ();
    virtual ~sqkSystem ();

    void InitApp ();
    virtual void NextFrame (long elapsed_time, long current_time);
    void eatkeypress (int key, bool shift, bool alt, bool ctrl);

    sqkView* GetView (int v)
      {return (v < views.Length ()) ? (sqkView*)views [v] : (sqkView*)NULL;}
    csSprite3D* GetSprite (int s)
      {return (s < sprites.Length ()) ? (csSprite3D*)sprites [s] : (csSprite3D*)NULL;}

    void CreateSkyBox ();
    void CreateViews ();
    void AddSprite (char* mesh, char* skin, char* skinname,
      float x, float y, float z, float scale, bool lit);
};

#endif /*SQUAWK_H*/
