/*
    Copyright (C) 1999 by Seth Galbraith

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SQKVIEW_H
#define SQKVIEW_H

#include "csengine/sector.h"
#include "csengine/csview.h"

class csViewVector : public csVector
{
  bool FreeItem (csSome item)
  {
    if (item) delete (csView *) item;
    return true;
  }
};

/**
 * A viewport that doesn't have to be convex or even contiguous,
 * made up of multiple convex views
 */
class sqkView
{
  public:

    csViewVector views;

    /**
     * Set to FrameWidth and FrameHeight so that FOV, center and
     * clipping polygons are set relative to the screen size.
     * 0,0 is the lower left corner, and 1,1 is the upper right corner.
     */
    int width, height;

    /**
     * If true (it is by default), this view rotates intuitively.
     * Left and right rotation is always around the world's Y axis.
     * @@@ this should be replaced by a gravity axis or something.
     * Left and right are reversed when the camera is upside down.
     * If false, left and right rotation is around the view's Y axis.
     */
    bool gravity;

  public:

    sqkView();
    ~sqkView();

    /// Add a convex view.
    void AddView (csView * v);

    /// Get a convex view by index.
    csView* GetView (int v)
      {return (v < views.Length ()) ? (csView*)views [v] : (csView*)NULL;}

    /**
     * set the FrameWidth and FrameHeight to csSystemDriver's values.
     * @@@ Not sure the logic of this system is sound,
     * @@@ but it seems the only way to know FrameWidth and FrameHeight.
     */
    void SetSize (int w, int h) { width = w;  height = h; }

    /**
     * Add a vertex to a view clipping polygon in relative coordinates.
     * 0,0 is the lower left corner, and 1,1 is the upper right corner.
     */
    void AddVertex (int v, float x, float y);

    /**
     * Set the center of the view on the screen in relative coordinates.
     * 0,0 is the lower left corner, and 1,1 is the upper right corner.
     */
    void SetCenter (float x, float y);

    /**
     * Relative rotation, measured in radians. (180 degrees = pi * radians)
     * v.x = pitch = looking up and down
     * v.y = yaw   = turning left and right
     * v.z = roll  = leaning left and right
     * @@@ gravity has no effect if you don't use VEC_ROT_LEFT or VEC_ROT_RIGHT
     */
    void Rotate (const csVector3& v, float speed);

    /// Set the feild-of-view relative to the height of the screen
    void SetFOV (float f);


    void SetSector (csSector * s);
    void SetPosition (const csVector3& v);
    void Draw ();
};

#endif /*SQKVIEW_H*/
