/*
    Copyright (C) 1999 by Seth Galbraith

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "sysdef.h"
#include "sqkview.h"
#include "csengine/csview.h"

sqkView::sqkView()
{
  gravity = true;
}

sqkView::~sqkView()
{
}

void sqkView::AddView (csView * v)
{
  views.Push (v);
}

void sqkView::AddVertex (int v, float x, float y)
{
  GetView(v)->AddViewVertex (int(x * width), int(y * height));
}

void sqkView::Rotate (const csVector3& v, float speed)
{
  csCamera * c;
  for (int i=0; i < views.Length(); i++)
  {
    c = GetView(i)->GetCamera();
    if (gravity)
    {
      if (v.x || v.z) c->Rotate (csVector3 (v.x,0,v.z), speed);
      if (v.y)
      {
        if (c->GetW2C().Col2().y < 0) // upside down (-:
          c->RotateWorld (csVector3 (0,-(v.y),0), speed);
        else c->RotateWorld (csVector3 (0,v.y,0), speed);
      }
    }
    else c->Rotate(v,speed);
  }
}

void sqkView::SetCenter (float x, float y)
{
  for (int i=0; i < views.Length(); i++)
    GetView(i)->SetPerspectiveCenter (width * x, height * y);
}

void sqkView::SetSector (csSector * s)
{
  for (int i=0; i < views.Length(); i++)
    GetView(i)->SetSector (s);
}

void sqkView::SetPosition (const csVector3 & v)
{
  for (int i=0; i < views.Length(); i++)
    GetView(i)->GetCamera ()->SetPosition (v);
}

void sqkView::SetFOV (float f)
{
  for (int i=0; i < views.Length(); i++)
    GetView(i)->GetCamera ()->SetFOV ((int)(f * height));
}

void sqkView::Draw ()
{
  for (int i=0; i < views.Length(); i++)
    GetView(i)->Draw();
}
