/*
    Copyright (C) 1999 by Seth Galbraith

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cssys/common/sysdriv.h"
#include "csgeom/math3d.h"

class csWorld;
class csView;
class csSprite3D;

class SqkSystem : public SysSystemDriver
{
  public:
    csWorld* world;
    csView* view [4];
    bool linkedViews;
    csSprite3D * sprite [1];
    long frameTime;

  public:
    SqkSystem ();
    virtual ~SqkSystem ();

    void InitApp ();

    virtual void NextFrame (long elapsed_time, long current_time);
    void eatkeypress (int key, bool shift, bool alt, bool ctrl);

    void RotateView (int i, const csVector3& v, float speed);
};
