// mdl Quake to sprite3d CrystalSpace

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mdl.h"

bool WriteSPR(char *spritename, Mdl mdl, float scaleMdl, int delayMdl,
  float positionMdlX, float positionMdlY, float positionMdlZ,
  bool actionNamingMdl, bool resizeSkin, bool altFormat);

int main(int ac, char ** av)
{
  float scaleMdl = 0.025f;
  int delayMdl = 100;
  float positionMdlX = 0.0;
  float positionMdlY = 0.0;
  float positionMdlZ = 0.0;
  bool actionNamingMdl = true;
  bool resizeSkin = true;
  bool altFormat = false;

  bool help = false;

  fprintf(stdout, "mdl2spr version 0.31\n");
  fprintf(stdout, "\tA quake model convertor for CrystalSpace.\n");
  fprintf(stdout, "\t\tby NooTe (noote@bigfoot.com)\n\n");

  if(ac>3)
  {
    for(int i=1; i<ac-2; i++)
    {
      if(av[i][0]!='-' && av[i][0]!='/')
      {
        fprintf(stderr, "'%s' unreconized option\n", av[i]);
        help=true;
        break;
      }
      switch(av[i][1])
      {
      case 'h':
      case '?':
        {
          help = true;
        }
        break;

      case 'n':
        {
          actionNamingMdl = (actionNamingMdl)?false:true;
          fprintf(stdout, "%s auto naming of action frameset.\n", (actionNamingMdl)?"enable":"disable");
        }
        break;

      case 's':
        {
          float temp = atof(av[i+1]);
          if(temp==0.0)
          {
            fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
            help = true;
          }
          else
          {
            scaleMdl = temp;
            i++;
            fprintf(stdout, "set to %.3f general scale.\n", scaleMdl);
          }
        }
        break;

      case 'd':
        {
          int temp = atoi(av[i+1]);
          if(temp==0)
          {
            fprintf(stderr, "cannot convert %s to a valid int !\n", av[i+1]);
            help = true;
          }
          else
          {
            delayMdl = temp;
            i++;
            fprintf(stdout, "set to %i frame delay.\n", delayMdl);
          }
        }
        break;

      case 'x':
        {
          float temp = atof(av[i+1]);
          if(temp==0.0)
          {
            fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
            help = true;
          }
          else
          {
            positionMdlX = temp;
            i++;
            fprintf(stdout, "set to %.3f moving X axe position.\n", positionMdlX);
          }
        }
        break;

      case 'y':
        {
          float temp = atof(av[i+1]);
          if(temp==0.0)
          {
            fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
            help = true;
          }
          else
          {
            positionMdlY = temp;
            i++;
            fprintf(stdout, "set to %.3f moving Y axe position.\n", positionMdlY);
          }
        }
        break;

      case 'z':
        {
          float temp = atof(av[i+1]);
          if(temp==0.0)
          {
            fprintf(stderr, "cannot convert %s to a valid float !\n", av[i+1]);
            help = true;
          }
          else
          {
            positionMdlZ = temp;
            i++;
            fprintf(stdout, "set to %.3f moving Z axe position.\n", positionMdlZ);
          }
        }
        break;

      case 'r':
        {
          resizeSkin = (resizeSkin)?false:true;
          fprintf(stdout, "%s automatic power-of-2 skin resizing.\n", (resizeSkin)?"enable":"disable");
        }
        break;

      case 'a':
        {
          altFormat = (altFormat)?false:true;
          fprintf(stdout, "%s alternate sprite format.\n", (altFormat)?"enable":"disable");
        }
        break;

      default:
        {
          fprintf(stderr, "'%s' unreconized option !\n", av[i]);
          help=true;
        }
        break;
      }

      if(help) break;
    }
  }
  else if (ac<3) help = true;

  if(help)
  {
    fprintf(stdout, "\nmdl2spr <option> [mdl file] [sprite name]\n");
    fprintf(stdout, "\toptions :\n");
    fprintf(stdout, "\t\t-h : help (this page)\n");
    fprintf(stdout, "\t\t-s [float] : global scale of mdl (default %.3f)\n", scaleMdl);
    fprintf(stdout, "\t\t-d [int] : frame delay for frames which don't have delay (default %d)\n", delayMdl);
    fprintf(stdout, "\t\t-n : %s auto naming of action frameset (%s by default)\n", (!actionNamingMdl)?"enable":"disable", (actionNamingMdl)?"enable":"disable");
    fprintf(stdout, "\t\t-x [float] : sprite moving on X axis (default %.3f)\n", positionMdlX);
    fprintf(stdout, "\t\t-y [float] : sprite moving on Y axis (default %.3f)\n", positionMdlY);
    fprintf(stdout, "\t\t-z [float] : sprite moving on Z axis (default %.3f)\n", positionMdlZ);
    fprintf(stdout, "\t\t-r : %s automatic power-of-2 skin resizing (%s by default)\n", (!resizeSkin)?"enable":"disable", (resizeSkin)?"enable":"disable");
    fprintf(stdout, "\t\t-a : %s alternate sprite format (%s by default)\n", (!altFormat)?"enable":"disable", (altFormat)?"enable":"disable");
    return -1;
  }

  Mdl mdl(av[ac-2]);
  
  if(mdl.getError())
  {
    fprintf(stderr, "\nerror : %s !\n", mdl.getErrorString());
    exit(-1);
  }
  
  fprintf(stdout, "\nQuake Model %s have :\n", av[ac-1]);
  fprintf(stdout, "\t %d Skin%s\n", mdl.nbskins, (mdl.nbskins>1)?"s":"");
  fprintf(stdout, "\t %d Frame%s\n", mdl.nbframesets, (mdl.nbframesets>1)?"s":"");
  fprintf(stdout, "\t %d Triangle%s\n", mdl.nbtriangles, (mdl.nbtriangles>1)?"s":"");
  fprintf(stdout, "\t %d Vertice%s\n\n", mdl.nbvertices, (mdl.nbvertices>1)?"s":"");
  
  WriteSPR(av[ac-1], mdl, scaleMdl, delayMdl,
    positionMdlX, positionMdlY, positionMdlZ,
    actionNamingMdl, resizeSkin, altFormat);
  return 1;
}