#ifndef __LCC_WINCRYPT
#define __LCC_WINCRYPT
#ifdef UNICODE
#define CryptAcquireContext CryptAcquireContextW
#define CryptSignHash CryptSignHashW
#define CryptVerifySignature CryptVerifySignatureW
#define CryptSetProvider CryptSetProviderW
#define MS_DEF_PROV MS_DEF_PROV_W
#else
#define CryptAcquireContext CryptAcquireContextA
#define CryptSignHash CryptSignHashA
#define CryptVerifySignature CryptVerifySignatureA
#define CryptSetProvider CryptSetProviderA
#define MS_DEF_PROV MS_DEF_PROV_A
#endif 
#define GET_ALG_CLASS(x) (x & (7 << 13))
#define GET_ALG_TYPE(x) (x & (15 << 9))
#define GET_ALG_SID(x) (x & (511))
#define ALG_CLASS_ANY (0)
#define ALG_CLASS_SIGNATURE (1 << 13)
#define ALG_CLASS_MSG_ENCRYPT (2 << 13)
#define ALG_CLASS_DATA_ENCRYPT (3 << 13)
#define ALG_CLASS_HASH (4 << 13)
#define ALG_CLASS_KEY_EXCHANGE (5 << 13)
#define ALG_TYPE_ANY (0)
#define ALG_TYPE_DSS (1 << 9)
#define ALG_TYPE_RSA (2 << 9)
#define ALG_TYPE_BLOCK (3 << 9)
#define ALG_TYPE_STREAM (4 << 9)
#define ALG_SID_ANY (0)
#define ALG_SID_RSA_ANY 0
#define ALG_SID_RSA_PKCS 1
#define ALG_SID_RSA_MSATWORK 2
#define ALG_SID_RSA_ENTRUST 3
#define ALG_SID_RSA_PGP 4
#define ALG_SID_DSS_ANY 0
#define ALG_SID_DSS_PKCS 1
#define ALG_SID_DSS_DMS 2
#define ALG_SID_DES 1
#define ALG_SID_RC2 2
#define ALG_SID_RC4 1
#define ALG_SID_SEAL 2
#define ALG_SID_MD2 1
#define ALG_SID_MD4 2
#define ALG_SID_MD5 3
#define ALG_SID_SHA 4
#define ALG_SID_MAC 5
#define ALG_SID_EXAMPLE 80
#ifndef ALGIDDEF
#define ALGIDDEF
typedef unsigned int ALG_ID;
#endif
#define CALG_MD2 (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD2)
#define CALG_MD4 (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD4)
#define CALG_MD5 (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MD5)
#define CALG_SHA (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_SHA)
#define CALG_MAC (ALG_CLASS_HASH | ALG_TYPE_ANY | ALG_SID_MAC)
#define CALG_RSA_SIGN (ALG_CLASS_SIGNATURE | ALG_TYPE_RSA | ALG_SID_RSA_ANY)
#define CALG_DSS_SIGN (ALG_CLASS_SIGNATURE | ALG_TYPE_DSS | ALG_SID_DSS_ANY)
#define CALG_RSA_KEYX (ALG_CLASS_KEY_EXCHANGE|ALG_TYPE_RSA|ALG_SID_RSA_ANY)
#define CALG_DES (ALG_CLASS_DATA_ENCRYPT|ALG_TYPE_BLOCK|ALG_SID_DES)
#define CALG_RC2 (ALG_CLASS_DATA_ENCRYPT|ALG_TYPE_BLOCK|ALG_SID_RC2)
#define CALG_RC4 (ALG_CLASS_DATA_ENCRYPT|ALG_TYPE_STREAM|ALG_SID_RC4)
#define CALG_SEAL (ALG_CLASS_DATA_ENCRYPT|ALG_TYPE_STREAM|ALG_SID_SEAL)
typedef struct _VTableProvStruc { FARPROC FuncVerifyImage; } VTableProvStruc, *PVTableProvStruc;
typedef unsigned long HCRYPTPROV;
typedef unsigned long HCRYPTKEY;
typedef unsigned long HCRYPTHASH;
#define CRYPT_VERIFYCONTEXT 0xF0000000
#define CRYPT_NEWKEYSET 0x8
#define CRYPT_DELETEKEYSET 0x10
#define CRYPT_EXPORTABLE 1
#define CRYPT_USER_PROTECTED 2
#define CRYPT_CREATE_SALT 4
#define CRYPT_UPDATE_KEY 8
#define SIMPLEBLOB 1
#define PUBLICKEYBLOB 6
#define AT_KEYEXCHANGE 1
#define AT_SIGNATURE 2
#define CRYPT_USERDATA 1
#define KP_IV 1 
#define KP_SALT 2 
#define KP_PADDING 3 
#define KP_MODE 4 
#define KP_MODE_BITS 5 
#define KP_PERMISSIONS 6 
#define KP_ALGID 7 
#define KP_BLOCKLEN 8 
#define PKCS5_PADDING 1 
#define CRYPT_MODE_CBC 1 
#define CRYPT_MODE_ECB 2 
#define CRYPT_MODE_OFB 3 
#define CRYPT_MODE_CFB 4 
#define CRYPT_MODE_CTS 5 
#define CRYPT_ENCRYPT 1 
#define CRYPT_DECRYPT 2 
#define CRYPT_EXPORT 4 
#define CRYPT_READ 8 
#define CRYPT_WRITE 16 
#define CRYPT_MAC 32 
#define HP_ALGID 1 
#define HP_HASHVAL 2 
#define HP_HASHSIZE 4 
#define CRYPT_FAILED FALSE
#define CRYPT_SUCCEED TRUE
#define RCRYPT_SUCCEEDED(rt) ((rt) == CRYPT_SUCCEED)
#define RCRYPT_FAILED(rt) ((rt) == CRYPT_FAILED)
#define PP_ENUMALGS 1
#define PP_ENUMCONTAINERS 2
#define PP_IMPTYPE 3
#define PP_NAME 4
#define PP_VERSION 5
#define PP_CONTAINER 6
#define CRYPT_FIRST 1
#define CRYPT_NEXT 2
#define CRYPT_IMPL_HARDWARE 1
#define CRYPT_IMPL_SOFTWARE 2
#define CRYPT_IMPL_MIXED 3
#define CRYPT_IMPL_UNKNOWN 4
#define PROV_RSA_FULL 1
#define PROV_RSA_SIG 2
#define PROV_DSS 3
#define PROV_FORTEZZA 4
#define PROV_MS_MAIL 5
#define PROV_SSL 6
#define PROV_STT_MER 7
#define PROV_STT_ACQ 8
#define PROV_STT_BRND 9
#define PROV_STT_ROOT 10
#define PROV_STT_ISS 11
#define MS_DEF_PROV_A "Microsoft Base Cryptographic Provider v1.0"
#define MS_DEF_PROV_W L"Microsoft Base Cryptographic Provider v1.0"
#define MAXUIDLEN 64
#define CUR_BLOB_VERSION 2
typedef struct _PROV_ENUMALGS {
	ALG_ID aiAlgid;
	DWORD dwBitLen;
	DWORD dwNameLen;
	CHAR szName[20];
} PROV_ENUMALGS;
typedef struct _PUBLICKEYSTRUC {
	BYTE bType;
	BYTE bVersion;
	WORD reserved;
	ALG_ID aiKeyAlg;
} PUBLICKEYSTRUC;
typedef struct _RSAPUBKEY {
	DWORD magic; 
	DWORD bitlen; 
	DWORD pubexp; 
} RSAPUBKEY;
BOOL WINAPI CryptAcquireContextA(HCRYPTPROV *,LPCSTR,LPCSTR,DWORD,DWORD);
BOOL WINAPI CryptAcquireContextW(HCRYPTPROV *,LPCWSTR,LPCWSTR,DWORD,DWORD);
BOOL WINAPI CryptReleaseContext(HCRYPTPROV,DWORD);
BOOL WINAPI CryptGenKey(HCRYPTPROV,ALG_ID,DWORD,HCRYPTKEY *);
BOOL WINAPI CryptDeriveKey(HCRYPTPROV,ALG_ID,HCRYPTHASH,DWORD,HCRYPTKEY *);
BOOL WINAPI CryptDestroyKey(HCRYPTKEY); 
BOOL WINAPI CryptSetKeyParam(HCRYPTKEY,DWORD,BYTE *,DWORD);
BOOL WINAPI CryptGetKeyParam(HCRYPTKEY,DWORD,BYTE *,DWORD *,DWORD);
BOOL WINAPI CryptSetHashParam(HCRYPTHASH,DWORD,BYTE *,DWORD);
BOOL WINAPI CryptGetHashParam(HCRYPTHASH,DWORD,BYTE *,DWORD *,DWORD);
BOOL WINAPI CryptSetProvParam(HCRYPTPROV,DWORD,BYTE *,DWORD);
BOOL WINAPI CryptGetProvParam(HCRYPTPROV,DWORD,BYTE *,DWORD *,DWORD);
BOOL WINAPI CryptGenRandom(HCRYPTPROV,DWORD,BYTE *);
BOOL WINAPI CryptGetUserKey(HCRYPTPROV,DWORD,HCRYPTKEY *);
BOOL WINAPI CryptExportKey(HCRYPTKEY,HCRYPTKEY,DWORD,DWORD,BYTE *,DWORD *);
BOOL WINAPI CryptImportKey(HCRYPTPROV,BYTE *,DWORD,HCRYPTKEY,DWORD,HCRYPTKEY *);
BOOL WINAPI CryptEncrypt(HCRYPTKEY,HCRYPTHASH,BOOL,DWORD,BYTE *,DWORD *,DWORD);
BOOL WINAPI CryptDecrypt(HCRYPTKEY,HCRYPTHASH,BOOL,DWORD,BYTE *,DWORD *);
BOOL WINAPI CryptCreateHash(HCRYPTPROV,ALG_ID,HCRYPTKEY,DWORD,HCRYPTHASH *);
BOOL WINAPI CryptHashData(HCRYPTHASH,BYTE *,DWORD,DWORD);
BOOL WINAPI CryptHashSessionKey(HCRYPTHASH,HCRYPTKEY,DWORD);
BOOL WINAPI CryptGetHashValue(HCRYPTHASH,DWORD,BYTE *,DWORD *);
BOOL WINAPI CryptDestroyHash(HCRYPTHASH); 
BOOL WINAPI CryptSignHashA(HCRYPTHASH,DWORD,LPCSTR,DWORD,BYTE *,DWORD *);
BOOL WINAPI CryptSignHashW(HCRYPTHASH,DWORD,LPCWSTR,DWORD,BYTE *,DWORD *);
BOOL WINAPI CryptVerifySignatureA(HCRYPTHASH,BYTE *,DWORD,HCRYPTKEY,LPCSTR,DWORD);
BOOL WINAPI CryptVerifySignatureW(HCRYPTHASH,BYTE *,DWORD,HCRYPTKEY,LPCWSTR,DWORD);
BOOL WINAPI CryptSetProviderA(LPCST,DWORD);
BOOL WINAPI CryptSetProviderW(LPCWSTR,DWORD);
#endif 
