#include "sqk.h"
#include "gfx.h"
#include "mus.h"
#include "anm.h"

#include <stdio.h>
#include <conio.h>
#include <graphics.h>

// normal key codes
#define ESC        27
#define CTRL_Q     17
#define BACKSPACE   8
#define TAB         9
#define ENTER      13
#define SPACE      32
// extended key codes
#define ALT_X      45
#define SHIFT_TAB  15
#define HOME       71
#define UP         72
#define PGUP       73
#define LEFT       75
#define CENTER     76
#define RIGHT      77
#define END        79
#define DOWN       80
#define PGDN       81

#define NUM_ICONS 4
char huge quit_icon   [4004];
char huge resume_icon [4004];
char huge load_icon   [4004];
char huge new_icon    [4004];
box icon_from [NUM_ICONS];
box icon_to   [NUM_ICONS];
char icon_files [NUM_ICONS][13] =
	{"resume.pcx","new.pcx","load.pcx","quit.pcx"};

char huge cursor_bytes[12804];
gfx *cursor = (gfx*) cursor_bytes;
box cursor_from (0,0,319,39);
box cursor_to (0,0,319,39);

extern scr screen;
extern gfx *bg;
extern char std_fn[][13];
extern box full_screen;

gfx *menu[NUM_ICONS];

main (int argc, char ** argv)
{
	FILE *log_file;
	int i, err, key, extend, mode, dir, f, choice, selection;
	animation anm;
	box full_move   (0,0,199,199);
	box b, box1, box2;
	char str[41];

	// attempt to open the log file
	log_file = fopen ("log.txt","wt");
	if (log_file==NULL)
	{
		printf ("\nFATAL ERROR: can't open 'LOG.TXT'");
		printf ("\nPress <ENTER> to continue.");
		scanf  ("");
		return 1;
	}
	// record command line and parameters
	fprintf (log_file,"Command:  %s\n",argv[0]);
	if (argc==1) fprintf (log_file,"\tno parameters\n");
	else if (argc==2) fprintf (log_file,"\tone parameter:  %s\n",argv[1]);
	else
	{
		fprintf (log_file,"\t %d parameters:\n");
		for (i=1;i<argc;i++)  fprintf (log_file,"\t%s\n",argv[i]);
	}
	// attempt to initialize graphics mode
	err = screen.init();
	if (err)
	{
	fprintf (log_file,"graphics error #%d\n",err);
	fclose (log_file);  return 1;
	}
	else fprintf (log_file,"Graphics initialized successfully.\n");

	// load icons
	menu[3] = (gfx*)quit_icon;  menu[0] = (gfx*)resume_icon;
	menu[2] = (gfx*)load_icon;  menu[1] = (gfx*)new_icon;
	icon_from[0] = box(0,0,99,39);  icon_to[0] = box(40, 20,139, 59);
	icon_from[1] = box(0,0,99,39);  icon_to[1] = box(40, 60,139, 99);
	icon_from[2] = box(0,0,99,39);  icon_to[2] = box(40,100,139,139);
	icon_from[3] = box(0,0,99,39);  icon_to[3] = box(40,140,139,179);
	screen.draw (full_screen,full_screen,bg);
	for (i=0; i<NUM_ICONS; i++)
	{
		menu[i]->r=icon_from[i].r;  menu[i]->b=icon_from[i].b;
		err = load_pcx (menu[i],icon_files[i],0);
		if (err)
			{fprintf(log_file,"can't open '%s.'\n",icon_files[i]); continue;}
		fprintf (log_file,"'%s' loaded.\n",icon_files[i]);
		screen.draw (icon_to[i],icon_from[i],menu[i]);
		screen.show ();  key = getch();  if (!key) getch();
	}
	// load menu cursor
	cursor->r = cursor_from.r;  cursor->b = cursor_from.b;
	err = load_pcx (cursor,"cursor.pcx",0);
	if (err)  fprintf (log_file,"can't open 'cursor.pcx.'\n");
	else fprintf (log_file,"'cursor.pcx' loaded.\n");
	screen.draw (full_screen,full_screen,bg);
	screen.draw (cursor_to,cursor_from,cursor);
	screen.show ();  key = getch();  if (!key) getch();

	// load animation
	err = anm.load();
	if (err)  fprintf (log_file,"%d errors loading animation.\n",err);
	else fprintf (log_file,"Animation loaded successfully.\n");
	for (int move=0; move<NUM_MOVES; move++)
	{
		screen.draw (full_screen,full_screen,bg);
		screen.draw (full_screen,full_move,anm.actPtr(move)->g());
		screen.shade (box(1,1,319,199),std_fn[move],8);
		screen.draw  (box(0,0,318,198),std_fn[move],8);
		screen.show ();
		fflush (stdin);  key = getch ();
		if (!key)  getch();
	}

	// main input routine
	screen.draw (full_screen,full_screen,bg);
	while (1)
	{
		if (!kbhit()) continue;
		extend = 0;  key = getch ();
		if (!key)  {extend=1; key=getch();}
		if ((!extend&&(key==ESC||key==CTRL_Q))||(extend&&key==ALT_X))
		{
			if (main_menu()==3) break;
			else screen.draw (full_screen,full_screen,bg);
		}
		anm.react (key,extend);  anm.advance ();
		anm.shadow ();  anm.show ();  screen.show ();
		box1 = anm.toBox();
		screen.draw (box1,box1,bg);
	}

	fclose (log_file);
	return 0;
}

int main_menu (void)
{
	int key,extend,choice=1,i;
	unsigned char cursor_frame=0,c_f;
	box box3;
	screen.shade(full_screen);
	for (i=0; i<NUM_ICONS; i++)
		screen.draw (icon_to[i],icon_from[i],menu[i]);
	while (1)
	{
		do
		{
			cursor_frame++;  c_f = (cursor_frame/2)%8;
			cursor_from = box (40*c_f,0,40*c_f+39,39);
			cursor_to   = box (0,40*choice+20,39,40*choice+59);
			screen.draw (cursor_to,cursor_from,cursor);
			screen.show ();
			screen.draw (cursor_to,cursor_to,bg);
			screen.shade (cursor_to);
		}  while (!kbhit());
		key = getch ();
		if (key) switch (key)
		{
			case ESC:     return 0;
			case CTRL_Q:  return 3;
			case ENTER: case SPACE:  return choice;
			case TAB: choice++;  if (choice>=NUM_ICONS) choice=0;  break;
		}
		else switch (key=getch())
		{
			case ALT_X:   return 3;
			case CENTER:  return choice;
			case RIGHT: case PGDN: case DOWN: case END:
				choice++;  if (choice>=NUM_ICONS) choice=0;  break;
			case LEFT: case HOME: case UP: case PGUP: case SHIFT_TAB:
				choice--;  if (choice<0) choice=NUM_ICONS-1; break;
		}
	}
}



