    ///////////////////////
   // gfx.h             //
  // graphics routines //
 // version 1         //
///////////////////////

#ifndef GFX
#define GFX

  ///////////////////////////////////////////
 // header for a file in Zsoft PCX format //
///////////////////////////////////////////
typedef struct {
	char ZsoftFlag;      // should be 10
	char versionNumber;  // should be 5 if the image is 256 color
	char encoding;       // should be 1
	char bitsPerPixel;   // should be 8 if the image is 256 color
	unsigned int minX;   // probably 0
	unsigned int minY;   // probably 0
	unsigned int maxX;
	unsigned int maxY;
	int xResolution;
	int yResolution;
	char egaPalette[16][3];  // not used for 256 color images
	char reserved;           // not used
	char planes;             // should be 1 if the image is 256 color
	int bytesPerLine;        // always even:  should be == maxX - minX +1
	int interpretation;      // 1 = color, 2 = grayscale in some versions
	char blanks[58];
} pcxHeader;

typedef unsigned char pal256 [256] [3];

  ///////////////////////
 // 2 dimensional box //
///////////////////////
class box
{
public:
	int l,t,r,b;
	box (void)  {l=t=r=b=0;};
	box (int L, int T, int R, int B)  {l=L; t=T; r=R; b=B;};
	box (int *B)  {l=B[0]; t=B[1]; r=B[2]; b=B[3];};
	box operator = (box b2)
		{l=b2.l; t=b2.t; r=b2.r; b=b2.b;  return b2;};
};

  ///////////////////////////
 // bgi compatible bitmap //
///////////////////////////
class gfx {public:  unsigned int r,b;  unsigned char c[];};

  /////////////////////////////////////////////////////////////////////
 // screen class -- there should be only one instance of this class //
/////////////////////////////////////////////////////////////////////
class scr
{
	pal256 pal;
	gfx *buf;  // virtual screen buffer
public:
	// these methods allow read-only access to the virtual screen buffer
	int l (void) {return 0;};  int r (void)  {return buf->r;};
	int t (void) {return 0;};  int b (void)  {return buf->b;};
	unsigned char c (int x, int y)  {return buf->c[y*(buf->r+1)+x];};

	// these methods write to the virtual screen buffer
	// point
	void draw (int x, int y, unsigned char c)
		{buf->c[y*(buf->r+1)+x] = c;};
	// rectangle
	void draw (box b, unsigned char c, int fill);
	// bitmap
	void draw (box to, box from, gfx *image);
	// string
	void draw (box b, char *string, int size);
	// shaded area
	void shade (box b);
	// bitmap shadow
	void shade (box to, box from, gfx *image);
	// string shadow
	void shade (box b, char *string, int size);
	// clear the screen
	void clear (void);

	void show (void);  // copy the virtual screen buffer to the actual screen
	scr (void);        // initialize and clear the virtual screen buffer
	int init (void);   // initialize the graphics mode
	~scr (void);       // restore text mode
};


  //////////////////////////////////////////
 // load an image in Zsoft's .PCX format //
//////////////////////////////////////////
int load_pcx (gfx *gx, char *fn, pal256 *pal);

#endif