	///////////////////////
   // gfx.cpp           //
  // graphics routines //
 // version 1         //
/////////////////////// ///////////////////////////////////////////////
   // this code requires the Borland Turbo C++ 3.0 graphics library //
  // and the Jordan Hargraphix graphics drivers                    //
 // the compiled program requires the file "svga256.bgi" to run   //
///////////////////////////////////////////////////////////////////

#include "gfx.h"

#include "svgautil.h"

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <graphics.h>

int huge detectGfxMode (void) {return 0;}

// #define MAXDATA 100000
// unsigned char huge data[MAXDATA];
unsigned char huge background[64004];
unsigned char huge font[16388];
unsigned char huge buffer[64004];
gfx  *bg, *fnt;   scr screen;
box full_screen (0,0,319,199);
box full_font   (0,0,127,127);

void scr::scr (void)
{
	buf = (gfx*) buffer;      buf->r=319;  buf->b=199;
	bg  = (gfx*) background;  bg ->r=319;  bg ->b=199;
	fnt = (gfx*) font;        fnt->r=127;  fnt->b=127;
}

int scr::init (void)
{
	int gfxDriver=DETECT, gfxMode, gfxErr, key;
	box b1 (0,0,319,199);
	box b2 (0,0,319,199);
	box b3 (0,0,319,199);
	char * txt = "This is a test of the font drawing function.\nPress any key to continue.";

	installuserdriver ("Svga256", detectGfxMode);
	initgraph (&gfxDriver,&gfxMode,"");

	gfxErr = graphresult();
	if (gfxErr)  return graphresult();

	getvgapalette256 (&pal);
	pal[0][0]   = 0;   pal[0][1]   = 0;   pal[0][2]   = 0;
	pal[1][0]   = 30;  pal[1][1]   = 30;  pal[1][2]   = 30;
	pal[255][0] = 63;  pal[255][1] = 63;  pal[255][2] = 63;
	setvgapalette256 (&pal);
	setfillstyle (SOLID_FILL,1);   bar (0,0,319,199);

	// load background and palette
	gfxErr = load_pcx (bg,"bg.pcx",&pal);
	if (gfxErr) return gfxErr;

	pal[0][0]   = 0;   pal[0][1]   = 0;   pal[0][2]   = 0;
	pal[255][0] = 63;  pal[255][1] = 63;  pal[255][2] = 63;
	setvgapalette256(&pal);

	// show background
	fflush (stdin);  key = getch ();  if (!key) getch ();
	b1.t = 0;  b1.b = 60;
	for (int l=0,t=0,r=39,b=199; r<320; l+=10,r+=10)
	{
		if (kbhit()) {fflush(stdin); break;}
		b1.l=l; b1.r=r; b2.l=l; b2.r=r;
		clear (); draw (b2,b1,bg); show();
	}
	clear ();
	for (l=152,r=167,t=95,b=104; r<320; l-=8,t-=5,r+=8,b+=5)
	{
		if (kbhit()) {fflush(stdin); break;}
		b2.l=l; b2.t=t; b2.r=r; b2.b=b;
		draw (b2,b3,bg);  show ();
	}

	// load font
	gfxErr = load_pcx (fnt,"fnt.pcx",0);
	if (gfxErr) return gfxErr+2;
	draw (b3,b3,bg);  draw (b3,full_font,fnt);  show ();  getch ();
	for (int i=2; i<9; i++)  {draw(b3,b3,bg); draw(b3,txt,i); show();}
	fflush (stdin);  key = getch ();  if (!key) getch ();
	for (i=12; i<200; i*=2)  {draw(b3,b3,bg); draw(b3,txt,i); show();}

	return 0;
}

scr::~scr (void)  {closegraph();}

void scr::show (void)  {putimage (0,0,buf,0);}

void scr::clear (void)
{
	for (int y=0,i=0; y<=buf->b; y++)
		for (int x=0; x<=buf->r; x++,i++)  buf->c[i] = 0;
}

void scr::draw (box to, box from, gfx *img)
{
	// image size
	int t_w = to.r   - to.l   + 1;   int t_h = to.b   - to.t   + 1;
	int s_w = buf->r + 1;  // screen width

	// sample size
	int f_w = from.r - from.l + 1;   int f_h = from.b - from.t + 1;
	int g_w = img->r + 1;  // source picture width

	// scaling factors
	float h_s = (float)f_w / t_w;
	float v_s = (float)f_h / t_h;

	// clip boxes to fit on the screen
	int n;
	if (to.l<0)    {n=0-to.l;  from.l+=h_s*n;  to.l+=n;  t_w-=n;}
	if (to.t<0)    {n=0-to.t;  from.t+=v_s*n;  to.t+=n;  t_h-=n;}
	if (to.r>319)  {n=to.r-319;  t_w-=n;}
	if (to.b>199)  {n=to.b-199;  t_h-=n;}

	// origin points
	int    t_o = to.l   + to.t   * s_w;
	float  f_o = from.l + from.t * g_w;

	float t,f; // byte counters

	for (int y=0; y<t_h; y++)
	{
		t = t_o + y * s_w;  f = f_o + (int)(y*v_s) * g_w;
		for (int x=0; x<t_w; x++,t++,f+=h_s)
			{unsigned char c = img->c[f];  if (c)  buf->c[t] = c;}
	}
}

void scr::shade (box to, box from, gfx *img)
{
	int t_w = to.r   - to.l   + 1;   int t_h = to.b   - to.t   + 1;
	int s_w = buf->r + 1;

	int f_w = from.r - from.l + 1;   int f_h = from.b - from.t + 1;
	int g_w = img->r + 1;

	float h_s = (float)f_w / t_w;
	float v_s = (float)f_h / t_h;

	// clip boxes to fit on the screen
	int n;
	if (to.l<0)    {n=0-to.l;  from.l+=h_s*n;  to.l+=n;  t_w-=n;}
	if (to.t<0)    {n=0-to.t;  from.t+=v_s*n;  to.t+=n;  t_h-=n;}
	if (to.r>319)  {n=to.r-319;  t_w-=n;}
	if (to.b>199)  {n=to.b-199;  t_h-=n;}

	// origin points
	int    t_o = to.l   + to.t   * s_w;
	float  f_o = from.l + from.t * g_w;


	float t,f;

	for (int y=0; y<t_h; y++)
	{
		t = t_o + y * s_w;  f = f_o + (int)(y*v_s) * g_w;
		for (int x=0; x<t_w; x++,t++,f+=h_s)
			{unsigned char c = img->c[f];  if (c)  buf->c[t] = 0;}
	}
}

void scr::draw (box b,char *str,int size)
{
	int x=b.l, y=b.t;  box bx, b2;

	for (int i=0; str[i]!='\0'; i++,x+=size)
	{
		if (x>b.r-size) {x=0;y+=size;}
		if (y>b.b-size) break;
		if (str[i]=='\n') {x=(-size);y+=size;continue;}
		bx.l=8*(str[i]%16); bx.r=bx.l+7;
		bx.t=8*(str[i]/16); bx.b=bx.t+7;
		b2.l=x; b2.r=x+size-1; b2.t=y; b2.b=y+size-1;
		draw (b2,bx,fnt);
	}
}

void scr::shade (box b,char *str,int size)
{
	int x=b.l, y=b.t;  box bx, b2;

	for (int i=0; str[i]!='\0'; i++,x+=size)
	{
		if (x>b.r-size) {x=0;y+=size;}
		if (y>b.b-size) break;
		if (str[i]=='\n') {x=(-size);y+=size;continue;}
		bx.l=8*(str[i]%16); bx.r=bx.l+7;
		bx.t=8*(str[i]/16); bx.b=bx.t+7;
		b2.l=x; b2.r=x+size-1; b2.t=y; b2.b=y+size-1;
		shade (b2,bx,fnt);
	}
}

void scr::draw (box b, unsigned char c, int fill)
{
	int x,y,i,j,  w = buf->r+1;
	if (fill) for (y=b.t; y<=b.b; y++)
		{i=y*w+b.l;  for (x=b.l; x<=b.r; x++,i++) buf->c[i]=c;}
	else
	{
		i = b.t*w+b.l;  j = b.t*w+b.r;
		for (y=b.t; y<=b.b; y++,i+=w,j+=w)  {buf->c[i]=c; buf->c[j]=c;}
		i = b.t*w+b.l+1;  j = b.b*w+b.l+1;
		for (x=b.l+1; x<b.r; x++,i++,j++)  {buf->c[i]=c; buf->c[j]=c;}
	}
}

void scr::shade (box b)
{
	for (int y=b.t; y<=b.b; y++)
		for (int i=y*(buf->r+1)+b.l+y%2, x=b.l+y%2;  x<=b.r;  x+=2, i+=2)
			buf->c[i] = 0;
}


  ////////////////////////////////////////////////
 // load an image saved in Zsoft's .PCX format //
////////////////////////////////////////////////
int load_pcx (gfx *gx, char *fn, pal256 *pal)
{
	FILE * fptr;
	pcxHeader hdr;
	unsigned char c,n;
	int angle1=0, angle2, j, k;
	long i=0, x;
	float max = (gx->r+1) * (gx->b+1);
	char str [41];

	// open the file for reading
	fptr = fopen (fn,"rb");
	if (fptr == NULL)  return 1;

	// load the PCX header
	fread (&hdr,sizeof(pcxHeader),1,fptr);
	if (hdr.maxY-hdr.minY != gx->b || hdr.bytesPerLine != gx->r+1)
		{fclose (fptr);  return 2;}


/*
	x=0;
	if ((long)(gx->b+1)*hdr.bytesPerLine < MAXDATA)
	{
		fread (data,1,MAXDATA,fptr);
		do
		{
			c = data[x];  x++;
			if (c<192)  {gx->c[i]=c; i++;}
			else
			{
				n = c-192;
				c = data[x];  x++;
				for (j=0; j<n; j++)  {gx->c[i]=c; i++;}
			}
		} while (i < (long)hdr.bytesPerLine*(hdr.maxY-hdr.minY+1));
	}
	else
	{
*/
		sprintf (str,"Loading '%s'...",fn);
		setcolor (0);    outtextxy(1,1,str);
		setcolor (255);  outtextxy(0,0,str);

		setlinestyle (SOLID_LINE,0,1);	setcolor(255);
		setfillstyle (SOLID_FILL,255);	pieslice (160,100,0,360,50);
		setfillstyle (SOLID_FILL,0);  	pieslice (160,100,0,360,49);
		setfillstyle (SOLID_FILL,255);

		// decode PCX run-time encoded data
		do
		{
			fread (&c,1,1,fptr);
			if (c<192)  {gx->c[i]=c; i++;}
			else
			{
				n = c-192;
				fread (&c,1,1,fptr);
				for (j=0; j<n; j++)  {gx->c[i]=c; i++;}
			}
			setcolor (255);
			angle2 = 360*(i/max);
			pieslice (160,100,angle1,angle2,49);
			angle1 = angle2-1;
			setcolor (0);  circle (160,100,49);
		} while (i < (long)hdr.bytesPerLine*(hdr.maxY-hdr.minY+1));
//	}
	// load palette
	if (pal!=NULL)
	{
		setcolor (0);  rectangle(29,93,290,106);
		setcolor (255);  rectangle (30,94,289,105);
		setfillstyle (SOLID_FILL,0);  bar (31,95,288,104);
		fseek (fptr,-768,SEEK_END);
		for (i=0;i<256;i++)
		{
			for (j=0;j<3;j++)
			{
				fread (&c,1,1,fptr);  k = c;
				(*pal)[i][j] = k/4;
			}
			setcolor (i);
			line (32+i,96,32+i,103);
		}
	}

	// close file and return
	fclose (fptr);
	return 0;
}




