/* -------------------------------------------------------------------- */
/* Mouse++ Version 4.0             cursor.h            Revised 10/05/92 */
/*                                                                      */
/* General mouse class for Turbo C++/Borland C++.                       */
/* Copyright 1991, 1992 by Carl W. Moreland                             */
/* -------------------------------------------------------------------- */

#ifndef CURSORdotH
#define CURSORdotH

static unsigned gcDefaultImage[] =
{
  0x3FFF,       /* 0011111111111111 */
  0x1FFF,       /* 0001111111111111 */
  0x0FFF,       /* 0000111111111111 */
  0x07FF,       /* 0000011111111111 */
  0x03FF,       /* 0000001111111111 */
  0x01FF,       /* 0000000111111111 */
  0x00FF,       /* 0000000011111111 */
  0x007F,       /* 0000000001111111 */
  0x003F,       /* 0000000000111111 */
  0x001F,       /* 0000000000011111 */
  0x01FF,       /* 0000000111111111 */
  0x10FF,       /* 0001000011111111 */
  0x30FF,       /* 0011000011111111 */
  0x787F,       /* 0111100001111111 */
  0xF87F,       /* 1111100001111111 */
  0xFC7F,       /* 1111110001111111 */

  0x0000,       /* 0000000000000000 */
  0x4000,       /* 0100000000000000 */
  0x6000,       /* 0110000000000000 */
  0x7000,       /* 0111000000000000 */
  0x7800,       /* 0111100000000000 */
  0x7C00,       /* 0111110000000000 */
  0x7E00,       /* 0111111000000000 */
  0x7F00,       /* 0111111100000000 */
  0x7F80,       /* 0111111110000000 */
  0x7C00,       /* 0111110000000000 */
  0x6C00,       /* 0110110000000000 */
  0x4600,       /* 0100011000000000 */
  0x0600,       /* 0000011000000000 */
  0x0300,       /* 0000001100000000 */
  0x0300,       /* 0000001100000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcCheckImage[] =
{
  0xFFF0,       /* 1111111111110000 */
  0xFFE0,       /* 1111111111100000 */
  0xFFC0,       /* 1111111111000000 */
  0xFF81,       /* 1111111110000001 */
  0xFF03,       /* 1111111100000011 */
  0x0607,       /* 0000011000000111 */
  0x000F,       /* 0000000000001111 */
  0x001F,       /* 0000000000011111 */
  0xC03F,       /* 1100000000111111 */
  0xF07F,       /* 1111000001111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0006,       /* 0000000000000110 */
  0x000C,       /* 0000000000001100 */
  0x0018,       /* 0000000000011000 */
  0x0030,       /* 0000000000110000 */
  0x0060,       /* 0000000001100000 */
  0x70C0,       /* 0111000011000000 */
  0x1D80,       /* 0001110110000000 */
  0x0700,       /* 0000011100000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcCrossImage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x8002,       /* 1000000000000010 */
  0x4004,       /* 0100000000000100 */
  0x2008,       /* 0010000000001000 */
  0x1010,       /* 0001000000010000 */
  0x0820,       /* 0000100000100000 */
  0x0440,       /* 0000010001000000 */
  0x0280,       /* 0000001010000000 */
  0x0000,       /* 0000000000000000 */
  0x0280,       /* 0000001010000000 */
  0x0440,       /* 0000010001000000 */
  0x0820,       /* 0000100000100000 */
  0x1010,       /* 0001000000010000 */
  0x2008,       /* 0010000000001000 */
  0x4004,       /* 0100000000000100 */
  0x8002,       /* 1000000000000010 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcPlusImage[32] =
{
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x7FFC,       /* 0111111111111100 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcHourglassImage[32] =
{
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0xC003,       /* 1100000000000011 */
  0xC003,       /* 1100000000000011 */
  0xE007,       /* 1110000000000111 */
  0xF00F,       /* 1111000000001111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF81F,       /* 1111100000011111 */
  0xF00F,       /* 1111000000001111 */
  0xE007,       /* 1110000000000111 */
  0xC003,       /* 1100000000000011 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */

  0x0000,       /* 0000000000000000 */
  0x3FFC,       /* 0011111111111100 */
  0x1008,       /* 0001000000001000 */
  0x1C38,       /* 0001110000111000 */
  0x0FF0,       /* 0000111111110000 */
  0x07E0,       /* 0000011111100000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0240,       /* 0000001001000000 */
  0x0520,       /* 0000010100100000 */
  0x0890,       /* 0000100010010000 */
  0x1188,       /* 0001000110001000 */
  0x17E8,       /* 0001011111101000 */
  0x3FFC,       /* 0011111111111100 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcHandImage[32] =
{
  0xF3FF,       /* 1111001111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE1FF,       /* 1110000111111111 */
  0xE04F,       /* 1110000001001111 */
  0xE001,       /* 1110000000000001 */
  0XE000,       /* 1110000000000000 */
  0x8000,       /* 1000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */

  0x0C00,       /* 0000110000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x1200,       /* 0001001000000000 */
  0x13B0,       /* 0001001110110000 */
  0x124E,       /* 0001001001001110 */
  0X1249,       /* 0001001001001001 */
  0x7249,       /* 0111001001001001 */
  0x9001,       /* 1001000000000001 */
  0x9001,       /* 1001000000000001 */
  0X9001,       /* 1001000000000001 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0x8001,       /* 1000000000000001 */
  0xFFFF        /* 1111111111111111 */
};

static unsigned gcGunImage[32] =
{
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xC001,       /* 1100000000000001 */
  0xF801,       /* 1111100000000001 */
  0xF801,       /* 1111100000000001 */
  0xF801,       /* 1111100000000000 */
  0xFF80,       /* 1111111110000000 */
  0xFFC0,       /* 1111111111000000 */
  0xFFC0,       /* 1111111111000000 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x7FFC,       /* 0111111111111100 */
  0x7FFC,       /* 0111111111111100 */
  0x1FFC,       /* 0001111111111100 */
  0x02B8,       /* 0000001010111000 */
  0x023C,       /* 0000001000111100 */
  0x03FC,       /* 0000001111111100 */
  0x003C,       /* 0000000000111100 */
  0x001E,       /* 0000000000011110 */
  0x001E,       /* 0000000000011110 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcIbeamImage[32] =
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0xF1E0,       /* 1111000111100000 */
  0x0A00,       /* 0000101000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0400,       /* 0000010000000000 */
  0x0A00,       /* 0000101000000000 */
  0xF1E0        /* 1111000111100000 */
};

static unsigned gcFaceImage[32] =
{
  0xF00F,       /* 1111000000001111 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x0000,       /* 0000000000000000 */
  0x1428,       /* 0001010000101000 */
  0x0420,       /* 0000010000100000 */
  0x1818,       /* 0001100000011000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x1008,       /* 0001000000001000 */
  0x0000,       /* 0000000000000000 */
  0x1248,       /* 0001001001001000 */
  0x0240,       /* 0000001001000000 */
  0x8181,       /* 1000000110000001 */
  0xC003,       /* 1100000000000011 */
  0xF00F,       /* 1111000000001111 */

  0x0000,       /* 0000000000000000 */
  0x1FF8,       /* 0001111111111000 */
  0x3FFC,       /* 0011111111111100 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x73CE,       /* 0111001111001110 */
  0x73CE,       /* 0111001111001110 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x6FF6,       /* 0110111111110110 */
  0x700E,       /* 0111000000001110 */
  0x7FFE,       /* 0111111111111110 */
  0x7FFE,       /* 0111111111111110 */
  0x3FFC,       /* 0011111111111100 */
  0x1FF8,       /* 0001111111111000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcJetImage[32] =
{
  0xFEFF,       /* 1111111011111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xFC7F,       /* 1111110001111111 */
  0xF83F,       /* 1111100000111111 */
  0xF83F,       /* 1111100000111111 */
  0xF01F,       /* 1111000000011111 */
  0xE00F,       /* 1110000000001111 */
  0xC007,       /* 1100000000000111 */
  0x8003,       /* 1000000000000011 */
  0x0001,       /* 0000000000000001 */
  0x0001,       /* 0000000000000001 */
  0xF83F,       /* 1111100000111111 */
  0xF01F,       /* 1111000000011111 */
  0xE00F,       /* 1110000000001111 */
  0xE10F,       /* 1110000100001111 */

  0x0000,       /* 0000000000000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0100,       /* 0000000100000000 */
  0x0380,       /* 0000001110000000 */
  0x0380,       /* 0000001110000000 */
  0x07C0,       /* 0000011111000000 */
  0x0FE0,       /* 0000111111100000 */
  0x1FF0,       /* 0001111111110000 */
  0x3FF8,       /* 0011111111111000 */
  0x7FFC,       /* 0111111111111100 */
  0x0380,       /* 0000001110000000 */
  0x0380,       /* 0000001110000000 */
  0x07C0,       /* 0000011111000000 */
  0x0EE0,       /* 0000111011100000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcBullseyeImage[32] =
{
  0xF00F,       /* 1111000000001111 */
  0xC003,       /* 1100000000000011 */
  0x8001,       /* 1000000000000001 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x8001,       /* 1000000000000001 */
  0xC003,       /* 1100000000000011 */
  0xF00F,       /* 1111000000001111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0FF0,       /* 0000111111110000 */
  0x381C,       /* 0011100000011100 */
  0x6FF6,       /* 0110111111110110 */
  0x5C3A,       /* 0101110000111010 */
  0x57EA,       /* 0101011111101010 */
  0x566A,       /* 0101011001101010 */
  0x566A,       /* 0101011001101010 */
  0x57EA,       /* 0101011111101010 */
  0x5C3A,       /* 0101110000111010 */
  0x6FF6,       /* 0110111111110110 */
  0x381C,       /* 0011100000011100 */
  0x0FF0,       /* 0000111111110000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};

static unsigned gcMouseppImage[] =
{				/* |       |       |       |       |        */
  0x11FF, 0xFFFF, 0xFF00,	/* 0001000111111111111111111111111111111111 */
  0x01FF, 0xFFFF, 0xFF00,	/* 0 000 0111111111111111111111111111111111 */
  0x0120, 0x4231, 0xC700,	/* 0  0  0100100000010000100011000111000111 */
  0x0000, 0x0011, 0xC700,	/* 0 0 0 00  00 00 00   00  0010 01110 0111 */
  0x0000, 0x0000, 0x0100,	/* 0 0 0 0 00 0 00 0 0000 00 000 00000 0001 */
  0x0000, 0x0000, 0x0100,	/* 0 000 0 00 0 00 00  00    0     0     01 */
  0x1000, 0x0000, 0x0100,	/* 0 010 0 00 0 0  0000 0 000000 00000 0001 */
  0x1000, 0x0011, 0xC700,	/* 0 010 00  000 0 0   000   010 01110 0111 */
  0x1130, 0x0431, 0xC700,	/* 0001000100110000000001000011000111000111 */
				/* |       |       |       |       |        */
  0x0000, 0x0000, 0x0000,	/* 0000000000000000000000000000000000000000 */
  0x4400, 0x0000, 0x0000,	/* 0100010000000000000000000000000000000000 */
  0x6C00, 0x0000, 0x0000,	/* 0110110000000000000000000000000000000000 */
  0x54C9, 0x3984, 0x1000,	/* 0101010011001001001110011000010000010000 */
  0x5529, 0x4244, 0x1000,	/* 0101010100101001010000100100010000010000 */
  0x4529, 0x33DF, 0x7C00,	/* 0100010100101001001100111101111101111100 */
  0x4529, 0x0A04, 0x1000,	/* 0100010100101011000010100000010000010000 */
  0x44C5, 0x71C4, 0x1000,	/* 0100010011000101011100011100010000010000 */
  0x0000, 0x0000, 0x0000,	/* 0000000000000000000000000000000000000000 */
};

static unsigned char cgcMouseppImage[] =
{				/* |       |       |       |       |        */
  0x11, 0xFF, 0xFF, 0xFF, 0xFF,	/* 0001000111111111111111111111111111111111 */
  0x01, 0xFF, 0xFF, 0xFF, 0xFF,	/* 0 000 0111111111111111111111111111111111 */
  0x01, 0x20, 0x42, 0x31, 0xC7,	/* 0  0  0100100000010000100011000111000111 */
  0x00, 0x00, 0x00, 0x11, 0xC7,	/* 0 0 0 00  00 00 00   00  0010 01110 0111 */
  0x00, 0x00, 0x00, 0x00, 0x01,	/* 0 0 0 0 00 0 00 0 0000 00 000 00000 0001 */
  0x00, 0x00, 0x00, 0x00, 0x01,	/* 0 000 0 00 0 00 00  00    0     0     01 */
  0x10, 0x00, 0x00, 0x00, 0x01,	/* 0 010 0 00 0 0  0000 0 000000 00000 0001 */
  0x10, 0x00, 0x00, 0x11, 0xC7,	/* 0 010 00  000 0 0   000   010 01110 0111 */
  0x11, 0x30, 0x04, 0x31, 0xC7,	/* 0001000100110000000001000011000111000111 */
				/* |       |       |       |       |        */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x44, 0x00, 0x00, 0x00, 0x00,	/* 0100010000000000000000000000000000000000 */
  0x6C, 0x00, 0x00, 0x00, 0x00,	/* 0110110000000000000000000000000000000000 */
  0x54, 0xC0, 0x00, 0x00, 0x10,	/* 0101010011000000000000000000000000010000 */
  0x55, 0x20, 0x00, 0x00, 0x10,	/* 0101010100100000000000000000000000010000 */
  0x45, 0x20, 0x00, 0x00, 0x7C,	/* 0100010100100000000000000000000001111100 */
  0x45, 0x20, 0x00, 0x00, 0x10,	/* 0100010100100000000000000000000000010000 */
  0x44, 0xC0, 0x00, 0x00, 0x10,	/* 0100010011000000000000000000000000010000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
				/* |       |       |       |       |        */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x09, 0x38, 0x00, 0x00,	/* 0000000000001001001110000000000000000000 */
  0x00, 0x09, 0x40, 0x00, 0x00,	/* 0000000000001001010000000000000000000000 */
  0x00, 0x09, 0x30, 0x00, 0x00,	/* 0000000000001001001100000000000000000000 */
  0x00, 0x0B, 0x08, 0x00, 0x00,	/* 0000000000001011000010000000000000000000 */
  0x00, 0x05, 0x70, 0x00, 0x00,	/* 0000000000000101011100000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
				/* |       |       |       |       |        */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x39, 0x84, 0x10,	/* 0000000000000000001110011000010000010000 */
  0x00, 0x00, 0x42, 0x44, 0x10,	/* 0000000000000000010000100100010000010000 */
  0x00, 0x00, 0x33, 0xDF, 0x7C,	/* 0000000000000000001100111101111101111100 */
  0x00, 0x00, 0x0A, 0x04, 0x10,	/* 0000000000000000000010100000010000010000 */
  0x00, 0x00, 0x71, 0xC4, 0x10,	/* 0000000000000000011100011100010000010000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
				/* |       |       |       |       |        */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00,	/* 0000000000000000000000000000000000000000 */
  0x00, 0xC0, 0x39, 0x80, 0x00,	/* 0000000011000000001110011000000000000000 */
  0x01, 0x20, 0x42, 0x40, 0x00,	/* 0000000100100000010000100100000000000000 */
  0x01, 0x20, 0x33, 0xC0, 0x00,	/* 0000000100100000001100111100000000000000 */
  0x01, 0x20, 0x0A, 0x00, 0x00,	/* 0000000100100000000010100000000000000000 */
  0x00, 0xC0, 0x71, 0xC0, 0x00,	/* 0000000011000000011100011100000000000000 */
  0x00, 0x00, 0x00, 0x00, 0x00	/* 0000000000000000000000000000000000000000 */
};

static unsigned char cgcPlusImage[] =
{
  0xF8, 0x3F,       /* 1111100000111111 */	// screen mask
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0x00, 0x01,       /* 0000000000000001 */
  0x00, 0x01,       /* 0000000000000001 */
  0x00, 0x01,       /* 0000000000000001 */
  0x00, 0x01,       /* 0000000000000001 */
  0x00, 0x01,       /* 0000000000000001 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xF8, 0x3F,       /* 1111100000111111 */
  0xFF, 0xFF,       /* 1111111111111111 */

  0x01, 0x80,       /* 0000000110000000 */	// bit plane 0
  0x01, 0x80,       /* 0000000110000000 */
  0x01, 0x80,       /* 0000000110000000 */
  0x01, 0x80,       /* 0000000110000000 */
  0x01, 0x80,       /* 0000000110000000 */
  0x01, 0x80,       /* 0000000110000000 */
  0xFF, 0x80,       /* 1111111110000000 */
  0xFF, 0xFE,       /* 1111111111111110 */
  0x03, 0xFE,       /* 0000001111111110 */
  0x03, 0x80,       /* 0000001100000000 */
  0x03, 0x00,       /* 0000001100000000 */
  0x03, 0x00,       /* 0000001100000000 */
  0x03, 0x00,       /* 0000001100000000 */
  0x03, 0x00,       /* 0000001100000000 */
  0x03, 0x00,       /* 0000001100000000 */
  0x00, 0x00,       /* 0000000000000000 */

  0x03, 0x80,       /* 0000001110000000 */	// bit plane 1
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0xFF, 0xFE,       /* 1111111111111110 */
  0xFF, 0x80,       /* 1111111110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x00, 0x00,       /* 0000000000000000 */

  0x01, 0x00,       /* 0000000100000000 */	// bit plane 2
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0xFE,       /* 0000000111111110 */
  0xFF, 0xFE,       /* 1111111111111110 */
  0xFF, 0xFE,       /* 1111111111111110 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x03, 0x80,       /* 0000001110000000 */
  0x00, 0x00,       /* 0000000000000000 */

  0x01, 0x00,       /* 0000000100000000 */	// bit plane 3
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0xFF, 0xFE,       /* 1111111111111110 */
  0xFF, 0x00,       /* 1111111100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,	    /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x01, 0x00,       /* 0000000100000000 */
  0x00, 0x00        /* 0000000000000000 */
};


static unsigned gcTemplateImage[] =	// use this for creating new cursors
{
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */
  0xFFFF,       /* 1111111111111111 */

  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000,       /* 0000000000000000 */
  0x0000        /* 0000000000000000 */
};


static TextCursor tdef(0x77FF, 0x7700);
static TextCursor txt1(0x0000, 0x0E0F);
static TextCursor txt2(0x7000, 0x0E0F);
static TextCursor txt3(0x7F00, 0xFF0F);
static TextCursor txt4(0x00FF, 0x0FD4);

static GraphicsCursor   gcDefault(1,  1, gcDefaultImage,   11, 16);
static GraphicsCursor     gcCheck(6,  8, gcCheckImage,     16, 10);
static GraphicsCursor      gcPlus(7,  7, gcPlusImage,      15, 15);
static GraphicsCursor     gcCross(7,  7, gcCrossImage,     15, 15);
static GraphicsCursor       gcGun(2,  1, gcGunImage,       16, 11);
static GraphicsCursor      gcHand(4,  0, gcHandImage,      16, 16);
static GraphicsCursor gcHourglass(7,  7, gcHourglassImage, 15, 16);
static GraphicsCursor     gcIbeam(5,  7, gcIbeamImage,     11, 16);
static GraphicsCursor      gcFace(7,  7, gcFaceImage,      16, 16);
static GraphicsCursor       gcJet(7,  0, gcJetImage,       15, 16);
static GraphicsCursor  gcBullseye(7,  7, gcBullseyeImage,  16, 14);
static GraphicsCursor   gcMousepp(19, 4, gcMouseppImage,   39, 9, 1);

static ColorGraphicsCursor    cgcPlus(7,  7, cgcPlusImage,    15, 15);
static ColorGraphicsCursor cgcMousepp(19, 4, cgcMouseppImage, 39, 9);

#endif