	///////////////
   // anm.h     //
  // animation //
 // version 1 //
///////////////

#include "gfx.h"

#include <string.h>

// normal key codes
#define ESC        27
#define CTRL_Q     17
#define BACKSPACE   8
#define TAB         9
#define ENTER      13
#define SPACE      32
// extended key codes
#define ALT_X      45
#define SHIFT_TAB  15
#define HOME       71
#define UP         72
#define PGUP       73
#define LEFT       75
#define CENTER     76
#define RIGHT      77
#define END        79
#define DOWN       80
#define PGDN       81

#define NUM_MOVES 7
enum MOVES  {Walk, Run, Jump, Swim, Slide, Attack, Fall};
#define NUM_CTRLS 15
enum CTRLS  {north,northeast,east,southeast,south,southwest,west,northwest,
			 walk, run, jump, swim, slide, attack, fall};

class action
{
	gfx *gptr;  char fn[13];
public:
	gfx * g (void)  {return gptr;};
	void set_fn (char *str)  {strncpy (fn,str,13);};
	void set_gx (gfx  *ptr)  {gptr = ptr; gptr->r=199; gptr->b=199;};
	int  load   (void)       {return load_pcx (gptr,fn,0);};
	void show   (int F, int D, box B);
	void shadow (int F, int D, box B);
};

class animation
{
	int f,d,m, turn,fwd;  box to;
	int control  [NUM_CTRLS];
	int ext_ctrl [NUM_CTRLS];
	action act [NUM_MOVES];
public:
	box toBox (void) {return to;};
	action * actPtr (int move)  {return act + move;};
	int frm (void) {return f;};
	int dir (void) {return d;};
	int mov (void) {return m;};
	animation    (void);
	int  load    (void);
	void move    (box b);
	void move    (int F, int D, int M);
	void advance (void);
	void show    (void)  {act[m].show(f,d,to);};
	void shadow  (void)  {act[m].shadow(f,d,to);};
	void react   (int key, int extend);
};

