	///////////////
   // anm.cpp   //
  // animation //
 // version 1 //
///////////////

#include "anm.h"
#include <conio.h>
#include <math.h>


animation anm;
extern scr screen;
extern gfx *bg;
box all_over (0,0,319,199);

int deltaX[8] =    { 0, +3, +5, +3,  0, -3, -5, -3};
int deltaY[8] =    {-3, -2,  0, +2, +3, +2,  0, -2};
int sidestepX[8] = {+5, +3,  0, -3, -5, -3,  0, +3};
int sidestepY[8] = { 0, +2, +3, +2,  0, -2, -3, -5};

char huge act0[40004];  char huge act1[40004];  char huge act2[40004];
char huge act3[40004];  char huge act4[40004];  char huge act5[40004];
char huge act6[40004];
gfx *std_mv[NUM_MOVES] = {(gfx*)act0, (gfx*)act1, (gfx*)act2, (gfx*)act3,
						  (gfx*)act4, (gfx*)act5, (gfx*)act6};

char std_fn[NUM_MOVES][13] =
{
	"walk.pcx","run.pcx","jump.pcx","swim.pcx",
	"slide.pcx","attack.pcx","fall.pcx"
};

int std_ctrl [NUM_CTRLS] = {0,0,0,0,0,0,0,0,'1','2','3','4','5','6','7'};
int std_extd [NUM_CTRLS] = {UP,PGUP,RIGHT,PGDN,DOWN,END,LEFT,HOME,
							0,0,0,0,0,0,0};

void action::show (int F, int D, box B)
{
	box b (F*25, D*25, F*25+24, D*25+24);
	screen.draw (B,b,gptr);
}

void action::shadow (int F, int D, box B)
{
	box b1 (F*25, D*25, F*25+24, D*25+24);
	box b2 (B.l, (B.t+B.b)/2, B.r, B.b);
	screen.shade (b2,b1,gptr);
}

animation::animation (void)
{
	int i;  f=d=m=0;  to.l=148; to.t=88; to.r=172; to.b=112;
	for (i=0; i<NUM_MOVES; i++)
		{act[i].set_gx(std_mv[i]);  act[i].set_fn(std_fn[i]);}
	for (i=0; i<NUM_CTRLS; i++)
		{control[i] = std_ctrl[i];  ext_ctrl[i] = std_extd[i];}
}

int animation::load (void)
{
	for (int err=0,i=0; i<NUM_MOVES; i++)
	{
		screen.draw(all_over,all_over,bg);
		screen.show();  if (act[i].load()) err++;
	}
	return err;
}

void animation::move (box b)
	{to.l=b.l; to.t=b.t; to.r=b.r; to.b=b.b;}

void animation::move (int F, int D, int M)  {f=F; d=D; m=M;}

void animation::advance (void)
{
	int x,y;  box b = to;
	switch (m)
	{
		case Slide:
			x=to.l-150, y=to.t-90;
			// turn
			float slope;
			if (x==0)  slope = 10;          // vertical slope
			else slope = (float)y/x;
			if (fabs(slope) < 0.276)        // face horizontally
				{if (x>0) d=6;  else d=2;}
			else if (fabs(slope) > 1.61)    // face vertically
				{if (y>0) d=0;  else d=4;}
			else if (slope > 0)             // face diagonally
				{if (x>0) d=7;  else d=3;}  // positive (/) slope
			else{if (x>0) d=5;  else d=1;}  // negative (\) slope
			// move
			x = fwd*deltaX[d] + turn*sidestepX[d];  b.l += x;  b.r += x;
			y = fwd*deltaY[d] + turn*sidestepY[d];  b.t += y;  b.b += y;
			// animate
			if      (fwd>0)    {f++;  if (f>3)      f=0;}  // forward
			else if (turn==0)  {f--;  if (f>3||f<0) f=3;}  // backward
			else if (turn<0)   {f++;  if (f>7||f<4) f=4;}  // left
			else               {f--;  if (f>7||f<4) f=7;}  // right
			break;
		default:
			// turn
			d += turn;  if (d<0) d=7;  else if (d>7) d=0;
			// move
			x = fwd*deltaX[d];  b.l += x;  b.r += x;
			y = fwd*deltaY[d];  b.t += y;  b.b += y;
			// animate
			f += fwd;  if (f>7)  f = 0;  else if (f<0)  f = 7;
			break;
	}
	if (b.r>=0 && b.b>=0 && b.l<320 && b.t<200)  to = b;
}


void animation::react (int key, int extend)
{
	int choice=0, i;  if (key==0) return;
	// find out which key was pressed
	for (i=0; i<NUM_CTRLS; i++)
	{
		if (extend)
		{
			if (ext_ctrl[i]==key)  choice = i;
		}
		else if (control[i] == key)  choice = i;
	}
	// change current action (the member called 'm')
	if (choice >= 8)  {m = choice-8;  return;}
	// move and turn
	else switch (choice)
	{
		case 0 :  fwd = +1;   turn =  0;  break;
		case 1 :  fwd = +1;   turn = +1;  break;
		case 2 :  fwd =  0;   turn = +1;  break;
		case 3 :  fwd = -1;   turn = +1;  break;
		case 4 :  fwd = -1;   turn =  0;  break;
		case 5 :  fwd = -1;   turn = -1;  break;
		case 6 :  fwd =  0;   turn = -1;  break;
		case 7 :  fwd = +1;   turn = -1;  break;
		default:  break;
	}
}


