#include <stdio.h>
#include <conio.h>

// Compiled with Borland C++ v3.1
// 11:36 am EST 7/18/97

/*
	Colormap Description

The colormap is made up of 64 classes
containing 256 colors per class.. Each
class is a brightness of light, 0 being
fullbright and 63 being darkest.. Thanks
to Cable Hicks the creator of Adquedit
for helping me with the format of the
colormap, without him this wouldnt exist.

I made this just to help people who really
wanted to do colored lights but really didnt
have a clue of what to do.. Keep in mind
that this is in no way complete, ive spent
a couple days (an hour here and there)
trying to prefect this but i keep having
the same problem, i really dont have the
time to persue this any further for i have
other projects to work on so feel free to
go all out and change anything you want,
but if you can prefect this please let me
know and please distribute the code to others
as i have, because greedy programmers suck.

Have Fun!

Nine inch Nat
Wicked Development (http://wicked.unreal.org)

*/

unsigned char colormap[64][256];	// Hold the Data in 64 chunks of
					// 256 colors.

char endbyte;				// The last Byte, who knows why


// ReadMap()
// Open and read the current colormap.
void ReadMap()
{
FILE *infile;
int count, index;

	infile = fopen("colormap.lmp","rb");

	printf("Reading Colormap...\n");

	for (count = 0; count < 64; count++)			// 64 Tables
	{
		for (index = 0; index < 256; index ++)          // 256 color indexes per Table
		{
			colormap[count][index] = getc(infile);
		}
	}

	endbyte = getc(infile);					// Snag last byte

	fclose(infile);

}

// WriteData()
// Just writes the edited colormap so that you can read it.
void WriteData()
{
FILE *outfile;
int count, index;

	printf("Writing Table Data...\n");
	outfile = fopen("color.dat","wb");

	for (count = 0; count < 64; count++)
	{
		for (index = 0; index < 256; index ++)
		{
			fprintf(outfile, "Table: %d .... Data: %d\n", count, colormap[count][index]);
		}
	}

}

// WriteMap()
// Write the new colormap to a file.
void WriteMap()
{
FILE *outfile;
int count, index;
char data;

	printf("Writing new Colormap...\n");
	outfile = fopen("color2.lmp","wb");

	for (count = 0; count < 64; count++)
	{
		for (index = 0; index < 256; index ++)
		{
			data = colormap[count][index];
			putc(data,outfile);
		}
	}

	putc(endbyte, outfile);					// Write Last byte

	fclose(outfile);

}

// Modify()
// Modify the colormap, this is what you want to edit to make kewl lighting

void Modify(int begin, int end, int color)
{
unsigned char data;
int count, index, done, min, max, newdata;

	printf("Modifying Colormap...\n");

	for(count = begin; count < end; count++)
	{
		for (index = 0; index < 240; index ++)
		{

			data = colormap[count][index];

			do
			{
				if (data > 127 && data < 240 && color < 128)
				{
					done = 0;
					min = 0;
					max = 0;

					do
					{
						if(!(min <= data && max >= data))
						{
							min+=16;
							max = min + 15;
						}

						if (min <= data && max >= data)
							done = 1;
					}
					while(done != 1);

					newdata = max - data;
					data = min + newdata;

				}


				if (data < 127 && data > 0 && color > 127)
				{
					done = 0;
					min = 256;
					max = 256;
					do
					{
						if(!(min <= data && max >= data))
						{
							min-=16;
							max = min - 15;
						}

						if (min <= data && max >= data)
							done = 1;
					}
					while(done != 1);

					newdata = max - data;
					data = min + newdata;

				}

				if (data < color)
					data += 16;
				if (data > color + 15)
					data -= 16;

			} while(data < color || data > color + 15);

			colormap[count][index] = data;
		}

	}

}

void main()
{

	ReadMap();		// Read the colormap and store the data for us to use.
	Modify(0, 64, 64);	// Modify the current data
	WriteData();		// Write the Readable file.
	WriteMap();		// Write the new colormap.

}
