//tourney.c - Tourney Maker
//by David 'crt' Wright (wrightd@stanford.edu)
//code may be used only with prior written permission

#include <stdio.h>
#include <stdlib.h>

#define MAXTEAMS 256
#define MAXNAMESIZE 32
#define	NEW(t)	(t *)domalloc(sizeof(t))
#define SWAP(a,b,t)	{t=a;a=b;b=t;}
#define LOGFILE "tourney.log"
//define numlosses 4

//typedefs
typedef enum {
	ROUND_ROBIN,
	ELIM
} tourney_t;

typedef struct amatch_s {
	int	team1;
	int	team2;
	int	round;
	int	arena;
} amatch_t;


typedef struct arena_link_s {
        void *it;
        struct arena_link_s *next;
        struct arena_link_s *prev;
} arena_link_t;

//globals
int		wins[MAXTEAMS], losses[MAXTEAMS];
char	*names[MAXTEAMS];
int		logmatches=0;

static void *domalloc(int size)
{
	void *p;

	p = malloc(size);

//	if (p==NULL)
		//we are in trouble;
	memset(p,0,size);
	return p;
}

/*******
add_to_queue
*******/
void add_to_queue(arena_link_t *t, arena_link_t *que)
{
        while(que->next)
                que=que->next;
        que->next = t;
        t->prev = que;
        t->next = NULL;
}

/*******
remove_from_queue

if NULL is given as first parameter, top list item is popped off

item that is removed is returned, or NULL if not found
*******/
arena_link_t *remove_from_queue(arena_link_t *t, arena_link_t *que)
{
        arena_link_t *got = NULL;

        if(!t) t = que->next;
        if(!t) return(NULL);
        t->prev->next = t->next;
        if(t->next)
                t->next->prev = t->prev;

        return(t);
}

/*******
count_queue
*******/
int count_queue(arena_link_t *que)
{
        int i = 0;

        while(que->next) {
                que=que->next;
                i++;
        }

        return(i);
}

/************
Tourney code
**********/
//add a match to the list, using the provided info
void addmatch(arena_link_t *matchlist, int round, int team1, int team2, int arena)
{
	arena_link_t	*newlink;
	amatch_t		*newmatch;

	newlink=NEW(arena_link_t);
	newmatch=NEW(amatch_t);

	newmatch->team1 = team1;
	newmatch->team2 = team2;
	newmatch->round = round;
	newmatch->arena = arena;
	newlink->it=newmatch;
	add_to_queue(newlink, matchlist);

}

//pop a match off the list and return the info
void getmatch(arena_link_t *matchlist, int *round, int *team1, int *team2, int *arena)
{
		arena_link_t	*newlink;

		newlink=(arena_link_t *) remove_from_queue(NULL, matchlist);
		if (newlink==NULL)
			return;
		*round=((amatch_t *)newlink->it)->round;
		*team1=((amatch_t *)newlink->it)->team1;
		*team2=((amatch_t *)newlink->it)->team2;
		*arena=((amatch_t *)newlink->it)->arena;
		free(newlink);

}
//print all the matches on the list
void printmatchlist(arena_link_t *que)
{
	int i = 0;
	FILE *f;

	if (logmatches)
		f=fopen(LOGFILE,"a+");
	while(que->next) {
                que=que->next;
                i++;
                if (names[0]) //using names
                {
   	            	printf("%d: %s vs. %s round: %d server: %d\n",i, names[((amatch_t *)que->it)->team1], names[((amatch_t *)que->it)->team2], ((amatch_t *)que->it)->round, ((amatch_t *)que->it)->arena );
   	            	if (logmatches)
   	            		fprintf(f,"%d: %s vs. %s round: %d server: %d\n",i, names[((amatch_t *)que->it)->team1], names[((amatch_t *)que->it)->team2], ((amatch_t *)que->it)->round, ((amatch_t *)que->it)->arena );
   	            }
                else
                {
                	printf("%d: %d vs. %d round: %d server: %d\n",i, ((amatch_t *)que->it)->team1, ((amatch_t *)que->it)->team2, ((amatch_t *)que->it)->round, ((amatch_t *)que->it)->arena );
   	            	if (logmatches)
   	            		fprintf(f,"%d: %d vs. %d round: %d server: %d\n",i, ((amatch_t *)que->it)->team1, ((amatch_t *)que->it)->team2, ((amatch_t *)que->it)->round, ((amatch_t *)que->it)->arena );
                }
        }
	if (logmatches)
	fclose(f);

}

void PrintStats(int i)
{
	FILE *f;

	if (logmatches)
	{
		f=fopen(LOGFILE,"a+");
		if (names[0]) //using names
    		fprintf(f,"%s(%d,%d) ",names[i],wins[i],losses[i] );
		else
	    	fprintf(f,"%d(%d,%d) ",i,wins[i],losses[i] );
	    fclose(f);
	}

	if (names[0]) //using names
		printf("%s(%d,%d) ",names[i],wins[i],losses[i] );
	else
		printf("%d(%d,%d) ",i,wins[i],losses[i] );
}

void PrintArrayStats(int teamlist[], int numt)
{
	int	i;
	FILE *f;

	for (i=0 ; i<=numt ;  i++)
		PrintStats(teamlist[i]);

	printf("\n\n");
	if (logmatches)
	{
		f=fopen(LOGFILE,"a+");
		fprintf(f,"\n\n");
		fclose(f);
	}
}

void printdebug(char *s)
{
	printf("%s \n",s);
}
int RunMatch(int i, int j) //returns winner
{
	int	res;
	FILE *f;

	do {
		if (names[0]) //using names
			printf("%s(%d) vs. %s(%d)\n",names[i],i,names[j],j);
		else
			printf("%d vs. %d\n",i,j);
		printf("Winner Number? ");
		scanf("%d",&res);
	} while (res != i && res != j);
	if (logmatches)
	{
		f=fopen(LOGFILE,"a+");
		fprintf(f,"Winner: %d\n",res);
		fclose(f);
	}
	return res;

}

int SortByLosses(int players[MAXTEAMS], int numt, int numlosses) //returns number left
{
	int	i,j,t;

	for (i=0; i < numt-1 ; i++) //lazy selection sort
		for (j=i+1 ; j <= numt-1 ; j++)
		{
			if (losses[players[j]] < losses[players[i]])
				SWAP(players[i],players[j],t);
		}
	i=0;
	if (numlosses==0) //dont want to eliminate anyone
		return numt;
	while (losses[players[++i]] < numlosses) //eliminate anyone >numlosses
		if (i==numt-1) {i++; break;}

	return i;
}


/**************
RunRoundRobin - Runs a round robin tourney, everyone plays everyone.
Rotation Order Illustration of 6 player match:
X 5            0 1    0 3    0 5    0 4    0 2
1 4            2 3 -> 1 5 -> 3 4 -> 5 2 -> 4 1
2 3            4 5    2 4    1 2    3 1    5 3
***************/
void RunRoundRobin(int numt, int numar)
{
	arena_link_t	matches;
	int	i,j,blah;
	int	teamlist[MAXTEAMS];
	int true_round=0;
	int round=0;
	int arena;

	matches.next=NULL;
	matches.prev=NULL;

	//generate all matches

	for (i=0 ; i<=numt  - 1 ;  i++)
		teamlist[i]=i;

	do
	{
		round++;
		true_round++;
		arena=0;
		for (i=0 ; i<numt/2 ; i++)
		{
			addmatch(&matches,round,teamlist[i],teamlist[i+numt/2], ++arena);
			if (arena == numar) //too many matches for # of arenas
			{
				arena=0;
				round++;
			}

		}
//run it
		printmatchlist(&matches);
		do
		{
				getmatch(&matches, &blah, &i, &j, &blah);
				if (i==RunMatch(i,j))
				{
					wins[i]++;
					losses[j]++;
				} else
				{
					wins[j]++;
					losses[i]++;
				}

		} while (count_queue(&matches) != 0);
// {0,1,2,3,4,5} -> {0,3,1,4,5,2}
// do the rotation
		j=teamlist[numt/2];
		for (i=numt/2 ; i<=numt - 2 ; i++)
			teamlist[i]=teamlist[i+1]; //shift last ones left
		teamlist[numt-1]=teamlist[numt/2-1]; //move middle to last
		for (i=numt/2 - 1; i>=2 ; i--)
			teamlist[i]=teamlist[i-1]; //move first ones right
		teamlist[1]=j;

		//print some stuff
		PrintArrayStats(teamlist, numt-1);

	} while (true_round < numt - 1);


//print results
	for (i=0 ; i<=numt  - 1 ;  i++)
		teamlist[i]=i;

	SortByLosses(teamlist,numt, 0);
	PrintArrayStats(teamlist, numt - 1);


}



/**************
RunDoubleElim - Runs an N-elimination match.
Goes backwards through the array of players, any two adjacent players
with the same number of losses play. After it goes all the way through
the array, the round is over. The array is resorted after the results are
found, and the next round begins.

***************/

int RunDoubleElim(int numt, int numar, int numlosses) //returns overall winner
{
    arena_link_t	matches;
	int	teamlist[MAXTEAMS];
	int	i,j, blah;
	int	num_run;
	int	orignumt;
	int round=0;
	int arena;

	matches.prev=NULL; matches.next=NULL;
	orignumt=numt;

	for (i=0 ; i<=numt  - 1 ;  i++)
		teamlist[i]=i;


	do  //round loop
	{
		i=numt-1;
		num_run=0;
		round++;
		arena=0;
		while (i > 0) //match loop
		{
			if ((losses[teamlist[i]]==losses[teamlist[i-1]] && losses[teamlist[i]] < numlosses) || (numt<=numlosses && i==1)) //or last match(es)
			{
				addmatch(&matches, round, teamlist[i],teamlist[i-1], ++arena);
				if (arena==numar)
				{
					arena=0;
					round++;
				}
				i-=2;
				num_run++;
			} else
				i--;

		}
		if (num_run == 0)
			break;
//run it
		printmatchlist(&matches);
		do
		{
				getmatch(&matches, &blah, &i, &j, &blah);
				if (i==RunMatch(i,j))
				{
					wins[i]++;
					losses[j]++;
				} else
				{
					wins[j]++;
					losses[i]++;
				}

 		} while (count_queue(&matches) != 0);

		numt=SortByLosses(teamlist, numt, numlosses);

		PrintArrayStats(teamlist, orignumt-1);

		printf("%d left\n",numt);

	} while (num_run!=0);
	return teamlist[0];

}

/************
main
*************/
main (int argc,char *argv[])
{
	int i,numt, numar, numlosses;
	tourney_t ttype;
	char	c;

	printf("Tourney Maker 1.0\nby crt (wrightd@stanford.edu)\n\n");
	printf("Enter number of teams: ");
	scanf("%d",&numt);

	printf("Use Names [y/n]: ");
	scanf("\n%c",&c);


	if (c=='Y' || c=='y')
		for (i=0 ; i < numt;i++)
		{
			printf("%d: ",i);
			names[i]=domalloc(MAXNAMESIZE);
			scanf("%s",names[i]);
			//printf("%s\n",names[i]);
		}
	printf("Enter number of servers per round: ");
	scanf("%d",&numar);

	printf("Log matches and results to tourney.log [y/n]: ");
	scanf("\n%c",&c);
	if (c=='Y' || c=='y')
		logmatches=1;

	printf("You have entered %d teams and %d servers per round \n",numt,numar);
	printf("Tournament Type:\n  0: Round Robin\n  1: n-Elimination\n:");
	scanf("%d",&ttype);

	switch (ttype)
	{
		case ROUND_ROBIN:
			printf("Running round robin\n");
			RunRoundRobin(numt,numar);
		break;
		case ELIM:
			printf("Number of Eliminations: ");
			scanf("%d",&numlosses);
			printf("Running %d elimination\n",numlosses);
			RunDoubleElim(numt,numar,numlosses);
		break;
	}


	getch();

}

/**************
currently unused
runs a single elim tourney using a recursive method


void RunSEMatch(int players[MAXTEAMS], int results[MAXTEAMS], int losers[MAXTEAMS], int numt)
{

	if (numt!=2)
	{
		RunSEMatch(players, results, losers,numt/2);
		RunSEMatch(&players[numt/2],&results[numt/4],&losers[numt/4], numt/2);
	} else
	{
		printf("%d vs. %d\n",players[0],players[1]);
		printf("Winner? ");
		scanf("%d",&results[0]);
		losers[0] = (results[0] == players[0]) ? players[1] : players[0];
		wins[results[0]]++;
		losses[losers[0]]++;
		//getch();
	}

}


int RunSingleElim(int numt, int numar, int keepbusy)
{
	int	playar[2][MAXTEAMS];
	int	curplay, curresult;
	int	i;
	int orignumt;

	orignumt=numt;

	for (i=0 ; i<=numt  - 1 ;  i++)
		playar[0][i]=i;

	curplay=0;
	curresult=1;
	while (numt!=1)
	{

		RunSEMatch(playar[curplay], playar[curresult], &playar[curresult][numt/2], numt);

		if (keepbusy) //play the people that have lost already
			for (i=numt; i<orignumt ; i+=numt)
				RunSEMatch(playar[curplay]+i, playar[curresult]+i, &((playar[curresult]+i)[numt/2]), numt);

	for (i=0 ; i<=orignumt  - 1 ;  i++)
		printf("%d(%d,%d) ",playar[curresult][i],wins[playar[curresult][i]],losses[playar[curresult][i]] );
	getch(); printf("\n");

		numt/=2;
		i=curplay; curplay=curresult; curresult=i;

	}
	return playar[curplay][0];
}

//unused
void printmatchesbyround(arena_link_t *que, int round)
{

	 do {

		if (((amatch_t *)que->it)->round > round) break;
		if (((amatch_t *)que->it)->round < round) continue;
                printf("%d vs. %d round: %d arena: %d\n", ((amatch_t *)que->it)->team1, ((amatch_t *)que->it)->team2, ((amatch_t *)que->it)->round, ((amatch_t *)que->it)->arena );
			que=que->next;
      } while(que);

}
**************/
	/* in Arenathink
	if tournamenton && rounddone && !winnerfound
	{
		getroundmatches;
		rounddone=false
		runround;
	}
	*/
