

//Rocket Arena 2 Bot Support Routines
// Copyright 1998, David Wright
// For non-commercial use only

#include "g_local.h"
#include "bot_procs.h"
int idmap;
int num_arenas;

void SetObserverMode(edict_t *ent, observer_mode_t omode)
{
	switch(omode) 
	{
	case NORMAL:
		ent->movetype = MOVETYPE_WALK;
		ent->solid = SOLID_BBOX;
		ent->clipmask = MASK_PLAYERSOLID;
		ent->svflags&=~SVF_NOCLIENT;						
		ent->s.modelindex = 255;
		ent->client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
		break;
	case FREEFLYING :
		ent->movetype = MOVETYPE_NOCLIP;
		ent->solid = SOLID_NOT;
		ent->clipmask = 0;
		ent->svflags|=SVF_NOCLIENT;				
		ent->client->ps.pmove.pm_time = 0;
		ent->client->ps.pmove.pm_flags &= ~PMF_NO_PREDICTION;
		ent->client->ps.pmove.pm_flags &= ~PMF_TIME_TELEPORT;
		break;
	}
}

extern float	PlayersRangeFromSpot (edict_t *spot);

edict_t *SelectRandomArenaSpawnPoint (char *classn, int arena)
{
	edict_t	*spot;
	int		count = 0;
	int		selection;
	
	spot = NULL;
	while ((spot = G_Find (spot, FOFS(classname), classn)) != NULL)
	{
		if (spot->arena != arena && idmap==false) continue;
		count++;
	}
	
	if (!count)
		return NULL;
	
	selection = rand() % count;
	
	//gi.dprintf("%d spots, %d selected\n",count,selection);
	
	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname),classn);
		if (spot->arena != arena && idmap==false) 
			selection++;
	} while(selection--);
	
	return spot;
}

edict_t *SelectFarthestArenaSpawnPoint (char *classn, int arena)
{
	edict_t	*bestspot;
	float	bestdistance, bestplayerdistance;
	edict_t	*spot;
	int		count = 0;
	
	
	spot = NULL;
	bestspot = NULL;
	bestdistance = 50;
	while ((spot = G_Find (spot, FOFS(classname), classn)) != NULL)
	{
		//gi.bprintf (PRINT_HIGH,"arena %d spot %d\n", arena, spot->arena);
		if (spot->arena != arena && idmap==false) continue;
		bestplayerdistance = PlayersRangeFromSpot (spot);
		
		if (bestplayerdistance > bestdistance)
		{
			bestspot = spot;
			bestdistance = bestplayerdistance;
		}
	}
	
	if (bestspot)
	{
		return bestspot;
	}
	
	// if there is a player just spawned on each and every start spot
	// we have no choice to turn one into a telefrag meltdown
	return SelectRandomArenaSpawnPoint (classn, arena);
}

void move_to_arena (edict_t *ent, int arena, qboolean observer)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	
	edict_t	*dest;
	int i;
	
	if (observer)
	{
		if (!(dest=SelectFarthestArenaSpawnPoint ("misc_teleporter_dest", arena)))
			dest=SelectFarthestArenaSpawnPoint ("info_player_deathmatch", arena);
		
		if (arena != 0)
		{
			if (ent->client->resp.context == 0)
			{
				ent->client->resp.context=arena;
			}
		}
		else
		{
			{			
				//				show_arena_menu(ent); //else it is the first time
			}
		}
		ent->client->resp.context=arena;
		
	}
	else
	{
		//get rid of all menus
		ent->client->resp.context=arena;
		dest=SelectFarthestArenaSpawnPoint ("info_player_deathmatch", arena);
	}
	
	if (!dest)
	{
		gi.bprintf (PRINT_HIGH,"no dest found\n");
		return;
	}
	
	
	gi.unlinkentity (ent);
	
	VectorCopy (dest->s.origin, ent->s.origin);
	VectorCopy (dest->s.origin, ent->s.old_origin);
	ent->s.origin[2] += 10;
	
	// clear the velocity and hold them in place briefly
	VectorClear (ent->velocity);
	ent->client->ps.pmove.pm_time = 160>>3;		// hold time
	ent->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;
	
	// draw the teleport splash at source and on the player
	if (!observer)
		ent->s.event = EV_PLAYER_TELEPORT;
	
	// set angles
	for (i=0 ; i<3 ; i++)
		ent->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - ent->client->resp.cmd_angles[i]);
	
	VectorClear (ent->s.angles);
	VectorClear (ent->client->ps.viewangles);
	VectorClear (ent->client->v_angle);
	// telefrag avoidance at destination
	if (!KillBox (ent))
	{
	}
	if (observer)
	{
		ent->flags |= FL_NOTARGET;
		ent->takedamage = DAMAGE_NO; //always start with no damage
		
		if (strcmp(dest->classname,"misc_teleporter_dest") != 0) 
			SetObserverMode(ent,FREEFLYING);
		else
			SetObserverMode(ent,NORMAL);
		
	} else 
		SetObserverMode(ent, NORMAL);
	
	gi.linkentity(ent);//gilink
	
}

void Cmd_toarena_f (edict_t *ent, int observer)
{
	int		i;
	
	i = atoi (gi.argv(1));
	move_to_arena(ent,i,observer);
}

void Cmd_add_arena_bot_f (edict_t *ent,char *botname,int arena)
{
	edict_t *bot;
	
	//change this!!!
	bot = spawn_bot(botname);
	if (!bot)
		return;
	move_to_arena(bot,arena, true);
}

/*******
arena_init
*******/
void arena_init(edict_t *wsent)
{
	
	if(!wsent) return;
	
	num_arenas = wsent->arena; //worldspawn arena flag is # of arenas
	if (!num_arenas)
	{
		num_arenas=1;
		idmap = true;
	}
	else idmap = false;
}

extern gitem_armor_t bodyarmor_info;
extern int weapon_vals[];
//	  0  2  3  4  5   6    9   8   7
int weapon_vals_x[] = { 256, 1, 2, 4, 8, 16, 128, 64, 32 };

void get_arena_settings(arena_settings_t *settings)
{
	cvar_t *shotgun;
	cvar_t *supershotgun;
	cvar_t *machinegun;
	cvar_t *chaingun;
	cvar_t *grenadelauncher;
	cvar_t *rocketlauncher;
	cvar_t *hyperblaster;
	cvar_t *railgun;
	cvar_t *bfg;
	cvar_t *armor;
	cvar_t *health;
	cvar_t *shells;
	cvar_t *bullets;
	cvar_t *slugs;
	cvar_t *grenades;
	cvar_t *rockets;
	cvar_t *cells;
	
	shotgun=gi.cvar("shotgun","1",CVAR_SERVERINFO);
	supershotgun=gi.cvar("supershotgun","1",CVAR_SERVERINFO);
	machinegun=gi.cvar("machinegun","1",CVAR_SERVERINFO);
	chaingun=gi.cvar("chaingun","1",CVAR_SERVERINFO);
	grenadelauncher=gi.cvar("grenadelauncher","1",CVAR_SERVERINFO);
	rocketlauncher=gi.cvar("rocketlauncher","1",CVAR_SERVERINFO);
	hyperblaster=gi.cvar("hyperblaster","1",CVAR_SERVERINFO);
	railgun=gi.cvar("railgun","0",CVAR_SERVERINFO);
	bfg=gi.cvar("bfg","0",CVAR_SERVERINFO);
	armor=gi.cvar ("armor", "200", CVAR_SERVERINFO);
	health=gi.cvar ("health", "100", CVAR_SERVERINFO);
	shells=gi.cvar("shells","100",CVAR_SERVERINFO);
	bullets=gi.cvar("bullets","200",CVAR_SERVERINFO);
	slugs=gi.cvar("slugs","50",CVAR_SERVERINFO);
	grenades=gi.cvar("grenades","50",CVAR_SERVERINFO);
	rockets=gi.cvar("rockets","50",CVAR_SERVERINFO);
	cells=gi.cvar("cells","150",CVAR_SERVERINFO);
	
	settings->weapons=0;
	if (shotgun->value) settings->weapons += weapon_vals_x[1];
	if (supershotgun->value) settings->weapons += weapon_vals_x[2];
	if (machinegun->value) settings->weapons += weapon_vals_x[3];
	if (chaingun->value) settings->weapons += weapon_vals_x[4];
	if (grenadelauncher->value) settings->weapons += weapon_vals_x[5];
	if (railgun->value) settings->weapons += weapon_vals_x[6];
	if (hyperblaster->value) settings->weapons += weapon_vals_x[7];
	if (rocketlauncher->value) settings->weapons += weapon_vals_x[8];
	if (bfg->value) settings->weapons += weapon_vals_x[0];
	settings->armor = armor->value;
	settings->health = health->value;
	settings->shells = shells->value;
	settings->bullets = bullets->value;
	settings->slugs = slugs->value;
	settings->grenades = grenades->value;
	settings->rockets = rockets->value;
	settings->cells = cells->value;

}

void give_ammo(edict_t *e)
{
	arena_settings_t settings;
	
	
	qboolean	needswitch;
	gitem_t *w[9];
	gitem_t *it, *rl;
	int i;
	
	get_arena_settings(&settings);
	
	// give health
	e->health = settings.health;
	
	// give weapons
	rl = NULL;
	memset(w, 0, sizeof(w));
	w[0] = FindItemByClassname("weapon_bfg");
	w[1] = FindItemByClassname("weapon_shotgun");
	w[2] = FindItemByClassname("weapon_supershotgun");
	w[3] = FindItemByClassname("weapon_machinegun");
	w[4] = FindItemByClassname("weapon_chaingun");
	w[5] = FindItemByClassname("weapon_grenadelauncher");
	w[6] = FindItemByClassname("weapon_railgun");
	w[7] = FindItemByClassname("weapon_hyperblaster");
	w[8] = FindItemByClassname("weapon_rocketlauncher");
	needswitch = false;
	for(i=8; i>=0; i--) {
		if(settings.weapons & weapon_vals_x[i]) {
			if(!rl) {
				rl = w[i];
			}
			if(!e->client->pers.inventory[ITEM_INDEX(rl)] || needswitch) {
				e->client->newweapon = rl;
				e->client->pers.selected_item = e->client->ps.stats[STAT_SELECTED_ITEM] = ITEM_INDEX(rl);
				needswitch = false;
			}
			e->client->pers.inventory[ITEM_INDEX(w[i])] = 1;
		} else {
			if(e->client->pers.weapon == w[i]) {
				needswitch = true;
			}
			e->client->pers.inventory[ITEM_INDEX(w[i])] = 0;
		}
	}
	if(needswitch) {
		rl = FindItemByClassname("weapon_blaster");
		e->client->newweapon = rl;
		e->client->pers.selected_item = e->client->ps.stats[STAT_SELECTED_ITEM] = ITEM_INDEX(rl);
	}		
	// give ammo
	if(it = FindItemByClassname("ammo_shells")) e->client->pers.inventory[ITEM_INDEX(it)] = settings.shells;	//shells	100
	if(it = FindItemByClassname("ammo_bullets")) e->client->pers.inventory[ITEM_INDEX(it)] =settings.bullets;	//bullets       200
	if(it = FindItemByClassname("ammo_slugs")) e->client->pers.inventory[ITEM_INDEX(it)] = settings.slugs;	//slugs	 50
	if(it = FindItemByClassname("ammo_grenades")) e->client->pers.inventory[ITEM_INDEX(it)] = settings.grenades;	//grenades      50
	if(it = FindItemByClassname("ammo_rockets")) e->client->pers.inventory[ITEM_INDEX(it)] = settings.rockets;	//rockets       50
	if(it = FindItemByClassname("ammo_cells")) e->client->pers.inventory[ITEM_INDEX(it)] = settings.cells;	//cells	 200
	// give body armor
	if(it = FindItemByClassname("item_armor_body")) {
		e->client->pers.inventory[ITEM_INDEX(it)] = settings.armor;
	}
}

void Cmd_start_match_f(int context)
{
	int i;
	edict_t *e;
	
	for (i=0 ; i<maxclients->value ; i++)
	{
		e = g_edicts + 1 + i;
		if(e->inuse && e->client && e->client->resp.context == context)
		{
			e->takedamage = DAMAGE_AIM;
			e->flags &= ~FL_NOTARGET;
			give_ammo(e);
			//change this
			if (e->bot_client)
				botPickBestWeapon(e);
			move_to_arena(e, e->client->resp.context, false);
			
		}
	}
	
}

void Cmd_stop_match_f(int context)
{
	int i;
	edict_t *e;
	
	for (i=0 ; i<maxclients->value ; i++)
	{
		e = g_edicts + 1 + i;
		if(e->inuse && e->client && e->client->resp.context == context)
		{
			move_to_arena(e, e->client->resp.context, true );
			e->takedamage = DAMAGE_NO;
			e->flags |= FL_NOTARGET;
		}
	}
}

/*******
getarenaname - looks for the name from the bsp
*******/
char *getarenaname(int arena)
{
	edict_t	*spot=NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_intermission")) != NULL)
		if (spot->arena == arena)
			return spot->message;

	newname = gi.TagMalloc(35, TAG_LEVEL);
	sprintf(newname, "Arena Number %d", arena);
}

/*******
send_sound_to_arena
*******/
void send_sound_to_arena(char *soundname, int context)
{
	int i;
	edict_t *e;

	for (i=0 ; i<maxclients->value ; i++)
	{
		e = g_edicts + 1 + i;
		if(e->inuse && e->client && e->client->resp.context == context) {
			stuffcmd(e, va("play %s\n",soundname));

		}
	}
}

/*******
show_stringc
*******/
void show_stringc(char *s, int context)
{
	int i;
	edict_t *e;

	for (i=0 ; i<maxclients->value ; i++)
	{
		e = g_edicts + 1 + i;
		if(e->inuse && e->client && e->client->resp.context == context) {
			gi.centerprintf(e, s);
		}
	}
}
/*******
show_string
*******/
void show_string(int priority, char *s, int context)
{
	int i;
	edict_t *e;

	for (i=0 ; i<maxclients->value ; i++)
	{
		e = g_edicts + 1 + i;
		if(e->inuse && e->client && e->client->resp.context == context) {
			gi.cprintf(e,priority, s);
		}
	}
}
