//Quake2 .md2 file viewer
//source code released on Dec 8, 1997
//by Trey Harrison    -     trey@crack.com
//learn. do not steal.

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <windows.h>
#include <glide.h>
#include "md2view.h"

//if it wasnt read from the pak, when it loads the skin,
//it removes the pathname. otherwise it tries to read the
//skin from the pak as well
int read_from_pak;

void InitModelTexture(mdl_t *mdl, char *pakfile, int skin_num, char *skin_fname)
{
	GuTexPalette palette;
	unsigned char temppal[768];	
	FxU32 textureSize, startAddress;
	GrTexInfo info;
	unsigned char *texdata;
	unsigned char *oldmap;
  unsigned char cur_byte;
	int i,j,run_len;
	FILE *f;
	int tw,th;
  short w,h;
	GrAspectRatio_t asp;
	GrLOD_t lod;
	char  *fname;
  int    offset,size;

  //this is why the skin and .md2 must be in the same directory
  //from which you run the program
  if (!skin_fname && skin_num >= mdl->num_skins || skin_num < 0)
    return;

  if (!skin_fname)
    skin_fname = mdl->skinnames[skin_num];

  if (!read_from_pak)
  {      
    //first try regular fname
    f = fopen(skin_fname,"rb");    
    
    if (!f)
    {
      //eh.. search the current directory
      fname = remove_path(skin_fname);
      f = fopen(fname,"rb");
      
      if (!f)
      {
        ExitWithError("Unable to read model skin.");
        return;
      }
    }
    
    offset=0;
    fseek(f,0,SEEK_END);
    size=ftell(f);
    fseek(f,0,SEEK_SET);
  }
  else
  {
    f = FindInPak(pakfile,skin_fname,&size,&offset);
  }

  
  //PCX reading stuff
  fseek(f,offset+8,SEEK_SET);        
	fread(&w,sizeof(short),1,f);
	fread(&h,sizeof(short),1,f);
  
  w++;
  h++;  
  
  tw = w;
  th = h;
    
  //allocate space for the pcx to be read into
  oldmap = (unsigned char *)malloc(tw*th);
  
	fseek(f,offset+128,SEEK_SET);
	j = 0;
  
	//.pcx decoding loop type thing
	while(j < tw*th)
  {
		cur_byte = fgetc(f);
		if((cur_byte & 0xC0) == 0xC0)
    {
			run_len = cur_byte & 0x3F;
			cur_byte = fgetc(f);
			for( ;(run_len>0) && (j<tw*th); run_len--, j++)
      {
				oldmap[j] = cur_byte;
			}
		}
    else
    {
			oldmap[j] = cur_byte;
			j++;
		}
	}
	
	//read the pcx palette
  fseek(f,offset+size-768,SEEK_SET);
	fread(temppal,768,1,f);
	fclose(f);
	
	//3dfx palette table setup
	for (i=0;i<256;i++) {
		palette.data[i] = 0;
		palette.data[i] |= (unsigned int)(temppal[i*3+0]) << 16;
		palette.data[i] |= (unsigned int)(temppal[i*3+1]) << 8;
		palette.data[i] |= (unsigned int)(temppal[i*3+2]);
	}
	grTexDownloadTable(GR_TMU0,GR_TEXTABLE_PALETTE,&palette);
	
	//3dfx texture scaling crap	
	//since the 3dfx requires "nice" sized textures, we will
	//almost always have to scale the textures. upscaling is better
	//in that we loose no detail. In cases where the skin is
	//larger than 256, it will have to be downscaled since
	//the 3dfx cant handle larger textures.
		
	//Pick the closest compatible texture size

	if (tw>128)     { tw=256; }
	else if (tw>64) { tw=128; }
	else if (tw>32) { tw=64;  }
	else if (tw>16) { tw=32;  }
	else if (tw>8)  { tw=16;  }
	else if (tw>4)  { tw=8;	  }
	else if (tw>2)  { tw=4;	  }
	else if (tw>1)  { tw=2;	  }
	else ExitWithError("Bad texture width");

	if (th>128)     th=256;
	else if (th>64) th=128;
	else if (th>32) th=64;
	else if (th>16) th=32;
	else if (th>8)  th=16;
	else if (th>4)  th=8;
	else if (th>2)  th=4;
	else if (th>1)  th=2;
	else ExitWithError("Bad texture height");
	
	//Figure out which aspect ratio it is
	if (tw>th)
  {
	  switch (tw)
    {    
    case 2:   lod = GR_LOD_2;   break;
    case 4:   lod = GR_LOD_4;   break;
    case 8:   lod = GR_LOD_8;   break;
    case 16:  lod = GR_LOD_16;  break;
    case 32:  lod = GR_LOD_32;  break;
    case 64:  lod = GR_LOD_64;  break;
    case 128: lod = GR_LOD_128; break;
    case 256: lod = GR_LOD_256; break;
    }
          
    switch(tw/th)
    {
		case 1: asp = GR_ASPECT_1x1;
				break;
		case 2: asp = GR_ASPECT_2x1;
				break;
		case 4: asp = GR_ASPECT_4x1;
				break;
		case 8:	asp = GR_ASPECT_8x1;
				break;
		default: asp = -1;
		}
	}
  else
  {
		switch (th)
    {    
    case 2:   lod = GR_LOD_2;   break;
    case 4:   lod = GR_LOD_4;   break;
    case 8:   lod = GR_LOD_8;   break;
    case 16:  lod = GR_LOD_16;  break;
    case 32:  lod = GR_LOD_32;  break;
    case 64:  lod = GR_LOD_64;  break;
    case 128: lod = GR_LOD_128; break;
    case 256: lod = GR_LOD_256; break;
    }

    switch(th/tw) {
		case 1: asp = GR_ASPECT_1x1;
				break;
		case 2: asp = GR_ASPECT_1x2;
				break;
		case 4: asp = GR_ASPECT_1x4;
				break;
		case 8:	asp = GR_ASPECT_1x8;
				break;		
		default: asp = -1;
		}
	}
	if (asp==-1) {
		ExitWithError("Unable to determine aspect ratio");
	}
	
	//only 1 Lod ("level of detail")
	info.smallLod = lod;
	info.largeLod = lod;
	info.aspectRatio = asp;
	info.format = GR_TEXFMT_P_8;	
	
  //make sure we havent fucked anything
  textureSize = grTexTextureMemRequired(GR_MIPMAPLEVELMASK_BOTH, &info);
	if (textureSize != (FxU32)tw*th) ExitWithError("Miscalculating required memory");
	
	//allocate memory for the scaled texture
	texdata = (unsigned char *)malloc(tw*th);
	if (texdata==NULL) {
		ExitWithError("Not enough memory for scaled texture");
	}
	 
	//scale the old texture 
  for (i=0;i<th;i++) {
		for(j=0;j<tw;j++) {
			texdata[i*tw + j] = 				
				//scaling formula. pretty simple. also pretty slow. =)
				oldmap[
				(int)((float)j*(float)w/(float)tw) +
				(int)((float)i*(float)h/(float)th)*w
				];				
		}
	}
	//point the info.data to the new scaled texture
	info.data = texdata;
	
	//we'll put this at the very beginning of texture memory
	//since, after all, we're only dealing with 1 texture and
	//dont need to do any sort of texture memory management
	startAddress = grTexMinAddress(GR_TMU0);

	//download it into memory
	grTexDownloadMipMap(GR_TMU0,startAddress,GR_MIPMAPLEVELMASK_BOTH,&info);
	
	//set it as the texture source
	grTexSource(GR_TMU0,startAddress,GR_MIPMAPLEVELMASK_BOTH,&info);
		
	//store the scaled width and height into the model structure
  if (tw>th)
  {
    mdl->s_scale = 256.0;
	  mdl->t_scale = 256.0 * (float)th/(float)tw;	
  }
  else
  {
    mdl->t_scale = 256.0;
	  mdl->s_scale = 256.0 * (float)tw/(float)th;	
  }

  free(texdata);
  free(oldmap);
}

//these effect the view window
#define ZSCALE 512.f

#define DEG2RAD(x) (x*(float)3.1415927/(float)180)

__inline void XRotatePoint(vec3_t *in, vec3_t *out, float c, float s)
{
	out->x = in->x;
	out->y = (in->y*c) - (in->z*s);
	out->z = (in->y*s) + (in->z*c);
}

__inline void YRotatePoint(vec3_t *in,vec3_t *out,float c, float s)
{										 
	out->x = (in->x*c) + (in->z*s);
	out->y = in->y;
	out->z = (in->z*c) - (in->x*s);
}


__inline void ZRotatePoint(vec3_t *in, vec3_t *out, float c, float s)
{
	out->x = (in->x*c) + (in->y*s);
	out->y = (in->y*c) - (in->x*s);
	out->z = in->z;  
}

GrVertex    vert_list[64];

void DrawModel(mdl_t *mdl, float Xrot, float Yrot, float Zrot, int frame, float ratio, int Xoffs, int Yoffs, float Zoffs)
{
	int         i,nextframe;
	float       z,invz;
	float       Xcos,Ycos,Zcos,Xsin,Ysin,Zsin;
  vec3_t      p1;
  vec3_t      p2;
  vec3_t      p,rp;
	
  GrVertex    *v;
  frameinfo_t *frameinfo1,*frameinfo2;
  int         *command;
  int         num_verts,vert_index;
  int         command_type;
			
  //this is required so that the VTX_SNAPS work
  SetIntelPrecision();

  //only need to calculate these rotation sins and cosines once
	//per frame
	Xcos = (float)cos(DEG2RAD(Xrot));
	Xsin = (float)sin(DEG2RAD(Xrot));
 	
	Ycos = (float)cos(DEG2RAD(Yrot));
	Ysin = (float)sin(DEG2RAD(Yrot));
 	
	Zcos = (float)cos(DEG2RAD(Zrot));
	Zsin = (float)sin(DEG2RAD(Zrot));
 	
	//keep the frame value valid
	frame     = frame % mdl->numframes;		
	nextframe = (frame+1) % mdl->numframes;

	frameinfo1 = (frameinfo_t *)((char *)mdl->frames + mdl->framesize*frame);
  frameinfo2 = (frameinfo_t *)((char *)mdl->frames + mdl->framesize*nextframe);
  
  command = mdl->glcmds;
  
	//do the gl commands <?>
  while (*command)
  {
    if (*command>0)
    {
      //triangle strip
      num_verts = *command;
      command_type = 0;
    }
    else
    {
      //triangle fan
      num_verts = -(*command);
      command_type = 1;
    }
    
    command++;
    
    for (i=0,v=vert_list; i<num_verts; i++,v++)
    {
      //grab the floating point s and t
      v->tmuvtx[0].sow = (*((float *)command)) * mdl->s_scale;  command++;
      v->tmuvtx[0].tow = (*((float *)command)) * mdl->t_scale; command++;      
      
      //grab the vertex index
      vert_index = *command;   command++;

      //grab the 2 vertices to interpolate between
      p1.z = -((frameinfo1->verts[vert_index].x * frameinfo1->scale.x) + frameinfo1->origin.x);
		  p1.x =  ((frameinfo1->verts[vert_index].y * frameinfo1->scale.y) + frameinfo1->origin.y);
		  p1.y = -((frameinfo1->verts[vert_index].z * frameinfo1->scale.z) + frameinfo1->origin.z);

      p2.z = -((frameinfo2->verts[vert_index].x * frameinfo2->scale.x) + frameinfo2->origin.x);
		  p2.x =  ((frameinfo2->verts[vert_index].y * frameinfo2->scale.y) + frameinfo2->origin.y);
		  p2.y = -((frameinfo2->verts[vert_index].z * frameinfo2->scale.z) + frameinfo2->origin.z);

      //interpolate
      p.x = p1.x + (p2.x - p1.x)*ratio;
      p.y = p1.y + (p2.y - p1.y)*ratio;
      p.z = p1.z + (p2.z - p1.z)*ratio;
      
		  //transform the point
      ZRotatePoint(&p,&rp,Zcos,Zsin);
      YRotatePoint(&rp,&p,Ycos,Ysin);
  		XRotatePoint(&p,&rp,Xcos,Xsin);
            
      //setup the point
		  z = rp.z + Zoffs;		
		  
      invz   = 1.f / z;
      v->x   = (ZSCALE * rp.x * invz) + Xoffs;
		  v->y   = (ZSCALE * rp.y * invz) + Yoffs;
		  v->oow = invz;			
				
      v->x += VTX_SNAP; v->x -= VTX_SNAP;
		  v->y += VTX_SNAP; v->y -= VTX_SNAP;
		
      v->tmuvtx[0].sow *= invz;
		  v->tmuvtx[0].tow *= invz;

      v->r = 255.f;
  		v->g = 255.f;
	    v->b = 255.f;      
    }
    
    switch (command_type)
    {
    case 0:
      //tristrip
      for (i=0;i<num_verts-2;i++)
      {
        //this is to ensure correct vertex order
        if (i&1)
          guDrawTriangleWithClip(&vert_list[i],&vert_list[i+2],&vert_list[i+1]);
        else
          guDrawTriangleWithClip(&vert_list[i],&vert_list[i+1],&vert_list[i+2]);
      }
      break;

    case 1:
      //trifan
      for (i=0;i<num_verts-2;i++)
      {
        guDrawTriangleWithClip(&vert_list[0],&vert_list[i+1],&vert_list[i+2]);
      }
      break;
    }
  }    
}

void mdl_loader(FILE *f, mdl_t *mdl, int offset)
{
  //assumes F is pointing right at the mdl header
  int i;

  mdlheader_t mdlheader;

  //read the header
  fread(&mdlheader,sizeof(mdlheader_t),1,f);    
  
  //dont need all the info from the header, just some of it
  mdl->numframes   = mdlheader.num_frames;
	mdl->framesize   = mdlheader.framesize;

  mdl->num_glcmds  = mdlheader.num_glcmds;  

  mdl->skinwidth   = mdlheader.skinwidth;
	mdl->skinheight  = mdlheader.skinheight;    
  
  //only need to allocate room for the glcmds and the framedata

  fseek(f,offset+mdlheader.ofs_glcmds,SEEK_SET);
  mdl->glcmds = (long *)SafeMalloc(mdl->num_glcmds * sizeof(long));
  fread(mdl->glcmds,mdl->num_glcmds*sizeof(long),1,f);

  fseek(f,offset+mdlheader.ofs_frames,SEEK_SET);
  mdl->frames = (frameinfo_t *)SafeMalloc(mdl->framesize*mdl->numframes);
  fread(mdl->frames,mdl->framesize*mdl->numframes,1,f);  

	//the 1st skin name will be used as the texture
  fseek(f,offset+mdlheader.ofs_skins,SEEK_SET);
  mdl->num_skins = mdlheader.num_skins;
  mdl->skinnames = (char **)SafeMalloc(sizeof(char *) * mdl->num_skins);
  for (i=0; i<mdl->num_skins; i++)
  {
    mdl->skinnames[i] = (char *)SafeMalloc(64);
    fread(mdl->skinnames[i],64,1,f);
  }
}

FILE *FindInPath(char *path, char *filename, int *size, int *offset)
{  
  char fname[256];
  FILE *f;

  strcpy(fname,path);
  
  dos_path(filename);

  strcat(fname,filename);

  f = fopen(fname,"rb");
  
  if (!f)
    return 0;
  
  fseek(f,0,SEEK_END);
  *size   = ftell(f);
  fseek(f,0,SEEK_SET);
  
  *offset = 0;
  
  return f;
}

FILE *FindInPak(char *pakname, char *filename, int *size, int *offset)
{
  //the size / offset thing is used so that the same code
  //can be reading either from a regular file, or a file
  //contained in in a .pak file

  int          num_pak_entries;
  pakentry_t  *pak_entries;
  pakheader_t  pakheader;
  int          i,found;
  FILE        *f; 
  
  if (pakname[0]==0) ExitWithError("Invalid pak filename");

  f = fopen(pakname,"rb");
  
  if (!f)
    return FindInPath(extract_path(pakname),filename,size,offset);

  fread(&pakheader,sizeof(pakheader_t),1,f);
  
  fseek(f,pakheader.diroffset,SEEK_SET);
  num_pak_entries = pakheader.dirsize / (sizeof(pakentry_t));

  pak_entries = (pakentry_t *)SafeMalloc(sizeof(pakentry_t) * num_pak_entries);
  fread(pak_entries,pakheader.dirsize,1,f);

  found = 0;

  for (i=0;i<num_pak_entries;i++)
  {
    if (!stricmp(pak_entries[i].filename,filename))
    {
      //found it.
      found = 1;
      break;
    }
  }  

  if (!found)
  {
    //couldnt find it. return 0
    free(pak_entries);
    return FindInPath(extract_path(pakname),filename,size,offset);    
  }  

  fseek(f,pak_entries[i].offset,SEEK_SET);

  *size   = pak_entries[i].size;
  *offset = pak_entries[i].offset;

  free(pak_entries);  
  return f;
}


mdl_t *LoadMDLFromMDL(char *fname)
{
  FILE        *f;	
	mdl_t       *mdl;

  if (fname[0]==0) ExitWithError("Invalid mdl filename");
	f = fopen(fname,"rb");
	if (f==NULL) ExitWithError("Unable to open mdl file");
  
  mdl = (mdl_t *)SafeMalloc(sizeof(mdl_t));	
	memset(mdl,0,sizeof(mdl_t));

  mdl_loader(f,mdl,0);  

  fclose(f);

	read_from_pak = 0;

  return(mdl);
}

mdl_t *LoadMDLFromPAK(char *pakname, char *mdlname)
{
  FILE        *f;	
	mdl_t       *mdl;  
  int         size,offset;

  f = FindInPak(pakname,mdlname,&size,&offset);
	if (f==NULL)
  {    
    return LoadMDLFromMDL(mdlname);
  }  

  mdl = (mdl_t *)SafeMalloc(sizeof(mdl_t));	
	memset(mdl,0,sizeof(mdl_t));

  mdl_loader(f,mdl,offset);

  fclose(f);
	
  read_from_pak = 1;

  return(mdl);
}

void FreeModel(mdl_t *mdl)
{
  int i;

  if (!mdl) return;

	if (mdl->frames)
  {
    free(mdl->frames);
    mdl->frames = 0;
  }
	
  if (mdl->glcmds)
  {
    free(mdl->glcmds);
    mdl->glcmds = 0;
  }

  if (mdl->skinnames)
  {
    for (i=0; i<mdl->num_skins; i++)
    {
      if (mdl->skinnames[i])
      {
        free(mdl->skinnames[i]);
        mdl->skinnames[i] = 0;
      }
    }
    free(mdl->skinnames);
    mdl->skinnames = 0;
  }
}

void WriteMdlList(char *pakname)
{
  int          num_pak_entries;
  pakentry_t   pak_entry;
  pakheader_t  pakheader;
  int          i,found;
  FILE        *f,*f2;
  char         md2name[256];

  f = fopen(pakname,"rb");
  
  if (!f)
    ExitWithError("Invalid pak filename");    

  fread(&pakheader,sizeof(pakheader_t),1,f);
  
  fseek(f,pakheader.diroffset,SEEK_SET);
  num_pak_entries = pakheader.dirsize / (sizeof(pakentry_t));

  f2 = fopen("md2names.txt","wb");

  for (i=0;i<num_pak_entries;i++)
  {
    fread(&pak_entry,sizeof(pakentry_t),1,f);
    ExtractExtName(".md2",pak_entry.filename,md2name);

    if (md2name[0])
    {
      fwrite(md2name,strlen(md2name),1,f2);
      fputc('\n',f2);
    }
  }

  fclose(f2);
  fclose(f);  
}
