//
//  SnipeHud v1.2
//
//  Written by Tim "Zear" Hammock (zear@planetstarsiege.com)
//  April 6 - 13, 1999
//
//  Thanks to Cowboy for the crosshair code snippet - genius
//  Thanks to DS.Poker for the basis for my zoom-setting-chain-thingy
//  Thanks to Presto for most of the 1.01 changes
//  Thanks to the 1.1 beta testers for the many corrections and suggestions
//
//  New in version 1.2 (4/13/99):
//      $SnipeHud::position (hud placement) uses newest Presto style
//      Added zoom level indicator
//      Added banner for main menu screen
//      Added passive/active toggle for sensitivity
//      Added momentary/static toggle
//      Mouse x-axis flipping now also handled automatically
//
//  New in version 1.1 (4/9/99 - No public release):
//      REQUIRES Presto Pack v0.93 or better
//      Crosshair location calculation now works always (thanks Cowboy)
//      Mouse y-axis flipping handled automatically (thanks Presto)
//      Default mouse sensitivity handled automatically (thanks Presto)
//
//  New in version 1.01 (4/8/99):
//      Mouse y-axis flipped playstyle supported
//      Presto cleaned it up and added relative placement
//      Presto also found and fixed a bug in my Presto-ization
//          that resulted in multiple view objects being created
//
//  New in version 1.0 (4/7/99):
//      Mouse sensitivity is implemented
//      Crosshair
//      Window border
//      Fixed a 'Doh!' style bug in keybinding
//

// ---------------------------------------------------------------------------
// begin user prefs

// Please see the readme for instructions on how to set these preferences

$SnipeHud::position = "100% 100% 30% 30%";  // Position and size specified as
                                            //     "x y width height"

$SnipeHud::zoomToggle = ";";	// key to bind to toggle on/off
                                //     (press on, press off)

$SnipeHud::sensitivity = "l";   // key to bind to mouse sensitivity on/off
                                //     (press on, release off or vice-versa)

$SnipeHud::zoomInKey = ".";	    // key to bind for zoom in

$SnipeHud::zoomOutKey = ",";	// key to bind for zoom out

$SnipeHud::initialOn = false;	// true:  SnipeHud visible at startup
                                // false: SnipeHud not visible at startup

$SnipeHud::passiveSense = true; // true:  sensitivity in passive mode
                                // false: sensitivity in active mode

$SnipeHud::momentary = false;	// true:  press/release performs on/off of hud
                                // false: press/press performs on/off of hud

$SnipeHud::set[2] = "x 5 0.003";    // zoom levels and corresponding mouse
$SnipeHud::set[5] = "2 10 0.002";   //     sensitivity settings
$SnipeHud::set[10] = "5 20 0.001";
$SnipeHud::set[20] = "10 x 0.0005";

// end user prefs
// ---------------------------------------------------------------------------


Include("presto\\HUD.cs");

function SnipeHud::zoom(%val)
{
    if (%val == in)
    {
        SnipeHud::zoom(getWord($SnipeHud::set[$pref::SnipeHud::currentZoom], 1));
        return;
    }

    if (%val == out)
    {
        SnipeHud::zoom(getWord($SnipeHud::set[$pref::SnipeHud::currentZoom], 0));
        return;
    }

    if(%val > 20 || %val < 1 || %val == "x")
        return;
    
    $pref::SnipeHud::currentZoom = %val;

    if($SnipeHud::zoomState)
        SnipeHUD::newView();
}

function SnipeHud::calcViewSize()
{
    %screen = Presto::ScreenSize();
    $SnipeHud::viewWidth = getWord(%screen, 0) * $pref::SnipeHud::currentZoom;
    $SnipeHud::viewHeight = getWord(%screen, 1) * $pref::SnipeHud::currentZoom;
    $SnipeHud::viewX = (HUD::Width(SnipeHUD::frame) / 2) - ($SnipeHud::viewWidth / 2) - 2;
    $SnipeHud::viewY = (HUD::Height(SnipeHUD::frame) / 2) - ($SnipeHud::viewHeight / 2) - 2;
}

function SnipeHUD::newView()
{
    SnipeHud::calcViewSize();
    if ($SnipeHud::view != -1)
        deleteObject($SnipeHud::view);
    
    $SnipeHud::view = newObject("SnipeHud::view", SimGui::TSControl, $SnipeHud::viewX, $SnipeHud::viewY, $SnipeHud::viewWidth, $SnipeHud::viewHeight);
    addToSet($SnipeHud::mask, $SnipeHud::view);
    
    if ($SnipeHud::zoomState && $SnipeHud::senseOn)
        SnipeHud::setSensitivity(getWord($SnipeHud::set[$pref::SnipeHud::currentZoom], 2));

    HUD::Update(SnipeHud::zoomLevel);
}
Event::Attach(eventHudResized, SnipeHUD::newView);
 
function SnipeHud::display(%on)
{
    if (%on == toggle)
        %on = !$SnipeHud::zoomState;
    HUD::Display(SnipeHud::frame, %on);
    HUD::Display(SnipeHud::zoomLevel, %on);
    HUD::Display(SnipeHud::crosshairs, %on);
    HUD::Display(SnipeHud::crosshairs2, %on);
    $SnipeHud::zoomState = %on;
    if (%on)
    {
        if(!$SnipeHud::passiveSense)
            SnipeHud::sensitivity(true);
        SnipeHUD::newView();
    }
    else
    {
        SnipeHud::sensitivity(false);
    }
}

function SnupeHud::update()
{
    HUD::AddTextLine(SnipeHud::zoomLevel, "<f1>"@$pref::SnipeHud::currentZoom@"x");
}

function SnipeHud::sensitivity(%on)
{
    if (%on == toggle)
        %on = !$SnipeHud::senseOn;
    
    if (%on && $SnipeHud::zoomState)
    {
        $SnipeHud::normalMouseSensitivity = Client::getMouseSensitivity("playMap.sae");
        SnipeHud::setSensitivity(getWord($SnipeHud::set[$pref::SnipeHud::currentZoom], 2));
        $SnipeHud::senseOn = true;
        return;
    }
    
    if (!%on && $SnipeHud::normalMouseSensitivity != "")
    {
        SnipeHud::setSensitivity($SnipeHud::normalMouseSensitivity);
        $SnipeHud::senseOn = false;
    }
}

function SnipeHud::setSensitivity(%sensitivity)
{
    if(%sensitivity < $minMouseSensitivity)
        %sensitivity = $minMouseSensitivity;
    if(%sensitivity > $maxMouseSensitivity)
        %sensitivity = $maxMouseSensitivity;
    
    EditActionMap("playMap.sae");
    //bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    if(Client::getMouseXAxisFlip("playMap.sae"))
    {
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sensitivity);
    }
    else
    {
        bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    }
    if(Client::getMouseYAxisFlip("playMap.sae"))
    {
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sensitivity);
    }
    else
    {
        bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
    }
}

function null() {}

$SnipeHUD::crosshairHpos = "center(SnipeHud::frame)-5 center(SnipeHud::frame)-1 11 3";
$SnipeHUD::crosshairVpos = "center(SnipeHud::frame) center(SnipeHud::frame)-5 2 11";

$SnipeHud::senseOn = false;
$SnipeHud::zoomState = $SnipeHud::initialOn;

EditActionMap("playMap.sae");
bindCommand(keyboard0, make, $SnipeHud::zoomInKey, TO, "SnipeHud::zoom(in);");
bindCommand(keyboard0, make, $SnipeHud::zoomOutKey, TO, "SnipeHud::zoom(out);");

bindCommand(keyboard0, make, $SnipeHud::zoomToggle, TO, "SnipeHud::display(toggle);");
if($SnipeHud::momentary)
    bindCommand(keyboard0, break, $SnipeHud::zoomToggle, TO, "SnipeHud::display(toggle);");
else
    bindCommand(keyboard0, break, $SnipeHud::zoomToggle, TO, "null();");

if($SnipeHud::passiveSense)
{
    bindCommand(keyboard0, make, $SnipeHud::sensitivity, TO, "SnipeHud::sensitivity(true);");
    bindCommand(keyboard0, break, $SnipeHud::sensitivity, TO, "SnipeHud::sensitivity(false);");
}
else
{
    bindCommand(keyboard0, make, $SnipeHud::sensitivity, TO, "SnipeHud::sensitivity(false);");
    bindCommand(keyboard0, break, $SnipeHud::sensitivity, TO, "SnipeHud::sensitivity(true);");
}

$SnipeHud::view = -1;
HUD::New(SnipeHud::frame, "", $SnipeHud::position);
$SnipeHud::mask = HUD::AddObject(SnipeHud::frame, SimGui::Control, 2, 2, HUD::Width(SnipeHud::frame)-4, HUD::Height(SnipeHud::frame)-4);

HUD::New(SnipeHud::zoomLevel, "SnupeHud::update", "left(SnipeHud::frame)+2 top(SnipeHud::frame)+2 30 15");

HUD::New(SnipeHud::crosshairs, "", $Snipehud::crosshairHpos);
HUD::New(SnipeHud::crosshairs2, "", $Snipehud::crosshairVpos);

if($pref::SnipeHud::currentZoom < 1 || $pref::SnipeHud::currentZoom > 20)
{
    %i = 1;
    while($SnipeHud::set[%i] == "" && %i < 21)
    { %i++; }
    if(%i > 20)
    {
        echo("No SnipeHud zoom steps specified");
        %i = 1;
    }
    $pref::SnipeHud::currentZoom = %i;
}
    
Presto::AddScriptBanner(SnipeHud, "\n<f2><jc>SnipeHud!\n\n<f0><jc>(ver. 1.2)\n\n<f1><jc>By Tim \"Zear\" Hammock\n\n<f0><jc>zear@planetstarsiege.com");

if($SnipeHud::initialOn && !$SnipeHud::momentary)
    SnipeHUD::display(true);
