// Extended favorites and autolast favorites by Doug.
// Lets you set alternate favorites or extra favorites
// for current favorite keys. Also buys the last favorite
// you bought when you enter an inventory station.
// Heavily modified from Writer's One Tap Throw script.
// --------
// This script is to allow you to set alternate favorite keys to what your current keys
// are set to. For instance my first favorite key buys me scout armor with an 
// Inteceptor Pack, I could set the alternate to be Scout armor with various weapons.
// --------
// To set an alternate favorite, simply hold the key you wish the alternate to be bound to
// for the time you set, to save frustration, hold it for double the time you set it for.
// Then simply buy/sell and click Mark Favorite, and your alternate favorite will be marked.
// Your alternate favorite will be marked to your favorite number + your total favorites.
// Meaning if you mark fav 2, and you have a total of 6, it will be saved to favorite 8.
// You can also do this if you aren't at an INV station, so you can set your next favorite to 
// bought.
// --------
// Set your variables below
// -----------------------------------------------------------------------------------------
// =========================================================================================
function Doug::ToggleFav()
{
	if ($Doug::togglefav == "on")
	{
		$Doug::togglefav = "off";
	Client::centerPrint("<f1>Autobuy Favorites <f0>Off\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $Doug::textdelay);
	}
	else if ($Doug::togglefav == "off")
	{
		$Doug::togglefav = "on";
	Client::centerPrint("<f1>Autobuy Favorites <f0>On\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $Doug::textdelay);
	}
}
function Doug::ToggleCleanSell()
{
	if ($Doug::togglecleansell == "on")
	{
		$Doug::togglecleansell = "off";
	Client::centerPrint("<f1>Automatically sell useless ammo <f0>Off\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $Doug::textdelay);
	}
	else if ($Doug::togglecleansell == "off")
	{
		$Doug::togglecleansell = "on";
	Client::centerPrint("<f1>Automatically sell useless ammo <f0>On\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $Doug::textdelay);
	}
}

$Doug::stationaccess = "off";
$Doug::last = $Doug::FavOnEntry;

function Doug::extFav(%on, $Doug::favnum)
{
    	if(%on)
	{
   		 $WithinFavTapTime = 1;               
   		 schedule("$WithinFavTapTime=0;", $Doug::delaytime);   		 
	}	
    	else if($WithinFavTapTime)
        {	
		if ($Doug::stationaccess == "on")
		{
    				if ($Doug::togglecleansell == "on")
    				{
    					schedule("Doug::CleanUpSell();",$Doug::cleandelay);
       					CmdInventoryGui::buyFavorites($Doug::favnum);
       					$Doug::last = $Doug::favnum;
    				}
    	    			else if ($Doug::togglecleansell == "off")
    				{
       					CmdInventoryGui::buyFavorites($Doug::favnum);
       					$Doug::last = $Doug::favnum;
    				}
		}
		else if ($Doug::stationaccess == "off")
		{
			$Doug::last = $Doug::favnum;
		}
        }
        else
        {
		if ($Doug::stationaccess == "on")
		{
		    		if ($Doug::togglecleansell == "on")
    				{
    					schedule("Doug::CleanUpSell();",$Doug::cleandelay);
       					CmdInventoryGui::buyFavorites($Doug::favnum + $Doug::totalfav);
       					$Doug::last = $Doug::favnum + $Doug::totalfav;
    				}
    	    			else if ($Doug::togglecleansell == "off")
    				{
       					CmdInventoryGui::buyFavorites($Doug::favnum + $Doug::totalfav);
       					$Doug::last = $Doug::favnum + $Doug::totalfav;
    				}
		}
		else if ($Doug::stationaccess == "off")
		{
			$Doug::last = $Doug::favnum + $Doug::totalfav;
		}

	}
	schedule("HUD::Update(FavHUD);", $Doug::hudupdate);
}

function Doug::LastFav::parseForLastFav(%client, %msg)
{
	if(%client)
        return;
        
    if (String::findSubStr(%msg, "Station Access On") != -1)
    {
    	if ($Doug::togglefav == "on")
    	{
    		if ($Doug::togglecleansell == "on")
    		{
    			schedule("Doug::CleanUpSell();",$Doug::cleandelay);
       			CmdInventoryGui::buyFavorites($Doug::last);
    		}
    	    	else if ($Doug::togglecleansell == "off")
    		{
       			CmdInventoryGui::buyFavorites($Doug::last);
    		}
    		
    	}
    	else if ($Doug::togglefav == "off")
    	{
    		schedule("remoteEval(2048, playAnim, 11);",1.5);
    	}
    	$Doug::stationaccess = "on";
    }
    if (String::findSubStr(%msg, "Station Access Off") != -1)
    {
    	$Doug::stationaccess = "off";
    	
    	if ($Doug::last == "1")
    	{
    		use($Doug::fav1wep);
    		if ($Doug::fav1wep == "Thunderbolt")
    		{
			useItem("49");
		}
    	}
    	else if ($Doug::last == "2")
    	{
    		use($Doug::fav2wep);
    		if ($Doug::fav2wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "3")
    	{
    		use($Doug::fav3wep);
    		if ($Doug::fav3wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "4")
    	{
    		use($Doug::fav4wep);
    		if ($Doug::fav4wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "5")
    	{
    		use($Doug::fav5wep);
    		if ($Doug::fav5wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "6")
    	{
    		use($Doug::fav6wep);
    		if ($Doug::fav6wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "7")
    	{
    		use($Doug::fav7wep);
    		if ($Doug::fav7wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "8")
    	{
    		use($Doug::fav8wep);
    		if ($Doug::fav8wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "9")
    	{
    		use($Doug::fav9wep);
    		if ($Doug::fav9wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
      	else if ($Doug::last == "10")
    	{
    		use($Doug::fav10wep);
    		if ($Doug::fav10wep == "Thunderbolt")
    		{
    		useItem("49");
    		}
    	}
    	else
    	{
    		use("Disc Launcher");
    	}
    }
}
Event::Attach(eventClientMessage, Doug::LastFav::parseForLastFav);

// ===================================================================================================
// Doug::extFav(1, FAVORITE); This will say you are holding FavKey1 down to the function
// Doug::extFav(0, FAVORITE); This will say you are no longer holding Favkey1 down
// The function measures how long you held the key down and then buys the appropriate favorite
// ---------------------------------------------------------------------------------------------------
// To add a favorite key, simply copy and paste
// the bind lines, and change the numbers to that favkey.
// The sixth favkey is for my personal usage, you can use it though.
// You will also want to add a $Doug::favwep above for it (by copying and pasting again) in the 
// parsing area, you will want to add and define $Doug::favkey# in doug.cs as well.
// And in favhud.cs, you will want to add that in there as well.
// As you can see, this is quite a project, especially for someone who doesn't script
// In the future I plan to make this much easier. I just need to find out how heh.
// ---------------------------------------------------------------------------------------------------
EditActionMap("playMap.sae");  
bindCommand(keyboard0, make, $Doug::favkey1, TO, "Doug::extFav(1, 1);");
bindCommand(keyboard0, break, $Doug::favkey1, TO, "Doug::extFav(0, 1);");

bindCommand(keyboard0, make, $Doug::favkey2, TO, "Doug::extFav(1, 2);");
bindCommand(keyboard0, break, $Doug::favkey2, TO, "Doug::extFav(0, 2);");

bindCommand(keyboard0, make, $Doug::favkey3, TO, "Doug::extFav(1, 3);");
bindCommand(keyboard0, break, $Doug::favkey3, TO, "Doug::extFav(0, 3);");

bindCommand(keyboard0, make, $Doug::favkey4, TO, "Doug::extFav(1, 4);");
bindCommand(keyboard0, break, $Doug::favkey4, TO, "Doug::extFav(0, 4);");

bindCommand(keyboard0, make, $Doug::favkey5, TO, "Doug::extFav(1, 5);");
bindCommand(keyboard0, break, $Doug::favkey5, TO, "Doug::extFav(0, 5);");

bindCommand(keyboard0, make, $Doug::favkey6, TO, "Doug::extFav(1, 6);");
bindCommand(keyboard0, break, $Doug::favkey6, TO, "Doug::extFav(0, 6);");

bindCommand(keyboard0, make, $Doug::togglekey, TO, "Doug::ToggleFav();");
bindCommand(keyboard0, make, $Doug::togglecleankey, TO, "Doug::ToggleCleanSell();");
bindCommand(keyboard0, make, $Doug::buylastitemkey, TO, "CmdInventoryGui::buySelected();");
bindCommand(keyboard0, make, $Doug::markfavskey, TO, "CmdInventoryGui::markFavorites();");