// BE SURE YOU READ DOUG.TXT AND ALL DOCUMENTATION
// Version 0.2

// Note from Doug

// All binding variables are plain keys on your keyboard. Meaning it does not contain shift, ctrl, or alt. Nor
// is it a mouse key, nor can it be a mouse key.
// All bindings that I have in this .cs file are here because I use control, alt, shift, or the mouse for them
// and I am quite sure not everyone would want to use it like that.
// If you wish to have a toggle, a favorite key, or something else with Shift, Control, or Alt appended to it, you
// must go into the .cs file for it and change it yourself (sorry).

// ==========================
// Global Setting - Text delay
// ==========================

$Doug::textdelay = "4"; 		// Set this for how long you want notification text to stay on your screen.
$Doug::hudupdate = "0.1";		// Set this value higher if your HUD is having a hard time updating.
					// This may be misleading as the hudupdate is actually a time delay variable
					// Its a called schedule, its delayed .1 seconds at the end of my favorites function
					// to make sure it gets all the info from the function, your hud is only updated
					// when you use the favorites function.

// ==========================
// adminpass.cs Set a password for a server you regularly admin.
// ==========================

$Doug::adminpass = "";

// ==========================
// favorites.cs bindings
// ==========================
// How favorites.cs works
// When you access the extra favorite on your key, it reads the original favorite on that key
// and then adds $Doug::totalfav to that, so if you hit your Favorite1 key to access the extra favorite
// it will add your $Doug::totalfav (defaulted to 5) and make it 6. This way it creates a 6th favorite
// if you dont have one set, making it come right after your original favorites.
// Therefor, one key will access favorites 1 and 6, another will access 2 and 7, and so on
// This is why you set $Doug::totalfav to the total number of favorite keys you have.
// Also, if you have more than 5 keys, you will have to know how to add more keys yourself
// by looking at favorites.cs, and having some scripting knowledge.
// Keep in mind what I just said when you go to name your favorites in FavHUD, if you do.

$Doug::totalfav = "5"; 			// Set this to your total number of favorites, so if you have 5, put 5.
$Doug::delaytime = "0.5"; 		// Set this to your number of seconds you want to be delayed to get
		    			// your alternate favorite.
$Doug::favkey1 = "numpad2";
$Doug::favkey2 = "numpad3";
$Doug::favkey3 = "numpad5";
$Doug::favkey4 = "numpad6";		// Set these to whatever you want your favorite keys to be
$Doug::favkey5 = "numpad8";

$Doug::buylastitemkey = "home";		// Set this to a key you wish to use to automatically buy your last bought item!
					// I didn't make an option for this to be auto as some people might not want the 
					// last manually-bought item again.
				
$Doug::markfavskey = "insert";		// Key you wish to mark favorites with. You may want to leave this key blank if you don't
					// find it useful.

$Doug::fav1wep = "";
$Doug::fav2wep = "";
$Doug::fav3wep = "";			// If you leave these blank, no weapon will be brought up after buying a fav
$Doug::fav4wep = "";			// Fill in the blank for a weapon you wish to be automatically brought up
$Doug::fav5wep = "";			// when you buy that certain favorite. Here is an example
$Doug::fav6wep = "";			// $fav1wep = "Disc Launcher";  When you by your first favorite it will bring
$Doug::fav7wep = "";			// up the Disc Launcher when you exit the station.
$Doug::fav8wep = "";
$Doug::fav9wep = "";
$Doug::fav10wep = "";

$Doug::cleandelay = "0.4";		// Increase this if Autocleansell isnt working properly or not at all.
$Doug::togglekey = "numpad*";		// Key you wish to toggle autolastfav on/off
$Doug::togglecleankey = "numpad-";	// Key you wish to toggle autocleanonbuy on/off
$Doug::togglefav = "on"; 		// Default if you want it on/off on entry.
$Doug::togglecleansell = "off"; 	// Default if you want it on/off on entry. - This is like beta code, it makes you wait
					// and could lag low end comps, I have it defaulted to off, default it to on
					// at your own risk

// ==========================
// FavHUD.cs bindings
// ==========================
$FavHUD::Default = "true";		// Set this to whether you want FavHUD to be ON when you enter the game or OFF when you 
					// enter it.
					// set "true" for ON, "false" for OFF.

$FavHUD::Position = "100% 20%";		// Set these to where you want your FavHUD to appear.
					// The first number controls if the box goes left or right (0% being left, 100% right)
					// Second number makes it go up and down (0% being top, 100% being bottom)
					// The percent is a percentage of your resolution. Try the default though.				

$Doug::favname = "no";			// Set this to "yes" if you are going to name your favorites!
$Doug::fav1 = "1";
$Doug::fav2 = "2";
$Doug::fav3 = "3";
$Doug::fav4 = "4";
$Doug::fav5 = "5";			// You can name your favorites here, or just leave the numbers.
$Doug::fav6 = "6";			// If you name, make sure you set $favname = "yes";  ! (18 character limit)
$Doug::fav7 = "7";			// If you leave the numbers, the box will be just big enough to fit a double digit number
$Doug::fav8 = "8";
$Doug::fav9 = "9";
$Doug::fav10 = "10";

$Doug::FavOnEntry = "1";		// Default LastFav you want to have on entry.
					// In other words, your most used favorite. If you dont want a fav on entry, delete the 1.

editActionMap("playMap.sae");
bindCommand(keyboard0, make, control, "h", TO, "HUD::ToggleDisplay(FavHUD);"); 	// Key you wish to Toggle FavHUD On/Off
// ==========================
// dropsell.cs bindings
// ==========================
$Doug::dropallkey = "numpad7";		// Key you wish to use to drop all items and weapons
$Doug::sellallkey = "end";		// Key you wish to use to sell all items and weapons
$Doug::cleanupkey = "L";		// Key you wish to use to drop all unneeded ammo.
$Doug::cleanupsellkey = "comma";	// Key you wish to use to sell all unneeded ammo.

// ==========================
// fire.cs bindings - Needed for dualshot.cs shield.cs *** Shield.cs REQUIRES you set these!
// ==========================
EditActionMap("playMap.sae"); 
bindCommand(keyboard0, make, "rcontrol", TO, "Doug::Fire();"); 			// Bind this to your fire key
bindCommand(keyboard0, break, "rcontrol", TO, "Doug::FireStop();"); 		// It will NOT affect your firing

bindCommand(mouse0, make, button2, TO, "Doug::JetOn();"); 			// Bind this to your Jet key
bindCommand(mouse0, break, button2, TO, "Doug::JetOff();"); 			// It will NOT affect your jetting

bindCommand(keyboard0, make, "/", TO, "Doug::UseBackPack();");			// I hope you don't have another toggle
										// function for your backpack right now.

// ==========================
// dualshot.cs bindings
// ==========================
$Doug::toggledualkey = "b"; 		// Key you want to toggle dualshot on/off with
$Doug::toggledual = "on"; 		// Default for it to be "on" or "off" on load. 
					// Defaulting it to ON will not affect you if you 
					// arent using a sniper weapon, Rocket Launcher, 
					// or Thunderbolt
		
// ==========================
// shield.cs bindings If you want to charge your shield energy (it got low) during combat so you can take punishment in groups
//		      simply toggle SmartShield OFF, and when you are ready, toggle it back on and it will take over!
// ==========================
$Doug::toggleshieldkey = "n";		// Key you want to toggle SmartShield on/off

$Doug::toggleshield = "on";		// Default if you want SmartShield on/off

$Doug::shieldchecktime = "3";		// Time to wait after you stop firing to check status
					// If it sees you started firing again, it does nothing
					// Otherwise, after the time limit, it turns off your shield.

$Doug::shieldrecovery = "5";		// This happens if you are jetjumping and stop jetjumping and you are shooting.
					// It will wait 5 seconds and check if you are still shooting (5 seconds recovery)
					// if you are still shooting shields will stay active. 
					// If you are not still shooting, shields will turn off.
// ==========================
// misc.cs bindings
// ==========================
$Doug::moverightkey = "right";
$Doug::moveleftkey = "left";   		// You need to set these for the stand pose and ducking to work properly
$Doug::movebackkey = "down";	  	// This will NOT affect your movement.
$Doug::moveforwardkey = "up";
$Doug::duckkey = "delete";		// Duck without your view ducking.
$Doug::standorduck = "duck";		// Would like to "duck" or "stand" when you stop running? Change it to "stand" if you want
$Doug::animdelay = "1";			// How long script waits to make you duck or stand when you stop running. Set to higher
					// if it doesn't work often enough for you.
$Doug::sayhellokey = "h";

// ==========================
// shock.cs bindings
// ==========================
$Doug::cyclenext = "]";  		// Set these to your cycle forward and cycle backward keys, your cycling will not be 
$Doug::cycleback = "[";			// affected

// ==========================
// taunt.cs bindings
// ==========================
EditActionMap("playMap.sae"); 
bindCommand(mouse0, break, "button0", TO, "Doug::RandomTaunt();"); 	 // Bind this to your jump key and make sure you
							    		 // leave the "break" "break". This will choose
							    		 // a taunt out of a list of taunts. The taunt
							    		 // is a localmessage. You will only taunt 
							    		 // 20% of the time when you release the jump
							    		 // key, 20% of the time it chooses from the list.
							    		 // All the enemies here is the voice.
							    		 // This only spams if you rapidly hit jump

//======================Please=ignore=this============================================
if ($Presto::version >= 0.93) 
{
	Presto::AddScriptBanner(DougPack,
		"<jc><f0>DougPack 0.2 by Doug\n" @
		"<f1>FavHUD\n" @
		"<f2>Favorites\n" @
		"<f0>Favorite naming\n" @
		"<f1>SmartShield\n" @
		"<f2>DualShot\n" @
		"<f0>Random Battle-Taunt\n" @
		"<f1>Shock Bypass\n" @
		"<f2>Read all instructions!");
}							     
// ===================================================================================
exec("doug\\dropsell.cs"); 	// Favorites.cs requires a function in this
exec("doug\\favorites.cs"); 	// FavHUD.cs requires functions in this
exec("doug\\favhud.cs");   
exec("doug\\taunt.cs");
exec("doug\\shock.cs");
exec("doug\\fire.cs");		// Dualshot and Shield need this
exec("doug\\dualshot.cs");
exec("doug\\shield.cs");
exec("doug\\misc.cs");	
exec("doug\\adminpass.cs");							   
