@rem = ('                          
@echo off
perl -w remaic.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
goto END_OF_BAT
');
undef(@rem);

# Installation:
# replace "remaic.bat" above with the full path name of wherever you keep
#  your copy of this ReMaic.bat file in order to be able to run ReMaic from
#  anywhere so long as the directory it is in is in your path.
# Linux etc users should add the usual hash-bang line to the top of the
#  script.

# ReMaic (previously known as CamDem)
# Utility to change the camera view within (.ls format) Quake demos
# v3.3 with roll capability
# v3.4 with countdown addition option (and Stefan's "entity 1" fix)
# v3.5 with precached sound effects, some other fixes, subtitles, and
#      and different countdown implementation through weaponmodels.
# v4 without the SdS-specific stuff (i.e. the countdown),
#    added fading commands, tweaked for a public release.

$pi_under_180 = 45 / atan2(1,1);
$PLAYER = 1;
$CAMERA = 449;
$backspaces = "\b" x 20;

&get_LMPC();
&get_arguments();
&read_camera_instructions();
&process_header_blocks();
while (not eof IN) { &write_block(&process_block(&read_block())) };
print STDOUT "blocks filmed\n";
close(IN);
close(OUT);
close(LOG) if ($logging);
&make_dem($output);

sub error {
    my($message) = @_;
    print " -- problem:\n";
    die $message;
}

sub read_camera_instructions {
    if ($logging) {
        open(LOG, ">remaic.log") or die "Couldn't write remaic.log: $!";
    };
    %history = %noted = %sounds =
    @soundfx = @texts = @target = @camera = @palette = ();
    $cam_com = '';
    $noted{$PLAYER} = 1;
    foreach $line (<CAMERA>) {
	$line =~ s/#.*$//;            # remove comments
	$line =~ s/^\s*//;
	$line =~ s/\s*$//;            # remove bounding whitespace
	unless ($line eq '') {
            if ($line =~ /^[\d\.]*\s+((eyes)|(stay)|(cut)|(move)|(end\s+move))/i) {
		push (@camera,$line);
            } elsif ($line =~ /^([\d\.]*)\s+text\S*\s(\w+).*[^\\](".*[^\\]")/i) {
		push (@texts,$1,$2,$3);
            } elsif ($line =~ /^([\d\.]*)\s+subtitle\s+"(.*[^\\])"/i) {
                ($subtitle_time, $subtitle) = ($1, $2);
                push (@texts, $subtitle_time, "stufftext",
                 "\"alias subtitle echo \\\"$subtitle\\\";\\nprint_subtitle\\n\"");
            } elsif ($line =~ /^[\d\.]*\s+((turn)|(view)|(pan)|(end\s+pan)|(end\s+turn))/i) {
		push (@target,$line);
            } elsif ($line =~ /^[\d\.]*\s+((lean)|(roll)|(end\s+roll))/i) {
		push (@rolls,$line);
            } elsif ($line =~ /^([\d\.]*)\s+sound\s+(\S*)\s*\"(.*)\"(.*)$/i) {
                $sounds{$3} = 1;
                if ($1) { push (@soundfx,$1,$2,$3,$4) };
            } elsif ($line =~ /^[\d\.]*\s+((palette)|(fade)|(end\s+fade))/i) {
                push (@palette,$line);
	    } else {
                &error("Couldn't process command in camera file:\n'$line'")
	    };
	};
        while ($line =~ s/\be(\d+)\b//i) {
	    if ($1 == $CAMERA) {
		&error("Entity $CAMERA is the camera! Yuk! Recursive mess!")
	    };
	    $noted{$1} = 1;  # note any entities used
	};
    };
    &print_log ("Camera instructions read as:\n",join("\n",(@camera,'')));
    &print_log ("Text instructions read as:\n",join("\n",(@texts,'')));
    &print_log ("Target instructions read as:\n",join("\n",(@target,'')));
    &print_log ("Roll instructions read as:\n", join("\n",(@rolls,'')));
    &print_log ("palette instructions read as:\n", join("\n",(@palette,'')));
    &print_log ("SoundFX instructions read as:\n", join("\n",(@soundfx,'')));
    &print_log ("Precaching: ", join(" ", keys %sounds), "\n");
    close(CAMERA);
    push (@camera,  '999999 s end');
    push (@target,  '999999 v end');
    push (@rolls,   '999999 l end');
    push (@palette, '999999 p end');
    foreach $entity (keys %noted) {
	$history{$entity} = { 'x' => [ ],
			      'y' => [ ],
			      'z' => [ ] };
    };
    push(@texts,     999999, 'never', 'ever');
    push(@soundfx,   999999, 'never', 'ever', 'ever!');
    &get_next_text();
    &get_next_sound();
}

sub process_header_blocks {
    $b = $time = 0;
    @block = &read_block();
    $_ = join('',@block);
    while (not /serverinfo/) {
        print "Ignoring a non-serverinfo block...\n";
        @block = &read_block();
        $_ = join('',@block);
    };
 # copy cd block and first block, but also give view to our camera
 # and precache sound FX if there are any
    @block = &precache_sounds(@block);
    splice(@block,-3,1," setview $CAMERA;\n");
    &write_block(@block);
 # copy second block, but also spawn the camera (with eyes as model)
    @block = &read_block();
   # note origins of all important entities
    foreach $entity (keys %history) {
        %stats = &seek_entity($entity,@block);
        $stats{'default_origin'} ||= '0 0 0';
	($x,$y,$z) = split(/ /,$stats{'default_origin'});
        &record_history($entity,0,$x,$y,$z);
	$coords{$entity} = "$x $y $z";
	if ($entity == $PLAYER) {
	    $player_model = $stats{'default_modelindex'};
	    $player_model =~ s/^(\d+(?:\.\d)?).*$/$1/;
	    $eyes_model = $player_model + 1;
	};
    };
    @spawndata = (
 " spawnbaseline {\n",
 "  entity $CAMERA;\n",
 "  default_modelindex $eyes_model; // progs/eyes.mdl\n",
 "  default_frame 0;\n",
 "  default_colormap 1;\n",
 "  default_skin 0;\n",
 "  default_origin 0.000000000 0.000000000 0.000000000;\n",
 "  default_angles 0.000000000 0.000000000 0.000000000;\n",
 " }\n"
    );
    splice(@block,-2,1,@spawndata);
    &write_block(@block);
 # copy third block
    &write_block(&read_block());
}

sub record_history {
    my($entity,$time,$x,$y,$z) = @_;
    push(@{ $history{$entity}{'x'} }, "$time $x");
    push(@{ $history{$entity}{'y'} }, "$time $y");
    push(@{ $history{$entity}{'z'} }, "$time $z");
    &print_log("Recorded entity $entity at ($x $y $z) at $time\n");
}

sub get_next_text {
    $next_text_time = shift(@texts);
    $next_text_command = shift(@texts);
    $next_text = shift(@texts);
}

sub get_next_sound {
    $next_sound_time = shift(@soundfx);
    $next_sound_entity = shift(@soundfx);
    $next_sound_file = shift(@soundfx);
    $next_sound_fx = shift(@soundfx);
}

sub play_sound {
    my(@b) = @_;
    $channel = 0; while ($next_sound_fx =~ s/c(\d)//) { $channel = $1 };
    $vol = -1; while ($next_sound_fx =~ s/v(\S+)//) { $vol = sprintf("%.9f", $1) };
    if ($next_sound_entity) {
        if ($next_sound_entity eq 'p') { $next_sound_entity = $PLAYER };
        $next_sound_entity =~ s/^e//;
        $atten = -1;
        ($orig_x, $orig_y, $orig_z) = &coords($next_sound_entity);
    } else {
        $next_sound_entity = $CAMERA;
        ($orig_x, $orig_y, $orig_z) = ($c_x, $c_y, $c_z);
        $atten = "0.000000000";
    }; while ($next_sound_fx =~ s/a(\d)//) { $atten = sprintf("%.9f", $1) };
    @sound_lines = (" sound {\n");
    if ($vol >= 0) { push @sound_lines, "  vol $vol;\n" };
    if ($atten >= 0) { push @sound_lines, "  attenuation $atten;\n" };
    push @sound_lines, (
        "  channel $channel;\n",
        "  entity $next_sound_entity;\n",
        "  soundnum $sounds{$next_sound_file}; // $next_sound_file.wav\n",
        sprintf("  origin %.9f %.9f %.9f;\n", $orig_x, $orig_y, $orig_z),
        " }\n"         );
    return @sound_lines;
}

sub initialise_camera {
    $old_c_x = $old_c_y = $old_c_z = 999999;
    $palette = '0  0  0  0';
    $c_x = $c_y = $c_z = $roll = $intermission = 0;
    ($x,$y,$z) = &coords($PLAYER);
    $x += 30; $y += 30; $z += 10;
    $next_cam = "stay $x $y $z";
    $t_x = $t_y = $t_z = 999999;
    $next_targ = 'view p p p';
    $next_roll = 'lean 0';
    $next_palette = 'palette 0 0 0 0';
    $next_palette_time = $next_targ_time = $next_cam_time =
     $next_roll_time = $time = 1;
}

sub coords {
    my($entity) = @_;
    return (split (/ /,$coords{$entity}));
};

sub process_block {
 # note any time and camera view information
    my(@block) = &get_time(@_);
 # update coords and history of all important entities
    foreach $entity (keys %history) {
	%stats = &seek_entity($entity,@block);
	($x,$y,$z) = &coords($entity);
	$x = ($stats{'origin_x'}) || $x;
	$y = ($stats{'origin_y'}) || $y;
	$z = ($stats{'origin_z'}) || $z;
	$coords{$entity} = "$x $y $z";
        &record_history($entity,$time,$x,$y,$z);
    };
    unless (defined $next_cam) { &initialise_camera() };
 # drip blood if appropriate
    if ($bleeding_hell and ($current_health < 100) and not $intermission) {
	my($x,$y,$z) = &coords($PLAYER);
	$drips = (1 - $current_health/100);
	$drips = $drips ** 1.3;
	if (rand() < $drips) {
	    splice(@block,-1,0,&bleed(int($drips*rand(19))+1,$x,$y,$z+20));
	};
    };
 # process current camera commands and place it in position
    &update_camera();
    &position_camera();
    if ($intermission && ($setview ne $PLAYER)) {
	if ($auto_intermission) {
	    $setview = $PLAYER;
	} else {
            print "Intermission found and ignored\n";
	    $intermission = 0;
	};
    };
    splice(@block,-1,0," setview $setview;\n");
    ($old_c_x, $old_c_y, $old_c_z) = ($c_x, $c_y, $c_z);
    splice(@block,-1,0,&camera_text($c_x,$c_y,$c_z));
    while ($time >= $next_text_time) {
	splice(@block,1,0," $next_text_command $next_text;\n");
	&get_next_text();
    };
 # deal with the palette
    $old_palette = $palette;
    &update_palette();
    &calculate_palette();
    if ($palette ne $old_palette) {
        splice(@block,1,0," stufftext \"v_cshift $palette\\n\";\n");
    };
 # process current target commands and point view at target
    &update_roll();
    &roll_camera();
    &update_target();
    &target_camera();
    while ($time >= $next_sound_time) {
        splice(@block,-1,0,&play_sound(@block));
        &get_next_sound();
    };
    splice(@block,1,0,$camera_line);
 # note final figures in the log
    &print_log("time: $time ($next_cam_time $next_targ_time $next_roll_time)\n");
    &print_log("camera: ($c_x $c_y $c_z)\n");
    &print_log("target: ($t_x $t_y $t_z)\n");
    &print_log("roll: $roll, palette: $palette\n");
    return(@block);
}

sub bleed {
 # make a mess on the floor
    my($flow,$x,$y,$z) = @_;
    return (" particle {\n",
   sprintf ("  origin %.9f %.9f %.9f;\n", $x, $y, $z),
	    "  vel 0.00000000 0.00000000 -15.0000000;\n",
	    "  color $flow;\n",
	    "  count 73;\n",
	    " }\n");
}

sub update_camera {
    $time_left = $next_cam_time - $time;
    while ($time_left <= 0) {
        &print_log("*activate* $next_cam\n");
 # "cut" is a synonym for "stay"
	$next_cam =~ s/cut/stay/;
 # "end move" is a synonym for "stay" at current co-ordinates
	if ($next_cam =~ /end move/) { $next_cam = "stay $cam_coords" };
 # "eyes" takes no co-ordinates
        if (($next_cam !~ /eyes\s+(\d+)/) and
            ($next_cam =~ /eyes/)) { $next_cam .= " $PLAYER" };
	($cam_com, $cam_coords) = $next_cam =~ /^([esm])\S*\s+(.*)$/;
	if ($cam_coords =~ /(\S+)\s+(\S+)\s+(\S+)\s+(\S+)/) {
	    &error("Too many coords in camera command:\n$next_cam\n");
	};
	$line = shift(@camera);
	($next_cam_time, $next_cam) = $line =~ /^(\S+)\s+(\S.*)/;
	$time_left = $next_cam_time - $time;
    };
}

sub update_target {
    $time_left = $next_targ_time - $time;
    while ($time_left <= 0) {
        &print_log("*activate* $next_targ\n");
 # "end pan" and "end turn" are synonyms to "view" current target
	if ($next_targ =~ /end [(pan)|(turn)]/) { $next_targ = "view $targ_coords" };
	($targ_com, $targ_coords) = $next_targ =~ /^([vpt])\S*\s+(.*)$/;
	if ($targ_coords =~ /(\S+)\s+(\S+)\s+(\S+)\s+(\S+)/) {
	    &error("Too many arguments in camera command:\n$next_targ\n");
	};
	$line = shift(@target);
	($next_targ_time, $next_targ) = $line =~ /^(\S+)\s+(\S.*)/;
	$time_left = $next_targ_time - $time;
    };
}

sub update_roll {
    $time_left = $next_roll_time - $time;
    while ($time_left <= 0) {
        &print_log("*activate* $next_roll\n");
 # "end roll" is a synonym to "lean" at current angle
	if ($next_roll =~ /end roll/) { $next_roll = "lean $roll_angle" };
	($roll_com, $roll_angle) = $next_roll =~ /^([rl])\S*\s+(.*)$/;
	if ($roll_angle =~ /(\S+)\s+(\S+)/) {
	    &error("Too many arguments in camera command:\n$next_roll\n");
	};
	$line = shift(@rolls);
	($next_roll_time, $next_roll) = $line =~ /^(\S+)\s+(\S.*)/;
	$time_left = $next_roll_time - $time;
    };
}

sub update_palette {
    $time_left = $next_palette_time - $time;
    while ($time_left <= 0) {
        &print_log("*activate* $next_palette\n");
 # "end roll" is a synonym to "lean" at current angle
        if ($next_palette =~ /end fade/) { $next_palette = "palette $palette" };
        ($palette_com, $new_palette) = $next_palette =~ /^([pf])\S*\s+(.*)$/;
        if ($new_palette !~ /\s+/) {
            $new_palette = "0 0 0 $new_palette";
        };
        $line = shift(@palette);
        ($next_palette_time, $next_palette) = ($line =~ /^(\S+)\s+(\S.*)/);
        $time_left = $next_palette_time - $time;
    };
}

sub position_camera {
    if ($cam_com eq 'e') {
        ($setview) = ($cam_coords =~ /(\d+)/);
        &print_log("Looking through eyes of entity $setview.\n");
    } else {
	$setview = $CAMERA;
	($x,$y,$z,$cam_coords)
	 = &eval_coords($cam_coords,$old_c_x,$old_c_y,$old_c_z);
	if ($cam_com eq 'm') {
            &print_log("Moving to ($cam_coords) = ($x $y $z)\n");
	    $proportion = ($time - $old_time) / $time_left;
	    if ($proportion > 1) { $proportion = 1 };
	    $c_x += $proportion * ($x - $c_x);
	    $c_y += $proportion * ($y - $c_y);
	    $c_z += $proportion * ($z - $c_z);
	} elsif ($cam_com eq 's') {
            &print_log("Staying at ($cam_coords) = ($x $y $z)\n");
	    ($c_x, $c_y, $c_z) = ($x, $y, $z);
	};
    };
}

sub target_camera {
    if ($cam_com eq 'e') {
	$camera_line = $old_view;
    } else {
	($x,$y,$z,$targ_coords)
	  = &eval_coords($targ_coords,$t_x,$t_y,$t_z);
	if ($targ_com eq 'p') {
            &print_log("Panning view to ($targ_coords) = ($x $y $z)\n");
	    $proportion = ($time - $old_time) / $time_left;
	    if ($proportion > 1) { $proportion = 1 };
	    $t_x += $proportion * ($x - $t_x);
	    $t_y += $proportion * ($y - $t_y);
	    $t_z += $proportion * ($z - $t_z);
	    $camera_angles = &angles($t_x-$c_x, $t_y-$c_y, $t_z-$c_z);
	} elsif ($targ_com eq 't') {
            &print_log("Turning view to ($targ_coords) = ($x $y $z)\n");
	    $proportion = ($time - $old_time) / $time_left;
	    if ($proportion > 1) { $proportion = 1 };
	    my ($angle1, $angle2) = split(/ /,$camera_angles);
	    $turning_to = &angles($x - $c_x, $y - $c_y, $z - $c_z);
            &print_log("i.e. angles from $camera_angles\nto $turning_to\n");
	    my ($aim_angle1, $aim_angle2) = split(/ /,$turning_to);
	    $diff_angle1 = $aim_angle1 - $angle1;
	    if ($diff_angle1 > 180) { $diff_angle1 -= 360 }
	     elsif ($diff_angle1 < -180) { $diff_angle1 += 360 };
	    $angle1 += $proportion * $diff_angle1;
	    if ($angle1 > 360) { $angle1 -= 360 };
	    $diff_angle2 = $aim_angle2 - $angle2;
	    if ($diff_angle2 > 180) { $diff_angle2 -= 360 }
	     elsif ($diff_angle2 < -180) { $diff_angle2 += 360 };
	    $angle2 += $proportion * $diff_angle2;
	    if ($angle2 > 360) { $angle2 -= 360 };
	    if ($proportion == 1) { ($t_x, $t_y, $t_z) = ($x, $y, $z) };
            $camera_angles = sprintf "%.9f %.9f %.9f", ($angle1, $angle2, $roll);
	} elsif ($targ_com eq 'v') {
            &print_log("Holding view at ($targ_coords) = ($x $y $z)\n");
	    ($t_x, $t_y, $t_z) = ($x, $y, $z);
	    $camera_angles = &angles($t_x-$c_x, $t_y-$c_y, $t_z-$c_z);
	};
	$camera_line = " camera $camera_angles;\n";
    };
}

sub roll_camera {
    if ($cam_com eq 'e') {
	$camera_line = $old_view;
    } else {
	if ($roll_com eq 'r') {
            &print_log("Rolling view to $roll_angle\n");
	    $proportion = ($time - $old_time) / $time_left;
	    if ($proportion > 1) { $proportion = 1 };
	    $diff_angle = $roll_angle - $roll;
	    if ($diff_angle > 180) { $diff_angle -= 360 }
	     elsif ($diff_angle < -180) { $diff_angle += 360 };
	    $roll += $proportion * $diff_angle;
	    if ($roll > 360) { $roll -= 360 };
	    if ($proportion == 1) { $roll = $roll_angle };
	} elsif ($roll_com eq 'l') {
            &print_log("Leaning at $roll_angle\n");
            $roll = $roll_angle;
	};
    };
}

sub calculate_palette {
    if ($palette_com eq 'f') {
        &print_log("Fading palette to $new_palette\n");
        $proportion = ($time - $old_time) / $time_left;
        if ($proportion > 1) { $proportion = 1 };
        my(@new_palette_values) = split(/\s+/,$new_palette);
        my(@palette_values) = split(/\s+/,$palette);
        foreach $value (@palette_values) {
            $new_value = shift @new_palette_values;
            $diff_value = $new_value - $value;
            $value += $proportion * $diff_value;
            if ($proportion == 1) { $value = $new_value };
            $value = int($value + 0.5);
        };
        $palette = join(' ', @palette_values);
    } elsif ($palette_com eq 'p') {
        &print_log("Set palette to $new_palette\n");
        $palette = $new_palette;
    };
}

sub eval_coords {
    my($coords,$now_x,$now_y,$now_z) = @_;
    if ($coords =~ /^\S*$/) { $coords = "$coords $coords $coords" };
    my($x,$y,$z) = split(/\s+/,$coords);
    $calc_x = &eval_coord($x,'x',$now_x);
    $calc_y = &eval_coord($y,'y',$now_y);
    $calc_z = &eval_coord($z,'z',$now_z);
    if ($coords =~ /now/i) {
	 if ($x =~ /now/i) { $x = $calc_x };
	 if ($y =~ /now/i) { $y = $calc_y };
	 if ($z =~ /now/i) { $z = $calc_z };
	 $coords = "$x $y $z";
    };
    return($calc_x,$calc_y,$calc_z,$coords);
}

sub eval_coord {
    my($coord,$name,$now) = @_;
    my($expr,$offset) = ($coord,0);
    if ($expr =~ /^([+\-]?\d+(?:\.\d+)?)$/) { return $1 };
    if ($expr =~ s/([+\-]\d+(?:\.\d+)?)$//) { $offset = $1 };
    if ($expr =~ s/now//i) { $offset += $now };
    if ($expr eq '') { return($offset) };
    $expr =~ s/p/e1/i;
    if ($expr =~ /^e(\d+)~(\d+(?:\.\d+)?)$/i) {
	return(&look_up($2,$1,$name) + $offset)
    } elsif ($expr =~ /^e(\d+)$/) {
	($x,$y,$z) = &coords($1);
	if ($name eq 'x') { return $x + $offset }
	elsif ($name eq 'y') { return $y + $offset }
	elsif ($name eq 'z') { return $z + $offset }
    };
    &error("Bad coordinate expression: $coord");
}

sub look_up {
    my($ago,$entity,$axis) = @_;
    do {
	$event = shift(@{ $history{$entity}{$axis} });
        &print_log("reading event: $event\n");
	($when,$what) = split(/ /,$event);
    } until ($when > $time - $ago);
    unshift(@{ $history{$entity}{$axis} },$event);
    return($what);
}
 
sub camera_text {
    my($x,$y,$z) = @_;
    return (" updateentity {\n",
	    "  entity $CAMERA;\n",
            (sprintf "  origin_x %.9f;\n", $x),
            (sprintf "  origin_y %.9f;\n", $y),
            (sprintf "  origin_z %.9f;\n", $z),
	    " }\n");
}
  
sub angles {
    my($x,$y,$z) = @_;
    unless ($x || $y || $z || $intermission) {
	print STDERR "Warning: camera and target coincided\n";
        &print_log("*warning* camera position coincided with viewed target\n");
    };
    my $angle2 = ($x == 0) ? ( ($y >= 0) ? 90 : 270 )
			   : ( ($y == 0) ? (($x >= 0) ? 0 : 180 )
					 : ( $pi_under_180 * atan2($y,$x) ) );
    if ($angle2 < 0) { $angle2 += 360 };
    $xxyy = $x * $x + $y * $y;
    my $angle1 = ($xxyy == 0) ? ( $z >= 0 ? -90 : 90 )
			      : ( $pi_under_180 * atan2(-$z,sqrt($xxyy)) );
    sprintf "%.9f %.9f %.9f", ($angle1, $angle2, $roll);
}

sub precache_sounds {
    my(@b) = ();
    $caching = $count_sounds = 0;
    for (@_) {
        push @b, $_;
        if (/^  sounds /) { $caching = 1 };
    	if ($caching) {
            while (s/"(.*?)"//) { $count_sounds++ };
            if (/;\s*$/) {
                $_ = pop @b;
                s/;\s*$//;
                push @b, $_;
                foreach $filename (sort keys %sounds) {
                    $sounds{$filename} = ++$count_sounds;
                    push @b, "\n   \"$filename.wav\"";
                };
                $_ = pop @b; push @b, "$_;\n";
		$caching = 0;
            };
	};
    };
    return @b;
}

sub get_time {
    my(@b) = @_;
    $old_time = $time;
    if ($b[1] =~ /camera/) { ($old_view) = splice(@b,1,1) };
    if ($b[1] =~ /time (.*)s;/) {
	$time = $1;
    } elsif ($b[1] =~ /time (.*):(.*)m;/) {
	$time = $1 * 60 + $2;
    };
    if ($print_time) {
	($printed_time = $time) =~ s/(\....).*$/$1/;
	splice(@b,1,0," centerprint \"$printed_time\\n\";\n");
    };
    return @b;
}

sub seek_entity {
    my($e,@b) = @_;
    my(%answer) = ();
    do { $line = shift(@b) } until (($line =~ /entity $e;/) or ($line =~ /^\}/));
    if ($line =~ /entity $e;/) {
	$line = shift(@b);
	until ($line =~ /^ \}/) {
	    ($key, $data) = $line =~ /^  (\w+)[ ;](.*?);?$/;
	    if (defined $key) { $answer{$key} = $data };
	    $line = shift(@b);
	};
    };
    return %answer;
}

sub read_block {
# reads one block on IN up to the next end of block
# end of file into @block.
    my(@block) = ();
    my($line);
    do {
	$line = <IN>;
	if (defined $line) {
	    if ($no_red && ($line =~ / damage /)) {
		for (1..5) { $line = <IN> };
	    };
	    if ($line =~ /health (.*);/) {
		$current_health = $1;
                if ($current_health <= 0) {
                    $current_health = 0;
                    unless ($cam_com eq 'e') {
                        $line = "  health 1000;\n";
                    };
                };
	    };
	    if ($decenter and ($line =~ /centerprint/)) {
		 while ($line !~ /";/) { $line = <IN> };
            };
            if (($cam_com eq 'e') or
                 (($line !~ / vel_/) && ($line !~ /punchangle/)
               && ($line !~ / weaponmodel/) && ($line !~ / weaponframe/))) {
		push(@block,$line);
	    };
	    if ($line =~ /intermission/) { $intermission = 1 };
	};
    } until ((not $line) || ($line =~ /^\}/));
    return @block;
}

sub write_block {
# writes @block to OUT
    my(@block) = @_;
    print OUT @block;
    &print_log ("Wrote block ", $b++, "\n\n");
    printf ("$backspaces"."[%.3f] $b ", $time);
    if ($debug) { $_ = <STDIN> };
    return @block;
}

sub get_arguments {
    unless (defined $ARGV[0]) {
        print <<HELP1;
ReMaic v4 by Anthony Bailey <URL:mailto:ReMaic\@PlanetQuake.com>
The ReMaic homepage is <URL:http://PlanetQuake.com/ReMaic/>

 Calling syntax: remaic <flag>* <input> [<screenplay> [<output>]]
  /D flag uses DemTool rather than LMPC for *.dem -> *.ls decompilaton
  /I flag continues camera operation during intermissions.
  /L flag writes the remaic.log file (no longer written by default)
  /b flag makes the player bleed when low on health.      (deprecated!)
  /c flag removes all centerprinted messages in original. (deprecated!)
  /d flag removes all damage messages to stop red flash.  (deprecated!)
  /t flag prints running clock times in output.           (deprecated!)
  Default input and output file extensions are .ls, camera is .cam
  Default name for camera file is as input, with 'out' as default output
  If camera file specified, default name for output is the same

  Press return for camera file syntax...
HELP1
        $_ = <STDIN>;
        print <<HELP2;
 Camera file syntax: a number of <line>s, where:
  <line> = <time> <instruct> [#<commentary>] <newline>
  <time> = <decimal number in seconds>
  <instruct> = <positioning_command> <position> | <rolling_command> <angle> 
               <palette_command> <palette>  end (movieviewpanrollfade)
                eyes  sound [<entity>] "<file>" <sndfx>* 
               text <lmpc_command> "<text>"  subtitle "<text>"                
  <positioning_command> = stay | cut | move | view | pan | turn
  <position> = <coord> <coord> <coord> | <coord>
  <coord> = now | <abs> | <offset expression> | <expression>
  <abs> = <absolute decimal number in pixel units>
  <offset expression> = <expression>(+|-)<abs>
  <expression> = <entity>[~<time>]
  <entity> = p | e<integer>
  <rolling_command> = lean | roll
  <angle> = <decimal angle in degrees>
  <palette_command> = palette  fade
  <palette> = <red> <green> <blue> <intensity>  <intensity>
  <sndfx> = a<attenuation>  v<volume>  c<channel>
  <lmpc_command> = print  centerprint  finale  stufftext

HELP2
	exit;
    };
    $debug = $bleeding_hell = $print_time
           = $no_red = $use_demtool = $decenter = $logging = 0;
    $auto_intermission = 1;
    $input = $ARGV[0];
    while ($input =~ s!^[-/]!!) {
	if ($input eq 'debug') {
	    print "Debug mode on\n"; $debug = 1;
        } elsif ($input eq 'i') {
            print "Option 'i' is obsolete: used by default, to disable use 'I'\n";
        } elsif ($input eq 'I') {
            print "Use camera during intermission views\n"; $auto_intermission = 0;
        } elsif ($input eq 'D') {
            print "Use demtool for decompilation\n"; $use_demtool = 1;
        } elsif ($input eq 'L') {
            print "Writing ReMaic.log\n"; $logging = 1;
        } elsif ($input eq 'n') {
            print "Option 'n' is obsolete: ReMaic should skip all non-serverinfof header blocks.\n";
        } elsif ($input eq 't') {
            print "Write times on finished film\n"; $print_time = 1;
            print " deprecated feature: suggest you use demtool -t instead.\n";
        } elsif ($input eq 'b') {
	    print "Bleed when on low health\n"; $bleeding_hell = 1;
            print " deprecated feature: suggest you use demtool -b instead.\n";
        } elsif ($input eq 'd') {
	    print "Remove all damage messages\n"; $no_red = 1;
            print " deprecated feature: suggest you use demtool --damage instead.\n";
        } elsif ($input eq 'c') {
	    print "Remove all previously centerprinted text\n"; $decenter = 1;
            print " deprecated feature: suggest you use demtool -c instead.\n";
	} else { die "Unknown command line option: $input" };
	shift @ARGV;
	$input = $ARGV[0];
    };
    my $camera = $ARGV[1] || $input;
    $output = $ARGV[2] || $ARGV[1] || 'out';
    $input = &get_ls($input);
    open(IN, "<$input")
     or die "Couldn't read expected input file $input:\n $!";
    unless ($camera =~ /\./) { $camera .= '.cam' };
    open(CAMERA, "<$camera")
     or die "Couldn't read expected camera file $camera:\n $!";
    unless ($output =~ /\./) { $output .= '.ls' };
    open(OUT, ">$output")
     or die "Couldn't write expected output file $output:\n $!";
    print "ReMaic v4: converting $input to $output using $camera.\n";
    print "0";
}

sub get_ls {
    my($file) = @_;
    if (-e "$file.ls") { $file .= '.ls' }
    elsif (-e "$file.dem") { $file .= '.dem' };
    if ($file =~ /\.dem$/) {
	($other = $file) =~ s/\.dem$/\.ls/;
        if ($use_demtool) {
            print "Running demtool -w $file > $other\n";
            system ("demtool -w $file > $other");
        } else {
            system ("$lmpc -s $file $other");
        };
	$file = $other;
    };
    return $file;
}

sub make_dem {
    my($file) = @_;
    ($file_prefix = $file) =~ s/\..*$//;
    system("$lmpc -l $file $file_prefix.dem");
}

sub get_LMPC {
    $lmpc = 'lmpc';
    if (-e 'remaic.cfg') {
        open(CFG,'<remaic.cfg') or die "Couldn't read config file remaic.cfg";
        chomp($lmpc = <CFG>);
        close(CFG);
    };
}

sub print_log {
    print LOG @_ if ($logging);
}

__END__

:END_OF_BAT
