/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __MENU_H
#define __MENU_H

enum
{
    MENU_ALIGN_LEFT,
    MENU_ALIGN_CENTER,
    MENU_ALIGN_RIGHT
};

enum
{
    MENU_BAD,
    MENU_MAIN,
    MENU_DEMO,
    MENU_PLAYERS,
    MENU_SETTINGS,
};

#define MAX_MENU_PARMS  8

typedef struct menuitem_s
{
    char        *text;      // text to be displayed
    int         align;      // left, center, right
    int         indent;     // pixels to indent to the right
    int         param[MAX_MENU_PARMS];  // params used by the SelectFunc
    void        (*Select)(edict_t *ent, struct menuitem_s *item, int key);
//    struct menuitem_s *next;
} menuitem_t;

typedef struct menu_s
{
    char        *title;     // always displayed at top
    int         id;         // ID_* menu type
    menuitem_t  *items;     // item array
    int         num;        // number of items
    int         top;        // index of first item to be displayed
    int         cur;        // current selected item
    int         param[MAX_MENU_PARMS];  // params used by the UpdateFunc
    void        (*Show)(edict_t *ent, struct menu_s *menu);
    void        (*Close)(edict_t *ent, struct menu_s *menu);
    struct menu_s *next;
} menu_t;

extern void Menu_Close(edict_t *ent, qboolean update);
extern void Menu_CloseAll(edict_t *ent, qboolean update);

extern int Menu_AddItem(char *text, char *fmt, ...);
extern void Menu_Display(edict_t *ent);
extern void Menu_Update(edict_t *ent, int id);
extern void Menu_UpdateAll(int id);

extern void Menu_Prev(edict_t *ent);
extern void Menu_Next(edict_t *ent);
extern void Menu_Select(edict_t *ent, int key);
extern void Menu_SelectOpen(edict_t *ent, menuitem_t *item, int key);
extern void Menu_Start(menu_t *menu);
extern void Menu_Finish(menu_t *menu);
extern void Menu_Open(edict_t *ent, char *fmt, ...);

#endif // __MENU_H
