/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 2000 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@planetquake.com
*/

#include <stdarg.h>
#include <stdio.h>

#include "p_local.h"

game_import_t	gi;			// exported by quake2.exe to me
game_import_t	my_gi;		// exported by me to game dll

game_export_t	globals;	// exported by game dll to me
game_export_t	*ge;		// exported by me to quake2.exe

proxy_t			proxydata;

void ShutdownGame(void)
{
	globals.Shutdown();
	UnloadGameModule(&proxydata);

	// reset the proxy string so proxy modules will load again
	gi.cvar_forceset("nextproxy", "");
}

/*
=================
GetGameAPI

Returns a pointer to the structure with all entry points
and global variables
=================
*/
game_export_t *GetGameAPI (game_import_t *import)
{
	gi = *import;

	my_gi = gi;

	gi.dprintf("\nRelay Proxy v" RELAY_VERSION " " RELAY_RELEASE "\nCopyright (C) 2000 Conor Davis\ne-mail: cedavis@planetquake.com\n\n");
	LoadNextModule(&proxydata, &my_gi);
	if (!proxydata.ge)
		return NULL;

	ge = proxydata.ge;
	globals = *ge;
	ge->Shutdown						= ShutdownGame;

	return ge;
}

void Sys_Error (char *error, ...)
{
	va_list		argptr;
	char		text[1024];

	va_start (argptr, error);
	vsprintf (text, error, argptr);
	va_end (argptr);

	gi.error ("%s", text);
}

void Com_Printf (char *msg, ...)
{
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	gi.dprintf ("%s", text);
}
