/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __DEMOCONV_H
#define __DEMOCONV_H

#include "block.h"
#include "bsp.h"
#include "dm2.h"

extern bsp_t    map;
extern dm2_t    dm2in;
extern dm2_t    dm2out;
extern int      playernum;
extern size_t   startframe;
extern size_t   endframe;

extern int      player_cluster;

extern block_t  prefix;
extern char     prefix_buffer[MAX_MSGLEN];
extern block_t  suffix;
extern char     suffix_buffer[MAX_MSGLEN];

#endif  // __DEMOCONV_H