/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __SHARED_H
#define __SHARED_H

#include <stddef.h>

#include "volatile.h"

#pragma warning(disable: 4305)      // const double to float truncation
#pragma warning(disable: 4244)      // double to float conversion

//#define BIG_ENDIAN

#define MAX_MSGLEN          1400
#define MAX_SVSLEN          65535

#define ISBITSET(array, index)      (!!((array)[(index)>>3] & (1 << ((index) & 7))))
#define SETBIT(array, index, value) ((value) ? ((array)[(index)>>3] |= 1 << ((index) & 7)) : ((array)[(index)>>3] &= ~(1 << ((index) & 7))))

extern void Com_Printf(char *fmt, ...);
extern void Sys_Error(char *fmt, ...);

#endif // __SHARED_H
