// This file is distributed under the id Software source license.
// See the file id_license.txt for details.

#ifndef __Q2UTILS_H
#define __Q2UTILS_H

#include "q2defines.h"

extern vec3_t vec3_origin;

extern void RotatePointAroundVector( vec3_t dst, const vec3_t dir, const vec3_t point, float degrees );
extern void AngleVectors (vec3_t angles, vec3_t forward, vec3_t right, vec3_t up);
extern void ProjectPointOnPlane( vec3_t dst, const vec3_t p, const vec3_t normal );
extern void PerpendicularVector( vec3_t dst, const vec3_t src );
extern void R_ConcatRotations (float in1[3][3], float in2[3][3], float out[3][3]);
extern void R_ConcatTransforms (float in1[3][4], float in2[3][4], float out[3][4]);
extern float Q_fabs (float f);
extern float LerpAngle (float a2, float a1, float frac);
extern float anglemod(float a);
extern int BoxOnPlaneSide2 (vec3_t emins, vec3_t emaxs, struct cplane_s *p);
extern int BoxOnPlaneSide (vec3_t emins, vec3_t emaxs, struct cplane_s *p);
extern void ClearBounds (vec3_t mins, vec3_t maxs);
extern void AddPointToBounds (vec3_t v, vec3_t mins, vec3_t maxs);
extern vec_t VectorNormalize (vec3_t v);
extern vec_t VectorNormalize2 (vec3_t v, vec3_t out);
extern void VectorMA (vec3_t veca, float scale, vec3_t vecb, vec3_t vecc);
extern vec_t _DotProduct (vec3_t v1, vec3_t v2);
extern void _VectorSubtract (vec3_t veca, vec3_t vecb, vec3_t out);
extern void _VectorAdd (vec3_t veca, vec3_t vecb, vec3_t out);
extern void _VectorCopy (vec3_t in, vec3_t out);
extern void CrossProduct (vec3_t v1, vec3_t v2, vec3_t cross);
extern vec_t VectorLength(vec3_t v);
extern void VectorInverse (vec3_t v);
extern void VectorScale (vec3_t in, vec_t scale, vec3_t out);
extern int Q_log2(int val);

extern char *COM_SkipPath (char *pathname);
extern void COM_StripExtension (char *in, char *out);
extern char *COM_FileExtension (char *in);
extern void COM_FileBase (char *in, char *out);
extern void COM_FilePath (char *in, char *out);
extern void COM_DefaultExtension (char *path, char *extension);

extern char *va(char *format, ...);
extern char *COM_Parse (char **data_p);
extern void Com_PageInMemory (byte *buffer, int size);
extern int Q_stricmp (char *s1, char *s2);
extern int Q_strncasecmp (char *s1, char *s2, int n);
extern int Q_strcasecmp (char *s1, char *s2);
extern void Com_sprintf (char *dest, int size, char *fmt, ...);

extern char *Info_ValueForKey (char *s, char *key);
extern void Info_RemoveKey (char *s, char *key);
extern qboolean Info_Validate (char *s);
extern void Info_SetValueForKey (char *s, char *key, char *value);


#endif  // __Q2UTILS_H