/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __PROXY_H
#define __PROXY_H

#ifdef _WIN32
#include <windows.h>
#endif

#include "q2defines.h"

#ifdef _WIN32
typedef HANDLE mhandle_t;
#else
typedef void* mhandle_t;
#endif

typedef struct
{
    mhandle_t           hModule;
    game_export_t   *ge;
} proxy_t;

extern void UnloadGameModule(proxy_t *proxy);
extern qboolean LoadGameModule(proxy_t *proxydata, char *path, game_import_t *import);
extern void LoadNextModule(proxy_t *proxy, game_import_t *import);

#endif // __PROXY_H
