/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __PAK_H
#define __PAK_H

#include <stdio.h>

#define PACK_FILES  0x01
#define PACK_PACKS  0x02

#define PF_READONLY     0x01
#define PF_WRITEONLY    0x02
#define PF_READWRITE    0x04
#define PF_APPEND       0x08
#define PF_TEXT         0x10

typedef struct
{
    FILE    *fd;
    size_t  filepos;
    size_t  filelen;
    int     flags;
} PFILE;

extern void RemoveAllPackFiles();
extern int AddPackFile(const char *filename);
extern void RemovePackDir(const char *dir, int flags);
extern void RemoveAllPackDirs();
extern void AddPackDir(const char *dir, int flags);
extern PFILE *pfopen(const char *filename, const char *mode);
extern void pfclose(PFILE *pfd);
extern int pfseek(PFILE *pfd, long offset, int origin);
extern size_t pftell(PFILE *pfd);
extern size_t pfread(void *buffer, size_t size, size_t count, PFILE *pfd);
extern size_t pfwrite(void *buffer, size_t size, size_t count, PFILE *pfd);

#endif  // __PAK_H