/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 2000 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@planetquake.com
*/

#include <stdlib.h>
#include <string.h>

#include "shared.h"
#include "q2defines.h"
#include "msg.h"

static msg_t *msg_head = NULL;

msg_t *CreateMessage(int id, void *data, size_t data_size, qboolean reliable)
{
	msg_t	*msg;

	msg = malloc(sizeof(msg_t));
	msg->id = id;
	msg->reliable = reliable;
	msg->reference_count = 0;
	msg->prev = NULL;
	msg->next = msg_head;

	msg_head = msg;
	if (msg->next)
		msg->next->prev = msg;

	if (data_size)
	{
		msg->data = malloc(data_size);
		memcpy(msg->data, data, data_size);
	}
	else
		msg->data = NULL;

	return msg;
}

void FreeMessage(msg_t *msg)
{
	if (msg->prev)
		msg->prev->next = msg->next;
	else
		msg_head = msg->next;

	if (msg->next)
		msg->next->prev = msg->prev;

	if (msg->data)
		free(msg->data);

	free(msg);
}

void AddMessage(msg_t **array, msg_t *msg)
{
	while (array[0])
		array++;

	array[0] = msg;
	array[1] = NULL;

	msg->reference_count++;
}

void RemoveMessage(msg_t **array, msg_t *msg)
{
	msg->reference_count--;
	if (msg->reference_count <= 0)
		FreeMessage(msg);

	while (array[0])
	{
		if (array[0] == msg)
		{
			while (array[0])
			{
				array[0] = array[1];
				array++;
			}
			return;
		}
		array++;
	}
}

void RemoveAllMessages(msg_t **array)
{
	while (array[0])
	{
		array[0]->reference_count--;
		if (array[0]->reference_count <= 0)
			FreeMessage(array[0]);
		array[0] = NULL;
		array++;
	}
}

void FreeAllMessages()
{
	while (msg_head)
		FreeMessage(msg_head);
}