/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#ifndef __ENDIAN_H
#define __ENDIAN_H

extern short SwapShort(short l);
extern long SwapLong(long l);
extern float SwapFloat(float f);

#ifdef BIG_ENDIAN

#define LittleShort(x)  (SwapShort(x))
#define LittleLong(x)   (SwapLong(x))
#define LittleFloat(x)  (SwapFloat(x))
#define BigShort(x)     ((short)(x))
#define BigLong(x)      ((long)(x))
#define BigFloat(x)     ((float)(x))

#else

#define LittleShort(x)  ((short)(x))
#define LittleLong(x)   ((long)(x))
#define LittleFloat(x)  ((float)(x))
#define BigShort(x)     (SwapShort(x))
#define BigLong(x)      (SwapLong(x))
#define BigFloat(x)     (SwapFloat(x))

#endif  // BIG_ENDIAN

#endif  // __ENDIAN_H